/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.command.po.parser.security;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.keyple.calypso.command.po.AbstractPoResponseParser;
import org.eclipse.keyple.calypso.command.po.PoRevision;
import org.eclipse.keyple.calypso.command.po.builder.security.AbstractOpenSessionCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.security.OpenSession10CmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.security.OpenSession24CmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.security.OpenSession31CmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.security.OpenSession32CmdBuild;
import org.eclipse.keyple.calypso.command.po.exception.CalypsoPoAccessForbiddenException;
import org.eclipse.keyple.calypso.command.po.exception.CalypsoPoDataAccessException;
import org.eclipse.keyple.calypso.command.po.exception.CalypsoPoIllegalParameterException;
import org.eclipse.keyple.calypso.command.po.exception.CalypsoPoSecurityContextException;
import org.eclipse.keyple.calypso.command.po.exception.CalypsoPoTerminatedException;
import org.eclipse.keyple.calypso.command.po.parser.security.OpenSession10RespPars;
import org.eclipse.keyple.calypso.command.po.parser.security.OpenSession24RespPars;
import org.eclipse.keyple.calypso.command.po.parser.security.OpenSession31RespPars;
import org.eclipse.keyple.calypso.command.po.parser.security.OpenSession32RespPars;
import org.eclipse.keyple.core.card.command.AbstractApduResponseParser;
import org.eclipse.keyple.core.card.message.ApduResponse;
import org.eclipse.keyple.core.util.ByteArrayUtil;

public abstract class AbstractOpenSessionRespPars
extends AbstractPoResponseParser {
    private static final Map<Integer, AbstractApduResponseParser.StatusProperties> STATUS_TABLE;
    SecureSession secureSession;

    protected Map<Integer, AbstractApduResponseParser.StatusProperties> getStatusTable() {
        return STATUS_TABLE;
    }

    AbstractOpenSessionRespPars(ApduResponse response, AbstractOpenSessionCmdBuild<AbstractOpenSessionRespPars> builder, PoRevision revision) {
        super(response, builder);
        byte[] dataOut = response.getDataOut();
        if (dataOut.length > 0) {
            this.secureSession = this.toSecureSession(dataOut);
        }
    }

    public AbstractOpenSessionRespPars create(ApduResponse response, PoRevision revision) {
        switch (revision) {
            case REV1_0: {
                return new OpenSession10RespPars(response, (OpenSession10CmdBuild)this.builder);
            }
            case REV2_4: {
                return new OpenSession24RespPars(response, (OpenSession24CmdBuild)this.builder);
            }
            case REV3_1: 
            case REV3_1_CLAP: {
                return new OpenSession31RespPars(response, (OpenSession31CmdBuild)this.builder);
            }
            case REV3_2: {
                return new OpenSession32RespPars(response, (OpenSession32CmdBuild)this.builder);
            }
        }
        throw new IllegalArgumentException("Unknow revision " + (Object)((Object)revision));
    }

    abstract SecureSession toSecureSession(byte[] var1);

    public byte[] getPoChallenge() {
        return this.secureSession.getChallengeRandomNumber();
    }

    public int getTransactionCounterValue() {
        return ByteArrayUtil.threeBytesToInt((byte[])this.secureSession.getChallengeTransactionCounter(), (int)0);
    }

    public boolean wasRatified() {
        return this.secureSession.isPreviousSessionRatified();
    }

    public boolean isManageSecureSessionAuthorized() {
        return this.secureSession.isManageSecureSessionAuthorized();
    }

    public byte getSelectedKif() {
        return this.secureSession.getKIF();
    }

    public byte getSelectedKvc() {
        return this.secureSession.getKVC();
    }

    public byte[] getRecordDataRead() {
        return this.secureSession.getOriginalData();
    }

    static {
        HashMap<Integer, AbstractApduResponseParser.StatusProperties> m = new HashMap<Integer, AbstractApduResponseParser.StatusProperties>(AbstractApduResponseParser.STATUS_TABLE);
        m.put(26368, new AbstractApduResponseParser.StatusProperties("Lc value not supported.", CalypsoPoIllegalParameterException.class));
        m.put(26880, new AbstractApduResponseParser.StatusProperties("Transaction Counter is 0", CalypsoPoTerminatedException.class));
        m.put(27009, new AbstractApduResponseParser.StatusProperties("Command forbidden (read requested and current EF is a Binary file).", CalypsoPoDataAccessException.class));
        m.put(27010, new AbstractApduResponseParser.StatusProperties("Security conditions not fulfilled (PIN code not presented, AES key forbidding the compatibility mode, encryption required).", CalypsoPoSecurityContextException.class));
        m.put(27013, new AbstractApduResponseParser.StatusProperties("Access forbidden (Never access mode, Session already opened).", CalypsoPoAccessForbiddenException.class));
        m.put(27014, new AbstractApduResponseParser.StatusProperties("Command not allowed (read requested and no current EF).", CalypsoPoDataAccessException.class));
        m.put(27265, new AbstractApduResponseParser.StatusProperties("Wrong key index.", CalypsoPoIllegalParameterException.class));
        m.put(27266, new AbstractApduResponseParser.StatusProperties("File not found.", CalypsoPoDataAccessException.class));
        m.put(27267, new AbstractApduResponseParser.StatusProperties("Record not found (record index is above NumRec).", CalypsoPoDataAccessException.class));
        m.put(27392, new AbstractApduResponseParser.StatusProperties("P1 or P2 value not supported (key index incorrect, wrong P2).", CalypsoPoIllegalParameterException.class));
        m.put(25087, new AbstractApduResponseParser.StatusProperties("Correct execution (ISO7816 T=0).", null));
        STATUS_TABLE = m;
    }

    public static class SecureSession {
        private final byte[] challengeTransactionCounter;
        private final byte[] challengeRandomNumber;
        private final boolean previousSessionRatified;
        private final boolean manageSecureSessionAuthorized;
        private final byte kif;
        private final Byte kvc;
        private final byte[] originalData;
        private final byte[] secureSessionData;

        public SecureSession(byte[] challengeTransactionCounter, byte[] challengeRandomNumber, boolean previousSessionRatified, boolean manageSecureSessionAuthorized, byte kif, byte kvc, byte[] originalData, byte[] secureSessionData) {
            this.challengeTransactionCounter = challengeTransactionCounter;
            this.challengeRandomNumber = challengeRandomNumber;
            this.previousSessionRatified = previousSessionRatified;
            this.manageSecureSessionAuthorized = manageSecureSessionAuthorized;
            this.kif = kif;
            this.kvc = kvc;
            this.originalData = originalData;
            this.secureSessionData = secureSessionData;
        }

        public SecureSession(byte[] challengeTransactionCounter, byte[] challengeRandomNumber, boolean previousSessionRatified, boolean manageSecureSessionAuthorized, Byte kvc, byte[] originalData, byte[] secureSessionData) {
            this.challengeTransactionCounter = challengeTransactionCounter;
            this.challengeRandomNumber = challengeRandomNumber;
            this.previousSessionRatified = previousSessionRatified;
            this.manageSecureSessionAuthorized = manageSecureSessionAuthorized;
            this.kif = (byte)-1;
            this.kvc = kvc != null ? (byte)kvc : (byte)-1;
            this.originalData = originalData;
            this.secureSessionData = secureSessionData;
        }

        public byte[] getChallengeTransactionCounter() {
            return this.challengeTransactionCounter;
        }

        public byte[] getChallengeRandomNumber() {
            return this.challengeRandomNumber;
        }

        public boolean isPreviousSessionRatified() {
            return this.previousSessionRatified;
        }

        public boolean isManageSecureSessionAuthorized() {
            return this.manageSecureSessionAuthorized;
        }

        public byte getKIF() {
            return this.kif;
        }

        public byte getKVC() {
            return this.kvc;
        }

        public byte[] getOriginalData() {
            return this.originalData;
        }

        public byte[] getSecureSessionData() {
            return this.secureSessionData;
        }
    }
}

