/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.command.po.parser;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.keyple.calypso.command.po.AbstractPoResponseParser;
import org.eclipse.keyple.calypso.command.po.builder.SelectFileCmdBuild;
import org.eclipse.keyple.calypso.command.po.exception.CalypsoPoDataAccessException;
import org.eclipse.keyple.calypso.command.po.exception.CalypsoPoIllegalParameterException;
import org.eclipse.keyple.core.card.command.AbstractApduResponseParser;
import org.eclipse.keyple.core.card.message.ApduResponse;
import org.eclipse.keyple.core.util.Assert;
import org.eclipse.keyple.core.util.bertlv.TLV;
import org.eclipse.keyple.core.util.bertlv.Tag;

public final class SelectFileRespPars
extends AbstractPoResponseParser {
    private static final Map<Integer, AbstractApduResponseParser.StatusProperties> STATUS_TABLE;
    private byte[] proprietaryInformation = null;
    private static final Tag TAG_PROPRIETARY_INFORMATION;

    protected Map<Integer, AbstractApduResponseParser.StatusProperties> getStatusTable() {
        return STATUS_TABLE;
    }

    public SelectFileRespPars(ApduResponse response, SelectFileCmdBuild builder) {
        super(response, builder);
    }

    public byte[] getProprietaryInformation() {
        if (this.proprietaryInformation == null) {
            TLV tlv = new TLV(this.response.getDataOut());
            if (!tlv.parse(TAG_PROPRIETARY_INFORMATION, 0)) {
                throw new IllegalStateException("Proprietary information: tag not found.");
            }
            this.proprietaryInformation = tlv.getValue();
            Assert.getInstance().isEqual(Integer.valueOf(this.proprietaryInformation.length), 23, "proprietaryInformation");
        }
        return this.proprietaryInformation;
    }

    static {
        HashMap<Integer, AbstractApduResponseParser.StatusProperties> m = new HashMap<Integer, AbstractApduResponseParser.StatusProperties>(AbstractApduResponseParser.STATUS_TABLE);
        m.put(26368, new AbstractApduResponseParser.StatusProperties("Lc value not supported.", CalypsoPoIllegalParameterException.class));
        m.put(27266, new AbstractApduResponseParser.StatusProperties("File not found.", CalypsoPoDataAccessException.class));
        m.put(24857, new AbstractApduResponseParser.StatusProperties("Correct execution (ISO7816 T=0).", null));
        STATUS_TABLE = m;
        TAG_PROPRIETARY_INFORMATION = new Tag(5, 2, Tag.TagType.PRIMITIVE, 1);
    }
}

