/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.command.po.parser;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.keyple.calypso.command.po.AbstractPoResponseParser;
import org.eclipse.keyple.calypso.command.po.builder.ReadRecordsCmdBuild;
import org.eclipse.keyple.calypso.command.po.exception.CalypsoPoAccessForbiddenException;
import org.eclipse.keyple.calypso.command.po.exception.CalypsoPoDataAccessException;
import org.eclipse.keyple.calypso.command.po.exception.CalypsoPoIllegalParameterException;
import org.eclipse.keyple.calypso.command.po.exception.CalypsoPoSecurityContextException;
import org.eclipse.keyple.core.card.command.AbstractApduResponseParser;
import org.eclipse.keyple.core.card.message.ApduResponse;

public final class ReadRecordsRespPars
extends AbstractPoResponseParser {
    private static final Map<Integer, AbstractApduResponseParser.StatusProperties> STATUS_TABLE;

    protected Map<Integer, AbstractApduResponseParser.StatusProperties> getStatusTable() {
        return STATUS_TABLE;
    }

    public ReadRecordsRespPars(ApduResponse apduResponse, ReadRecordsCmdBuild builder) {
        super(apduResponse, builder);
    }

    public SortedMap<Integer, byte[]> getRecords() {
        TreeMap<Integer, byte[]> records = new TreeMap<Integer, byte[]>();
        if (((ReadRecordsCmdBuild)this.builder).getReadMode() == ReadRecordsCmdBuild.ReadMode.ONE_RECORD) {
            records.put(((ReadRecordsCmdBuild)this.builder).getFirstRecordNumber(), this.response.getDataOut());
        } else {
            byte[] apdu = this.response.getDataOut();
            int apduLen = apdu.length;
            int index = 0;
            while (apduLen > 0) {
                byte recordNb = apdu[index++];
                byte len = apdu[index++];
                records.put(Integer.valueOf(recordNb), Arrays.copyOfRange(apdu, index, index + len));
                index += len;
                apduLen = apduLen - 2 - len;
            }
        }
        return records;
    }

    static {
        HashMap<Integer, AbstractApduResponseParser.StatusProperties> m = new HashMap<Integer, AbstractApduResponseParser.StatusProperties>(AbstractApduResponseParser.STATUS_TABLE);
        m.put(27009, new AbstractApduResponseParser.StatusProperties("Command forbidden on binary files", CalypsoPoDataAccessException.class));
        m.put(27010, new AbstractApduResponseParser.StatusProperties("Security conditions not fulfilled (PIN code not presented, encryption required).", CalypsoPoSecurityContextException.class));
        m.put(27013, new AbstractApduResponseParser.StatusProperties("Access forbidden (Never access mode, stored value log file and a stored value operation was done during the current session).", CalypsoPoAccessForbiddenException.class));
        m.put(27014, new AbstractApduResponseParser.StatusProperties("Command not allowed (no current EF)", CalypsoPoDataAccessException.class));
        m.put(27266, new AbstractApduResponseParser.StatusProperties("File not found", CalypsoPoDataAccessException.class));
        m.put(27267, new AbstractApduResponseParser.StatusProperties("Record not found (record index is 0, or above NumRec", CalypsoPoDataAccessException.class));
        m.put(27392, new AbstractApduResponseParser.StatusProperties("P2 value not supported", CalypsoPoIllegalParameterException.class));
        STATUS_TABLE = m;
    }
}

