/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.command.po.parser;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.keyple.calypso.command.po.AbstractPoResponseParser;
import org.eclipse.keyple.calypso.command.po.builder.GetDataFciCmdBuild;
import org.eclipse.keyple.calypso.command.po.exception.CalypsoPoDataAccessException;
import org.eclipse.keyple.calypso.command.po.exception.CalypsoPoIllegalParameterException;
import org.eclipse.keyple.core.card.command.AbstractApduResponseParser;
import org.eclipse.keyple.core.card.message.ApduResponse;
import org.eclipse.keyple.core.util.ByteArrayUtil;
import org.eclipse.keyple.core.util.bertlv.TLV;
import org.eclipse.keyple.core.util.bertlv.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GetDataFciRespPars
extends AbstractPoResponseParser {
    private static final Logger logger = LoggerFactory.getLogger(GetDataFciRespPars.class);
    private static final Map<Integer, AbstractApduResponseParser.StatusProperties> STATUS_TABLE;
    private static final Tag TAG_FCI_TEMPLATE;
    private static final Tag TAG_DF_NAME;
    private static final Tag TAG_FCI_PROPRIETARY_TEMPLATE;
    private static final Tag TAG_FCI_ISSUER_DISCRETIONARY_DATA;
    private static final Tag TAG_APPLICATION_SERIAL_NUMBER;
    private static final Tag TAG_DISCRETIONARY_DATA;
    private boolean isDfInvalidated = false;
    private boolean isValidCalypsoFCI = false;
    private byte[] dfName = null;
    private byte[] applicationSN = null;
    private byte[] discretionaryData = null;

    protected Map<Integer, AbstractApduResponseParser.StatusProperties> getStatusTable() {
        return STATUS_TABLE;
    }

    public GetDataFciRespPars(ApduResponse response, GetDataFciCmdBuild builder) {
        super(response, builder);
        if (response.getStatusCode() == 25219) {
            logger.debug("The response to the select application command status word indicates that the DF has been invalidated.");
            this.isDfInvalidated = true;
        }
        try {
            byte[] responseData = response.getBytes();
            TLV tlv = new TLV(responseData);
            if (!tlv.parse(TAG_FCI_TEMPLATE, 0)) {
                logger.error("FCI parsing error: FCI template tag not found.");
                return;
            }
            if (!tlv.parse(TAG_DF_NAME, tlv.getPosition())) {
                logger.error("FCI parsing error: DF name tag not found.");
                return;
            }
            this.dfName = tlv.getValue();
            if (!tlv.parse(TAG_FCI_PROPRIETARY_TEMPLATE, tlv.getPosition())) {
                logger.error("FCI parsing error: FCI proprietary template tag not found.");
                return;
            }
            if (!tlv.parse(TAG_FCI_ISSUER_DISCRETIONARY_DATA, tlv.getPosition())) {
                logger.error("FCI parsing error: FCI issuer discretionary data tag not found.");
                return;
            }
            if (!tlv.parse(TAG_APPLICATION_SERIAL_NUMBER, tlv.getPosition())) {
                logger.error("FCI parsing error: serial number tag not found.");
                return;
            }
            this.applicationSN = tlv.getValue();
            if (logger.isDebugEnabled()) {
                logger.debug("Application Serial Number = {}", (Object)ByteArrayUtil.toHex((byte[])this.applicationSN));
            }
            if (!tlv.parse(TAG_DISCRETIONARY_DATA, tlv.getPosition())) {
                logger.error("FCI parsing error: discretionary data tag not found.");
                return;
            }
            this.discretionaryData = tlv.getValue();
            if (logger.isDebugEnabled()) {
                logger.debug("Discretionary Data = {}", (Object)ByteArrayUtil.toHex((byte[])this.discretionaryData));
            }
            this.isValidCalypsoFCI = true;
        }
        catch (Exception e) {
            logger.debug("Error while parsing the FCI BER-TLV data structure ({})", (Object)e.getMessage());
        }
    }

    public boolean isValidCalypsoFCI() {
        return this.isValidCalypsoFCI;
    }

    public byte[] getDfName() {
        return this.dfName;
    }

    public byte[] getApplicationSerialNumber() {
        return this.applicationSN;
    }

    public byte[] getDiscretionaryData() {
        return this.discretionaryData;
    }

    public boolean isDfInvalidated() {
        return this.isDfInvalidated;
    }

    static {
        HashMap<Integer, AbstractApduResponseParser.StatusProperties> m = new HashMap<Integer, AbstractApduResponseParser.StatusProperties>(AbstractApduResponseParser.STATUS_TABLE);
        m.put(27272, new AbstractApduResponseParser.StatusProperties("Data object not found (optional mode not available).", CalypsoPoDataAccessException.class));
        m.put(27392, new AbstractApduResponseParser.StatusProperties("P1 or P2 value not supported (<>004fh, 0062h, 006Fh, 00C0h, 00D0h, 0185h and 5F52h, according to available optional modes).", CalypsoPoIllegalParameterException.class));
        m.put(25219, new AbstractApduResponseParser.StatusProperties("Successful execution, FCI request and DF is invalidated.", null));
        STATUS_TABLE = m;
        TAG_FCI_TEMPLATE = new Tag(15, 1, Tag.TagType.CONSTRUCTED, 1);
        TAG_DF_NAME = new Tag(4, 2, Tag.TagType.PRIMITIVE, 1);
        TAG_FCI_PROPRIETARY_TEMPLATE = new Tag(5, 2, Tag.TagType.CONSTRUCTED, 1);
        TAG_FCI_ISSUER_DISCRETIONARY_DATA = new Tag(12, 2, Tag.TagType.CONSTRUCTED, 2);
        TAG_APPLICATION_SERIAL_NUMBER = new Tag(7, 3, Tag.TagType.PRIMITIVE, 1);
        TAG_DISCRETIONARY_DATA = new Tag(19, 1, Tag.TagType.PRIMITIVE, 1);
    }
}

