/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.command.po.builder.storedvalue;

import org.eclipse.keyple.calypso.command.PoClass;
import org.eclipse.keyple.calypso.command.po.AbstractPoCommandBuilder;
import org.eclipse.keyple.calypso.command.po.CalypsoPoCommand;
import org.eclipse.keyple.calypso.command.po.PoRevision;
import org.eclipse.keyple.calypso.command.po.parser.storedvalue.SvUndebitRespPars;
import org.eclipse.keyple.core.card.message.ApduResponse;

public final class SvUndebitCmdBuild
extends AbstractPoCommandBuilder<SvUndebitRespPars> {
    private static final CalypsoPoCommand command = CalypsoPoCommand.SV_UNDEBIT;
    private final PoClass poClass;
    private final PoRevision poRevision;
    private final byte[] dataIn;

    public SvUndebitCmdBuild(PoClass poClass, PoRevision poRevision, int amount, byte kvc, byte[] date, byte[] time) {
        super(command, null);
        if (amount < 0 || amount > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Amount is outside allowed boundaries (0 <= amount <= 32767)");
        }
        if (date == null || time == null) {
            throw new IllegalArgumentException("date and time cannot be null");
        }
        if (date.length != 2 || time.length != 2) {
            throw new IllegalArgumentException("date and time must be 2-byte arrays");
        }
        this.poRevision = poRevision;
        this.poClass = poClass;
        this.dataIn = new byte[15 + (poRevision == PoRevision.REV3_2 ? 10 : 5)];
        short amountShort = (short)amount;
        this.dataIn[1] = (byte)(amountShort >> 8 & 0xFF);
        this.dataIn[2] = (byte)(amountShort & 0xFF);
        this.dataIn[3] = date[0];
        this.dataIn[4] = date[1];
        this.dataIn[5] = time[0];
        this.dataIn[6] = time[1];
        this.dataIn[7] = kvc;
    }

    public void finalizeBuilder(byte[] undebitComplementaryData) {
        if (this.poRevision == PoRevision.REV3_2 && undebitComplementaryData.length != 20 || this.poRevision != PoRevision.REV3_2 && undebitComplementaryData.length != 15) {
            throw new IllegalArgumentException("Bad SV prepare load data length.");
        }
        byte p1 = undebitComplementaryData[4];
        byte p2 = undebitComplementaryData[5];
        this.dataIn[0] = undebitComplementaryData[6];
        System.arraycopy(undebitComplementaryData, 0, this.dataIn, 8, 4);
        System.arraycopy(undebitComplementaryData, 7, this.dataIn, 12, 3);
        System.arraycopy(undebitComplementaryData, 10, this.dataIn, 15, undebitComplementaryData.length - 10);
        this.request = this.setApduRequest(this.poClass.getValue(), command, p1, p2, this.dataIn, null);
    }

    public byte[] getSvUndebitData() {
        byte[] svUndebitData = new byte[12];
        svUndebitData[0] = command.getInstructionByte();
        svUndebitData[3] = this.poRevision == PoRevision.REV3_2 ? 25 : 20;
        System.arraycopy(this.dataIn, 0, svUndebitData, 4, 8);
        return svUndebitData;
    }

    @Override
    public SvUndebitRespPars createResponseParser(ApduResponse apduResponse) {
        return new SvUndebitRespPars(apduResponse, this);
    }

    @Override
    public boolean isSessionBufferUsed() {
        return true;
    }
}

