/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.command.po.builder.storedvalue;

import org.eclipse.keyple.calypso.command.PoClass;
import org.eclipse.keyple.calypso.command.po.AbstractPoCommandBuilder;
import org.eclipse.keyple.calypso.command.po.CalypsoPoCommand;
import org.eclipse.keyple.calypso.command.po.PoRevision;
import org.eclipse.keyple.calypso.command.po.parser.storedvalue.SvReloadRespPars;
import org.eclipse.keyple.core.card.message.ApduResponse;

public final class SvReloadCmdBuild
extends AbstractPoCommandBuilder<SvReloadRespPars> {
    private static final CalypsoPoCommand command = CalypsoPoCommand.SV_RELOAD;
    private final PoClass poClass;
    private final PoRevision poRevision;
    private final byte[] dataIn;

    public SvReloadCmdBuild(PoClass poClass, PoRevision poRevision, int amount, byte kvc, byte[] date, byte[] time, byte[] free) {
        super(command, null);
        if (amount < -8388608 || amount > 0x7FFFFF) {
            throw new IllegalArgumentException("Amount is outside allowed boundaries (-8388608 <= amount <=  8388607)");
        }
        if (date == null || time == null || free == null) {
            throw new IllegalArgumentException("date, time and free cannot be null");
        }
        if (date.length != 2 || time.length != 2 || free.length != 2) {
            throw new IllegalArgumentException("date, time and free must be 2-byte arrays");
        }
        this.poRevision = poRevision;
        this.poClass = poClass;
        this.dataIn = new byte[18 + (poRevision == PoRevision.REV3_2 ? 10 : 5)];
        this.dataIn[1] = date[0];
        this.dataIn[2] = date[1];
        this.dataIn[3] = free[0];
        this.dataIn[4] = kvc;
        this.dataIn[5] = free[1];
        this.dataIn[6] = (byte)(amount >> 16 & 0xFF);
        this.dataIn[7] = (byte)(amount >> 8 & 0xFF);
        this.dataIn[8] = (byte)(amount & 0xFF);
        this.dataIn[9] = time[0];
        this.dataIn[10] = time[1];
    }

    public void finalizeBuilder(byte[] reloadComplementaryData) {
        if (this.poRevision == PoRevision.REV3_2 && reloadComplementaryData.length != 20 || this.poRevision != PoRevision.REV3_2 && reloadComplementaryData.length != 15) {
            throw new IllegalArgumentException("Bad SV prepare load data length.");
        }
        byte p1 = reloadComplementaryData[4];
        byte p2 = reloadComplementaryData[5];
        this.dataIn[0] = reloadComplementaryData[6];
        System.arraycopy(reloadComplementaryData, 0, this.dataIn, 11, 4);
        System.arraycopy(reloadComplementaryData, 7, this.dataIn, 15, 3);
        System.arraycopy(reloadComplementaryData, 10, this.dataIn, 18, reloadComplementaryData.length - 10);
        this.request = this.setApduRequest(this.poClass.getValue(), command, p1, p2, this.dataIn, null);
    }

    public byte[] getSvReloadData() {
        byte[] svReloadData = new byte[15];
        svReloadData[0] = command.getInstructionByte();
        svReloadData[3] = this.poRevision == PoRevision.REV3_2 ? 28 : 23;
        System.arraycopy(this.dataIn, 0, svReloadData, 4, 11);
        return svReloadData;
    }

    @Override
    public SvReloadRespPars createResponseParser(ApduResponse apduResponse) {
        return new SvReloadRespPars(apduResponse, this);
    }

    @Override
    public boolean isSessionBufferUsed() {
        return true;
    }
}

