/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.command.po.builder.storedvalue;

import org.eclipse.keyple.calypso.command.PoClass;
import org.eclipse.keyple.calypso.command.po.AbstractPoCommandBuilder;
import org.eclipse.keyple.calypso.command.po.CalypsoPoCommand;
import org.eclipse.keyple.calypso.command.po.PoRevision;
import org.eclipse.keyple.calypso.command.po.parser.storedvalue.SvGetRespPars;
import org.eclipse.keyple.calypso.transaction.PoTransaction;
import org.eclipse.keyple.core.card.message.ApduResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SvGetCmdBuild
extends AbstractPoCommandBuilder<SvGetRespPars> {
    private static final Logger logger = LoggerFactory.getLogger(SvGetCmdBuild.class);
    private static final CalypsoPoCommand command = CalypsoPoCommand.SV_GET;
    private final PoTransaction.SvSettings.Operation svOperation;
    private final byte[] header;

    public SvGetCmdBuild(PoClass poClass, PoRevision poRevision, PoTransaction.SvSettings.Operation svOperation) {
        super(command, null);
        byte cla = poClass.getValue();
        byte p1 = poRevision == PoRevision.REV3_2 ? (byte)1 : 0;
        byte p2 = svOperation == PoTransaction.SvSettings.Operation.RELOAD ? (byte)7 : 9;
        this.request = this.setApduRequest(cla, command, p1, p2, null, (byte)0);
        if (logger.isDebugEnabled()) {
            this.addSubName(String.format("OPERATION=%s", svOperation.toString()));
        }
        this.header = new byte[4];
        this.header[0] = command.getInstructionByte();
        this.header[1] = p1;
        this.header[2] = p2;
        this.header[3] = 0;
        this.svOperation = svOperation;
    }

    public PoTransaction.SvSettings.Operation getSvOperation() {
        return this.svOperation;
    }

    @Override
    public SvGetRespPars createResponseParser(ApduResponse apduResponse) {
        return new SvGetRespPars(this.header, apduResponse, this);
    }

    @Override
    public boolean isSessionBufferUsed() {
        return false;
    }
}

