/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.command.po.builder.storedvalue;

import org.eclipse.keyple.calypso.command.PoClass;
import org.eclipse.keyple.calypso.command.po.AbstractPoCommandBuilder;
import org.eclipse.keyple.calypso.command.po.CalypsoPoCommand;
import org.eclipse.keyple.calypso.command.po.PoRevision;
import org.eclipse.keyple.calypso.command.po.parser.storedvalue.SvDebitRespPars;
import org.eclipse.keyple.core.card.message.ApduResponse;

public final class SvDebitCmdBuild
extends AbstractPoCommandBuilder<SvDebitRespPars> {
    private static final CalypsoPoCommand command = CalypsoPoCommand.SV_DEBIT;
    private final PoClass poClass;
    private final PoRevision poRevision;
    private final byte[] dataIn;

    public SvDebitCmdBuild(PoClass poClass, PoRevision poRevision, int amount, byte kvc, byte[] date, byte[] time) {
        super(command, null);
        if (amount < 0 || amount > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Amount is outside allowed boundaries (0 <= amount <= 32767)");
        }
        if (date == null || time == null) {
            throw new IllegalArgumentException("date and time cannot be null");
        }
        if (date.length != 2 || time.length != 2) {
            throw new IllegalArgumentException("date and time must be 2-byte arrays");
        }
        this.poRevision = poRevision;
        this.poClass = poClass;
        this.dataIn = new byte[15 + (poRevision == PoRevision.REV3_2 ? 10 : 5)];
        short amountShort = (short)(-amount);
        this.dataIn[1] = (byte)(amountShort >> 8 & 0xFF);
        this.dataIn[2] = (byte)(amountShort & 0xFF);
        this.dataIn[3] = date[0];
        this.dataIn[4] = date[1];
        this.dataIn[5] = time[0];
        this.dataIn[6] = time[1];
        this.dataIn[7] = kvc;
    }

    public void finalizeBuilder(byte[] debitComplementaryData) {
        if (this.poRevision == PoRevision.REV3_2 && debitComplementaryData.length != 20 || this.poRevision != PoRevision.REV3_2 && debitComplementaryData.length != 15) {
            throw new IllegalArgumentException("Bad SV prepare load data length.");
        }
        byte p1 = debitComplementaryData[4];
        byte p2 = debitComplementaryData[5];
        this.dataIn[0] = debitComplementaryData[6];
        System.arraycopy(debitComplementaryData, 0, this.dataIn, 8, 4);
        System.arraycopy(debitComplementaryData, 7, this.dataIn, 12, 3);
        System.arraycopy(debitComplementaryData, 10, this.dataIn, 15, debitComplementaryData.length - 10);
        this.request = this.setApduRequest(this.poClass.getValue(), command, p1, p2, this.dataIn, null);
    }

    public byte[] getSvDebitData() {
        byte[] svDebitData = new byte[12];
        svDebitData[0] = command.getInstructionByte();
        svDebitData[3] = this.poRevision == PoRevision.REV3_2 ? 25 : 20;
        System.arraycopy(this.dataIn, 0, svDebitData, 4, 8);
        return svDebitData;
    }

    @Override
    public SvDebitRespPars createResponseParser(ApduResponse apduResponse) {
        return new SvDebitRespPars(apduResponse, this);
    }

    @Override
    public boolean isSessionBufferUsed() {
        return true;
    }
}

