/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.command.po.builder.security;

import org.eclipse.keyple.calypso.command.PoClass;
import org.eclipse.keyple.calypso.command.po.AbstractPoCommandBuilder;
import org.eclipse.keyple.calypso.command.po.CalypsoPoCommand;
import org.eclipse.keyple.calypso.command.po.parser.security.VerifyPinRespPars;
import org.eclipse.keyple.calypso.transaction.PoTransaction;
import org.eclipse.keyple.core.card.message.ApduResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyPinCmdBuild
extends AbstractPoCommandBuilder<VerifyPinRespPars> {
    private static final Logger logger = LoggerFactory.getLogger(VerifyPinCmdBuild.class);
    private static final CalypsoPoCommand command = CalypsoPoCommand.VERIFY_PIN;
    private final byte cla;
    private final boolean readCounterOnly;

    public VerifyPinCmdBuild(PoClass poClass, PoTransaction.PinTransmissionMode pinTransmissionMode, byte[] pin) {
        super(command, null);
        if (pin == null || pinTransmissionMode == PoTransaction.PinTransmissionMode.PLAIN && pin.length != 4 || pinTransmissionMode == PoTransaction.PinTransmissionMode.ENCRYPTED && pin.length != 8) {
            throw new IllegalArgumentException("The PIN must be 4 bytes long");
        }
        this.cla = poClass.getValue();
        byte p1 = 0;
        byte p2 = 0;
        this.request = this.setApduRequest(this.cla, command, p1, p2, pin, null);
        if (logger.isDebugEnabled()) {
            this.addSubName(pinTransmissionMode.toString());
        }
        this.readCounterOnly = false;
    }

    public VerifyPinCmdBuild(PoClass poClass) {
        super(command, null);
        this.cla = poClass.getValue();
        byte p1 = 0;
        byte p2 = 0;
        this.request = this.setApduRequest(this.cla, command, p1, p2, null, null);
        if (logger.isDebugEnabled()) {
            this.addSubName("Read presentation counter");
        }
        this.readCounterOnly = true;
    }

    @Override
    public VerifyPinRespPars createResponseParser(ApduResponse apduResponse) {
        return new VerifyPinRespPars(apduResponse, this);
    }

    @Override
    public boolean isSessionBufferUsed() {
        return false;
    }

    public boolean isReadCounterOnly() {
        return this.readCounterOnly;
    }
}

