/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.command.po.builder.security;

import org.eclipse.keyple.calypso.command.PoClass;
import org.eclipse.keyple.calypso.command.po.CalypsoPoCommand;
import org.eclipse.keyple.calypso.command.po.PoRevision;
import org.eclipse.keyple.calypso.command.po.builder.security.AbstractOpenSessionCmdBuild;
import org.eclipse.keyple.calypso.command.po.parser.security.AbstractOpenSessionRespPars;
import org.eclipse.keyple.calypso.command.po.parser.security.OpenSession31RespPars;
import org.eclipse.keyple.core.card.message.ApduResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OpenSession31CmdBuild
extends AbstractOpenSessionCmdBuild<AbstractOpenSessionRespPars> {
    private static final Logger logger = LoggerFactory.getLogger(OpenSession31CmdBuild.class);
    private final int sfi;
    private final int recordNumber;

    public OpenSession31CmdBuild(byte keyIndex, byte[] samChallenge, int sfi, int recordNumber) {
        super(PoRevision.REV3_1);
        this.sfi = sfi;
        this.recordNumber = recordNumber;
        byte p1 = (byte)(recordNumber * 8 + keyIndex);
        byte p2 = (byte)(sfi * 8 + 1);
        byte le = 0;
        this.request = this.setApduRequest(PoClass.ISO.getValue(), CalypsoPoCommand.getOpenSessionForRev(PoRevision.REV3_1), p1, p2, samChallenge, le);
        if (logger.isDebugEnabled()) {
            String extraInfo = String.format("KEYINDEX=%d, SFI=%02X, REC=%d", keyIndex, sfi, recordNumber);
            this.addSubName(extraInfo);
        }
    }

    @Override
    public OpenSession31RespPars createResponseParser(ApduResponse apduResponse) {
        return new OpenSession31RespPars(apduResponse, this);
    }

    @Override
    public boolean isSessionBufferUsed() {
        return false;
    }

    @Override
    public int getSfi() {
        return this.sfi;
    }

    @Override
    public int getRecordNumber() {
        return this.recordNumber;
    }
}

