/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.command.po.builder.security;

import org.eclipse.keyple.calypso.command.PoClass;
import org.eclipse.keyple.calypso.command.po.CalypsoPoCommand;
import org.eclipse.keyple.calypso.command.po.PoRevision;
import org.eclipse.keyple.calypso.command.po.builder.security.AbstractOpenSessionCmdBuild;
import org.eclipse.keyple.calypso.command.po.parser.security.AbstractOpenSessionRespPars;
import org.eclipse.keyple.calypso.command.po.parser.security.OpenSession24RespPars;
import org.eclipse.keyple.core.card.message.ApduResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OpenSession24CmdBuild
extends AbstractOpenSessionCmdBuild<AbstractOpenSessionRespPars> {
    private static final Logger logger = LoggerFactory.getLogger(OpenSession24CmdBuild.class);
    private final int sfi;
    private final int recordNumber;

    public OpenSession24CmdBuild(byte keyIndex, byte[] samChallenge, int sfi, int recordNumber) {
        super(PoRevision.REV2_4);
        if (keyIndex == 0) {
            throw new IllegalArgumentException("Key index can't be null for rev 2.4!");
        }
        this.sfi = sfi;
        this.recordNumber = recordNumber;
        byte p1 = (byte)(128 + recordNumber * 8 + keyIndex);
        byte p2 = (byte)(sfi * 8);
        byte le = 0;
        this.request = this.setApduRequest(PoClass.LEGACY.getValue(), CalypsoPoCommand.getOpenSessionForRev(PoRevision.REV2_4), p1, p2, samChallenge, le);
        if (logger.isDebugEnabled()) {
            String extraInfo = String.format("KEYINDEX=%d, SFI=%02X, REC=%d", keyIndex, sfi, recordNumber);
            this.addSubName(extraInfo);
        }
    }

    @Override
    public OpenSession24RespPars createResponseParser(ApduResponse apduResponse) {
        return new OpenSession24RespPars(apduResponse, this);
    }

    @Override
    public boolean isSessionBufferUsed() {
        return false;
    }

    @Override
    public int getSfi() {
        return this.sfi;
    }

    @Override
    public int getRecordNumber() {
        return this.recordNumber;
    }
}

