/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.command.po.builder.security;

import org.eclipse.keyple.calypso.command.PoClass;
import org.eclipse.keyple.calypso.command.po.AbstractPoCommandBuilder;
import org.eclipse.keyple.calypso.command.po.CalypsoPoCommand;
import org.eclipse.keyple.calypso.command.po.parser.security.CloseSessionRespPars;
import org.eclipse.keyple.core.card.message.ApduResponse;
import org.eclipse.keyple.core.util.ByteArrayUtil;

public final class CloseSessionCmdBuild
extends AbstractPoCommandBuilder<CloseSessionRespPars> {
    private static final CalypsoPoCommand command = CalypsoPoCommand.CLOSE_SESSION;

    public CloseSessionCmdBuild(PoClass poClass, boolean ratificationAsked, byte[] terminalSessionSignature) {
        super(command, null);
        if (terminalSessionSignature != null && terminalSessionSignature.length != 4 && terminalSessionSignature.length != 8) {
            throw new IllegalArgumentException("Invalid terminal sessionSignature: " + ByteArrayUtil.toHex((byte[])terminalSessionSignature));
        }
        byte p1 = ratificationAsked ? (byte)-128 : 0;
        byte le = 0;
        this.request = this.setApduRequest(poClass.getValue(), command, p1, (byte)0, terminalSessionSignature, le);
    }

    public CloseSessionCmdBuild(PoClass poClass) {
        super(command, null);
        this.request = this.setApduRequest(poClass.getValue(), command, (byte)0, (byte)0, null, (byte)0);
    }

    @Override
    public CloseSessionRespPars createResponseParser(ApduResponse apduResponse) {
        return new CloseSessionRespPars(apduResponse, this);
    }

    @Override
    public boolean isSessionBufferUsed() {
        return false;
    }
}

