/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.command.po.builder;

import org.eclipse.keyple.calypso.command.PoClass;
import org.eclipse.keyple.calypso.command.po.AbstractPoCommandBuilder;
import org.eclipse.keyple.calypso.command.po.CalypsoPoCommand;
import org.eclipse.keyple.calypso.command.po.parser.WriteRecordRespPars;
import org.eclipse.keyple.core.card.message.ApduResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WriteRecordCmdBuild
extends AbstractPoCommandBuilder<WriteRecordRespPars> {
    private static final Logger logger = LoggerFactory.getLogger(WriteRecordCmdBuild.class);
    private static final CalypsoPoCommand command = CalypsoPoCommand.WRITE_RECORD;
    private final int sfi;
    private final int recordNumber;
    private final byte[] data;

    public WriteRecordCmdBuild(PoClass poClass, byte sfi, int recordNumber, byte[] newRecordData) {
        super(command, null);
        byte cla = poClass.getValue();
        this.sfi = sfi;
        this.recordNumber = recordNumber;
        this.data = newRecordData;
        byte p2 = sfi == 0 ? (byte)4 : (byte)((byte)(sfi * 8) + 4);
        this.request = this.setApduRequest(cla, command, (byte)recordNumber, p2, newRecordData, null);
        if (logger.isDebugEnabled()) {
            String extraInfo = String.format("SFI=%02X, REC=%d", sfi, recordNumber);
            this.addSubName(extraInfo);
        }
    }

    @Override
    public WriteRecordRespPars createResponseParser(ApduResponse apduResponse) {
        return new WriteRecordRespPars(apduResponse, this);
    }

    @Override
    public boolean isSessionBufferUsed() {
        return true;
    }

    public int getSfi() {
        return this.sfi;
    }

    public int getRecordNumber() {
        return this.recordNumber;
    }

    public byte[] getData() {
        return this.data;
    }
}

