/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.command.po.builder;

import org.eclipse.keyple.calypso.SelectFileControl;
import org.eclipse.keyple.calypso.command.PoClass;
import org.eclipse.keyple.calypso.command.po.AbstractPoCommandBuilder;
import org.eclipse.keyple.calypso.command.po.CalypsoPoCommand;
import org.eclipse.keyple.calypso.command.po.parser.SelectFileRespPars;
import org.eclipse.keyple.core.card.message.ApduResponse;
import org.eclipse.keyple.core.util.ByteArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SelectFileCmdBuild
extends AbstractPoCommandBuilder<SelectFileRespPars> {
    private static final Logger logger = LoggerFactory.getLogger(SelectFileCmdBuild.class);
    private static final CalypsoPoCommand command = CalypsoPoCommand.SELECT_FILE;
    private final byte[] path;
    private final SelectFileControl selectFileControl;

    public SelectFileCmdBuild(PoClass poClass, SelectFileControl selectFileControl) {
        super(command, null);
        byte p2;
        byte p1;
        this.path = null;
        this.selectFileControl = selectFileControl;
        byte cla = poClass.getValue();
        byte[] selectData = new byte[]{0, 0};
        switch (selectFileControl) {
            case FIRST_EF: {
                p1 = 2;
                p2 = 0;
                break;
            }
            case NEXT_EF: {
                p1 = 2;
                p2 = 2;
                break;
            }
            case CURRENT_DF: {
                p1 = 9;
                p2 = 0;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported selectFileControl parameter " + selectFileControl.toString());
            }
        }
        this.request = this.setApduRequest(cla, command, p1, p2, selectData, (byte)0);
        if (logger.isDebugEnabled()) {
            this.addSubName("SELECTIONCONTROL" + (Object)((Object)selectFileControl));
        }
    }

    public SelectFileCmdBuild(PoClass poClass, byte[] selectionPath) {
        super(command, null);
        this.path = selectionPath;
        this.selectFileControl = null;
        byte p1 = (byte)(poClass == PoClass.LEGACY ? 8 : 9);
        this.request = this.setApduRequest(poClass.getValue(), command, p1, (byte)0, selectionPath, (byte)0);
        if (logger.isDebugEnabled()) {
            this.addSubName("SELECTIONPATH=" + ByteArrayUtil.toHex((byte[])selectionPath));
        }
    }

    @Override
    public SelectFileRespPars createResponseParser(ApduResponse apduResponse) {
        return new SelectFileRespPars(apduResponse, this);
    }

    @Override
    public boolean isSessionBufferUsed() {
        return false;
    }

    public byte[] getPath() {
        return this.path;
    }

    public SelectFileControl getSelectFileControl() {
        return this.selectFileControl;
    }
}

