/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.command.po.builder;

import org.eclipse.keyple.calypso.command.PoClass;
import org.eclipse.keyple.calypso.command.po.AbstractPoCommandBuilder;
import org.eclipse.keyple.calypso.command.po.CalypsoPoCommand;
import org.eclipse.keyple.calypso.command.po.parser.ReadRecordsRespPars;
import org.eclipse.keyple.core.card.message.ApduResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReadRecordsCmdBuild
extends AbstractPoCommandBuilder<ReadRecordsRespPars> {
    private static final Logger logger = LoggerFactory.getLogger(ReadRecordsCmdBuild.class);
    private static final CalypsoPoCommand command = CalypsoPoCommand.READ_RECORDS;
    private final int sfi;
    private final int firstRecordNumber;
    private final ReadMode readMode;

    public ReadRecordsCmdBuild(PoClass poClass, int sfi, int firstRecordNumber, ReadMode readMode, int expectedLength) {
        super(command, null);
        byte p2;
        this.sfi = sfi;
        this.firstRecordNumber = firstRecordNumber;
        this.readMode = readMode;
        byte p1 = (byte)firstRecordNumber;
        byte by = p2 = sfi == 0 ? (byte)5 : (byte)((byte)(sfi * 8) + 5);
        if (readMode == ReadMode.ONE_RECORD) {
            p2 = (byte)(p2 - 1);
        }
        byte le = (byte)expectedLength;
        this.request = this.setApduRequest(poClass.getValue(), command, p1, p2, null, le);
        if (logger.isDebugEnabled()) {
            String extraInfo = String.format("SFI=%02X, REC=%d, READMODE=%s, EXPECTEDLENGTH=%d", new Object[]{sfi, firstRecordNumber, readMode, expectedLength});
            this.addSubName(extraInfo);
        }
    }

    @Override
    public ReadRecordsRespPars createResponseParser(ApduResponse apduResponse) {
        return new ReadRecordsRespPars(apduResponse, this);
    }

    @Override
    public boolean isSessionBufferUsed() {
        return false;
    }

    public int getSfi() {
        return this.sfi;
    }

    public int getFirstRecordNumber() {
        return this.firstRecordNumber;
    }

    public ReadMode getReadMode() {
        return this.readMode;
    }

    public static enum ReadMode {
        ONE_RECORD,
        MULTIPLE_RECORD;

    }
}

