/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.command.po.builder;

import org.eclipse.keyple.calypso.command.PoClass;
import org.eclipse.keyple.calypso.command.po.AbstractPoCommandBuilder;
import org.eclipse.keyple.calypso.command.po.CalypsoPoCommand;
import org.eclipse.keyple.calypso.command.po.parser.IncreaseRespPars;
import org.eclipse.keyple.core.card.message.ApduResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IncreaseCmdBuild
extends AbstractPoCommandBuilder<IncreaseRespPars> {
    private static final Logger logger = LoggerFactory.getLogger(IncreaseCmdBuild.class);
    private static final CalypsoPoCommand command = CalypsoPoCommand.INCREASE;
    private final int sfi;
    private final int counterNumber;
    private final int incValue;

    public IncreaseCmdBuild(PoClass poClass, byte sfi, int counterNumber, int incValue) {
        super(command, null);
        byte cla = poClass.getValue();
        this.sfi = sfi;
        this.counterNumber = counterNumber;
        this.incValue = incValue;
        byte[] incValueBuffer = new byte[]{(byte)(incValue >> 16 & 0xFF), (byte)(incValue >> 8 & 0xFF), (byte)(incValue & 0xFF)};
        byte p2 = (byte)(sfi * 8);
        this.request = this.setApduRequest(cla, command, (byte)counterNumber, p2, incValueBuffer, (byte)0);
        if (logger.isDebugEnabled()) {
            String extraInfo = String.format("SFI=%02X, COUNTER=%d, INCREMENT=%d", sfi, counterNumber, incValue);
            this.addSubName(extraInfo);
        }
    }

    @Override
    public IncreaseRespPars createResponseParser(ApduResponse apduResponse) {
        return new IncreaseRespPars(apduResponse, this);
    }

    @Override
    public boolean isSessionBufferUsed() {
        return true;
    }

    public int getSfi() {
        return this.sfi;
    }

    public int getCounterNumber() {
        return this.counterNumber;
    }

    public int getIncValue() {
        return this.incValue;
    }
}

