/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.command.po.builder;

import org.eclipse.keyple.calypso.command.PoClass;
import org.eclipse.keyple.calypso.command.po.AbstractPoCommandBuilder;
import org.eclipse.keyple.calypso.command.po.CalypsoPoCommand;
import org.eclipse.keyple.calypso.command.po.parser.DecreaseRespPars;
import org.eclipse.keyple.core.card.message.ApduResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DecreaseCmdBuild
extends AbstractPoCommandBuilder<DecreaseRespPars> {
    private static final Logger logger = LoggerFactory.getLogger(DecreaseCmdBuild.class);
    private static final CalypsoPoCommand command = CalypsoPoCommand.DECREASE;
    private final int sfi;
    private final int counterNumber;
    private final int decValue;

    public DecreaseCmdBuild(PoClass poClass, byte sfi, int counterNumber, int decValue) {
        super(command, null);
        byte cla = poClass.getValue();
        this.sfi = sfi;
        this.counterNumber = counterNumber;
        this.decValue = decValue;
        byte[] decValueBuffer = new byte[]{(byte)(decValue >> 16 & 0xFF), (byte)(decValue >> 8 & 0xFF), (byte)(decValue & 0xFF)};
        byte p2 = (byte)(sfi * 8);
        this.request = this.setApduRequest(cla, command, (byte)counterNumber, p2, decValueBuffer, (byte)0);
        if (logger.isDebugEnabled()) {
            String extraInfo = String.format("SFI=%02X, COUNTER=%d, DECREMENT=%d", sfi, counterNumber, decValue);
            this.addSubName(extraInfo);
        }
    }

    @Override
    public DecreaseRespPars createResponseParser(ApduResponse apduResponse) {
        return new DecreaseRespPars(apduResponse, this);
    }

    @Override
    public boolean isSessionBufferUsed() {
        return true;
    }

    public int getSfi() {
        return this.sfi;
    }

    public int getCounterNumber() {
        return this.counterNumber;
    }

    public int getDecValue() {
        return this.decValue;
    }
}

