/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.command.po.builder;

import org.eclipse.keyple.calypso.command.PoClass;
import org.eclipse.keyple.calypso.command.po.AbstractPoCommandBuilder;
import org.eclipse.keyple.calypso.command.po.CalypsoPoCommand;
import org.eclipse.keyple.calypso.command.po.parser.AppendRecordRespPars;
import org.eclipse.keyple.core.card.message.ApduResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AppendRecordCmdBuild
extends AbstractPoCommandBuilder<AppendRecordRespPars> {
    private static final Logger logger = LoggerFactory.getLogger(AppendRecordCmdBuild.class);
    private static final CalypsoPoCommand command = CalypsoPoCommand.APPEND_RECORD;
    private final int sfi;
    private final byte[] data;

    public AppendRecordCmdBuild(PoClass poClass, byte sfi, byte[] newRecordData) {
        super(command, null);
        byte cla = poClass.getValue();
        this.sfi = sfi;
        this.data = newRecordData;
        byte p1 = 0;
        byte p2 = sfi == 0 ? (byte)0 : (byte)(sfi * 8);
        this.request = this.setApduRequest(cla, command, p1, p2, newRecordData, null);
        if (logger.isDebugEnabled()) {
            String extraInfo = String.format("SFI=%02X", sfi);
            this.addSubName(extraInfo);
        }
    }

    @Override
    public AppendRecordRespPars createResponseParser(ApduResponse apduResponse) {
        return new AppendRecordRespPars(apduResponse, this);
    }

    @Override
    public boolean isSessionBufferUsed() {
        return true;
    }

    public int getSfi() {
        return this.sfi;
    }

    public byte[] getData() {
        return this.data;
    }
}

