/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.command.po;

import org.eclipse.keyple.calypso.command.po.PoRevision;
import org.eclipse.keyple.core.card.command.CardCommand;

public enum CalypsoPoCommand implements CardCommand
{
    GET_DATA_FCI("Get Data'FCI'", -54),
    OPEN_SESSION_10("Open Secure Session V1", -118),
    OPEN_SESSION_24("Open Secure Session V2.4", -118),
    OPEN_SESSION_31("Open Secure Session V3.1", -118),
    OPEN_SESSION_32("Open Secure Session V3.2", -118),
    CLOSE_SESSION("Close Secure Session", -114),
    READ_RECORDS("Read Records", -78),
    UPDATE_RECORD("Update Record", -36),
    WRITE_RECORD("Write Record", -46),
    APPEND_RECORD("Append Record", -30),
    GET_CHALLENGE("Get Challenge", -124),
    INCREASE("Increase", 50),
    DECREASE("Decrease", 48),
    SELECT_FILE("Select File", -92),
    CHANGE_KEY("Change Key", -40),
    VERIFY_PIN("Verify PIN", 32),
    GET_DATA_TRACE("Get Data'Trace'", -54),
    SV_GET("SV Get", 124),
    SV_DEBIT("SV Debit", -70),
    SV_RELOAD("SV Reload", -72),
    SV_UNDEBIT("SV Undebit", -68),
    INVALIDATE("Invalidate", 4),
    REHABILITATE("Invalidate", 68);

    private final String name;
    private final byte instructionByte;

    private CalypsoPoCommand(String name, byte instructionByte) {
        this.name = name;
        this.instructionByte = instructionByte;
    }

    public String getName() {
        return this.name;
    }

    public byte getInstructionByte() {
        return this.instructionByte;
    }

    public static CalypsoPoCommand getOpenSessionForRev(PoRevision rev) {
        switch (rev) {
            case REV1_0: {
                return OPEN_SESSION_10;
            }
            case REV2_4: {
                return OPEN_SESSION_24;
            }
            case REV3_1: 
            case REV3_1_CLAP: {
                return OPEN_SESSION_31;
            }
            case REV3_2: {
                return OPEN_SESSION_32;
            }
        }
        throw new IllegalStateException("Any revision should have a matching command");
    }
}

