/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.plugin.remotese.pluginse;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.keyple.plugin.remotese.pluginse.VirtualReader;
import org.eclipse.keyple.plugin.remotese.pluginse.VirtualReaderSession;
import org.eclipse.keyple.plugin.remotese.pluginse.VirtualReaderSessionFactory;
import org.eclipse.keyple.plugin.remotese.rm.RemoteMethodTxEngine;
import org.eclipse.keyple.plugin.remotese.transport.DtoSender;
import org.eclipse.keyple.seproxy.event.PluginEvent;
import org.eclipse.keyple.seproxy.event.ReaderEvent;
import org.eclipse.keyple.seproxy.exception.KeypleReaderException;
import org.eclipse.keyple.seproxy.exception.KeypleReaderNotFoundException;
import org.eclipse.keyple.seproxy.message.ProxyReader;
import org.eclipse.keyple.seproxy.plugin.AbstractObservablePlugin;
import org.eclipse.keyple.seproxy.plugin.AbstractObservableReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RemoteSePlugin
extends AbstractObservablePlugin {
    private static final Logger logger = LoggerFactory.getLogger(RemoteSePlugin.class);
    public static final String PLUGIN_NAME = "RemoteSePlugin";
    private final VirtualReaderSessionFactory sessionManager;
    private final DtoSender sender;
    private final Map<String, String> parameters;

    RemoteSePlugin(VirtualReaderSessionFactory sessionManager, DtoSender sender) {
        super(PLUGIN_NAME);
        this.sessionManager = sessionManager;
        logger.info("Init RemoteSePlugin");
        this.sender = sender;
        this.parameters = new HashMap<String, String>();
    }

    public VirtualReader getReaderByRemoteName(String remoteName) throws KeypleReaderNotFoundException {
        for (AbstractObservableReader virtualReader : this.readers) {
            if (!((VirtualReader)virtualReader).getNativeReaderName().equals(remoteName)) continue;
            return (VirtualReader)virtualReader;
        }
        throw new KeypleReaderNotFoundException(remoteName);
    }

    ProxyReader createVirtualReader(String clientNodeId, String nativeReaderName, DtoSender dtoSender) throws KeypleReaderException {
        logger.debug("createVirtualReader for nativeReader {}", (Object)nativeReaderName);
        VirtualReaderSession session = this.sessionManager.createSession(nativeReaderName, clientNodeId);
        try {
            if (this.getReaderByRemoteName(nativeReaderName) != null) {
                throw new KeypleReaderException("Virtual Reader already exists for reader " + nativeReaderName);
            }
        }
        catch (KeypleReaderNotFoundException keypleReaderNotFoundException) {
            // empty catch block
        }
        logger.info("Create a new Virtual Reader with localReaderName {} with session {}", (Object)nativeReaderName, (Object)session.getSessionId());
        VirtualReader virtualReader = new VirtualReader(session, nativeReaderName, new RemoteMethodTxEngine(this.sender));
        this.readers.add(virtualReader);
        this.notifyObservers(new PluginEvent(this.getName(), virtualReader.getName(), PluginEvent.EventType.READER_CONNECTED));
        return virtualReader;
    }

    void disconnectRemoteReader(String nativeReaderName) throws KeypleReaderNotFoundException {
        logger.debug("Disconnect Virtual reader {}", (Object)nativeReaderName);
        VirtualReader virtualReader = this.getReaderByRemoteName(nativeReaderName);
        logger.info("Disconnect VirtualReader with name {} with session {}", (Object)nativeReaderName);
        virtualReader.clearObservers();
        this.readers.remove((Object)virtualReader);
        this.notifyObservers(new PluginEvent(this.getName(), virtualReader.getName(), PluginEvent.EventType.READER_DISCONNECTED));
    }

    void onReaderEvent(ReaderEvent event, String sessionId) {
        logger.debug("OnReaderEvent {}", (Object)event);
        logger.debug("Dispatch ReaderEvent to the appropriate Reader : {} sessionId : {}", (Object)event.getReaderName(), (Object)sessionId);
        try {
            VirtualReader virtualReader = this.getReaderByRemoteName(event.getReaderName());
            virtualReader.onRemoteReaderEvent(event);
        }
        catch (KeypleReaderNotFoundException e) {
            e.printStackTrace();
        }
    }

    protected SortedSet<AbstractObservableReader> initNativeReaders() throws KeypleReaderException {
        return new TreeSet<AbstractObservableReader>();
    }

    protected AbstractObservableReader fetchNativeReader(String name) throws KeypleReaderException {
        throw new IllegalArgumentException("fetchNativeReader is not used in this plugin, did you meant to use getReader?");
    }

    protected void startObservation() {
    }

    protected void stopObservation() {
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameter(String key, String value) throws IllegalArgumentException {
        this.parameters.put(key, value);
    }
}

