/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.plugin.remotese.nativese.method;

import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import org.eclipse.keyple.plugin.remotese.nativese.NativeReaderServiceImpl;
import org.eclipse.keyple.plugin.remotese.rm.RemoteMethod;
import org.eclipse.keyple.plugin.remotese.rm.RemoteMethodExecutor;
import org.eclipse.keyple.plugin.remotese.transport.KeypleDtoHelper;
import org.eclipse.keyple.plugin.remotese.transport.json.JsonParser;
import org.eclipse.keyple.plugin.remotese.transport.model.KeypleDto;
import org.eclipse.keyple.plugin.remotese.transport.model.TransportDto;
import org.eclipse.keyple.seproxy.event.DefaultSelectionRequest;
import org.eclipse.keyple.seproxy.event.ObservableReader;
import org.eclipse.keyple.seproxy.exception.KeypleReaderException;
import org.eclipse.keyple.seproxy.message.ProxyReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RmSetDefaultSelectionRequestExecutor
implements RemoteMethodExecutor {
    private static final Logger logger = LoggerFactory.getLogger(RmSetDefaultSelectionRequestExecutor.class);
    private final NativeReaderServiceImpl nativeReaderService;

    public RmSetDefaultSelectionRequestExecutor(NativeReaderServiceImpl nativeReaderService) {
        this.nativeReaderService = nativeReaderService;
    }

    @Override
    public TransportDto execute(TransportDto transportDto) {
        KeypleDto keypleDto = transportDto.getKeypleDTO();
        String body = keypleDto.getBody();
        JsonObject jsonObject = (JsonObject)JsonParser.getGson().fromJson(body, JsonObject.class);
        JsonPrimitive selectionRequestJson = jsonObject.getAsJsonPrimitive("defaultSelectionRequest");
        JsonPrimitive notificationModeJson = jsonObject.getAsJsonPrimitive("notificationMode");
        logger.trace("DefaultSelectionRequest : {}", (Object)selectionRequestJson.getAsString());
        logger.trace("Notification Mode : {}", (Object)notificationModeJson.getAsString());
        DefaultSelectionRequest defaultSelectionRequest = (DefaultSelectionRequest)JsonParser.getGson().fromJson(selectionRequestJson.getAsString(), DefaultSelectionRequest.class);
        ObservableReader.NotificationMode notificationMode = ObservableReader.NotificationMode.get((String)notificationModeJson.getAsString());
        String nativeReaderName = keypleDto.getNativeReaderName();
        logger.trace("Execute locally SetDefaultSelectionRequest : {} - {}", (Object)notificationMode, (Object)defaultSelectionRequest);
        try {
            ProxyReader reader = this.nativeReaderService.findLocalReader(nativeReaderName);
            if (reader instanceof ObservableReader) {
                logger.debug(reader.getName() + " is an ObservableReader, invoke setDefaultSelectionRequest on it");
                ((ObservableReader)reader).setDefaultSelectionRequest(defaultSelectionRequest, notificationMode);
                String parseBody = "{}";
                return transportDto.nextTransportDTO(new KeypleDto(RemoteMethod.DEFAULT_SELECTION_REQUEST.getName(), parseBody, false, keypleDto.getSessionId(), nativeReaderName, keypleDto.getVirtualReaderName(), keypleDto.getNodeId()));
            }
            throw new KeypleReaderException("Reader is not observable, can not invoke SetDefaultSelectionRequest on " + nativeReaderName);
        }
        catch (KeypleReaderException e) {
            return transportDto.nextTransportDTO(KeypleDtoHelper.ExceptionDTO(RemoteMethod.DEFAULT_SELECTION_REQUEST.getName(), e, keypleDto.getSessionId(), nativeReaderName, keypleDto.getVirtualReaderName(), keypleDto.getNodeId()));
        }
    }
}

