/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.seproxy.plugin;

import org.eclipse.keyple.seproxy.SeSelector;
import org.eclipse.keyple.seproxy.event.ObservableReader;
import org.eclipse.keyple.seproxy.exception.KeypleIOReaderException;
import org.eclipse.keyple.seproxy.message.AnswerToReset;
import org.eclipse.keyple.seproxy.message.ApduRequest;
import org.eclipse.keyple.seproxy.message.ApduResponse;
import org.eclipse.keyple.seproxy.message.SelectionStatus;
import org.eclipse.keyple.seproxy.plugin.AbstractLocalReader;
import org.eclipse.keyple.util.ByteArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSelectionLocalReader
extends AbstractLocalReader
implements ObservableReader {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSelectionLocalReader.class);

    protected AbstractSelectionLocalReader(String pluginName, String readerName) {
        super(pluginName, readerName);
    }

    @Override
    protected SelectionStatus openLogicalChannel(SeSelector seSelector) throws KeypleIOReaderException {
        SelectionStatus selectionStatus;
        byte[] atr = this.getATR();
        boolean selectionHasMatched = true;
        if (seSelector.getAtrFilter() != null) {
            if (atr == null) {
                throw new KeypleIOReaderException("Didn't get an ATR from the SE.");
            }
            if (logger.isTraceEnabled()) {
                logger.trace("[{}] openLogicalChannel => ATR: {}", (Object)this.getName(), (Object)ByteArrayUtils.toHex(atr));
            }
            if (!seSelector.getAtrFilter().atrMatches(atr)) {
                logger.trace("[{}] openLogicalChannel => ATR didn't match. SELECTOR = {}", (Object)this.getName(), (Object)seSelector);
                selectionHasMatched = false;
            }
        }
        if (selectionHasMatched && seSelector.getAidSelector() != null) {
            SeSelector.AidSelector aidSelector = seSelector.getAidSelector();
            byte[] aid = aidSelector.getAidToSelect();
            if (aid == null) {
                throw new IllegalArgumentException("AID must not be null for an AidSelector.");
            }
            if (logger.isTraceEnabled()) {
                logger.trace("[{}] openLogicalChannel => Select Application with AID = {}", (Object)this.getName(), (Object)ByteArrayUtils.toHex(aid));
            }
            byte[] selectApplicationCommand = new byte[6 + aid.length];
            selectApplicationCommand[0] = 0;
            selectApplicationCommand[1] = -92;
            selectApplicationCommand[2] = 4;
            selectApplicationCommand[3] = !aidSelector.isSelectNext() ? 0 : 2;
            selectApplicationCommand[4] = (byte)aid.length;
            System.arraycopy(aid, 0, selectApplicationCommand, 5, aid.length);
            selectApplicationCommand[5 + aid.length] = 0;
            ApduResponse fciResponse = this.processApduRequest(new ApduRequest("Internal Select Application", selectApplicationCommand, true, aidSelector.getSuccessfulSelectionStatusCodes()));
            if (!fciResponse.isSuccessful()) {
                logger.trace("[{}] openLogicalChannel => Application Selection failed. SELECTOR = {}", (Object)this.getName(), (Object)aidSelector);
            }
            selectionStatus = new SelectionStatus(new AnswerToReset(atr), fciResponse, fciResponse.isSuccessful());
        } else {
            selectionStatus = new SelectionStatus(new AnswerToReset(atr), new ApduResponse(null, null), selectionHasMatched);
        }
        return selectionStatus;
    }
}

