/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.seproxy.message;

import java.util.Arrays;
import org.eclipse.keyple.seproxy.message.AnswerToReset;
import org.eclipse.keyple.seproxy.message.ApduResponse;

public class SelectionStatus {
    private final AnswerToReset atr;
    private final ApduResponse fci;
    private final boolean isMatching;

    public SelectionStatus(AnswerToReset atr, ApduResponse fci, boolean isMatching) {
        if (atr == null && fci == null) {
            throw new IllegalArgumentException("Atr and Fci can't be null at the same time.");
        }
        this.atr = atr;
        this.fci = fci;
        this.isMatching = isMatching;
    }

    public AnswerToReset getAtr() {
        return this.atr;
    }

    public ApduResponse getFci() {
        return this.fci;
    }

    public boolean hasMatched() {
        return this.isMatching;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SelectionStatus)) {
            return false;
        }
        SelectionStatus selectionStatus = (SelectionStatus)o;
        return selectionStatus.getAtr() == null ? this.atr == null : (selectionStatus.getAtr().equals(this.atr) && selectionStatus.getFci() == null ? this.fci == null : selectionStatus.getFci().equals(this.fci) && selectionStatus.hasMatched() == this.isMatching);
    }

    public int hashCode() {
        int hash = 17;
        hash = 19 * hash + (this.isMatching ? 0 : 1);
        hash = 31 * hash + (this.atr == null ? 0 : Arrays.hashCode(this.atr.getBytes()));
        hash = 7 * hash + (this.fci == null ? 0 : Arrays.hashCode(this.fci.getBytes()));
        return hash;
    }
}

