/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.SSLParameters;
import jdk.incubator.http.AsyncSSLConnection;
import jdk.incubator.http.ConnectionPool;
import jdk.incubator.http.HttpClientImpl;
import jdk.incubator.http.HttpHeaders;
import jdk.incubator.http.HttpRequestImpl;
import jdk.incubator.http.PlainHttpConnection;
import jdk.incubator.http.PlainProxyConnection;
import jdk.incubator.http.PlainTunnelingConnection;
import jdk.incubator.http.SSLConnection;
import jdk.incubator.http.SSLTunnelConnection;
import jdk.incubator.http.internal.common.ByteBufferReference;

abstract class HttpConnection
implements Closeable {
    protected Mode mode;
    final InetSocketAddress address;
    final HttpClientImpl client;

    HttpConnection(InetSocketAddress inetSocketAddress, HttpClientImpl httpClientImpl) {
        this.address = inetSocketAddress;
        this.client = httpClientImpl;
    }

    public static HttpConnection getConnection(InetSocketAddress inetSocketAddress, HttpClientImpl httpClientImpl, HttpRequestImpl httpRequestImpl) {
        return HttpConnection.getConnectionImpl(inetSocketAddress, httpClientImpl, httpRequestImpl, false);
    }

    public static HttpConnection getConnection(InetSocketAddress inetSocketAddress, HttpClientImpl httpClientImpl, HttpRequestImpl httpRequestImpl, boolean bl) {
        return HttpConnection.getConnectionImpl(inetSocketAddress, httpClientImpl, httpRequestImpl, bl);
    }

    public abstract void connect() throws IOException, InterruptedException;

    public abstract CompletableFuture<Void> connectAsync();

    abstract boolean connected();

    abstract boolean isSecure();

    abstract boolean isProxied();

    abstract CompletableFuture<Void> whenReceivingResponse();

    final boolean isOpen() {
        return this.channel().isOpen();
    }

    private static HttpConnection getPlainConnection(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, HttpRequestImpl httpRequestImpl, HttpClientImpl httpClientImpl) {
        if (httpRequestImpl.isWebSocket() && inetSocketAddress2 != null) {
            return new PlainTunnelingConnection(inetSocketAddress, inetSocketAddress2, httpClientImpl);
        }
        if (inetSocketAddress2 == null) {
            return new PlainHttpConnection(inetSocketAddress, httpClientImpl);
        }
        return new PlainProxyConnection(inetSocketAddress2, httpClientImpl);
    }

    private static HttpConnection getSSLConnection(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, HttpRequestImpl httpRequestImpl, String[] stringArray, boolean bl, HttpClientImpl httpClientImpl) {
        if (inetSocketAddress2 != null) {
            return new SSLTunnelConnection(inetSocketAddress, httpClientImpl, inetSocketAddress2);
        }
        if (!bl) {
            return new SSLConnection(inetSocketAddress, httpClientImpl, stringArray);
        }
        return new AsyncSSLConnection(inetSocketAddress, httpClientImpl, stringArray);
    }

    private static HttpConnection getConnectionImpl(InetSocketAddress inetSocketAddress, HttpClientImpl httpClientImpl, HttpRequestImpl httpRequestImpl, boolean bl) {
        HttpConnection httpConnection = null;
        InetSocketAddress inetSocketAddress2 = httpRequestImpl.proxy(httpClientImpl);
        boolean bl2 = httpRequestImpl.secure();
        ConnectionPool connectionPool = httpClientImpl.connectionPool();
        String[] stringArray = null;
        if (bl2 && bl) {
            stringArray = new String[]{"h2", "http/1.1"};
        }
        if (!bl2) {
            httpConnection = connectionPool.getConnection(false, inetSocketAddress, inetSocketAddress2);
            if (httpConnection != null) {
                return httpConnection;
            }
            return HttpConnection.getPlainConnection(inetSocketAddress, inetSocketAddress2, httpRequestImpl, httpClientImpl);
        }
        if (!bl) {
            httpConnection = connectionPool.getConnection(true, inetSocketAddress, inetSocketAddress2);
        }
        if (httpConnection != null) {
            return httpConnection;
        }
        return HttpConnection.getSSLConnection(inetSocketAddress, inetSocketAddress2, httpRequestImpl, stringArray, bl, httpClientImpl);
    }

    void returnToCache(HttpHeaders httpHeaders) {
        if (httpHeaders == null) {
            this.close();
            return;
        }
        if (!this.isOpen()) {
            return;
        }
        ConnectionPool connectionPool = this.client.connectionPool();
        boolean bl = httpHeaders.firstValue("Connection").map(string -> !string.equalsIgnoreCase("close")).orElse(true);
        if (bl) {
            connectionPool.returnToPool(this);
        } else {
            this.close();
        }
    }

    final void checkWrite(long l, ByteBuffer byteBuffer) throws IOException {
        long l2 = this.write(byteBuffer);
        if (l2 != l) {
            throw new IOException("incorrect number of bytes written");
        }
    }

    final void checkWrite(long l, ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        long l2 = this.write(byteBufferArray, n, n2);
        if (l2 != l) {
            throw new IOException("incorrect number of bytes written");
        }
    }

    abstract SocketChannel channel();

    final InetSocketAddress address() {
        return this.address;
    }

    synchronized void configureMode(Mode mode) throws IOException {
        this.mode = mode;
        if (mode == Mode.BLOCKING) {
            this.channel().configureBlocking(true);
        } else {
            this.channel().configureBlocking(false);
        }
    }

    synchronized Mode getMode() {
        return this.mode;
    }

    abstract ConnectionPool.CacheKey cacheKey();

    SSLParameters sslParameters() {
        return null;
    }

    abstract long write(ByteBuffer[] var1, int var2, int var3) throws IOException;

    abstract long write(ByteBuffer var1) throws IOException;

    abstract void writeAsync(ByteBufferReference[] var1) throws IOException;

    abstract void writeAsyncUnordered(ByteBufferReference[] var1) throws IOException;

    abstract void flushAsync() throws IOException;

    @Override
    public abstract void close();

    abstract void shutdownInput() throws IOException;

    abstract void shutdownOutput() throws IOException;

    static void resumeChannelRead(ByteBuffer byteBuffer, int n) {
        int n2 = byteBuffer.limit();
        byteBuffer.position(n2);
        int n3 = byteBuffer.capacity() - n2;
        if (n > 0 && n < n3) {
            byteBuffer.limit(n2 + n);
        } else {
            byteBuffer.limit(byteBuffer.capacity());
        }
    }

    final ByteBuffer read() throws IOException {
        ByteBuffer byteBuffer = this.readImpl();
        return byteBuffer;
    }

    protected abstract ByteBuffer readImpl() throws IOException;

    public String toString() {
        return "HttpConnection: " + this.channel().toString();
    }

    static enum Mode {
        BLOCKING,
        NON_BLOCKING,
        ASYNC;

    }
}

