/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.LogManager;
import org.jboss.logmanager.LoggerNode;
import org.jboss.logmanager.SerializedLogger;

public final class Logger
extends java.util.logging.Logger
implements Serializable {
    private static final long serialVersionUID = 5093333069125075416L;
    private static final ResourceBundle TOMBSTONE = new ResourceBundle(){

        @Override
        protected Object handleGetObject(String key) {
            return null;
        }

        @Override
        public Enumeration<String> getKeys() {
            return null;
        }
    };
    private final LoggerNode loggerNode;
    private volatile ResourceBundle resourceBundle;
    private static final String LOGGER_CLASS_NAME = Logger.class.getName();
    static final int OFF_INT = Level.OFF.intValue();
    static final int SEVERE_INT = Level.SEVERE.intValue();
    static final int WARNING_INT = Level.WARNING.intValue();
    static final int INFO_INT = Level.INFO.intValue();
    static final int CONFIG_INT = Level.CONFIG.intValue();
    static final int FINE_INT = Level.FINE.intValue();
    static final int FINER_INT = Level.FINER.intValue();
    static final int FINEST_INT = Level.FINEST.intValue();

    public static Logger getLogger(String name) {
        return LogContext.getLogContext().getLogger(name);
    }

    public static Logger getLogger(String name, String bundleName) {
        Logger logger2 = LogContext.getLogContext().getLogger(name);
        logger2.resourceBundle = ResourceBundle.getBundle(bundleName, Locale.getDefault(), Logger.class.getClassLoader());
        return logger2;
    }

    Logger(LoggerNode loggerNode, String name) {
        super(name, null);
        super.setLevel(loggerNode.getLevel());
        this.loggerNode = loggerNode;
    }

    protected final Object writeReplace() throws ObjectStreamException {
        return new SerializedLogger(this.getName());
    }

    @Override
    public void setFilter(Filter filter) throws SecurityException {
        LogContext.checkAccess();
        this.loggerNode.setFilter(filter);
    }

    @Override
    public Filter getFilter() {
        return this.loggerNode.getFilter();
    }

    @Override
    public void setLevel(Level newLevel) throws SecurityException {
        LogContext.checkAccess();
        super.setLevel(newLevel);
        this.loggerNode.setLevel(newLevel);
    }

    public void setLevelName(String newLevelName) throws SecurityException {
        this.setLevel(this.loggerNode.getContext().getLevelForName(newLevelName));
    }

    public int getEffectiveLevel() {
        return this.loggerNode.getEffectiveLevel();
    }

    @Override
    public Level getLevel() {
        return this.loggerNode.getLevel();
    }

    @Override
    public boolean isLoggable(Level level) {
        return this.loggerNode.isLoggableLevel(level.intValue());
    }

    public <V> V getAttachment(AttachmentKey<V> key) {
        return this.loggerNode.getAttachment(key);
    }

    public <V> V attach(AttachmentKey<V> key, V value) throws SecurityException {
        LogContext.checkAccess();
        return this.loggerNode.attach(key, value);
    }

    public <V> V attachIfAbsent(AttachmentKey<V> key, V value) throws SecurityException {
        LogContext.checkAccess();
        return this.loggerNode.attachIfAbsent(key, value);
    }

    public <V> V detach(AttachmentKey<V> key) throws SecurityException {
        LogContext.checkAccess();
        return this.loggerNode.detach(key);
    }

    @Override
    public void addHandler(Handler handler) throws SecurityException {
        LogContext.checkAccess();
        if (handler == null) {
            throw new NullPointerException("handler is null");
        }
        this.loggerNode.addHandler(handler);
    }

    @Override
    public void removeHandler(Handler handler) throws SecurityException {
        LogContext.checkAccess();
        if (handler == null) {
            return;
        }
        this.loggerNode.removeHandler(handler);
    }

    @Override
    public Handler[] getHandlers() {
        Handler[] handlers = this.loggerNode.getHandlers();
        return handlers.length > 0 ? (Handler[])handlers.clone() : handlers;
    }

    public void setHandlers(Handler[] handlers) throws SecurityException {
        Handler[] safeHandlers;
        LogContext.checkAccess();
        for (Handler handler : safeHandlers = (Handler[])handlers.clone()) {
            if (handler != null) continue;
            throw new IllegalArgumentException("A handler is null");
        }
        this.loggerNode.setHandlers(safeHandlers);
    }

    public Handler[] getAndSetHandlers(Handler[] handlers) throws SecurityException {
        Handler[] safeHandlers;
        LogContext.checkAccess();
        for (Handler handler : safeHandlers = (Handler[])handlers.clone()) {
            if (handler != null) continue;
            throw new IllegalArgumentException("A handler is null");
        }
        return this.loggerNode.setHandlers(safeHandlers);
    }

    public boolean compareAndSetHandlers(Handler[] expected, Handler[] newHandlers) throws SecurityException {
        Object[] oldHandlers;
        Handler[] safeNewHandlers;
        LogContext.checkAccess();
        Object[] safeExpectedHandlers = (Handler[])expected.clone();
        for (Handler handler : safeNewHandlers = (Handler[])newHandlers.clone()) {
            if (handler != null) continue;
            throw new IllegalArgumentException("A handler is null");
        }
        do {
            if (Arrays.equals(oldHandlers = this.loggerNode.getHandlers(), safeExpectedHandlers)) continue;
            return false;
        } while (!this.loggerNode.compareAndSetHandlers((Handler[])oldHandlers, safeNewHandlers));
        return true;
    }

    public Handler[] clearHandlers() throws SecurityException {
        LogContext.checkAccess();
        return this.loggerNode.clearHandlers();
    }

    @Override
    public void setUseParentHandlers(boolean useParentHandlers) {
        LogContext.checkAccess();
        this.loggerNode.setUseParentHandlers(useParentHandlers);
    }

    @Override
    public boolean getUseParentHandlers() {
        return this.loggerNode.getUseParentHandlers();
    }

    public void setUseParentFilters(boolean useParentFilter) {
        LogContext.checkAccess();
        this.loggerNode.setUseParentFilters(useParentFilter);
    }

    public boolean getUseParentFilters() {
        return this.loggerNode.getUseParentFilters();
    }

    @Override
    public Logger getParent() {
        LoggerNode parentNode = this.loggerNode.getParent();
        return parentNode == null ? null : parentNode.createLogger();
    }

    @Override
    public void setParent(java.util.logging.Logger parent) {
        throw new SecurityException("setParent() disallowed");
    }

    public LogContext getLogContext() {
        return this.loggerNode.getContext();
    }

    @Override
    public void log(LogRecord record) {
        Filter filter = null;
        int effectiveLevel = this.loggerNode.getEffectiveLevel();
        if (!(LogManager.PER_THREAD_LOG_FILTER && (filter = LogManager.getThreadLocalLogFilter()) != null || this.loggerNode.isLoggableLevel(record.getLevel().intValue()))) {
            return;
        }
        if (LogManager.PER_THREAD_LOG_FILTER && filter != null && !filter.isLoggable(record)) {
            return;
        }
        this.logRaw(record);
    }

    @Override
    public void entering(String sourceClass, String sourceMethod) {
        Filter filter = null;
        if (!(LogManager.PER_THREAD_LOG_FILTER && (filter = LogManager.getThreadLocalLogFilter()) != null || this.loggerNode.isLoggableLevel(FINER_INT))) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(Level.FINER, "ENTRY", LOGGER_CLASS_NAME);
        rec.setSourceClassName(sourceClass);
        rec.setSourceMethodName(sourceMethod);
        if (LogManager.PER_THREAD_LOG_FILTER && filter != null && !filter.isLoggable(rec)) {
            return;
        }
        this.logRaw(rec);
    }

    @Override
    public void entering(String sourceClass, String sourceMethod, Object param1) {
        Filter filter = null;
        if (!(LogManager.PER_THREAD_LOG_FILTER && (filter = LogManager.getThreadLocalLogFilter()) != null || this.loggerNode.isLoggableLevel(FINER_INT))) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(Level.FINER, "ENTRY {0}", LOGGER_CLASS_NAME);
        rec.setSourceClassName(sourceClass);
        rec.setSourceMethodName(sourceMethod);
        rec.setParameters(new Object[]{param1});
        if (LogManager.PER_THREAD_LOG_FILTER && filter != null && !filter.isLoggable(rec)) {
            return;
        }
        this.logRaw(rec);
    }

    @Override
    public void entering(String sourceClass, String sourceMethod, Object[] params) {
        Filter filter = null;
        if (!(LogManager.PER_THREAD_LOG_FILTER && (filter = LogManager.getThreadLocalLogFilter()) != null || this.loggerNode.isLoggableLevel(FINER_INT))) {
            return;
        }
        StringBuilder builder = new StringBuilder("ENTRY");
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                builder.append(" {").append(i).append('}');
            }
        }
        ExtLogRecord rec = new ExtLogRecord(Level.FINER, builder.toString(), LOGGER_CLASS_NAME);
        rec.setSourceClassName(sourceClass);
        rec.setSourceMethodName(sourceMethod);
        if (params != null) {
            rec.setParameters(params);
        }
        if (LogManager.PER_THREAD_LOG_FILTER && filter != null && !filter.isLoggable(rec)) {
            return;
        }
        this.logRaw(rec);
    }

    @Override
    public void exiting(String sourceClass, String sourceMethod) {
        Filter filter = null;
        if (!(LogManager.PER_THREAD_LOG_FILTER && (filter = LogManager.getThreadLocalLogFilter()) != null || this.loggerNode.isLoggableLevel(FINER_INT))) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(Level.FINER, "RETURN", LOGGER_CLASS_NAME);
        rec.setSourceClassName(sourceClass);
        rec.setSourceMethodName(sourceMethod);
        if (LogManager.PER_THREAD_LOG_FILTER && filter != null && !filter.isLoggable(rec)) {
            return;
        }
        this.logRaw(rec);
    }

    @Override
    public void exiting(String sourceClass, String sourceMethod, Object result) {
        Filter filter = null;
        if (!(LogManager.PER_THREAD_LOG_FILTER && (filter = LogManager.getThreadLocalLogFilter()) != null || this.loggerNode.isLoggableLevel(FINER_INT))) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(Level.FINER, "RETURN {0}", LOGGER_CLASS_NAME);
        rec.setSourceClassName(sourceClass);
        rec.setSourceMethodName(sourceMethod);
        rec.setParameters(new Object[]{result});
        if (LogManager.PER_THREAD_LOG_FILTER && filter != null && !filter.isLoggable(rec)) {
            return;
        }
        this.logRaw(rec);
    }

    @Override
    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        Filter filter = null;
        if (!(LogManager.PER_THREAD_LOG_FILTER && (filter = LogManager.getThreadLocalLogFilter()) != null || this.loggerNode.isLoggableLevel(FINER_INT))) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(Level.FINER, "THROW", LOGGER_CLASS_NAME);
        rec.setSourceClassName(sourceClass);
        rec.setSourceMethodName(sourceMethod);
        rec.setThrown(thrown);
        if (LogManager.PER_THREAD_LOG_FILTER && filter != null && !filter.isLoggable(rec)) {
            return;
        }
        this.logRaw(rec);
    }

    @Override
    public void severe(String msg) {
        Filter filter = null;
        if (!(LogManager.PER_THREAD_LOG_FILTER && (filter = LogManager.getThreadLocalLogFilter()) != null || this.loggerNode.isLoggableLevel(SEVERE_INT))) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(Level.SEVERE, msg, LOGGER_CLASS_NAME);
        if (LogManager.PER_THREAD_LOG_FILTER && filter != null && !filter.isLoggable(rec)) {
            return;
        }
        this.logRaw(rec);
    }

    @Override
    public void severe(Supplier<String> msgSupplier) {
        Filter filter = null;
        if (!(LogManager.PER_THREAD_LOG_FILTER && (filter = LogManager.getThreadLocalLogFilter()) != null || this.loggerNode.isLoggableLevel(SEVERE_INT))) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(Level.SEVERE, msgSupplier.get(), LOGGER_CLASS_NAME);
        if (LogManager.PER_THREAD_LOG_FILTER && filter != null && !filter.isLoggable(rec)) {
            return;
        }
        this.logRaw(rec);
    }

    @Override
    public void warning(String msg) {
        Filter filter = null;
        if (!(LogManager.PER_THREAD_LOG_FILTER && (filter = LogManager.getThreadLocalLogFilter()) != null || this.loggerNode.isLoggableLevel(WARNING_INT))) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(Level.WARNING, msg, LOGGER_CLASS_NAME);
        if (LogManager.PER_THREAD_LOG_FILTER && filter != null && !filter.isLoggable(rec)) {
            return;
        }
        this.logRaw(rec);
    }

    @Override
    public void warning(Supplier<String> msgSupplier) {
        Filter filter = null;
        if (!(LogManager.PER_THREAD_LOG_FILTER && (filter = LogManager.getThreadLocalLogFilter()) != null || this.loggerNode.isLoggableLevel(WARNING_INT))) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(Level.WARNING, msgSupplier.get(), LOGGER_CLASS_NAME);
        if (LogManager.PER_THREAD_LOG_FILTER && filter != null && !filter.isLoggable(rec)) {
            return;
        }
        this.logRaw(rec);
    }

    @Override
    public void info(String msg) {
        Filter filter = null;
        if (!(LogManager.PER_THREAD_LOG_FILTER && (filter = LogManager.getThreadLocalLogFilter()) != null || this.loggerNode.isLoggableLevel(INFO_INT))) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(Level.INFO, msg, LOGGER_CLASS_NAME);
        if (LogManager.PER_THREAD_LOG_FILTER && filter != null && !filter.isLoggable(rec)) {
            return;
        }
        this.logRaw(rec);
    }

    @Override
    public void info(Supplier<String> msgSupplier) {
        Filter filter = null;
        if (!(LogManager.PER_THREAD_LOG_FILTER && (filter = LogManager.getThreadLocalLogFilter()) != null || this.loggerNode.isLoggableLevel(INFO_INT))) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(Level.INFO, msgSupplier.get(), LOGGER_CLASS_NAME);
        if (LogManager.PER_THREAD_LOG_FILTER && filter != null && !filter.isLoggable(rec)) {
            return;
        }
        this.logRaw(rec);
    }

    @Override
    public void config(String msg) {
        Filter filter = null;
        if (!(LogManager.PER_THREAD_LOG_FILTER && (filter = LogManager.getThreadLocalLogFilter()) != null || this.loggerNode.isLoggableLevel(CONFIG_INT))) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(Level.CONFIG, msg, LOGGER_CLASS_NAME);
        if (LogManager.PER_THREAD_LOG_FILTER && filter != null && !filter.isLoggable(rec)) {
            return;
        }
        this.logRaw(rec);
    }

    @Override
    public void config(Supplier<String> msgSupplier) {
        Filter filter = null;
        if (!(LogManager.PER_THREAD_LOG_FILTER && (filter = LogManager.getThreadLocalLogFilter()) != null || this.loggerNode.isLoggableLevel(CONFIG_INT))) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(Level.CONFIG, msgSupplier.get(), LOGGER_CLASS_NAME);
        if (LogManager.PER_THREAD_LOG_FILTER && filter != null && !filter.isLoggable(rec)) {
            return;
        }
        this.logRaw(rec);
    }

    @Override
    public void fine(String msg) {
        Filter filter = null;
        if (!(LogManager.PER_THREAD_LOG_FILTER && (filter = LogManager.getThreadLocalLogFilter()) != null || this.loggerNode.isLoggableLevel(FINE_INT))) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(Level.FINE, msg, LOGGER_CLASS_NAME);
        if (LogManager.PER_THREAD_LOG_FILTER && filter != null && !filter.isLoggable(rec)) {
            return;
        }
        this.logRaw(rec);
    }

    @Override
    public void fine(Supplier<String> msgSupplier) {
        Filter filter = null;
        if (!(LogManager.PER_THREAD_LOG_FILTER && (filter = LogManager.getThreadLocalLogFilter()) != null || this.loggerNode.isLoggableLevel(FINE_INT))) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(Level.FINE, msgSupplier.get(), LOGGER_CLASS_NAME);
        if (LogManager.PER_THREAD_LOG_FILTER && filter != null && !filter.isLoggable(rec)) {
            return;
        }
        this.logRaw(rec);
    }

    @Override
    public void finer(String msg) {
        Filter filter = null;
        if (!(LogManager.PER_THREAD_LOG_FILTER && (filter = LogManager.getThreadLocalLogFilter()) != null || this.loggerNode.isLoggableLevel(FINER_INT))) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(Level.FINER, msg, LOGGER_CLASS_NAME);
        if (LogManager.PER_THREAD_LOG_FILTER && filter != null && !filter.isLoggable(rec)) {
            return;
        }
        this.logRaw(rec);
    }

    @Override
    public void finer(Supplier<String> msgSupplier) {
        Filter filter = null;
        if (!(LogManager.PER_THREAD_LOG_FILTER && (filter = LogManager.getThreadLocalLogFilter()) != null || this.loggerNode.isLoggableLevel(FINER_INT))) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(Level.FINER, msgSupplier.get(), LOGGER_CLASS_NAME);
        if (LogManager.PER_THREAD_LOG_FILTER && filter != null && !filter.isLoggable(rec)) {
            return;
        }
        this.logRaw(rec);
    }

    @Override
    public void finest(String msg) {
        Filter filter = null;
        if (!(LogManager.PER_THREAD_LOG_FILTER && (filter = LogManager.getThreadLocalLogFilter()) != null || this.loggerNode.isLoggableLevel(FINEST_INT))) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(Level.FINEST, msg, LOGGER_CLASS_NAME);
        if (LogManager.PER_THREAD_LOG_FILTER && filter != null && !filter.isLoggable(rec)) {
            return;
        }
        this.logRaw(rec);
    }

    @Override
    public void finest(Supplier<String> msgSupplier) {
        Filter filter = null;
        if (!(LogManager.PER_THREAD_LOG_FILTER && (filter = LogManager.getThreadLocalLogFilter()) != null || this.loggerNode.isLoggableLevel(FINEST_INT))) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(Level.FINEST, msgSupplier.get(), LOGGER_CLASS_NAME);
        if (LogManager.PER_THREAD_LOG_FILTER && filter != null && !filter.isLoggable(rec)) {
            return;
        }
        this.logRaw(rec);
    }

    @Override
    public void log(Level level, String msg) {
        Filter filter = null;
        if (!(LogManager.PER_THREAD_LOG_FILTER && (filter = LogManager.getThreadLocalLogFilter()) != null || this.loggerNode.isLoggableLevel(level.intValue()))) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(level, msg, LOGGER_CLASS_NAME);
        if (LogManager.PER_THREAD_LOG_FILTER && filter != null && !filter.isLoggable(rec)) {
            return;
        }
        this.logRaw(rec);
    }

    @Override
    public void log(Level level, Supplier<String> msgSupplier) {
        Filter filter = null;
        if (!(LogManager.PER_THREAD_LOG_FILTER && (filter = LogManager.getThreadLocalLogFilter()) != null || this.loggerNode.isLoggableLevel(level.intValue()))) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(level, msgSupplier.get(), LOGGER_CLASS_NAME);
        if (LogManager.PER_THREAD_LOG_FILTER && filter != null && !filter.isLoggable(rec)) {
            return;
        }
        this.logRaw(rec);
    }

    @Override
    public void log(Level level, String msg, Object param1) {
        Filter filter = null;
        if (!(LogManager.PER_THREAD_LOG_FILTER && (filter = LogManager.getThreadLocalLogFilter()) != null || this.loggerNode.isLoggableLevel(level.intValue()))) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(level, msg, LOGGER_CLASS_NAME);
        rec.setParameters(new Object[]{param1});
        if (LogManager.PER_THREAD_LOG_FILTER && filter != null && !filter.isLoggable(rec)) {
            return;
        }
        this.logRaw(rec);
    }

    @Override
    public void log(Level level, String msg, Object[] params) {
        Filter filter = null;
        if (!(LogManager.PER_THREAD_LOG_FILTER && (filter = LogManager.getThreadLocalLogFilter()) != null || this.loggerNode.isLoggableLevel(level.intValue()))) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(level, msg, LOGGER_CLASS_NAME);
        if (params != null) {
            rec.setParameters(params);
        }
        if (LogManager.PER_THREAD_LOG_FILTER && filter != null && !filter.isLoggable(rec)) {
            return;
        }
        this.logRaw(rec);
    }

    @Override
    public void log(Level level, String msg, Throwable thrown) {
        Filter filter = null;
        if (!(LogManager.PER_THREAD_LOG_FILTER && (filter = LogManager.getThreadLocalLogFilter()) != null || this.loggerNode.isLoggableLevel(level.intValue()))) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(level, msg, LOGGER_CLASS_NAME);
        rec.setThrown(thrown);
        if (LogManager.PER_THREAD_LOG_FILTER && filter != null && !filter.isLoggable(rec)) {
            return;
        }
        this.logRaw(rec);
    }

    @Override
    public void log(Level level, Throwable thrown, Supplier<String> msgSupplier) {
        Filter filter = null;
        if (!(LogManager.PER_THREAD_LOG_FILTER && (filter = LogManager.getThreadLocalLogFilter()) != null || this.loggerNode.isLoggableLevel(level.intValue()))) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(level, msgSupplier.get(), LOGGER_CLASS_NAME);
        rec.setThrown(thrown);
        if (LogManager.PER_THREAD_LOG_FILTER && filter != null && !filter.isLoggable(rec)) {
            return;
        }
        this.logRaw(rec);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg) {
        Filter filter = null;
        if (!(LogManager.PER_THREAD_LOG_FILTER && (filter = LogManager.getThreadLocalLogFilter()) != null || this.loggerNode.isLoggableLevel(level.intValue()))) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(level, msg, LOGGER_CLASS_NAME);
        rec.setSourceClassName(sourceClass);
        rec.setSourceMethodName(sourceMethod);
        if (LogManager.PER_THREAD_LOG_FILTER && filter != null && !filter.isLoggable(rec)) {
            return;
        }
        this.logRaw(rec);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, Supplier<String> msgSupplier) {
        Filter filter = null;
        if (!(LogManager.PER_THREAD_LOG_FILTER && (filter = LogManager.getThreadLocalLogFilter()) != null || this.loggerNode.isLoggableLevel(level.intValue()))) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(level, msgSupplier.get(), LOGGER_CLASS_NAME);
        rec.setSourceClassName(sourceClass);
        rec.setSourceMethodName(sourceMethod);
        if (LogManager.PER_THREAD_LOG_FILTER && filter != null && !filter.isLoggable(rec)) {
            return;
        }
        this.logRaw(rec);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object param1) {
        Filter filter = null;
        if (!(LogManager.PER_THREAD_LOG_FILTER && (filter = LogManager.getThreadLocalLogFilter()) != null || this.loggerNode.isLoggableLevel(level.intValue()))) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(level, msg, LOGGER_CLASS_NAME);
        rec.setSourceClassName(sourceClass);
        rec.setSourceMethodName(sourceMethod);
        rec.setParameters(new Object[]{param1});
        if (LogManager.PER_THREAD_LOG_FILTER && filter != null && !filter.isLoggable(rec)) {
            return;
        }
        this.logRaw(rec);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object[] params) {
        Filter filter = null;
        if (!(LogManager.PER_THREAD_LOG_FILTER && (filter = LogManager.getThreadLocalLogFilter()) != null || this.loggerNode.isLoggableLevel(level.intValue()))) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(level, msg, LOGGER_CLASS_NAME);
        rec.setSourceClassName(sourceClass);
        rec.setSourceMethodName(sourceMethod);
        if (params != null) {
            rec.setParameters(params);
        }
        if (LogManager.PER_THREAD_LOG_FILTER && filter != null && !filter.isLoggable(rec)) {
            return;
        }
        this.logRaw(rec);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        Filter filter = null;
        if (!(LogManager.PER_THREAD_LOG_FILTER && (filter = LogManager.getThreadLocalLogFilter()) != null || this.loggerNode.isLoggableLevel(level.intValue()))) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(level, msg, LOGGER_CLASS_NAME);
        rec.setSourceClassName(sourceClass);
        rec.setSourceMethodName(sourceMethod);
        rec.setThrown(thrown);
        if (LogManager.PER_THREAD_LOG_FILTER && filter != null && !filter.isLoggable(rec)) {
            return;
        }
        this.logRaw(rec);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, Throwable thrown, Supplier<String> msgSupplier) {
        Filter filter = null;
        if (!(LogManager.PER_THREAD_LOG_FILTER && (filter = LogManager.getThreadLocalLogFilter()) != null || this.loggerNode.isLoggableLevel(level.intValue()))) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(level, msgSupplier.get(), LOGGER_CLASS_NAME);
        rec.setSourceClassName(sourceClass);
        rec.setSourceMethodName(sourceMethod);
        rec.setThrown(thrown);
        if (LogManager.PER_THREAD_LOG_FILTER && filter != null && !filter.isLoggable(rec)) {
            return;
        }
        this.logRaw(rec);
    }

    @Override
    @Deprecated(since="3.0", forRemoval=true)
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg) {
        if (!(LogManager.PER_THREAD_LOG_FILTER && LogManager.getThreadLocalLogFilter() != null || this.loggerNode.isLoggableLevel(level.intValue()))) {
            return;
        }
        super.logrb(level, sourceClass, sourceMethod, bundleName, msg);
    }

    @Override
    @Deprecated(since="3.0", forRemoval=true)
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object param1) {
        if (!(LogManager.PER_THREAD_LOG_FILTER && LogManager.getThreadLocalLogFilter() != null || this.loggerNode.isLoggableLevel(level.intValue()))) {
            return;
        }
        super.logrb(level, sourceClass, sourceMethod, bundleName, msg, param1);
    }

    @Override
    @Deprecated(since="3.0", forRemoval=true)
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object[] params) {
        if (!(LogManager.PER_THREAD_LOG_FILTER && LogManager.getThreadLocalLogFilter() != null || this.loggerNode.isLoggableLevel(level.intValue()))) {
            return;
        }
        super.logrb(level, sourceClass, sourceMethod, bundleName, msg, params);
    }

    @Override
    @Deprecated(since="3.0", forRemoval=true)
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Throwable thrown) {
        if (!(LogManager.PER_THREAD_LOG_FILTER && LogManager.getThreadLocalLogFilter() != null || this.loggerNode.isLoggableLevel(level.intValue()))) {
            return;
        }
        super.logrb(level, sourceClass, sourceMethod, bundleName, msg, thrown);
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, ResourceBundle bundle2, String msg, Object ... params) {
        if (!(LogManager.PER_THREAD_LOG_FILTER && LogManager.getThreadLocalLogFilter() != null || this.loggerNode.isLoggableLevel(level.intValue()))) {
            return;
        }
        super.logrb(level, sourceClass, sourceMethod, bundle2, msg, params);
    }

    @Override
    public void logrb(Level level, ResourceBundle bundle2, String msg, Object ... params) {
        if (!(LogManager.PER_THREAD_LOG_FILTER && LogManager.getThreadLocalLogFilter() != null || this.loggerNode.isLoggableLevel(level.intValue()))) {
            return;
        }
        super.logrb(level, bundle2, msg, params);
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, ResourceBundle bundle2, String msg, Throwable thrown) {
        if (!(LogManager.PER_THREAD_LOG_FILTER && LogManager.getThreadLocalLogFilter() != null || this.loggerNode.isLoggableLevel(level.intValue()))) {
            return;
        }
        super.logrb(level, sourceClass, sourceMethod, bundle2, msg, thrown);
    }

    @Override
    public void logrb(Level level, ResourceBundle bundle2, String msg, Throwable thrown) {
        if (!(LogManager.PER_THREAD_LOG_FILTER && LogManager.getThreadLocalLogFilter() != null || this.loggerNode.isLoggableLevel(level.intValue()))) {
            return;
        }
        super.logrb(level, bundle2, msg, thrown);
    }

    public void log(String fqcn, Level level, String message, String bundleName, ExtLogRecord.FormatStyle style, Object[] params, Throwable t) {
        Filter filter = null;
        if (level == null || fqcn == null || message == null || !LogManager.PER_THREAD_LOG_FILTER || (filter = LogManager.getThreadLocalLogFilter()) == null || !this.loggerNode.isLoggableLevel(level.intValue())) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(level, message, style, fqcn);
        rec.setResourceBundleName(bundleName);
        rec.setParameters(params);
        rec.setThrown(t);
        if (LogManager.PER_THREAD_LOG_FILTER && filter != null && !filter.isLoggable(rec)) {
            return;
        }
        this.logRaw(rec);
    }

    public void log(String fqcn, Level level, String message, ExtLogRecord.FormatStyle style, Object[] params, Throwable t) {
        Filter filter = null;
        if (level == null || fqcn == null || message == null || (!LogManager.PER_THREAD_LOG_FILTER || (filter = LogManager.getThreadLocalLogFilter()) == null) && !this.loggerNode.isLoggableLevel(level.intValue())) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(level, message, style, fqcn);
        rec.setParameters(params);
        rec.setThrown(t);
        if (LogManager.PER_THREAD_LOG_FILTER && filter != null && !filter.isLoggable(rec)) {
            return;
        }
        this.logRaw(rec);
    }

    public void log(String fqcn, Level level, String message, Throwable t) {
        this.log(fqcn, level, message, ExtLogRecord.FormatStyle.MESSAGE_FORMAT, null, t);
    }

    public void logRaw(ExtLogRecord record) {
        record.setLoggerName(this.getName());
        ResourceBundle bundle2 = this.getResourceBundle();
        if (bundle2 != null) {
            record.setResourceBundleName(bundle2.getBaseBundleName());
            record.setResourceBundle(bundle2);
        }
        try {
            if (!this.loggerNode.isLoggable(record)) {
                return;
            }
        }
        catch (VirtualMachineError e) {
            throw e;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.loggerNode.publish(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setResourceBundle(ResourceBundle resourceBundle) {
        super.setResourceBundle(resourceBundle);
        Logger logger2 = this;
        synchronized (logger2) {
            this.resourceBundle = resourceBundle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceBundle getResourceBundle() {
        if (this.resourceBundle == null) {
            Logger logger2 = this;
            synchronized (logger2) {
                if (this.resourceBundle == null) {
                    this.resourceBundle = super.getResourceBundle();
                    if (this.resourceBundle == null) {
                        this.resourceBundle = TOMBSTONE;
                    }
                }
            }
        }
        return this.resourceBundle == TOMBSTONE ? null : this.resourceBundle;
    }

    public void logRaw(LogRecord record) {
        this.logRaw(ExtLogRecord.wrap(record));
    }

    public String toString() {
        return "Logger '" + this.getName() + "' in context " + this.loggerNode.getContext();
    }

    public static final class AttachmentKey<V> {
    }
}

