/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.util;

import io.vertx.core.json.JsonObject;
import java.io.ByteArrayInputStream;
import java.net.URI;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import org.eclipse.hono.util.JsonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevocableTrustAnchor
extends TrustAnchor {
    private static final Logger LOG = LoggerFactory.getLogger(RevocableTrustAnchor.class);
    private boolean ocspEnabled;
    private URI ocspResponderUri;
    private X509Certificate ocspResponderCert;
    private boolean ocspNonceEnabled;

    public RevocableTrustAnchor(X500Principal caPrincipal, PublicKey pubKey, byte[] nameConstraints) {
        super(caPrincipal, pubKey, nameConstraints);
    }

    public RevocableTrustAnchor(X500Principal caPrincipal, PublicKey pubKey, byte[] nameConstraints, JsonObject trustedCAProps) {
        super(caPrincipal, pubKey, nameConstraints);
        this.setRevocationProperties(trustedCAProps);
    }

    private void setRevocationProperties(JsonObject keyProps) {
        byte[] ocspResponderCertData;
        this.ocspEnabled = JsonHelper.getValue(keyProps, "ocsp-revocation-enabled", Boolean.class, false);
        this.ocspNonceEnabled = JsonHelper.getValue(keyProps, "ocsp-revocation-enabled", Boolean.class, false);
        String ocspResponderUriString = JsonHelper.getValue(keyProps, "ocsp-responder-uri", String.class, null);
        if (ocspResponderUriString != null) {
            this.ocspResponderUri = URI.create(ocspResponderUriString);
        }
        if ((ocspResponderCertData = (byte[])JsonHelper.getValue(keyProps, "ocsp-responder-cert", byte[].class, null)) != null) {
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                this.ocspResponderCert = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(ocspResponderCertData));
            }
            catch (CertificateException e) {
                LOG.error("failed to parse OCSP responder certificate", e);
            }
        }
        this.ocspNonceEnabled = JsonHelper.getValue(keyProps, "ocsp-nonce-enabled", Boolean.class, false);
    }

    public boolean isOcspEnabled() {
        return this.ocspEnabled;
    }

    public void setOcspEnabled(boolean ocspEnabled) {
        this.ocspEnabled = ocspEnabled;
    }

    public URI getOcspResponderUri() {
        return this.ocspResponderUri;
    }

    public void setOcspResponderUri(URI ocspResponderUri) {
        this.ocspResponderUri = ocspResponderUri;
    }

    public X509Certificate getOcspResponderCert() {
        return this.ocspResponderCert;
    }

    public void setOcspResponderCert(X509Certificate ocspResponderCert) {
        this.ocspResponderCert = ocspResponderCert;
    }

    public boolean isOcspNonceEnabled() {
        return this.ocspNonceEnabled;
    }

    public void setOcspNonceEnabled(boolean ocspNonceEnabled) {
        this.ocspNonceEnabled = ocspNonceEnabled;
    }
}

