/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.admissionregistration.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.admissionregistration.v1.ValidatingWebhook;
import io.fabric8.kubernetes.api.model.admissionregistration.v1.ValidatingWebhookBuilder;
import io.fabric8.kubernetes.api.model.admissionregistration.v1.ValidatingWebhookConfiguration;
import io.fabric8.kubernetes.api.model.admissionregistration.v1.ValidatingWebhookConfigurationFluent;
import io.fabric8.kubernetes.api.model.admissionregistration.v1.ValidatingWebhookFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ValidatingWebhookConfigurationFluentImpl<A extends ValidatingWebhookConfigurationFluent<A>>
extends BaseFluent<A>
implements ValidatingWebhookConfigurationFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private ArrayList<ValidatingWebhookBuilder> webhooks = new ArrayList();
    private Map<String, Object> additionalProperties;

    public ValidatingWebhookConfigurationFluentImpl() {
    }

    public ValidatingWebhookConfigurationFluentImpl(ValidatingWebhookConfiguration instance) {
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withWebhooks(instance.getWebhooks());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public ValidatingWebhookConfigurationFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ValidatingWebhookConfigurationFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ValidatingWebhookConfigurationFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ValidatingWebhookConfigurationFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public ValidatingWebhookConfigurationFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A addToWebhooks(int index, ValidatingWebhook item) {
        if (this.webhooks == null) {
            this.webhooks = new ArrayList();
        }
        ValidatingWebhookBuilder builder = new ValidatingWebhookBuilder(item);
        if (index < 0 || index >= this.webhooks.size()) {
            this._visitables.get("webhooks").add(builder);
            this.webhooks.add(builder);
        } else {
            this._visitables.get("webhooks").add(index, builder);
            this.webhooks.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToWebhooks(int index, ValidatingWebhook item) {
        if (this.webhooks == null) {
            this.webhooks = new ArrayList();
        }
        ValidatingWebhookBuilder builder = new ValidatingWebhookBuilder(item);
        if (index < 0 || index >= this.webhooks.size()) {
            this._visitables.get("webhooks").add(builder);
            this.webhooks.add(builder);
        } else {
            this._visitables.get("webhooks").set(index, builder);
            this.webhooks.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToWebhooks(ValidatingWebhook ... items) {
        if (this.webhooks == null) {
            this.webhooks = new ArrayList();
        }
        for (ValidatingWebhook item : items) {
            ValidatingWebhookBuilder builder = new ValidatingWebhookBuilder(item);
            this._visitables.get("webhooks").add(builder);
            this.webhooks.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToWebhooks(Collection<ValidatingWebhook> items) {
        if (this.webhooks == null) {
            this.webhooks = new ArrayList();
        }
        for (ValidatingWebhook item : items) {
            ValidatingWebhookBuilder builder = new ValidatingWebhookBuilder(item);
            this._visitables.get("webhooks").add(builder);
            this.webhooks.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromWebhooks(ValidatingWebhook ... items) {
        for (ValidatingWebhook item : items) {
            ValidatingWebhookBuilder builder = new ValidatingWebhookBuilder(item);
            this._visitables.get("webhooks").remove(builder);
            if (this.webhooks == null) continue;
            this.webhooks.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromWebhooks(Collection<ValidatingWebhook> items) {
        for (ValidatingWebhook item : items) {
            ValidatingWebhookBuilder builder = new ValidatingWebhookBuilder(item);
            this._visitables.get("webhooks").remove(builder);
            if (this.webhooks == null) continue;
            this.webhooks.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromWebhooks(Predicate<ValidatingWebhookBuilder> predicate) {
        if (this.webhooks == null) {
            return (A)this;
        }
        Iterator<ValidatingWebhookBuilder> each = this.webhooks.iterator();
        Object visitables = this._visitables.get("webhooks");
        while (each.hasNext()) {
            ValidatingWebhookBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ValidatingWebhook> getWebhooks() {
        return this.webhooks != null ? ValidatingWebhookConfigurationFluentImpl.build(this.webhooks) : null;
    }

    @Override
    public List<ValidatingWebhook> buildWebhooks() {
        return this.webhooks != null ? ValidatingWebhookConfigurationFluentImpl.build(this.webhooks) : null;
    }

    @Override
    public ValidatingWebhook buildWebhook(int index) {
        return this.webhooks.get(index).build();
    }

    @Override
    public ValidatingWebhook buildFirstWebhook() {
        return this.webhooks.get(0).build();
    }

    @Override
    public ValidatingWebhook buildLastWebhook() {
        return this.webhooks.get(this.webhooks.size() - 1).build();
    }

    @Override
    public ValidatingWebhook buildMatchingWebhook(Predicate<ValidatingWebhookBuilder> predicate) {
        for (ValidatingWebhookBuilder item : this.webhooks) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingWebhook(Predicate<ValidatingWebhookBuilder> predicate) {
        for (ValidatingWebhookBuilder item : this.webhooks) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withWebhooks(List<ValidatingWebhook> webhooks) {
        if (this.webhooks != null) {
            this._visitables.get("webhooks").clear();
        }
        if (webhooks != null) {
            this.webhooks = new ArrayList();
            for (ValidatingWebhook item : webhooks) {
                this.addToWebhooks(item);
            }
        } else {
            this.webhooks = null;
        }
        return (A)this;
    }

    @Override
    public A withWebhooks(ValidatingWebhook ... webhooks) {
        if (this.webhooks != null) {
            this.webhooks.clear();
            this._visitables.remove("webhooks");
        }
        if (webhooks != null) {
            for (ValidatingWebhook item : webhooks) {
                this.addToWebhooks(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasWebhooks() {
        return this.webhooks != null && !this.webhooks.isEmpty();
    }

    @Override
    public ValidatingWebhookConfigurationFluent.WebhooksNested<A> addNewWebhook() {
        return new WebhooksNestedImpl();
    }

    @Override
    public ValidatingWebhookConfigurationFluent.WebhooksNested<A> addNewWebhookLike(ValidatingWebhook item) {
        return new WebhooksNestedImpl(-1, item);
    }

    @Override
    public ValidatingWebhookConfigurationFluent.WebhooksNested<A> setNewWebhookLike(int index, ValidatingWebhook item) {
        return new WebhooksNestedImpl(index, item);
    }

    @Override
    public ValidatingWebhookConfigurationFluent.WebhooksNested<A> editWebhook(int index) {
        if (this.webhooks.size() <= index) {
            throw new RuntimeException("Can't edit webhooks. Index exceeds size.");
        }
        return this.setNewWebhookLike(index, this.buildWebhook(index));
    }

    @Override
    public ValidatingWebhookConfigurationFluent.WebhooksNested<A> editFirstWebhook() {
        if (this.webhooks.size() == 0) {
            throw new RuntimeException("Can't edit first webhooks. The list is empty.");
        }
        return this.setNewWebhookLike(0, this.buildWebhook(0));
    }

    @Override
    public ValidatingWebhookConfigurationFluent.WebhooksNested<A> editLastWebhook() {
        int index = this.webhooks.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last webhooks. The list is empty.");
        }
        return this.setNewWebhookLike(index, this.buildWebhook(index));
    }

    @Override
    public ValidatingWebhookConfigurationFluent.WebhooksNested<A> editMatchingWebhook(Predicate<ValidatingWebhookBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.webhooks.size(); ++i) {
            if (!predicate.test(this.webhooks.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching webhooks. No match found.");
        }
        return this.setNewWebhookLike(index, this.buildWebhook(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ValidatingWebhookConfigurationFluentImpl that = (ValidatingWebhookConfigurationFluentImpl)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.webhooks, that.webhooks)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.webhooks, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.webhooks != null && !this.webhooks.isEmpty()) {
            sb.append("webhooks:");
            sb.append(this.webhooks + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class WebhooksNestedImpl<N>
    extends ValidatingWebhookFluentImpl<ValidatingWebhookConfigurationFluent.WebhooksNested<N>>
    implements ValidatingWebhookConfigurationFluent.WebhooksNested<N>,
    Nested<N> {
        ValidatingWebhookBuilder builder;
        int index;

        WebhooksNestedImpl(int index, ValidatingWebhook item) {
            this.index = index;
            this.builder = new ValidatingWebhookBuilder(this, item);
        }

        WebhooksNestedImpl() {
            this.index = -1;
            this.builder = new ValidatingWebhookBuilder(this);
        }

        @Override
        public N and() {
            return (N)ValidatingWebhookConfigurationFluentImpl.this.setToWebhooks(this.index, this.builder.build());
        }

        @Override
        public N endWebhook() {
            return this.and();
        }
    }

    class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ValidatingWebhookConfigurationFluent.MetadataNested<N>>
    implements ValidatingWebhookConfigurationFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ValidatingWebhookConfigurationFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

