/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.formatters;

import java.util.ArrayList;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.logmanager.formatters.ColorMap;
import org.jboss.logmanager.formatters.FormatStep;
import org.jboss.logmanager.formatters.Formatters;

public final class FormatStringParser {
    private static final Pattern pattern = Pattern.compile("([^%]++)|(?:%(?:(-)?(\\d+))?(?:\\.(-)?(\\d+))?(.)(?:\\{([^}]*)\\})?)");

    private FormatStringParser() {
    }

    public static FormatStep[] getSteps(String formatString, ColorMap colors) {
        long time = System.currentTimeMillis();
        ArrayList<FormatStep> stepList = new ArrayList<FormatStep>();
        Matcher matcher = pattern.matcher(formatString);
        TimeZone timeZone = TimeZone.getDefault();
        boolean colorUsed = false;
        block31: while (matcher.find()) {
            String otherText = matcher.group(1);
            if (otherText != null) {
                stepList.add(Formatters.textFormatStep(otherText));
                continue;
            }
            String hyphen = matcher.group(2);
            String minWidthString = matcher.group(3);
            String widthHyphen = matcher.group(4);
            String maxWidthString = matcher.group(5);
            String formatCharString = matcher.group(6);
            String argument = matcher.group(7);
            int minimumWidth = minWidthString == null ? 0 : Integer.parseInt(minWidthString);
            boolean leftJustify = hyphen != null;
            boolean truncateBeginning = widthHyphen != null;
            int maximumWidth = maxWidthString == null ? 0 : Integer.parseInt(maxWidthString);
            char formatChar = formatCharString.charAt(0);
            switch (formatChar) {
                case 'c': {
                    stepList.add(Formatters.loggerNameFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth, argument));
                    continue block31;
                }
                case 'C': {
                    stepList.add(Formatters.classNameFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth, argument));
                    continue block31;
                }
                case 'd': {
                    stepList.add(Formatters.dateFormatStep(timeZone, argument, leftJustify, minimumWidth, truncateBeginning, maximumWidth));
                    continue block31;
                }
                case 'D': {
                    stepList.add(Formatters.moduleNameFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth, argument));
                    continue block31;
                }
                case 'e': {
                    stepList.add(Formatters.exceptionFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth, argument));
                    continue block31;
                }
                case 'E': {
                    stepList.add(Formatters.exceptionFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth, argument));
                    continue block31;
                }
                case 'F': {
                    stepList.add(Formatters.fileNameFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth));
                    continue block31;
                }
                case 'h': {
                    stepList.add(Formatters.hostnameFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth, false));
                    continue block31;
                }
                case 'H': {
                    stepList.add(Formatters.hostnameFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth, argument));
                    continue block31;
                }
                case 'i': {
                    stepList.add(Formatters.processIdFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth));
                    continue block31;
                }
                case 'k': {
                    stepList.add(Formatters.resourceKeyFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth));
                    continue block31;
                }
                case 'K': {
                    if (!ColorMap.SUPPORTS_COLOR) continue block31;
                    colorUsed = true;
                    stepList.add(Formatters.formatColor(colors, argument));
                    continue block31;
                }
                case 'l': {
                    stepList.add(Formatters.locationInformationFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth));
                    continue block31;
                }
                case 'L': {
                    stepList.add(Formatters.lineNumberFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth));
                    continue block31;
                }
                case 'm': {
                    stepList.add(Formatters.messageFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth));
                    continue block31;
                }
                case 'M': {
                    stepList.add(Formatters.methodNameFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth));
                    continue block31;
                }
                case 'n': {
                    stepList.add(Formatters.lineSeparatorFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth));
                    continue block31;
                }
                case 'N': {
                    stepList.add(Formatters.processNameFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth));
                    continue block31;
                }
                case 'p': {
                    stepList.add(Formatters.levelFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth));
                    continue block31;
                }
                case 'P': {
                    stepList.add(Formatters.localizedLevelFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth));
                    continue block31;
                }
                case 'r': {
                    stepList.add(Formatters.relativeTimeFormatStep(time, leftJustify, minimumWidth, truncateBeginning, maximumWidth));
                    continue block31;
                }
                case 's': {
                    stepList.add(Formatters.simpleMessageFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth));
                    continue block31;
                }
                case 't': {
                    stepList.add(Formatters.threadFormatStep(argument, leftJustify, minimumWidth, truncateBeginning, maximumWidth));
                    continue block31;
                }
                case 'v': {
                    stepList.add(Formatters.moduleVersionFormatStep(leftJustify, minimumWidth, maximumWidth, argument));
                    continue block31;
                }
                case 'x': {
                    int count = argument == null ? 0 : Integer.parseInt(argument);
                    stepList.add(Formatters.ndcFormatStep(leftJustify, minimumWidth, truncateBeginning, maximumWidth, count));
                    continue block31;
                }
                case 'X': {
                    stepList.add(Formatters.mdcFormatStep(argument, leftJustify, minimumWidth, truncateBeginning, maximumWidth));
                    continue block31;
                }
                case 'z': {
                    timeZone = TimeZone.getTimeZone(argument);
                    continue block31;
                }
                case '#': 
                case '$': {
                    stepList.add(Formatters.systemPropertyFormatStep(argument, leftJustify, minimumWidth, truncateBeginning, maximumWidth));
                    continue block31;
                }
                case '%': {
                    stepList.add(Formatters.textFormatStep("%"));
                    continue block31;
                }
            }
            throw new IllegalArgumentException("Encountered an unknown format character");
        }
        if (colorUsed) {
            stepList.add(Formatters.formatColor(colors, "clear"));
        }
        return stepList.toArray(new FormatStep[stepList.size()]);
    }
}

