/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.util.Iterator;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.jboss.logmanager.MDCProvider;
import org.jboss.logmanager.ThreadLocalMDC;

public final class MDC {
    private static final MDCProvider mdcProvider = MDC.getMDCProvider();

    private MDC() {
    }

    static MDCProvider getMDCProvider() {
        ServiceLoader<MDCProvider> configLoader = ServiceLoader.load(MDCProvider.class, MDC.class.getClassLoader());
        Iterator<MDCProvider> iterator = configLoader.iterator();
        while (true) {
            try {
                if (!iterator.hasNext()) {
                    return new ThreadLocalMDC();
                }
                return iterator.next();
            }
            catch (RuntimeException | ServiceConfigurationError e) {
                System.err.print("Warning: failed to load MDC Provider: ");
                e.printStackTrace(System.err);
                continue;
            }
            break;
        }
    }

    public static String get(String key) {
        return mdcProvider.get(key);
    }

    public static Object getObject(String key) {
        return mdcProvider.getObject(key);
    }

    public static String put(String key, String value) {
        return mdcProvider.put(key, value);
    }

    public static Object putObject(String key, Object value) {
        return mdcProvider.putObject(key, value);
    }

    public static String remove(String key) {
        return mdcProvider.remove(key);
    }

    public static Object removeObject(String key) {
        return mdcProvider.removeObject(key);
    }

    public static Map<String, String> copy() {
        return mdcProvider.copy();
    }

    public static Map<String, Object> copyObject() {
        return mdcProvider.copyObject();
    }

    public static void clear() {
        mdcProvider.clear();
    }
}

