/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.config;

import io.quarkus.runtime.annotations.RegisterForReflection;
import java.util.HashMap;
import java.util.Map;

@RegisterForReflection
public enum FileFormat {
    PEM,
    JKS,
    PKCS12;

    private static final Map<String, FileFormat> EXTENSIONS;

    public static FileFormat orDetect(FileFormat format, String path) {
        if (path == null) {
            return null;
        }
        if (format != null) {
            return format;
        }
        return FileFormat.detect(path);
    }

    public static FileFormat detect(String path) {
        if (path == null) {
            return null;
        }
        if (path.endsWith(".")) {
            return null;
        }
        int idx = path.lastIndexOf(".");
        String extension = path.substring(idx + 1).toLowerCase();
        return EXTENSIONS.get(extension);
    }

    public static boolean isKeyStoreFormat(FileFormat format) {
        return format == JKS || format == PKCS12;
    }

    static {
        EXTENSIONS = new HashMap<String, FileFormat>();
        EXTENSIONS.put("jks", JKS);
        EXTENSIONS.put("pem", PEM);
        EXTENSIONS.put("key", PEM);
        EXTENSIONS.put("crt", PEM);
        EXTENSIONS.put("p12", PKCS12);
        EXTENSIONS.put("pfx", PKCS12);
    }
}

