/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.inject;

import io.smallrye.config.ConfigLogging;
import java.security.AccessController;

class SecuritySupport {
    private SecuritySupport() {
    }

    static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(() -> {
            ClassLoader tccl = null;
            try {
                tccl = Thread.currentThread().getContextClassLoader();
            }
            catch (SecurityException ex) {
                ConfigLogging.log.failedToRetrieveClassloader(ex);
            }
            return tccl;
        });
    }
}

