/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.okhttp;

import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.http.WebSocketHandshakeException;
import io.fabric8.kubernetes.client.http.WebSocketResponse;
import io.fabric8.kubernetes.client.okhttp.OkHttpClientImpl;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;

class OkHttpWebSocketImpl
implements io.fabric8.kubernetes.client.http.WebSocket {
    private WebSocket webSocket;
    private Runnable requestMethod;

    public OkHttpWebSocketImpl(WebSocket webSocket, Runnable requestMethod) {
        this.webSocket = webSocket;
        this.requestMethod = requestMethod;
    }

    @Override
    public boolean send(ByteBuffer buffer) {
        return this.webSocket.send(ByteString.of(buffer));
    }

    @Override
    public boolean sendClose(int code, String reason) {
        return this.webSocket.close(code, reason);
    }

    @Override
    public long queueSize() {
        return this.webSocket.queueSize();
    }

    @Override
    public void request() {
        this.requestMethod.run();
    }

    public static CompletableFuture<WebSocketResponse> buildAsync(OkHttpClient httpClient, Request request, final WebSocket.Listener listener) {
        final CompletableFuture<WebSocketResponse> future = new CompletableFuture<WebSocketResponse>();
        httpClient.newWebSocket(request, new WebSocketListener(){
            private volatile boolean opened;
            private boolean more = true;
            private ReentrantLock lock = new ReentrantLock();
            private Condition moreRequested = this.lock.newCondition();

            @Override
            public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                if (response != null) {
                    response.close();
                }
                if (!this.opened) {
                    if (response != null) {
                        try {
                            future.complete(new WebSocketResponse(null, new WebSocketHandshakeException(new OkHttpClientImpl.OkHttpResponseImpl(response, null)).initCause(t)));
                        }
                        catch (IOException iOException) {}
                    } else {
                        future.completeExceptionally(t);
                    }
                } else {
                    listener.onError(new OkHttpWebSocketImpl(webSocket, this::request), t);
                }
            }

            @Override
            public void onOpen(WebSocket webSocket, Response response) {
                this.opened = true;
                if (response != null) {
                    response.close();
                }
                OkHttpWebSocketImpl value = new OkHttpWebSocketImpl(webSocket, this::request);
                listener.onOpen(value);
                future.complete(new WebSocketResponse(value, null));
            }

            @Override
            public void onMessage(WebSocket webSocket, ByteString bytes) {
                this.awaitMoreRequest();
                listener.onMessage((io.fabric8.kubernetes.client.http.WebSocket)new OkHttpWebSocketImpl(webSocket, this::request), bytes.asByteBuffer());
            }

            @Override
            public void onMessage(WebSocket webSocket, String text) {
                this.awaitMoreRequest();
                listener.onMessage((io.fabric8.kubernetes.client.http.WebSocket)new OkHttpWebSocketImpl(webSocket, this::request), text);
            }

            private void awaitMoreRequest() {
                this.lock.lock();
                try {
                    while (!this.more) {
                        if (this.moreRequested.await(30L, TimeUnit.SECONDS)) continue;
                        throw new KubernetesClientException("OkHttp HttpClient thread is waiting too long for the consumption of previous websocket message");
                    }
                    this.more = false;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw KubernetesClientException.launderThrowable(e);
                }
                finally {
                    this.lock.unlock();
                }
            }

            private void request() {
                this.lock.lock();
                try {
                    this.more = true;
                    this.moreRequested.signalAll();
                }
                finally {
                    this.lock.unlock();
                }
            }

            @Override
            public void onClosing(WebSocket webSocket, int code, String reason) {
                this.awaitMoreRequest();
                listener.onClose(new OkHttpWebSocketImpl(webSocket, this::request), code, reason);
            }
        });
        return future;
    }
}

