/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.common.utils;

import io.smallrye.common.classloader.ClassPathUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ConfigSourceUtil {
    public static final String CONFIG_ORDINAL_KEY = "config_ordinal";
    public static final String CONFIG_ORDINAL_100 = "100";

    private ConfigSourceUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> propertiesToMap(Properties properties) {
        HashMap<String, String> map = new HashMap<String, String>();
        Properties properties2 = properties;
        synchronized (properties2) {
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                map.put(String.valueOf(e.getKey()), String.valueOf(e.getValue()));
            }
        }
        return map;
    }

    public static Map<String, String> urlToMap(URL locationOfProperties) throws IOException {
        Properties properties = new Properties();
        ClassPathUtils.consumeStream(locationOfProperties, inputStream -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));){
                properties.load(reader);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        return ConfigSourceUtil.propertiesToMap(properties);
    }

    public static int getOrdinalFromMap(Map<String, String> map, int defaultOrdinal) {
        String ordStr = map.get(CONFIG_ORDINAL_KEY);
        return ordStr == null ? defaultOrdinal : Integer.parseInt(ordStr);
    }
}

