/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.emfresource.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.BasicInternalEList;
import org.eclipse.hawk.emfresource.HawkResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(LazyResolver.class);
    private final HawkResource resource;
    private Cache<EObject, String> eObjectWithPendingAttrs = CacheBuilder.newBuilder().weakKeys().build();
    private Cache<EObject, Map<EReference, LazyEListWrapper>> eObjectToLazyRefs = CacheBuilder.newBuilder().weakKeys().build();
    private Cache<EObject, LazyEContainment> eObjectToContainer = CacheBuilder.newBuilder().weakKeys().build();

    public LazyResolver(HawkResource resource) {
        this.resource = resource;
    }

    public void resolve(EObject object, boolean mustFetchAttributes) {
        try {
            this.resolveAttributes(object);
            Map refs = (Map)this.eObjectToLazyRefs.getIfPresent((Object)object);
            if (refs != null) {
                for (Map.Entry entry : refs.entrySet()) {
                    ((LazyEListWrapper)entry.getValue()).get(object, (EReference)entry.getKey(), refs, false, mustFetchAttributes);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while resolving lazy reference", (Throwable)e);
        }
    }

    public Object resolve(EObject object, EStructuralFeature feature, boolean greedyReferences, boolean mustFetchAttributes) {
        try {
            if (feature instanceof EReference) {
                LazyEListWrapper pendingObjects;
                Map lazyRefs = (Map)this.eObjectToLazyRefs.getIfPresent((Object)object);
                if (lazyRefs != null && (pendingObjects = (LazyEListWrapper)lazyRefs.get(feature)) != null) {
                    return pendingObjects.get(object, (EReference)feature, lazyRefs, greedyReferences, mustFetchAttributes);
                }
            } else if (feature instanceof EAttribute) {
                this.resolveAttributes(object);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while resolving lazy reference", (Throwable)e);
            e.printStackTrace();
        }
        return null;
    }

    private void resolveAttributes(EObject object) throws Exception {
        String pendingId = (String)this.eObjectWithPendingAttrs.getIfPresent((Object)object);
        this.eObjectWithPendingAttrs.invalidate((Object)object);
        if (pendingId != null) {
            HashMap<String, EObject> objects = new HashMap<String, EObject>();
            objects.put(pendingId, object);
            this.resource.fetchAttributes(objects);
        }
    }

    public boolean isLazy(EObject object, EStructuralFeature feature) {
        if (feature instanceof EReference) {
            Map pending = (Map)this.eObjectToLazyRefs.getIfPresent((Object)object);
            if (pending != null) {
                LazyEListWrapper lazyEList = (LazyEListWrapper)pending.get(feature);
                return lazyEList != null;
            }
        } else if (feature instanceof EAttribute) {
            return this.eObjectWithPendingAttrs.getIfPresent((Object)object) != null;
        }
        return false;
    }

    public void putLazyReference(EObject eob, EReference feature, EList<Object> value) {
        IdentityHashMap<EReference, LazyEListWrapper> allPending = (IdentityHashMap<EReference, LazyEListWrapper>)this.eObjectToLazyRefs.getIfPresent((Object)eob);
        if (allPending == null) {
            allPending = new IdentityHashMap<EReference, LazyEListWrapper>();
            this.eObjectToLazyRefs.put((Object)eob, allPending);
        }
        allPending.put(feature, new LazyEListWrapper(value));
        if (feature.isContainer()) {
            this.eObjectToContainer.put((Object)eob, (Object)new LazyEContainment(value.get(0).toString(), feature));
        }
    }

    public void removeLazyReference(EObject eob, EReference ref) {
        Map allPending = (Map)this.eObjectToLazyRefs.getIfPresent((Object)eob);
        if (allPending != null) {
            allPending.remove(ref);
        }
    }

    public boolean addToLazyReference(EObject sourceObj, EReference feature, Object value) {
        Map allPending = (Map)this.eObjectToLazyRefs.getIfPresent((Object)sourceObj);
        LazyEListWrapper pending = (LazyEListWrapper)allPending.get(feature);
        LOGGER.debug("Added {} to lazy references of feature {} in #{}: {}", new Object[]{value, feature.getName(), sourceObj, pending});
        return pending.add(value);
    }

    public boolean removeFromLazyReference(EObject sourceObj, EReference feature, Object value) {
        Map allPending = (Map)this.eObjectToLazyRefs.getIfPresent((Object)sourceObj);
        LazyEListWrapper pending = (LazyEListWrapper)allPending.get(feature);
        LOGGER.debug("Removed {} from lazy references of feature {} in #{}: {}", new Object[]{value, feature.getName(), sourceObj, pending});
        return pending.remove(value);
    }

    public void putLazyAttributes(String id, EObject eObject) {
        this.eObjectWithPendingAttrs.put((Object)eObject, (Object)id);
    }

    public void removeLazyAttributes(String id, EObject eObject) {
        this.eObjectWithPendingAttrs.invalidate((Object)eObject);
    }

    public EList<Object> getPending(EObject o, EReference r) {
        LazyEListWrapper lazyEListWrapper;
        Map allPending = (Map)this.eObjectToLazyRefs.getIfPresent((Object)o);
        if (allPending != null && (lazyEListWrapper = (LazyEListWrapper)allPending.get(r)) != null && lazyEListWrapper.isPending) {
            return lazyEListWrapper.getWrapped();
        }
        return null;
    }

    public EObject getContainer(EObject o) {
        LazyEContainment containment = (LazyEContainment)this.eObjectToContainer.getIfPresent((Object)o);
        return containment != null ? containment.getContainer() : null;
    }

    public EReference getContainingFeature(EObject o) {
        LazyEContainment containment = (LazyEContainment)this.eObjectToContainer.getIfPresent((Object)o);
        return containment != null ? containment.getContainmentReference() : null;
    }

    public Resource getResource(EObject o) {
        LazyEContainment containment = (LazyEContainment)this.eObjectToContainer.getIfPresent((Object)o);
        return containment != null ? containment.getContainer().eResource() : null;
    }

    private final class DirtyObjectMarkingEList<T>
    extends BasicInternalEList<T> {
        private static final long serialVersionUID = 1L;
        private final EObject eob;

        private DirtyObjectMarkingEList(Collection<T> collection, EObject source) {
            super(Object.class, collection);
            this.eob = source;
        }

        protected void didChange() {
            LazyResolver.this.resource.markChanged(this.eob);
        }
    }

    private class LazyEContainment {
        private String containerID;
        private EObject eContainer;
        private final EReference eContainmentReference;

        private LazyEContainment(String containerID, EReference eContainmentReference) {
            this.containerID = containerID;
            this.eContainmentReference = eContainmentReference;
        }

        private LazyEContainment(EObject eContainer, EReference eContainmentReference) {
            this.eContainer = eContainer;
            this.eContainmentReference = eContainmentReference;
        }

        public EObject getContainer() {
            if (this.eContainer == null) {
                try {
                    this.eContainer = LazyResolver.this.resource.fetchNode(this.containerID, false);
                }
                catch (Exception e) {
                    LOGGER.error("Could not fetch container: " + e.getMessage(), (Throwable)e);
                }
            }
            return this.eContainer;
        }

        public EReference getContainmentReference() {
            return this.eContainmentReference;
        }
    }

    private class LazyEListWrapper {
        private boolean isPending = true;
        private EList<Object> backingEList;

        private LazyEListWrapper(EList<Object> pending) {
            this.backingEList = pending;
        }

        public Object get(EObject object, EReference feature, Map<EReference, LazyEListWrapper> pending, boolean greedyReferences, boolean mustFetchAttributes) {
            if (this.isPending) {
                try {
                    this.resolvePendingReference(object, feature, pending, this.backingEList, greedyReferences, mustFetchAttributes);
                }
                catch (Exception e) {
                    LOGGER.error("Error while resolving reference: " + e.getMessage(), (Throwable)e);
                    return new BasicEList();
                }
            }
            if (feature.isMany()) {
                return this.backingEList;
            }
            if (!this.backingEList.isEmpty()) {
                return this.backingEList.get(0);
            }
            return null;
        }

        public boolean add(Object value) {
            return this.backingEList.add(value);
        }

        public boolean remove(Object value) {
            return this.backingEList.remove(value);
        }

        public EList<Object> getWrapped() {
            return this.backingEList;
        }

        private void resolvePendingReference(EObject object, EReference feature, Map<EReference, LazyEListWrapper> pending, EList<Object> ids, boolean greedyReferences, boolean mustFetchAttributes) throws Exception {
            EList<EObject> fetched = null;
            if (greedyReferences) {
                ArrayList<String> childrenIds = new ArrayList<String>();
                for (LazyEListWrapper elems : pending.values()) {
                    this.addAllStrings(elems.getWrapped(), childrenIds);
                }
                this.addAllStrings(ids, childrenIds);
                fetched = LazyResolver.this.resource.fetchNodes(childrenIds, mustFetchAttributes);
            }
            this.resolveReference(object, feature, ids, mustFetchAttributes);
        }

        /*
         * WARNING - void declaration
         */
        private EList<Object> resolveReference(EObject source, EReference feature, EList<Object> targets, boolean mustFetchAttributes) throws Exception {
            block10: {
                EObject eobTarget;
                ArrayList<Object> result;
                block9: {
                    void var9_10;
                    ArrayList<String> ids = new ArrayList<String>();
                    this.addAllStrings(targets, ids);
                    EList<EObject> resolved = LazyResolver.this.resource.fetchNodes(ids, mustFetchAttributes);
                    result = new ArrayList<Object>();
                    int iResolved = 0;
                    boolean bl = false;
                    while (var9_10 < targets.size()) {
                        Object elem = targets.get((int)var9_10);
                        if (elem instanceof String) {
                            EObject eob;
                            if ((eob = (EObject)resolved.get(iResolved++)) == null) {
                                LOGGER.warn("Failed to resolve lazy reference to node {}: deleted without notification?", elem);
                            } else {
                                result.add(eob);
                            }
                        } else {
                            result.add(elem);
                        }
                        ++var9_10;
                    }
                    this.backingEList = new DirtyObjectMarkingEList(result, source);
                    this.isPending = false;
                    if (!feature.isContainment()) break block9;
                    for (Object e : result) {
                        Resource eResource;
                        eobTarget = (EObject)e;
                        if (eobTarget.eContainer() != null && (eResource = eobTarget.eResource()) != null) {
                            eResource.getContents().remove((Object)eobTarget);
                        }
                        LazyResolver.this.eObjectToContainer.put((Object)eobTarget, (Object)new LazyEContainment(source, feature));
                    }
                    break block10;
                }
                if (!feature.isContainer()) break block10;
                if (source.eContainer() != null) {
                    source.eResource().getContents().remove((Object)source);
                }
                for (Object e : result) {
                    eobTarget = (EObject)e;
                    LazyResolver.this.eObjectToContainer.put((Object)source, (Object)new LazyEContainment(eobTarget, feature.getEOpposite()));
                }
            }
            return this.backingEList;
        }

        private void addAllStrings(EList<Object> source, List<String> target) {
            for (Object elem : source) {
                if (!(elem instanceof String)) continue;
                target.add((String)elem);
            }
        }
    }
}

