/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.AbstractDebugCheckboxSelectionDialog;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.MultipleInputDialog;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.TextGetSetEditingSupport;
import org.eclipse.debug.internal.ui.launchConfigurations.EnvironmentVariable;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class EnvironmentTab
extends AbstractLaunchConfigurationTab {
    protected TableViewer environmentTable;
    protected String[] envTableColumnHeaders = new String[]{LaunchConfigurationsMessages.EnvironmentTab_Variable_1, LaunchConfigurationsMessages.EnvironmentTab_Value_2};
    private static final String NAME_LABEL = LaunchConfigurationsMessages.EnvironmentTab_8;
    private static final String VALUE_LABEL = LaunchConfigurationsMessages.EnvironmentTab_9;
    protected static final String P_VARIABLE = "variable";
    protected static final String P_VALUE = "value";
    protected Button envAddButton;
    protected Button envEditButton;
    protected Button envRemoveButton;
    protected Button envCopyButton;
    protected Button envPasteButton;
    protected Button appendEnvironment;
    protected Button replaceEnvironment;
    protected Button envSelectButton;
    private KeyStroke copyKeyStroke;
    private KeyStroke pasteKeyStroke;

    public EnvironmentTab() {
        this.setHelpContextId("org.eclipse.debug.ui.launch_configuration_dialog_environment_tab");
        try {
            this.copyKeyStroke = KeyStroke.getInstance((String)"M1+C");
        }
        catch (ParseException parseException) {}
        try {
            this.pasteKeyStroke = KeyStroke.getInstance((String)"M1+V");
        }
        catch (ParseException parseException) {}
    }

    @Override
    public void createControl(Composite parent) {
        Composite mainComposite = SWTFactory.createComposite(parent, 2, 1, 768);
        this.setControl((Control)mainComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.getHelpContextId());
        this.createEnvironmentTable(mainComposite);
        this.createTableButtons(mainComposite);
        this.createAppendReplace(mainComposite);
        Dialog.applyDialogFont((Control)mainComposite);
    }

    protected void createAppendReplace(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, 1, 2, 768);
        this.appendEnvironment = this.createRadioButton(comp, LaunchConfigurationsMessages.EnvironmentTab_16);
        this.appendEnvironment.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnvironmentTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.replaceEnvironment = this.createRadioButton(comp, LaunchConfigurationsMessages.EnvironmentTab_17);
    }

    protected void updateAppendReplace() {
        boolean enable = this.environmentTable.getTable().getItemCount() > 0;
        this.appendEnvironment.setEnabled(enable);
        this.replaceEnvironment.setEnabled(enable);
    }

    protected void createEnvironmentTable(Composite parent) {
        Font font = parent.getFont();
        SWTFactory.createLabel(parent, LaunchConfigurationsMessages.EnvironmentTab_Environment_variables_to_set__3, 2);
        Composite tableComposite = SWTFactory.createComposite(parent, font, 1, 1, 1808, 0, 0);
        this.environmentTable = new TableViewer(tableComposite, 68354);
        Table table = this.environmentTable.getTable();
        table.setLayoutData((Object)new GridData(1808));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setFont(font);
        this.environmentTable.setContentProvider((IContentProvider)new EnvironmentVariableContentProvider());
        this.environmentTable.setLabelProvider((IBaseLabelProvider)new EnvironmentVariableLabelProvider());
        this.environmentTable.setColumnProperties(new String[]{P_VARIABLE, P_VALUE});
        this.environmentTable.addSelectionChangedListener(this::handleTableSelectionChanged);
        Menu menuTable = new Menu((Control)table);
        table.setMenu(menuTable);
        MenuItem miAdd = new MenuItem(menuTable, 0);
        miAdd.setText(LaunchConfigurationsMessages.EnvironmentTab_Add_4);
        miAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EnvironmentTab.this.handleEnvAddButtonSelected();
            }
        });
        MenuItem miCopy = new MenuItem(menuTable, 0);
        miCopy.setText(LaunchConfigurationsMessages.EnvironmentTab_Copy);
        miCopy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EnvironmentTab.this.handleEnvCopyButtonSelected();
            }
        });
        MenuItem miPaste = new MenuItem(menuTable, 0);
        miPaste.setText(LaunchConfigurationsMessages.EnvironmentTab_Paste);
        miPaste.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EnvironmentTab.this.handleEnvPasteButtonSelected();
            }
        });
        MenuItem miRemove = new MenuItem(menuTable, 0);
        miRemove.setText(LaunchConfigurationsMessages.EnvironmentTab_Remove_6);
        miRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EnvironmentTab.this.handleEnvRemoveButtonSelected();
            }
        });
        this.environmentTable.addSelectionChangedListener(event -> {
            IStructuredSelection selection = this.environmentTable.getStructuredSelection();
            if (selection.size() == 1) {
                miRemove.setText(LaunchConfigurationsMessages.EnvironmentTab_Remove_6);
            } else if (selection.size() > 1) {
                miRemove.setText(LaunchConfigurationsMessages.EnvironmentTab_Remove_All);
            }
        });
        table.addListener(35, event -> {
            if (table.getSelectionCount() <= 0) {
                miRemove.setEnabled(false);
                miCopy.setEnabled(false);
            } else {
                miRemove.setEnabled(true);
                miCopy.setEnabled(true);
            }
        });
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.environmentTable){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 3 || event.eventType == 4;
            }
        };
        int feature = 178;
        TableViewerEditor.create((TableViewer)this.environmentTable, (ColumnViewerEditorActivationStrategy)actSupport, (int)feature);
        TableViewerColumn tcv1 = new TableViewerColumn(this.environmentTable, 0, 0);
        tcv1.setLabelProvider((CellLabelProvider)ColumnLabelProvider.createTextProvider(element -> ((EnvironmentVariable)element).getName()));
        TableColumn tc1 = tcv1.getColumn();
        tc1.setText(this.envTableColumnHeaders[0]);
        tcv1.setEditingSupport(new TextGetSetEditingSupport<EnvironmentVariable>(tcv1.getViewer(), EnvironmentVariable::getName, (envVar, value) -> {
            String newName = value.trim();
            if (newName != null && !newName.isEmpty() && !newName.equals(envVar.getName()) && this.canRenameVariable(newName)) {
                envVar.setName(newName);
                this.updateAppendReplace();
                this.updateLaunchConfigurationDialog();
            }
        }));
        TableViewerColumn tcv2 = new TableViewerColumn(this.environmentTable, 0, 1);
        tcv2.setLabelProvider((CellLabelProvider)ColumnLabelProvider.createTextProvider(element -> ((EnvironmentVariable)element).getValue()));
        TableColumn tc2 = tcv2.getColumn();
        tc2.setText(this.envTableColumnHeaders[1]);
        tcv2.setEditingSupport(new TextGetSetEditingSupport<EnvironmentVariable>(tcv2.getViewer(), EnvironmentVariable::getValue, (envVar, value) -> {
            envVar.setValue((String)value);
            this.updateAppendReplace();
            this.updateLaunchConfigurationDialog();
        }));
        TableColumnLayout tableColumnLayout = new TableColumnLayout(true);
        PixelConverter pixelConverter = new PixelConverter(font);
        tableColumnLayout.setColumnData((Widget)tc1, (ColumnLayoutData)new ColumnWeightData(1, pixelConverter.convertWidthInCharsToPixels(20)));
        tableColumnLayout.setColumnData((Widget)tc2, (ColumnLayoutData)new ColumnWeightData(2, pixelConverter.convertWidthInCharsToPixels(20)));
        tableComposite.setLayout((Layout)tableColumnLayout);
        this.environmentTable.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                KeyStroke current = EnvironmentTab.this.computeKeyStroke(e);
                if (current.equals((Object)EnvironmentTab.this.copyKeyStroke)) {
                    EnvironmentTab.this.handleEnvCopyButtonSelected();
                } else if (current.equals((Object)EnvironmentTab.this.pasteKeyStroke)) {
                    EnvironmentTab.this.handleEnvPasteButtonSelected();
                }
            }
        });
    }

    protected void handleTableSelectionChanged(SelectionChangedEvent event) {
        int size = event.getStructuredSelection().size();
        this.envEditButton.setEnabled(size == 1);
        this.envRemoveButton.setEnabled(size > 0);
        this.envCopyButton.setEnabled(size > 0);
    }

    protected void createTableButtons(Composite parent) {
        Composite buttonComposite = SWTFactory.createComposite(parent, parent.getFont(), 1, 1, 130, 0, 0);
        this.envAddButton = this.createPushButton(buttonComposite, LaunchConfigurationsMessages.EnvironmentTab_Add_4, null);
        this.envAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EnvironmentTab.this.handleEnvAddButtonSelected();
            }
        });
        this.envSelectButton = this.createPushButton(buttonComposite, LaunchConfigurationsMessages.EnvironmentTab_18, null);
        this.envSelectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EnvironmentTab.this.handleEnvSelectButtonSelected();
            }
        });
        this.envEditButton = this.createPushButton(buttonComposite, LaunchConfigurationsMessages.EnvironmentTab_Edit_5, null);
        this.envEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EnvironmentTab.this.handleEnvEditButtonSelected();
            }
        });
        this.envEditButton.setEnabled(false);
        this.envRemoveButton = this.createPushButton(buttonComposite, LaunchConfigurationsMessages.EnvironmentTab_Remove_6, null);
        this.envRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EnvironmentTab.this.handleEnvRemoveButtonSelected();
            }
        });
        this.envRemoveButton.setEnabled(false);
        this.envCopyButton = this.createPushButton(buttonComposite, LaunchConfigurationsMessages.EnvironmentTab_Copy, null);
        this.envCopyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EnvironmentTab.this.handleEnvCopyButtonSelected();
            }
        });
        this.envCopyButton.setEnabled(false);
        this.envPasteButton = this.createPushButton(buttonComposite, LaunchConfigurationsMessages.EnvironmentTab_Paste, null);
        this.envPasteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EnvironmentTab.this.handleEnvPasteButtonSelected();
            }
        });
        this.envPasteButton.setEnabled(true);
    }

    protected void handleEnvAddButtonSelected() {
        MultipleInputDialog dialog = new MultipleInputDialog(this.getShell(), LaunchConfigurationsMessages.EnvironmentTab_22);
        dialog.addTextField(NAME_LABEL, null, false);
        dialog.addVariablesField(VALUE_LABEL, null, true);
        if (dialog.open() != 0) {
            return;
        }
        String name = dialog.getStringValue(NAME_LABEL);
        String value = dialog.getStringValue(VALUE_LABEL);
        if (name != null && value != null && name.length() > 0 && value.length() > 0) {
            this.addVariable(new EnvironmentVariable(name.trim(), value));
            this.updateAppendReplace();
        }
    }

    private boolean canRenameVariable(String newVariableName) {
        TableItem[] tableItemArray = this.environmentTable.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            EnvironmentVariable existingVariable = (EnvironmentVariable)item.getData();
            if (existingVariable.getName().equals(newVariableName)) {
                boolean overWrite = MessageDialog.openQuestion((Shell)this.getShell(), (String)LaunchConfigurationsMessages.EnvironmentTab_12, (String)MessageFormat.format(LaunchConfigurationsMessages.EnvironmentTab_13, newVariableName));
                if (!overWrite) {
                    return false;
                }
                this.environmentTable.remove((Object)existingVariable);
                return true;
            }
            ++n2;
        }
        return true;
    }

    protected boolean addVariable(EnvironmentVariable variable) {
        TableItem[] items;
        String name = variable.getName();
        TableItem[] tableItemArray = items = this.environmentTable.getTable().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            EnvironmentVariable existingVariable = (EnvironmentVariable)item.getData();
            if (existingVariable.getName().equals(name)) {
                boolean overWrite = MessageDialog.openQuestion((Shell)this.getShell(), (String)LaunchConfigurationsMessages.EnvironmentTab_12, (String)MessageFormat.format(LaunchConfigurationsMessages.EnvironmentTab_13, name));
                if (!overWrite) {
                    return false;
                }
                this.environmentTable.remove((Object)existingVariable);
                break;
            }
            ++n2;
        }
        this.environmentTable.add((Object)variable);
        this.updateLaunchConfigurationDialog();
        return true;
    }

    protected int addVariables(List<EnvironmentVariable> variables) {
        if (variables.isEmpty()) {
            return 0;
        }
        LinkedList<EnvironmentVariable> remove = new LinkedList<EnvironmentVariable>();
        LinkedList<EnvironmentVariable> conflicting = new LinkedList<EnvironmentVariable>();
        Map<String, String> requested = variables.stream().collect(Collectors.toMap(EnvironmentVariable::getName, EnvironmentVariable::getValue));
        TableItem[] tableItemArray = this.environmentTable.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            EnvironmentVariable existingVariable = (EnvironmentVariable)item.getData();
            String name = existingVariable.getName();
            String currentValue = requested.get(name);
            if (currentValue != null) {
                remove.add(existingVariable);
                if (!currentValue.equals(existingVariable.getValue())) {
                    conflicting.add(existingVariable);
                }
            }
            ++n2;
        }
        if (!conflicting.isEmpty()) {
            String names = conflicting.stream().map(EnvironmentVariable::getName).collect(Collectors.joining(", "));
            boolean overWrite = MessageDialog.openQuestion((Shell)this.getShell(), (String)LaunchConfigurationsMessages.EnvironmentTab_Paste_Overwrite_Title, (String)MessageFormat.format(LaunchConfigurationsMessages.EnvironmentTab_Paste_Overwrite_Message, names));
            if (!overWrite) {
                return 0;
            }
        }
        remove.forEach(arg_0 -> ((TableViewer)this.environmentTable).remove(arg_0));
        variables.forEach(arg_0 -> ((TableViewer)this.environmentTable).add(arg_0));
        this.updateLaunchConfigurationDialog();
        return variables.size();
    }

    private void handleEnvSelectButtonSelected() {
        TableItem[] items;
        Map<String, EnvironmentVariable> envVariables = this.getNativeEnvironment();
        TableItem[] tableItemArray = items = this.environmentTable.getTable().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            EnvironmentVariable var = (EnvironmentVariable)item.getData();
            envVariables.remove(var.getName());
            ++n2;
        }
        NativeEnvironmentSelectionDialog dialog = new NativeEnvironmentSelectionDialog(this.getShell(), envVariables);
        dialog.setTitle(LaunchConfigurationsMessages.EnvironmentTab_20);
        int button = dialog.open();
        if (button == 0) {
            Object[] selected;
            Object[] objectArray = selected = dialog.getResult();
            int n3 = selected.length;
            int n4 = 0;
            while (n4 < n3) {
                Object o = objectArray[n4];
                this.environmentTable.add(o);
                ++n4;
            }
        }
        this.updateAppendReplace();
        this.updateLaunchConfigurationDialog();
    }

    private Map<String, EnvironmentVariable> getNativeEnvironment() {
        Map stringVars = DebugPlugin.getDefault().getLaunchManager().getNativeEnvironmentCasePreserved();
        HashMap<String, EnvironmentVariable> vars = new HashMap<String, EnvironmentVariable>();
        for (Map.Entry entry : stringVars.entrySet()) {
            vars.put((String)entry.getKey(), new EnvironmentVariable((String)entry.getKey(), (String)entry.getValue()));
        }
        return vars;
    }

    private void handleEnvEditButtonSelected() {
        IStructuredSelection sel = this.environmentTable.getStructuredSelection();
        EnvironmentVariable var = (EnvironmentVariable)sel.getFirstElement();
        if (var == null) {
            return;
        }
        String originalName = var.getName();
        String value = var.getValue();
        MultipleInputDialog dialog = new MultipleInputDialog(this.getShell(), LaunchConfigurationsMessages.EnvironmentTab_11);
        dialog.addTextField(NAME_LABEL, originalName, false);
        if (value != null && value.contains(System.lineSeparator())) {
            dialog.addMultilinedVariablesField(VALUE_LABEL, value, true);
        } else {
            dialog.addVariablesField(VALUE_LABEL, value, true);
        }
        if (dialog.open() != 0) {
            return;
        }
        String name = dialog.getStringValue(NAME_LABEL);
        value = dialog.getStringValue(VALUE_LABEL);
        if (!originalName.equals(name)) {
            if (this.addVariable(new EnvironmentVariable(name.trim(), value))) {
                this.environmentTable.remove((Object)var);
            }
        } else {
            var.setValue(value);
            this.environmentTable.update((Object)var, null);
            this.updateLaunchConfigurationDialog();
        }
    }

    private void handleEnvRemoveButtonSelected() {
        IStructuredSelection sel = this.environmentTable.getStructuredSelection();
        try {
            this.environmentTable.getControl().setRedraw(false);
            for (EnvironmentVariable var : sel) {
                this.environmentTable.remove((Object)var);
            }
        }
        finally {
            this.environmentTable.getControl().setRedraw(true);
        }
        this.updateAppendReplace();
        this.updateLaunchConfigurationDialog();
    }

    private void handleEnvCopyButtonSelected() {
        Iterable iterable = () -> this.environmentTable.getStructuredSelection().iterator();
        String data = StreamSupport.stream(iterable.spliterator(), false).filter(o -> o instanceof EnvironmentVariable).map(EnvironmentVariable.class::cast).map(var -> String.format("%s=%s", var.getName(), var.getValue())).collect(Collectors.joining(System.lineSeparator()));
        Clipboard clipboard = new Clipboard(this.getShell().getDisplay());
        try {
            clipboard.setContents(new Object[]{data}, new Transfer[]{TextTransfer.getInstance()});
        }
        finally {
            clipboard.dispose();
        }
    }

    private void handleEnvPasteButtonSelected() {
        Clipboard clipboard = new Clipboard(this.getShell().getDisplay());
        try {
            List<EnvironmentVariable> variables = EnvironmentTab.convertEnvironmentVariablesFromData(clipboard.getContents((Transfer)TextTransfer.getInstance()));
            this.addVariables(variables);
            this.updateAppendReplace();
        }
        finally {
            clipboard.dispose();
        }
    }

    private static List<EnvironmentVariable> convertEnvironmentVariablesFromData(Object data) {
        if (!(data instanceof String)) {
            return Collections.emptyList();
        }
        String[] entries = ((String)data).split("\\R");
        ArrayList<EnvironmentVariable> result = new ArrayList<EnvironmentVariable>(entries.length);
        String[] stringArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            int idx = entry.indexOf(61);
            if (idx >= 1) {
                String name = entry.substring(0, idx).trim();
                String value = entry.substring(idx + 1);
                result.add(new EnvironmentVariable(name, value));
            }
            ++n2;
        }
        return Collections.unmodifiableList(result);
    }

    protected void updateEnvironment(ILaunchConfiguration configuration) {
        this.environmentTable.setInput((Object)configuration);
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.removeAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES);
    }

    @Override
    public void initializeFrom(ILaunchConfiguration configuration) {
        boolean append = true;
        try {
            append = configuration.getAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, true);
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e.getStatus());
        }
        if (append) {
            this.appendEnvironment.setSelection(true);
            this.replaceEnvironment.setSelection(false);
        } else {
            this.replaceEnvironment.setSelection(true);
            this.appendEnvironment.setSelection(false);
        }
        this.updateEnvironment(configuration);
        this.updateAppendReplace();
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        TableItem[] items = this.environmentTable.getTable().getItems();
        HashMap<String, String> map = new HashMap<String, String>(items.length);
        TableItem[] tableItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            EnvironmentVariable var = (EnvironmentVariable)item.getData();
            map.put(var.getName(), var.getValue());
            ++n2;
        }
        if (map.isEmpty()) {
            configuration.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
        } else {
            configuration.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, map);
        }
        if (this.appendEnvironment.getSelection()) {
            ILaunchConfiguration orig = configuration.getOriginal();
            boolean hasTrueValue = false;
            if (orig != null) {
                try {
                    hasTrueValue = orig.hasAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES) && orig.getAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, true);
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e.getStatus());
                }
            }
            if (hasTrueValue) {
                configuration.setAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, true);
            } else {
                configuration.removeAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES);
            }
        } else {
            configuration.setAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, false);
        }
    }

    @Override
    public String getName() {
        return LaunchConfigurationsMessages.EnvironmentTab_Environment_7;
    }

    @Override
    public String getId() {
        return "org.eclipse.debug.ui.environmentTab";
    }

    @Override
    public Image getImage() {
        return DebugPluginImages.getImage("IMG_OBJS_ENVIRONMENT");
    }

    @Override
    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    @Override
    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    @Override
    protected void initializeAttributes() {
        super.initializeAttributes();
        this.getAttributesLabelsForPrototype().put(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, LaunchConfigurationsMessages.EnvironmentTab_AttributeLabel_AppendEnvironmentVariables);
        this.getAttributesLabelsForPrototype().put(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, LaunchConfigurationsMessages.EnvironmentTab_AttributeLabel_EnvironmentVariables);
    }

    private KeyStroke computeKeyStroke(KeyEvent e) {
        int accelerator = SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)e);
        return SWTKeySupport.convertAcceleratorToKeyStroke((int)accelerator);
    }

    protected class EnvironmentVariableContentProvider
    implements IStructuredContentProvider {
        protected EnvironmentVariableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Map m;
            Object[] elements = new EnvironmentVariable[]{};
            ILaunchConfiguration config = (ILaunchConfiguration)inputElement;
            try {
                m = config.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
            }
            catch (CoreException e) {
                DebugUIPlugin.log((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), 4, "Error reading configuration", (Throwable)e));
                return elements;
            }
            if (m != null && !m.isEmpty()) {
                elements = new EnvironmentVariable[m.size()];
                String[] varNames = new String[m.size()];
                m.keySet().toArray(varNames);
                int i = 0;
                while (i < m.size()) {
                    elements[i] = new EnvironmentVariable(varNames[i], (String)m.get(varNames[i]));
                    ++i;
                }
            }
            return elements;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput == null) {
                return;
            }
            if (viewer instanceof TableViewer) {
                TableViewer tableViewer = (TableViewer)viewer;
                if (tableViewer.getTable().isDisposed()) {
                    return;
                }
                tableViewer.setComparator(new ViewerComparator(){

                    public int compare(Viewer iviewer, Object e1, Object e2) {
                        if (e1 == null) {
                            return -1;
                        }
                        if (e2 == null) {
                            return 1;
                        }
                        return ((EnvironmentVariable)e1).getName().compareToIgnoreCase(((EnvironmentVariable)e2).getName());
                    }
                });
            }
        }
    }

    public class EnvironmentVariableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object element, int columnIndex) {
            String result = null;
            if (element != null) {
                EnvironmentVariable var = (EnvironmentVariable)element;
                switch (columnIndex) {
                    case 0: {
                        result = var.getName();
                        break;
                    }
                    case 1: {
                        result = var.getValue();
                        break;
                    }
                }
            }
            return result;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return DebugPluginImages.getImage("IMG_OBJS_ENV_VAR");
            }
            return null;
        }
    }

    private class NativeEnvironmentSelectionDialog
    extends AbstractDebugCheckboxSelectionDialog {
        private Object fInput;

        public NativeEnvironmentSelectionDialog(Shell parentShell, Object input) {
            super(parentShell);
            this.fInput = input;
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.setShowSelectAllButtons(true);
        }

        @Override
        protected String getDialogSettingsId() {
            return "org.eclipse.debug.ui.ENVIRONMENT_TAB.NATIVE_ENVIROMENT_DIALOG";
        }

        @Override
        protected String getHelpContextId() {
            return "org.eclipse.debug.ui.select_native_environment_dialog";
        }

        @Override
        protected Object getViewerInput() {
            return this.fInput;
        }

        @Override
        protected String getViewerLabel() {
            return LaunchConfigurationsMessages.EnvironmentTab_19;
        }

        @Override
        protected IBaseLabelProvider getLabelProvider() {
            return new ILabelProvider(){

                public Image getImage(Object element) {
                    return DebugPluginImages.getImage("IMG_OBJS_ENVIRONMENT");
                }

                public String getText(Object element) {
                    EnvironmentVariable var = (EnvironmentVariable)element;
                    return MessageFormat.format(LaunchConfigurationsMessages.EnvironmentTab_7, var.getName(), var.getValue());
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void removeListener(ILabelProviderListener listener) {
                }
            };
        }

        @Override
        protected IContentProvider getContentProvider() {
            return new IStructuredContentProvider(){

                public Object[] getElements(Object inputElement) {
                    EnvironmentVariable[] elements = null;
                    if (inputElement instanceof HashMap) {
                        Comparator comparator = (o1, o2) -> {
                            String s1 = (String)o1;
                            String s2 = (String)o2;
                            return s1.compareTo(s2);
                        };
                        TreeMap envVars = new TreeMap(comparator);
                        envVars.putAll((Map)inputElement);
                        elements = new EnvironmentVariable[envVars.size()];
                        int index = 0;
                        for (Object key : envVars.keySet()) {
                            elements[index] = (EnvironmentVariable)envVars.get(key);
                            ++index;
                        }
                    }
                    return elements;
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            };
        }
    }
}

