/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.integration.tests.emf;

import java.io.File;
import org.eclipse.hawk.backend.tests.factories.IGraphDatabaseFactory;
import org.eclipse.hawk.core.graph.IGraphChangeListener;
import org.eclipse.hawk.graph.ProxyReferenceList;
import org.eclipse.hawk.graph.syncValidationListener.SyncValidationListener;
import org.eclipse.hawk.integration.tests.IntegrationTestSuite;
import org.eclipse.hawk.integration.tests.ModelIndexingTest;
import org.eclipse.hawk.integration.tests.emf.EMFModelSupportFactory;
import org.eclipse.hawk.localfolder.LocalFolder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;

public class ProxiesTest
extends ModelIndexingTest {
    @Rule
    public ModelIndexingTest.GraphChangeListenerRule<SyncValidationListener> syncValidation = new ModelIndexingTest.GraphChangeListenerRule((ModelIndexingTest)this, (IGraphChangeListener)new SyncValidationListener());

    @Parameterized.Parameters(name="{1}")
    public static Iterable<Object[]> params() {
        return IntegrationTestSuite.caseParams();
    }

    public ProxiesTest(File baseDir, IGraphDatabaseFactory dbf) {
        super(baseDir, dbf, new EMFModelSupportFactory());
    }

    @Test
    public void proxies() throws Throwable {
        this.indexer.registerMetamodels(new File[]{new File(this.baseDir, "resources/metamodels/Ecore.ecore"), new File(this.baseDir, "resources/metamodels/crossrefs.ecore")});
        LocalFolder vcs = this.requestFolderIndex(new File(this.baseDir, "resources/models/proxies"));
        this.scheduleAndWait(() -> {
            this.assertNoErrors(this.syncValidation.getListener());
            Assert.assertEquals((Object)4, (Object)this.eol("return Model.proxies.size;"));
            Assert.assertEquals((Object)4, (Object)this.eol(String.format("return Model.getProxies('%s').size;", vcs.getLocation())));
            Assert.assertEquals((Object)1, (Object)this.eol("return Element.all.selectOne(e|e.id = 0).hawkProxies.size;"));
            Assert.assertEquals((Object)0, (Object)this.eol("return Element.all.selectOne(e|e.id = 60).hawkProxies.size;"));
            ProxyReferenceList l = (ProxyReferenceList)this.eol("return Element.all.selectOne(e|e.id = 0).hawkProxies.first;");
            Assert.assertEquals((Object)"modelB.model", (Object)l.getTargetFile().getFilePath());
            Assert.assertEquals((long)1L, (long)l.getReferences().size());
            ProxyReferenceList.ProxyReference firstRef = (ProxyReferenceList.ProxyReference)l.getReferences().get(0);
            Assert.assertEquals((Object)"xrefs", (Object)firstRef.getEdgeLabel());
            Assert.assertEquals((Object)vcs.getLocation(), (Object)firstRef.getTarget().getRepositoryURL());
            Assert.assertEquals((Object)"modelB.model", (Object)firstRef.getTarget().getFilePath());
            Assert.assertEquals((Object)"_9r4mcF04Eeqfb-c5mrgLZw", (Object)firstRef.getTarget().getFragment());
            return null;
        });
    }
}

