/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.integration.tests.emf;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.hawk.backend.tests.factories.IGraphDatabaseFactory;
import org.eclipse.hawk.core.graph.IGraphChangeListener;
import org.eclipse.hawk.core.query.InvalidQueryException;
import org.eclipse.hawk.core.query.QueryExecutionException;
import org.eclipse.hawk.graph.syncValidationListener.SyncValidationListener;
import org.eclipse.hawk.integration.tests.IntegrationTestSuite;
import org.eclipse.hawk.integration.tests.ModelIndexingTest;
import org.eclipse.hawk.integration.tests.emf.EMFModelSupportFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;

public class MetamodelQueryTest
extends ModelIndexingTest {
    private static final String JDTAST_PT = "org.amma.dsl.jdt.primitiveTypes";
    private static final String JDTAST_DOM = "org.amma.dsl.jdt.dom";
    private static final String JDTAST_CORE = "org.amma.dsl.jdt.core";
    @Rule
    public ModelIndexingTest.GraphChangeListenerRule<SyncValidationListener> syncValidation = new ModelIndexingTest.GraphChangeListenerRule((ModelIndexingTest)this, (IGraphChangeListener)new SyncValidationListener());

    @Parameterized.Parameters(name="{1}")
    public static Iterable<Object[]> params() {
        return IntegrationTestSuite.caseParams();
    }

    public MetamodelQueryTest(File baseDir, IGraphDatabaseFactory dbf) {
        super(baseDir, dbf, new EMFModelSupportFactory());
    }

    @Before
    public void setUp() throws Throwable {
        this.indexer.registerMetamodels(new File[]{new File(this.baseDir, "resources/metamodels/Ecore.ecore"), new File(this.baseDir, "resources/metamodels/JDTAST.ecore")});
    }

    @Test
    public void metamodels() throws Exception {
        Assert.assertEquals((Object)"org.eclipse.hawk.emf.metamodel.EMFMetaModelResourceFactory", (Object)this.eolmm(JDTAST_CORE, ".metamodelType"));
        Assert.assertNotNull((Object)this.eolmm(JDTAST_CORE, ".resource"));
        Assert.assertEquals(new HashSet<String>(Arrays.asList(JDTAST_DOM, JDTAST_PT)), (Object)this.eolmm(JDTAST_CORE, ".dependencies.collect(dep|dep.uri).asSet"));
        Assert.assertEquals((Object)0, (Object)this.eolmm(JDTAST_PT, ".types.size"));
        Assert.assertEquals((Object)21, (Object)this.eolmm(JDTAST_CORE, ".types.size"));
    }

    @Test
    public void slotInstanceTypeName() throws Exception {
        Assert.assertEquals((Object)"NULL_INSTANCE_TYPE", (Object)this.eolmm(JDTAST_CORE, ".types.selectOne(t | t.name='IJavaModel').references.selectOne(r|r.name='javaProjects').instanceTypeName"));
        Assert.assertEquals((Object)String.class.getCanonicalName(), (Object)this.eolmm(JDTAST_CORE, ".types.selectOne(t | t.name='IJavaModel').attributes.selectOne(r|r.name='path').instanceTypeName"));
    }

    @Test
    public void slotType() throws Exception {
        Assert.assertEquals((Object)"IJavaProject", (Object)this.eolmm(JDTAST_CORE, ".types.selectOne(t | t.name='IJavaModel').references.selectOne(r|r.name='javaProjects').type.name"));
    }

    @Test
    public void typeSupertypes() throws Exception {
        Assert.assertEquals((Object)2, (Object)this.eolmm(JDTAST_CORE, ".types.selectOne(t | t.name='IJavaProject').allSupertypes.size"));
    }

    @Test
    public void typeSubtypes() throws Exception {
        Assert.assertEquals((Object)9, (Object)this.eolmm(JDTAST_CORE, ".types.selectOne(t | t.name='PhysicalElement').allSubtypes.size"));
    }

    private Object eolmm(String uri, String suffix) throws InvalidQueryException, QueryExecutionException {
        return this.eol(String.format("return Model.metamodels.selectOne(mm|mm.uri='%s')%s;", uri, suffix));
    }
}

