/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.uml.metamodel;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.hawk.core.IMetaModelResourceFactory;
import org.eclipse.hawk.core.model.IHawkMetaModelResource;
import org.eclipse.hawk.core.model.IHawkPackage;
import org.eclipse.hawk.emf.EMFWrapperFactory;
import org.eclipse.hawk.emf.metamodel.EMFMetaModelResource;
import org.eclipse.hawk.emf.metamodel.EMFMetaModelResourceFactory;
import org.eclipse.hawk.uml.metamodel.UMLWrapperFactory;
import org.eclipse.uml2.types.TypesPackage;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.internal.resource.UMLResourceFactoryImpl;
import org.eclipse.uml2.uml.profile.standard.StandardPackage;
import org.eclipse.uml2.uml.resource.UMLResource;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UMLMetaModelResourceFactory
implements IMetaModelResourceFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(UMLMetaModelResourceFactory.class);
    private static final String MM_EXTENSION = ".profile.uml";
    private EMFMetaModelResourceFactory emfMMFactory = new EMFMetaModelResourceFactory();
    private ResourceSet resourceSet;
    private EMFWrapperFactory emfWFactory = new EMFWrapperFactory();
    private UMLWrapperFactory umlWFactory = new UMLWrapperFactory();

    public UMLMetaModelResourceFactory() {
        this.resourceSet = new ResourceSetImpl();
        UMLUtil.init((ResourceSet)this.resourceSet);
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("uml", new UMLResourceFactoryImpl());
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
    }

    public String getHumanReadableName() {
        return "UML Metamodel Resource Factory";
    }

    public IHawkMetaModelResource parse(File f) throws Exception {
        UMLResource r = (UMLResource)this.resourceSet.createResource(URI.createFileURI((String)f.getAbsolutePath()));
        r.load(null);
        if (f.getName().endsWith(MM_EXTENSION)) {
            return new EMFMetaModelResource((Resource)r, (EMFWrapperFactory)this.umlWFactory, (IMetaModelResourceFactory)this);
        }
        return new EMFMetaModelResource((Resource)r, this.emfWFactory, (IMetaModelResourceFactory)this);
    }

    public Set<IHawkMetaModelResource> getStaticMetamodels() {
        HashSet<IHawkMetaModelResource> resources = new HashSet<IHawkMetaModelResource>();
        resources.add((IHawkMetaModelResource)new EMFMetaModelResource(EcorePackage.eINSTANCE.eResource(), this.emfWFactory, (IMetaModelResourceFactory)this));
        resources.add((IHawkMetaModelResource)new EMFMetaModelResource(TypesPackage.eINSTANCE.eResource(), this.emfWFactory, (IMetaModelResourceFactory)this));
        resources.add((IHawkMetaModelResource)new EMFMetaModelResource(XMLTypePackage.eINSTANCE.eResource(), this.emfWFactory, (IMetaModelResourceFactory)this));
        resources.add((IHawkMetaModelResource)new EMFMetaModelResource(UMLPackage.eINSTANCE.eResource(), this.emfWFactory, (IMetaModelResourceFactory)this));
        resources.add((IHawkMetaModelResource)new EMFMetaModelResource(StandardPackage.eINSTANCE.eResource(), (EMFWrapperFactory)this.umlWFactory, (IMetaModelResourceFactory)this));
        try {
            Resource rEcoreProfile = this.resourceSet.createResource(URI.createURI((String)"pathmap://UML_PROFILES/Ecore.profile.uml"));
            rEcoreProfile.load(null);
            EMFMetaModelResource hrEcoreProfile = new EMFMetaModelResource(rEcoreProfile, (EMFWrapperFactory)this.umlWFactory, (IMetaModelResourceFactory)this);
            resources.add((IHawkMetaModelResource)hrEcoreProfile);
            Resource rUMLProfile = this.resourceSet.createResource(URI.createURI((String)"pathmap://UML_PROFILES/UML2.profile.uml"));
            rUMLProfile.load(null);
            EMFMetaModelResource hrUMLProfile = new EMFMetaModelResource(rUMLProfile, (EMFWrapperFactory)this.umlWFactory, (IMetaModelResourceFactory)this);
            resources.add((IHawkMetaModelResource)hrUMLProfile);
        }
        catch (IOException e) {
            LOGGER.error("Error while loading predefined profiles", (Throwable)e);
        }
        return resources;
    }

    public void shutdown() {
    }

    public boolean canParse(File f) {
        return f.getName().toLowerCase().endsWith(MM_EXTENSION);
    }

    public Collection<String> getMetaModelExtensions() {
        return Collections.singleton(MM_EXTENSION);
    }

    public IHawkMetaModelResource parseFromString(String name, String contents) throws Exception {
        if (name == null || contents == null) {
            return null;
        }
        Resource r = this.resourceSet.createResource(URI.createURI((String)name));
        ByteArrayInputStream input = new ByteArrayInputStream(contents.getBytes("UTF-8"));
        r.load((InputStream)input, null);
        UMLWrapperFactory wf = name.endsWith(MM_EXTENSION) ? this.umlWFactory : this.emfWFactory;
        return new EMFMetaModelResource(r, (EMFWrapperFactory)wf, (IMetaModelResourceFactory)this);
    }

    public Optional<String> dumpPackageToString(IHawkPackage ePackage) throws Exception {
        return this.emfMMFactory.dumpPackageToString(ePackage);
    }
}

