/*******************************************************************************
 * Copyright (c) 2015-2017 The University of York.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 3.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-3.0
 *
 * Contributors:
 *     Antonio Garcia-Dominguez - initial API and implementation
 ******************************************************************************/
package org.eclipse.hawk.modelio.exml.metamodel;

import java.util.Collections;
import java.util.Set;

import org.eclipse.hawk.core.model.IHawkAnnotation;
import org.eclipse.hawk.core.model.IHawkAttribute;
import org.eclipse.hawk.core.model.IHawkClassifier;
import org.eclipse.hawk.core.model.IHawkReference;
import org.eclipse.hawk.core.model.IHawkStructuralFeature;
import org.eclipse.hawk.modelio.exml.metamodel.mlib.MAttribute;

public class ModelioAttribute extends AbstractModelioObject implements IHawkAttribute {

	private final ModelioClass mClass;
	private final MAttribute mAttr;

	public ModelioAttribute(ModelioClass mc, MAttribute mattr) {
		this.mClass = mc;
		this.mAttr = mattr;
	}

	public MAttribute getRawAttribute() {
		return mAttr;
	}

	@Override
	public String getName() {
		return mAttr.getName();
	}

	@Override
	public boolean isMany() {
		return mAttr.getIsMany();
	}

	@Override
	public boolean isUnique() {
		return mAttr.getIsUnique();
	}

	@Override
	public boolean isOrdered() {
		return mAttr.getIsOrdered();
	}

	@Override
	public boolean isRoot() {
		return false;
	}

	@Override
	public String getUri() {
		return mClass.getPackageNSURI() + "#" + getUriFragment();
	}

	@Override
	public String getUriFragment() {
		return mAttr.getId();
	}

	@Override
	public boolean isFragmentUnique() {
		return true;
	}

	@Override
	public boolean isSet(IHawkStructuralFeature hsf) {
		switch (hsf.getName()) {
		case "name": return true;
		default: return false;
		}
	}

	@Override
	public Object get(IHawkAttribute attr) {
		switch (attr.getName()) {
		case "name": return mAttr.getName();
		default: return null;
		}
	}

	@Override
	public Object get(IHawkReference ref, boolean b) {
		return null;
	}

	@Override
	public boolean isDerived() {
		return false;
	}

	@Override
	public Set<IHawkAnnotation> getAnnotations() {
		return Collections.emptySet();
	}

	@Override
	public IHawkClassifier getType() {
		if (mAttr.getMDataType() != null) {
			return new ModelioDataType(mClass.getPackage().getResource().getMetaPackage(), mAttr.getMDataType());
		} else {
			// Fall back to string type if unknown (e.g. for enums)
			return mClass.getPackage().getResource().getStringDataType();
		}
	}

	@Override
	public String getExml() {
		return mAttr.getExml();
	}

	@Override
	public String toString() {
		return "ModelioAttribute [getName()=" + getName() + ", isMany()=" + isMany() + ", isUnique()=" + isUnique()
				+ ", isOrdered()=" + isOrdered() + ", getType()=" + getType() + "]";
	}

	@Override
	public Object getEObject() {
		return null;
	}
}
