/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.integration.tests.bpmn;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.Callable;
import org.eclipse.hawk.backend.tests.factories.IGraphDatabaseFactory;
import org.eclipse.hawk.core.graph.IGraphChangeListener;
import org.eclipse.hawk.graph.syncValidationListener.SyncValidationListener;
import org.eclipse.hawk.integration.tests.IntegrationTestSuite;
import org.eclipse.hawk.integration.tests.ModelIndexingTest;
import org.eclipse.hawk.integration.tests.emf.EMFModelSupportFactory;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runners.Parameterized;

public class ModelVersioningTest
extends ModelIndexingTest {
    @Rule
    public ModelIndexingTest.GraphChangeListenerRule<SyncValidationListener> syncValidation = new ModelIndexingTest.GraphChangeListenerRule((ModelIndexingTest)this, (IGraphChangeListener)new SyncValidationListener());
    @Rule
    public TemporaryFolder modelFolder = new TemporaryFolder();
    private Path modelPath;

    @Parameterized.Parameters(name="{1}")
    public static Iterable<Object[]> params() {
        return IntegrationTestSuite.caseParams();
    }

    public ModelVersioningTest(File baseDir, IGraphDatabaseFactory dbf) {
        super(baseDir, dbf, new EMFModelSupportFactory());
    }

    public void prepare(String baseModel) throws Throwable {
        this.modelPath = new File(this.modelFolder.getRoot(), new File(baseModel).getName()).toPath();
        Files.copy(new File(this.baseDir, "resources/models/" + baseModel).toPath(), this.modelPath, new CopyOption[0]);
        this.requestFolderIndex(this.modelFolder.getRoot());
        this.scheduleAndWait(() -> {
            this.assertNoErrors(this.syncValidation.getListener());
            return null;
        });
    }

    @Test
    public void bpmn() throws Throwable {
        this.prepare("bpmn/v0-B.2.0.bpmn");
        Callable<Object> noErrors = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ModelVersioningTest.this.assertNoErrors(ModelVersioningTest.this.syncValidation.getListener());
                return null;
            }
        };
        int i = 1;
        while (i <= 8) {
            this.replaceWith("bpmn/v" + i + "-B.2.0.bpmn");
            this.indexer.requestImmediateSync();
            this.scheduleAndWait(noErrors);
            ++i;
        }
    }

    private void replaceWith(String replacement) throws IOException {
        File replacementFile = new File(this.baseDir, "resources/models/" + replacement);
        Files.copy(replacementFile.toPath(), this.modelPath, StandardCopyOption.REPLACE_EXISTING);
        System.err.println("Copied " + replacementFile + " over " + this.modelPath);
    }
}

