/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.timeaware.tests;

import java.io.File;
import java.io.IOException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hawk.backend.tests.factories.IGraphDatabaseFactory;
import org.eclipse.hawk.integration.tests.ModelIndexingTest;
import org.eclipse.hawk.integration.tests.emf.EMFModelSupportFactory;
import org.eclipse.hawk.integration.tests.mm.Tree.Tree;
import org.eclipse.hawk.integration.tests.mm.Tree.TreeFactory;
import org.eclipse.hawk.svn.tests.rules.TemporarySVNRepository;
import org.eclipse.hawk.timeaware.tests.AbstractTimeAwareModelIndexingTest;
import org.eclipse.hawk.timeaware.tests.TimeAwareTestSuite;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.tmatesoft.svn.core.SVNException;

@RunWith(value=Parameterized.class)
public class DerivedAttributeHistoryTest
extends AbstractTimeAwareModelIndexingTest {
    @Rule
    public TemporarySVNRepository svnRepository = new TemporarySVNRepository();
    private Resource rTree;

    @Parameterized.Parameters(name="{1}")
    public static Iterable<Object[]> params() {
        return TimeAwareTestSuite.caseParams();
    }

    public DerivedAttributeHistoryTest(File baseDir, IGraphDatabaseFactory dbFactory) {
        super(baseDir, dbFactory, (ModelIndexingTest.IModelSupportFactory)new EMFModelSupportFactory());
    }

    @Override
    protected void setUpMetamodels() throws Exception {
        this.indexer.registerMetamodels(new File[]{new File(this.baseDir, "resources/metamodels/Tree.ecore")});
    }

    @Test
    public void computedForAllVersions() throws Throwable {
        this.oneDerivedAttribute();
        this.requestSVNIndex(this.svnRepository);
        this.scheduleAndWait(() -> {
            Assert.assertTrue((boolean)((Boolean)this.timeAwareEOL("return Tree.latest.all.first.always(v|v.Important.isDefined());")));
            Assert.assertTrue((boolean)((Boolean)this.timeAwareEOL("return Tree.latest.all.first.earliest.Important;")));
            Assert.assertFalse((boolean)((Boolean)this.timeAwareEOL("return Tree.latest.all.first.latest.Important;")));
            Assert.assertEquals((Object)1, (Object)this.timeAwareEOL("return Tree.latest.all.first.whenAnnotated('Important').versions.size;"));
            return null;
        });
    }

    @Test
    public void whenComposability() throws Throwable {
        this.twoDerivedAttributeRepository();
        this.scheduleAndWait(() -> {
            Assert.assertEquals((Object)2, (Object)this.timeAwareEOL("return Tree.earliest.next.all.first.whenAnnotated('Important').versions.size;"));
            Assert.assertEquals((Object)2, (Object)this.timeAwareEOL("return Tree.earliest.next.all.first.whenAnnotated('HasChildren').versions.size;"));
            Assert.assertEquals((Object)1, (Object)this.timeAwareEOL("return Tree.earliest.next.all.first.whenAnnotated('Important').whenAnnotated('HasChildren').versions.size;"));
            Assert.assertEquals((Object)1, (Object)this.timeAwareEOL("return Tree.earliest.next.all.first.whenAnnotated('HasChildren').whenAnnotated('Important').versions.size;"));
            return null;
        });
    }

    @Test
    public void sinceAnnotated() throws Throwable {
        this.twoDerivedAttributeRepository();
        this.scheduleAndWait(() -> {
            Assert.assertEquals((Object)4, (Object)this.timeAwareEOL("return Tree.earliest.next.all.first.earliest.sinceAnnotated('Important').versions.size;"));
            Assert.assertEquals((Object)1, (Object)this.timeAwareEOL("return Tree.earliest.next.all.first.earliest.next.sinceAnnotated('Important').versions.size;"));
            Assert.assertEquals((Object)2, (Object)this.timeAwareEOL("return Tree.earliest.next.all.first.earliest.sinceAnnotated('HasChildren').versions.size;"));
            return null;
        });
    }

    @Test
    public void afterAnnotated() throws Throwable {
        this.twoDerivedAttributeRepository();
        this.scheduleAndWait(() -> {
            Assert.assertEquals((Object)3, (Object)this.timeAwareEOL("return Tree.earliest.next.all.first.earliest.afterAnnotated('Important').versions.size;"));
            Assert.assertFalse((boolean)((Boolean)this.timeAwareEOL("return Tree.earliest.next.all.first.earliest.next.afterAnnotated('Important').isDefined();")));
            Assert.assertEquals((Object)1, (Object)this.timeAwareEOL("return Tree.earliest.next.all.first.earliest.afterAnnotated('HasChildren').versions.size;"));
            return null;
        });
    }

    @Test
    public void untilAnnotated() throws Throwable {
        this.twoDerivedAttributeRepository();
        this.scheduleAndWait(() -> {
            Assert.assertEquals((Object)1, (Object)this.timeAwareEOL("return Tree.earliest.next.all.first.earliest.untilAnnotated('Important').versions.size;"));
            Assert.assertEquals((Object)3, (Object)this.timeAwareEOL("return Tree.earliest.next.all.first.earliest.next.sinceThen.untilAnnotated('Important').versions.size;"));
            Assert.assertEquals((Object)3, (Object)this.timeAwareEOL("return Tree.earliest.next.all.first.earliest.untilAnnotated('HasChildren').versions.size;"));
            Assert.assertEquals((Object)1, (Object)this.timeAwareEOL("return Tree.earliest.next.all.first.earliest.untilAnnotated('HasChildren').untilAnnotated('Important').versions.size;"));
            Assert.assertFalse((boolean)((Boolean)this.timeAwareEOL("return Tree.earliest.next.all.first.earliest.untilAnnotated('Important').untilAnnotated('HasChildren').isDefined();")));
            return null;
        });
    }

    @Test
    public void beforeAnnotated() throws Throwable {
        this.twoDerivedAttributeRepository();
        this.scheduleAndWait(() -> {
            Assert.assertFalse((boolean)((Boolean)this.timeAwareEOL("return Tree.earliest.next.all.first.earliest.beforeAnnotated('Important').isDefined();")));
            Assert.assertEquals((Object)2, (Object)this.timeAwareEOL("return Tree.earliest.next.all.first.earliest.next.sinceThen.beforeAnnotated('Important').versions.size;"));
            Assert.assertEquals((Object)2, (Object)this.timeAwareEOL("return Tree.earliest.next.all.first.earliest.beforeAnnotated('HasChildren').versions.size;"));
            return null;
        });
    }

    @Test
    public void revRefNavDerived() throws Throwable {
        this.indexer.getMetaModelUpdater().addDerivedAttribute("Tree", "Tree", "parentLabel", "String", false, false, false, "org.eclipse.hawk.epsilon.emc.EOLQueryEngine", "var parent = self.revRefNav_children.first; if (parent.isDefined()) return parent.label; else return '';", this.indexer);
        this.parentLabelRepository();
        this.scheduleAndWait(() -> {
            Assert.assertEquals((Object)"Root2", (Object)this.timeAwareEOL("return Tree.latest.all.selectOne(l|l.latest.label='Child').latest.parentLabel;"));
            Assert.assertEquals((Object)3, (Object)this.timeAwareEOL("return Tree.latest.all.selectOne(l|l.latest.label='Child').versions.size;"));
            return null;
        });
    }

    @Test
    public void eContainerDerived() throws Throwable {
        this.indexer.getMetaModelUpdater().addDerivedAttribute("Tree", "Tree", "parentLabel", "String", false, false, false, "org.eclipse.hawk.epsilon.emc.EOLQueryEngine", "var parent = self.eContainer; if (parent.isDefined()) return parent.label; else return '';", this.indexer);
        this.parentLabelRepository();
        this.scheduleAndWait(() -> {
            Assert.assertEquals((Object)"Root2", (Object)this.timeAwareEOL("return Tree.latest.all.selectOne(l|l.latest.label='Child').latest.parentLabel;"));
            Assert.assertEquals((Object)3, (Object)this.timeAwareEOL("return Tree.latest.all.selectOne(l|l.latest.label='Child').versions.size;"));
            return null;
        });
    }

    private void parentLabelRepository() throws Exception {
        File fTree = new File(this.svnRepository.getCheckoutDirectory(), "root.xmi");
        this.rTree = this.rsTree.createResource(URI.createFileURI((String)fTree.getAbsolutePath()));
        Tree root = this.treeFactory.createTree();
        root.setLabel("Root");
        this.rTree.getContents().add((Object)root);
        this.rTree.save(null);
        this.svnRepository.add(new File[]{fTree});
        this.svnRepository.commit("First commit");
        Tree child = this.treeFactory.createTree();
        child.setLabel("Child");
        root.getChildren().add((Object)child);
        this.rTree.save(null);
        this.svnRepository.commit("Second commit - add child");
        root.setLabel("Root1");
        this.rTree.save(null);
        this.svnRepository.commit("Third commit - change label 1");
        root.setLabel("Root2");
        this.rTree.save(null);
        this.svnRepository.commit("Third commit - change label 2");
        this.requestSVNIndex(this.svnRepository);
    }

    private void twoDerivedAttributeRepository() throws Exception, IOException, SVNException {
        this.indexer.getMetaModelUpdater().addDerivedAttribute("Tree", "Tree", "HasChildren", "Boolean", false, false, false, "org.eclipse.hawk.epsilon.emc.EOLQueryEngine", "return self.children.size > 0;", this.indexer);
        Tree tRoot = this.oneDerivedAttribute();
        Tree tChild = TreeFactory.eINSTANCE.createTree();
        tChild.setLabel("Child");
        tRoot.getChildren().add((Object)tChild);
        this.rTree.save(null);
        this.svnRepository.commit("Add child node");
        tRoot.setLabel("NowYouSeeMe");
        this.rTree.save(null);
        this.svnRepository.commit("Change label back");
        this.requestSVNIndex(this.svnRepository);
    }

    private Tree oneDerivedAttribute() throws Exception {
        this.indexer.getMetaModelUpdater().addDerivedAttribute("Tree", "Tree", "Important", "Boolean", false, false, false, "org.eclipse.hawk.epsilon.emc.EOLQueryEngine", "return self.label = 'NowYouSeeMe';", this.indexer);
        File fTree = new File(this.svnRepository.getCheckoutDirectory(), "root.xmi");
        this.rTree = this.rsTree.createResource(URI.createFileURI((String)fTree.getAbsolutePath()));
        Tree t = this.treeFactory.createTree();
        t.setLabel("NowYouSeeMe");
        this.rTree.getContents().add((Object)t);
        this.rTree.save(null);
        this.svnRepository.add(new File[]{fTree});
        this.svnRepository.commit("First commit");
        t.setLabel("NowYouDoNot");
        this.rTree.save(null);
        this.svnRepository.commit("Second commit - change label");
        return t;
    }
}

