/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.ui2.preferences;

import java.util.Set;
import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.osgiserver.HModel;
import org.eclipse.hawk.ui2.Activator;
import org.eclipse.hawk.ui2.dialog.HConfigDialog;
import org.eclipse.hawk.ui2.dialog.HImportDialog;
import org.eclipse.hawk.ui2.util.HUIManager;
import org.eclipse.hawk.ui2.wizard.HWizard;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;

public class HawkInstanceBlock {
    private Button createButton;
    private Button importButton;
    private Button removeButton;
    private Button configButton;
    private Button startButton;
    private Button stopButton;
    private Composite control;
    private TableViewer instanceListTableViewer;
    private Table fTable;

    public Control getControl() {
        return this.control;
    }

    protected Shell getShell() {
        return this.getControl().getShell();
    }

    public void createControl(Composite ancestor) {
        Font font = ancestor.getFont();
        Composite parent = new Composite(ancestor, 0);
        parent.setFont(font);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 1;
        parent.setLayout((Layout)layout);
        this.control = parent;
        this.fTable = new Table(parent, 67588);
        GridData gd = new GridData(1808);
        gd.heightHint = 250;
        gd.widthHint = 350;
        this.fTable.setLayoutData((Object)gd);
        this.fTable.setFont(font);
        this.fTable.setHeaderVisible(true);
        this.fTable.setLinesVisible(true);
        int defaultwidth = 117;
        TableColumn column = new TableColumn(this.fTable, 0);
        column.setText("Name");
        column.setWidth(defaultwidth);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HawkInstanceBlock.this.instanceListTableViewer.refresh(true);
            }
        });
        column = new TableColumn(this.fTable, 0);
        column.setText("Location");
        column.setWidth(defaultwidth);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HawkInstanceBlock.this.instanceListTableViewer.refresh(true);
            }
        });
        column = new TableColumn(this.fTable, 0);
        column.setText("Status");
        column.setWidth(defaultwidth);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HawkInstanceBlock.this.instanceListTableViewer.refresh(true);
            }
        });
        this.instanceListTableViewer = new TableViewer(this.fTable);
        this.instanceListTableViewer.setLabelProvider((IBaseLabelProvider)new HawkIndexLabelProvider());
        this.instanceListTableViewer.setContentProvider((IContentProvider)new HawkIndexContentProvider());
        this.instanceListTableViewer.setUseHashlookup(true);
        this.instanceListTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent evt) {
                ISelection selection = evt.getSelection();
                HModel element = (HModel)((IStructuredSelection)HawkInstanceBlock.this.instanceListTableViewer.getSelection()).getFirstElement();
                if (!selection.isEmpty()) {
                    HawkInstanceBlock.this.toggleHawk(element);
                    HawkInstanceBlock.this.removeButton.setEnabled(true);
                } else {
                    HawkInstanceBlock.this.removeButton.setEnabled(false);
                }
            }
        });
        this.instanceListTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                if (!e.getSelection().isEmpty()) {
                    HModel selection = (HModel)((IStructuredSelection)HawkInstanceBlock.this.instanceListTableViewer.getSelection()).getFirstElement();
                    if (selection.isRunning()) {
                        HawkInstanceBlock.this.configIndex();
                    } else {
                        selection.start(selection.getManager());
                        HawkInstanceBlock.this.instanceListTableViewer.refresh();
                    }
                    HawkInstanceBlock.this.toggleHawk(selection);
                }
            }
        });
        this.fTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0 && HawkInstanceBlock.this.removeButton.isEnabled()) {
                    HawkInstanceBlock.this.removeIndex();
                }
            }
        });
        Composite buttons = new Composite(parent, 2);
        buttons.setFont(font);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttons.setLayout((Layout)layout);
        GridData horizontalFill = new GridData(4, 2, true, true);
        this.createButton = new Button(buttons, 8);
        this.createButton.setText("&Create...");
        this.createButton.setEnabled(true);
        this.createButton.setLayoutData((Object)horizontalFill);
        this.createButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                HawkInstanceBlock.this.createIndex();
            }
        });
        this.importButton = new Button(buttons, 8);
        this.importButton.setText("&Import...");
        this.importButton.setEnabled(true);
        this.importButton.setLayoutData((Object)horizontalFill);
        this.importButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                HawkInstanceBlock.this.importIndex();
            }
        });
        this.startButton = new Button(buttons, 8);
        this.startButton.setText("&Start");
        this.startButton.setEnabled(false);
        this.startButton.setLayoutData((Object)horizontalFill);
        this.startButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                HModel element = (HModel)((IStructuredSelection)HawkInstanceBlock.this.instanceListTableViewer.getSelection()).getFirstElement();
                if (!element.isRunning()) {
                    element.start(element.getManager());
                }
                HawkInstanceBlock.this.toggleRunning(true);
                HawkInstanceBlock.this.instanceListTableViewer.refresh();
            }
        });
        this.stopButton = new Button(buttons, 8);
        this.stopButton.setText("&Stop");
        this.stopButton.setEnabled(false);
        this.stopButton.setLayoutData((Object)horizontalFill);
        this.stopButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                HModel element = (HModel)((IStructuredSelection)HawkInstanceBlock.this.instanceListTableViewer.getSelection()).getFirstElement();
                if (element.isRunning()) {
                    element.stop(IModelIndexer.ShutdownRequestType.ALWAYS);
                }
                HawkInstanceBlock.this.toggleRunning(false);
                HawkInstanceBlock.this.instanceListTableViewer.refresh();
            }
        });
        this.configButton = new Button(buttons, 8);
        this.configButton.setText("&Configure...");
        this.configButton.setEnabled(false);
        this.configButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                HawkInstanceBlock.this.configIndex();
            }
        });
        this.removeButton = new Button(buttons, 8);
        this.removeButton.setText("&Remove");
        this.removeButton.setEnabled(false);
        this.removeButton.setLayoutData((Object)horizontalFill);
        this.removeButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                HawkInstanceBlock.this.removeIndex();
            }
        });
        this.updateIndexes();
        this.instanceListTableViewer.refresh();
    }

    private void toggleHawk(HModel element) {
        boolean running = element.isRunning();
        this.toggleRunning(running);
    }

    private void toggleRunning(boolean running) {
        this.startButton.setEnabled(!running);
        this.configButton.setEnabled(running);
        this.stopButton.setEnabled(running);
    }

    public HModel[] getIndexes() {
        Set hawks = HUIManager.getInstance().getHawks();
        return hawks.toArray(new HModel[hawks.size()]);
    }

    protected void updateIndexes() {
        HModel[] array = this.getIndexes();
        this.instanceListTableViewer.setInput((Object)array);
        this.instanceListTableViewer.refresh();
    }

    private void createIndex() {
        HModel result;
        HWizard wizard = new HWizard();
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        if (dialog.open() == 0 && (result = wizard.getResult()) != null) {
            this.instanceListTableViewer.refresh();
            this.instanceListTableViewer.setSelection((ISelection)new StructuredSelection((Object)result));
            this.instanceListTableViewer.refresh(true);
        }
    }

    private void configIndex() {
        IStructuredSelection selection = (IStructuredSelection)this.instanceListTableViewer.getSelection();
        HModel firstElement = (HModel)selection.getFirstElement();
        if (firstElement == null) {
            return;
        }
        HConfigDialog dialog = new HConfigDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), firstElement);
        dialog.open();
    }

    private void removeIndex() {
        IStructuredSelection selected = (IStructuredSelection)this.instanceListTableViewer.getSelection();
        if (selected.size() >= 1) {
            HModel hawkmodel = (HModel)selected.getFirstElement();
            try {
                HUIManager.getInstance().delete(hawkmodel, hawkmodel.exists());
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
        this.instanceListTableViewer.refresh();
    }

    private void importIndex() {
        HImportDialog dialog = new HImportDialog(this.getShell());
        dialog.setBlockOnOpen(true);
        dialog.open();
        this.instanceListTableViewer.refresh();
    }

    class HawkIndexContentProvider
    implements IStructuredContentProvider {
        HawkIndexContentProvider() {
        }

        public Object[] getElements(Object input) {
            return HawkInstanceBlock.this.getIndexes();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    class HawkIndexLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected Image runningImage = null;
        protected Image stoppedImage = null;

        HawkIndexLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            HModel hModel = (HModel)obj;
            if (index == 0) {
                return hModel.getName();
            }
            if (index == 1) {
                return hModel.getFolder();
            }
            return hModel.getStatus().toString();
        }

        public Image getColumnImage(Object obj, int index) {
            if (index == 0) {
                return this.getImage(obj);
            }
            return null;
        }

        public Image getImage(Object obj) {
            HModel hModel;
            if (this.runningImage == null) {
                this.runningImage = Activator.getImageDescriptor("icons/hawk-running.png").createImage();
                this.stoppedImage = Activator.getImageDescriptor("icons/hawk-stopped.png").createImage();
            }
            if ((hModel = (HModel)obj).isRunning()) {
                return this.runningImage;
            }
            return this.stoppedImage;
        }
    }
}

