/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgi.cli.remote;

import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.UUID;
import org.apache.felix.service.command.CommandSession;

public class RemoteCommandSession {
    private final CommandSession delegate;
    private final String id;

    public RemoteCommandSession(CommandSession delegate) {
        this.delegate = delegate;
        this.id = UUID.randomUUID().toString();
    }

    public String getId() {
        return this.id;
    }

    public CommandSession attach(InputStream in, PrintStream out, PrintStream err) {
        this.set(this.delegate, "in", in);
        this.set(this.delegate, "out", out);
        this.set(this.delegate, "err", err);
        ReadableByteChannel inCh = Channels.newChannel(in);
        WritableByteChannel outCh = Channels.newChannel(out);
        WritableByteChannel errCh = out == err ? outCh : Channels.newChannel(err);
        this.set(this.delegate, "channels", new Channel[]{inCh, outCh, errCh});
        return this.delegate;
    }

    public void detach() {
        this.set(this.delegate, "in", null);
        this.set(this.delegate, "out", null);
        this.set(this.delegate, "err", null);
    }

    private void set(final Object obj, String field, final Object value) {
        try {
            final Field f = obj.getClass().getDeclaredField(field);
            final boolean accessible = f.isAccessible();
            if (!accessible) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        f.setAccessible(true);
                        try {
                            f.set(obj, value);
                        }
                        catch (Exception x) {
                            throw new RuntimeException(x);
                        }
                        f.setAccessible(accessible);
                        return null;
                    }
                });
            } else {
                f.set(obj, value);
            }
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }
}

