/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.InputStream;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.NoRowsResultSetImpl;
import org.apache.derby.impl.sql.execute.NormalizeResultSet;
import org.apache.derby.impl.sql.execute.RowUtil;
import org.apache.derby.impl.sql.execute.UpdatableVTIConstantAction;
import org.apache.derby.impl.sql.execute.WriteCursorConstantAction;

public abstract class DMLWriteResultSet
extends NoRowsResultSetImpl {
    protected WriteCursorConstantAction constantAction;
    protected int[] baseRowReadMap;
    protected int[] streamStorableHeapColIds;
    protected DynamicCompiledOpenConglomInfo heapDCOCI;
    protected DynamicCompiledOpenConglomInfo[] indexDCOCIs;
    private boolean needToObjectifyStream;
    public long rowCount;
    protected ResultDescription resultDescription;
    protected DataValueDescriptor[] cachedDestinations;

    DMLWriteResultSet(Activation activation) throws StandardException {
        this(activation, activation.getConstantAction());
    }

    DMLWriteResultSet(Activation activation, ConstantAction constantAction) throws StandardException {
        super(activation);
        this.constantAction = (WriteCursorConstantAction)constantAction;
        this.baseRowReadMap = this.constantAction.getBaseRowReadMap();
        this.streamStorableHeapColIds = this.constantAction.getStreamStorableHeapColIds();
        TransactionController transactionController = activation.getTransactionController();
        if (!(constantAction instanceof UpdatableVTIConstantAction)) {
            this.heapDCOCI = transactionController.getDynamicCompiledConglomInfo(this.constantAction.conglomId);
            if (this.constantAction.indexCIDS.length != 0) {
                this.indexDCOCIs = new DynamicCompiledOpenConglomInfo[this.constantAction.indexCIDS.length];
                for (int i = 0; i < this.constantAction.indexCIDS.length; ++i) {
                    this.indexDCOCIs[i] = transactionController.getDynamicCompiledConglomInfo(this.constantAction.indexCIDS[i]);
                }
            }
        }
        this.needToObjectifyStream = this.constantAction.getTriggerInfo() != null;
    }

    @Override
    public final long modifiedRowCount() {
        return this.rowCount + RowUtil.getRowCountBase();
    }

    @Override
    public ResultDescription getResultDescription() {
        return this.resultDescription;
    }

    protected ExecRow getNextRowCore(NoPutResultSet noPutResultSet) throws StandardException {
        ExecRow execRow = noPutResultSet.getNextRowCore();
        if (this.needToObjectifyStream) {
            this.objectifyStreams(execRow);
        }
        return execRow;
    }

    private void objectifyStreams(ExecRow execRow) throws StandardException {
        if (execRow != null && this.streamStorableHeapColIds != null) {
            for (int i = 0; i < this.streamStorableHeapColIds.length; ++i) {
                int n = this.streamStorableHeapColIds[i];
                int n2 = this.baseRowReadMap == null ? n : this.baseRowReadMap[n];
                DataValueDescriptor dataValueDescriptor = execRow.getColumn(n2 + 1);
                if (dataValueDescriptor == null) continue;
                InputStream inputStream = ((StreamStorable)((Object)dataValueDescriptor)).returnStream();
                ((StreamStorable)((Object)dataValueDescriptor)).loadStream();
                if (inputStream == null) continue;
                for (int j = 1; j <= execRow.nColumns(); ++j) {
                    DataValueDescriptor dataValueDescriptor2 = execRow.getColumn(j);
                    if (!(dataValueDescriptor2 instanceof StreamStorable) || ((StreamStorable)((Object)dataValueDescriptor2)).returnStream() != inputStream) continue;
                    execRow.setColumn(j, dataValueDescriptor.cloneValue(false));
                }
            }
        }
    }

    protected ExecRow makeDeferredSparseRow(ExecRow execRow, FormatableBitSet formatableBitSet, LanguageConnectionContext languageConnectionContext) throws StandardException {
        ExecRow execRow2;
        if (formatableBitSet == null) {
            execRow2 = execRow;
        } else {
            execRow2 = RowUtil.getEmptyValueRow(formatableBitSet.getLength() - 1, languageConnectionContext);
            int n = 1;
            for (int i = 1; i <= execRow2.nColumns(); ++i) {
                if (!formatableBitSet.isSet(i)) continue;
                execRow2.setColumn(i, execRow.getColumn(n++));
            }
        }
        return execRow2;
    }

    int decodeLockMode(int n) {
        if (n >>> 16 == 0) {
            return n;
        }
        int n2 = this.lcc.getCurrentIsolationLevel();
        if (n2 == 4) {
            return n >>> 16;
        }
        return n & 0xFF;
    }

    String getIndexNameFromCID(long l) {
        return this.constantAction.getIndexNameFromCID(l);
    }

    protected ExecRow normalizeRow(NoPutResultSet noPutResultSet, ExecRow execRow) throws StandardException {
        Object object;
        int n;
        int n2;
        int n3 = this.resultDescription.getColumnCount();
        if (this.cachedDestinations == null) {
            this.cachedDestinations = new DataValueDescriptor[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                n = n2 + 1;
                object = this.resultDescription.getColumnDescriptor(n);
                this.cachedDestinations[n2] = object.getType().getNull();
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            n = n2 + 1;
            object = this.resultDescription.getColumnDescriptor(n).getType();
            if (execRow.getColumn(n) == null) {
                execRow.setColumn(n, ((DataTypeDescriptor)object).getNull());
            }
            execRow.setColumn(n, NormalizeResultSet.normalizeColumn((DataTypeDescriptor)object, execRow, n, this.cachedDestinations[n2], this.resultDescription));
        }
        this.activation.setCurrentRow(execRow, noPutResultSet.resultSetNumber());
        return execRow;
    }

    public void rememberConstraint(UUID uUID) throws StandardException {
    }
}

