/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resources.connector;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.deploy.shared.ModuleType;
import javax.inject.Inject;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.deployment.GenericSniffer;
import org.glassfish.resources.util.ResourceUtil;
import org.jvnet.hk2.annotations.Service;

@Service(name="resources_ear")
public class ResourcesCompositeSniffer
extends GenericSniffer {
    final String[] containerNames = new String[]{"org.glassfish.resources.module.ResourcesContainer"};
    @Inject
    ServiceLocator locator;
    private static final List<String> deploymentConfigurationPaths = ResourcesCompositeSniffer.initDeploymentConfigurationPaths();

    public ResourcesCompositeSniffer() {
        super("resources_ear", "META-INF/glassfish-resources.xml", null);
    }

    public boolean handles(ReadableArchive archive) {
        return ResourceUtil.hasResourcesXML(archive, this.locator);
    }

    public String[] getContainersNames() {
        return this.containerNames;
    }

    public String getModuleType() {
        return "resources_ear";
    }

    public boolean supportsArchiveType(ArchiveType archiveType) {
        return archiveType.toString().equals(ModuleType.EAR.toString());
    }

    private static List<String> initDeploymentConfigurationPaths() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("META-INF/glassfish-resources.xml");
        return result;
    }

    protected List<String> getDeploymentConfigurationPaths() {
        return deploymentConfigurationPaths;
    }
}

