/**
 * Copyright (c) 2016, 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package org.eclipse.gemoc.executionframework.debugger;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gemoc.executionframework.debugger.IMutableFieldExtractor;
import org.eclipse.gemoc.executionframework.debugger.MutableField;
import org.eclipse.gemoc.executionframework.engine.core.CommandExecution;
import org.eclipse.gemoc.xdsmlframework.commons.DynamicAnnotationHelper;
import org.eclipse.xtext.naming.DefaultDeclarativeQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;

@SuppressWarnings("all")
public class AnnotationMutableFieldExtractor implements IMutableFieldExtractor {
  private final Map<EClass, Integer> counters = new HashMap<EClass, Integer>();
  
  private final DefaultDeclarativeQualifiedNameProvider nameprovider = new DefaultDeclarativeQualifiedNameProvider();
  
  @Override
  public List<MutableField> extractMutableField(final EObject eObject) {
    final List<MutableField> result = new ArrayList<MutableField>();
    EClass _eClass = eObject.eClass();
    final EAttribute idProp = _eClass.getEIDAttribute();
    String _xifexpression = null;
    if ((idProp != null)) {
      String _xblockexpression = null;
      {
        final Object id = eObject.eGet(idProp);
        String _xifexpression_1 = null;
        if ((id != null)) {
          String _xblockexpression_1 = null;
          {
            final NumberFormat formatter = new DecimalFormat("00");
            String _xifexpression_2 = null;
            if ((id instanceof Integer)) {
              _xifexpression_2 = formatter.format(((Integer) id));
            } else {
              _xifexpression_2 = id.toString();
            }
            final String idString = _xifexpression_2;
            EClass _eClass_1 = eObject.eClass();
            String _name = _eClass_1.getName();
            String _plus = (_name + "_");
            _xblockexpression_1 = (_plus + idString);
          }
          _xifexpression_1 = _xblockexpression_1;
        } else {
          String _xblockexpression_2 = null;
          {
            EClass _eClass_1 = eObject.eClass();
            boolean _containsKey = this.counters.containsKey(_eClass_1);
            boolean _not = (!_containsKey);
            if (_not) {
              EClass _eClass_2 = eObject.eClass();
              this.counters.put(_eClass_2, Integer.valueOf(0));
            }
            EClass _eClass_3 = eObject.eClass();
            final Integer counter = this.counters.get(_eClass_3);
            EClass _eClass_4 = eObject.eClass();
            this.counters.put(_eClass_4, Integer.valueOf(((counter).intValue() + 1)));
            EClass _eClass_5 = eObject.eClass();
            String _name = _eClass_5.getName();
            String _plus = (_name + "_");
            _xblockexpression_2 = (_plus + counter);
          }
          _xifexpression_1 = _xblockexpression_2;
        }
        _xblockexpression = _xifexpression_1;
      }
      _xifexpression = _xblockexpression;
    } else {
      String _xblockexpression_1 = null;
      {
        final QualifiedName qname = this.nameprovider.getFullyQualifiedName(eObject);
        String _xifexpression_1 = null;
        if ((qname == null)) {
          _xifexpression_1 = eObject.toString();
        } else {
          _xifexpression_1 = qname.toString();
        }
        _xblockexpression_1 = _xifexpression_1;
      }
      _xifexpression = _xblockexpression_1;
    }
    final String objectName = _xifexpression;
    EClass _eClass_1 = eObject.eClass();
    EList<EStructuralFeature> _eAllStructuralFeatures = _eClass_1.getEAllStructuralFeatures();
    for (final EStructuralFeature prop : _eAllStructuralFeatures) {
      boolean _isDynamic = DynamicAnnotationHelper.isDynamic(prop);
      if (_isDynamic) {
        String _name = prop.getName();
        String _plus = (_name + " (");
        String _plus_1 = (_plus + objectName);
        String _plus_2 = (_plus_1 + " :");
        EClass _eClass_2 = eObject.eClass();
        String _name_1 = _eClass_2.getName();
        String _plus_3 = (_plus_2 + _name_1);
        String _plus_4 = (_plus_3 + ")");
        final Supplier<Object> _function = new Supplier<Object>() {
          @Override
          public Object get() {
            return eObject.eGet(prop);
          }
        };
        final Consumer<Object> _function_1 = new Consumer<Object>() {
          @Override
          public void accept(final Object o) {
            Resource _eResource = eObject.eResource();
            final TransactionalEditingDomain ed = TransactionUtil.getEditingDomain(_eResource);
            String _name = prop.getName();
            String _plus = ((((("Setting value " + o) + " in ") + objectName) + ".") + _name);
            String _plus_1 = (_plus + " from the debugger");
            RecordingCommand command = new RecordingCommand(ed, _plus_1) {
              @Override
              protected void doExecute() {
                eObject.eSet(prop, o);
              }
            };
            CommandExecution.execute(ed, command);
          }
        };
        final MutableField mut = new MutableField(_plus_4, eObject, prop, _function, _function_1);
        result.add(mut);
      }
    }
    return result;
  }
}
