/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.util.parser.manifest.internal;

import java.util.Arrays;
import java.util.List;
import org.eclipse.virgo.util.parser.manifest.ManifestProblem;
import org.eclipse.virgo.util.parser.manifest.internal.Token;

public class SourceContext {
    private int[] linebreaks;
    private String theSource;

    public SourceContext(String theSource) {
        this.theSource = theSource;
        int[] nArray = new int[2];
        nArray[1] = theSource.length();
        this.linebreaks = nArray;
    }

    public void setLinebreaks(List<Integer> linebreaks) {
        this.linebreaks = new int[linebreaks.size()];
        int i = 0;
        while (i < linebreaks.size()) {
            this.linebreaks[i] = linebreaks.get(i);
            ++i;
        }
    }

    public int[] getLinebreaks() {
        int[] linebreaksCopy = new int[this.linebreaks.length];
        System.arraycopy(this.linebreaks, 0, linebreaksCopy, 0, this.linebreaks.length);
        return linebreaksCopy;
    }

    public int getLine(Token token) {
        return this.getRelevantStartLinebreakEntry(token.getStartOffset()) + 1;
    }

    public int getLine(int offset) {
        return this.getRelevantStartLinebreakEntry(offset) + 1;
    }

    public int getLine(ManifestProblem manifestParserProblemInstance) {
        return this.getRelevantStartLinebreakEntry(manifestParserProblemInstance.getStartOffset()) + 1;
    }

    public int getEndLine(Token token) {
        return this.getRelevantEndLinebreakEntry(token.getEndOffset()) + 1;
    }

    public int getStartColumn(Token token) {
        int lb = this.getRelevantStartLinebreakEntry(token.getStartOffset());
        return token.getStartOffset() - this.linebreaks[lb];
    }

    public int getStartColumn(ManifestProblem manifestParserProblemInstance) {
        int lb = this.getRelevantStartLinebreakEntry(manifestParserProblemInstance.getStartOffset());
        return manifestParserProblemInstance.getStartOffset() - this.linebreaks[lb];
    }

    public int getColumn(int offset) {
        int lb = this.getRelevantStartLinebreakEntry(offset);
        return offset - this.linebreaks[lb];
    }

    public int getEndColumn(Token token) {
        int lb = this.getRelevantEndLinebreakEntry(token.getEndOffset());
        return token.getEndOffset() - this.linebreaks[lb];
    }

    public int getEndColumn(ManifestProblem manifestParserProblemInstance) {
        int lb = this.getRelevantEndLinebreakEntry(manifestParserProblemInstance.getEndOffset());
        return manifestParserProblemInstance.getEndOffset() - this.linebreaks[lb];
    }

    private int getRelevantStartLinebreakEntry(int startoffset) {
        int pos = Arrays.binarySearch(this.linebreaks, startoffset);
        if (pos < 0) {
            return -pos - 2;
        }
        return pos;
    }

    private int getRelevantEndLinebreakEntry(int offset) {
        int pos = Arrays.binarySearch(this.linebreaks, offset);
        if (pos < 0) {
            return -pos - 2;
        }
        return pos;
    }

    public String getLineAsString(int relevantLine) {
        int startoffset = this.linebreaks[relevantLine - 1];
        int endoffset = this.linebreaks[relevantLine];
        return this.theSource.substring(startoffset, endoffset);
    }
}

