/*
 * Decompiled with CFR 0.152.
 */
package com.github.javabdd;

import com.github.javabdd.BDD;
import com.github.javabdd.BDDDomain;
import com.github.javabdd.BDDException;
import com.github.javabdd.BDDFactory;
import com.github.javabdd.BDDFactoryIntImpl;
import com.github.javabdd.BDDPairing;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;

public class JFactory
extends BDDFactoryIntImpl {
    public static boolean FLUSH_CACHE_ON_GC = true;
    static final boolean VERIFY_ASSERTIONS = false;
    static final boolean DO_BDD_VALIDATE = false;
    static final boolean PRE_INIT_OP_CACHES = false;
    static final boolean SWAPCOUNT = false;
    boolean ZDD = false;
    static final int REF_MASK = -4194304;
    static final int MARK_MASK = 0x200000;
    static final int LEV_MASK = 0x1FFFFF;
    static final int MAXVAR = 0x1FFFFF;
    static final int INVALID_BDD = -1;
    static final int REF_INC = 0x400000;
    static final int offset__refcou_and_level = 0;
    static final int offset__low = 1;
    static final int offset__high = 2;
    static final int offset__hash = 3;
    static final int offset__next = 4;
    static final int __node_size = 5;
    static final int bddtrue = 1;
    static final int bddfalse = 0;
    static final int BDDONE = 1;
    static final int BDDZERO = 0;
    boolean bddrunning;
    int bdderrorcond;
    int bddnodesize;
    int bddmaxnodesize;
    int bddmaxnodeincrease;
    int[] bddnodes;
    int bddfreepos;
    int bddfreenum;
    int bddproduced;
    int bddvarnum;
    int[] bddrefstack;
    int bddrefstacktop;
    int[] bddvar2level;
    int[] bddlevel2var;
    boolean bddresized;
    int minfreenodes = 20;
    int[] bddvarset;
    int univ = 1;
    int gbcollectnum;
    int cachesize;
    long gbcclock;
    int usednodes_nextreorder;
    static final int BDD_MEMORY = -1;
    static final int BDD_VAR = -2;
    static final int BDD_RANGE = -3;
    static final int BDD_DEREF = -4;
    static final int BDD_RUNNING = -5;
    static final int BDD_FILE = -6;
    static final int BDD_FORMAT = -7;
    static final int BDD_ORDER = -8;
    static final int BDD_BREAK = -9;
    static final int BDD_VARNUM = -10;
    static final int BDD_NODES = -11;
    static final int BDD_OP = -12;
    static final int BDD_VARSET = -13;
    static final int BDD_VARBLK = -14;
    static final int BDD_DECVNUM = -15;
    static final int BDD_REPLACE = -16;
    static final int BDD_NODENUM = -17;
    static final int BDD_ILLBDD = -18;
    static final int BDD_SIZE = -19;
    static final int BVEC_SIZE = -20;
    static final int BVEC_SHIFT = -21;
    static final int BVEC_DIVZERO = -22;
    static final int BDD_ERRNUM = 24;
    static String[] errorstrings = new String[]{"", "Out of memory", "Unknown variable", "Value out of range", "Unknown BDD root dereferenced", "bdd_init() called twice", "File operation failed", "Incorrect file format", "Variables not in ascending order", "User called break", "Mismatch in size of variable sets", "Cannot allocate fewer nodes than already in use", "Unknown operator", "Illegal variable set", "Bad variable block operation", "Trying to decrease the number of variables", "Trying to replace with variables already in the bdd", "Number of nodes reached user defined maximum", "Unknown BDD - was not in node table", "Bad size argument", "Mismatch in bitvector size", "Illegal shift-left/right parameter", "Division by zero"};
    static final int DEFAULTMAXNODEINC = 10000000;
    static final double M_LN2 = 0.6931471805599453;
    static final int bddop_and = 0;
    static final int bddop_xor = 1;
    static final int bddop_or = 2;
    static final int bddop_nand = 3;
    static final int bddop_nor = 4;
    static final int bddop_imp = 5;
    static final int bddop_biimp = 6;
    static final int bddop_diff = 7;
    static final int bddop_less = 8;
    static final int bddop_invimp = 9;
    static final int bddop_not = 10;
    static final int bddop_simplify = 11;
    static final int bddop_ite = 12;
    static final int bddop_relnext = 13;
    static final int bddop_relprev = 14;
    static final int bddop_relnextIntersection = 15;
    static final int bddop_relprevIntersection = 16;
    static final int bddop_relnextUnion = 17;
    static final int bddop_relprevUnion = 18;
    static final int bddop_saturationForward = 19;
    static final int bddop_boundedSaturationForward = 20;
    static final int bddop_saturationBackward = 21;
    static final int bddop_boundedSaturationBackward = 22;
    static final int INT_MAX = Integer.MAX_VALUE;
    int supportSize = 0;
    private static final int MAX_SAFE_NODE_SIZE = 0x19999997;
    static final int CACHEID_CONSTRAIN = 0;
    static final int CACHEID_RESTRICT = 1;
    static final int CACHEID_SATCOU = 2;
    static final int CACHEID_SATCOULN = 3;
    static final int CACHEID_PATHCOU = 4;
    static final int CACHEID_REPLACE = 0;
    static final int CACHEID_COMPOSE = 1;
    static final int CACHEID_VECCOMPOSE = 2;
    static final int CACHEID_EXIST = 0;
    static final int CACHEID_FORALL = 1;
    static final int CACHEID_UNIQUE = 2;
    static final int CACHEID_APPEX = 3;
    static final int CACHEID_APPAL = 4;
    static final int CACHEID_APPUN = 5;
    static final int OPERATOR_NUM = 11;
    static int[][] oprres = new int[][]{{0, 0, 0, 1}, {0, 1, 1, 0}, {0, 1, 1, 1}, {1, 1, 1, 0}, {1, 0, 0, 0}, {1, 1, 0, 1}, {1, 0, 0, 1}, {0, 0, 1, 0}, {0, 1, 0, 0}, {1, 0, 1, 1}, {1, 1, 0, 0}};
    int applyop;
    int appexop;
    int appexid;
    int quantid;
    int[] quantvarset;
    int quantvarsetID;
    int quantlast;
    int replaceid;
    int[] replacepair;
    int replacelast;
    int composelevel;
    int miscid;
    int supportID;
    int supportMin;
    int supportMax;
    int[] supportSet;
    BddCache applycache;
    BddCache itecache;
    BddCache quantcache;
    BddCache appexcache;
    BddCache replacecache;
    BddCache misccache;
    BddCache countcache;
    double cacheratio;
    boolean satPolarity;
    bddPair pairs;
    int pairsid;
    double increasefactor;
    int bddreordermethod;
    int bddreordertimes;
    int reorderdisabled;
    BddTree vartree;
    int blockid;
    int[] extroots;
    int extrootsize;
    levelData[] levels;
    imatrix iactmtx;
    int verbose;
    int usednum_before;
    int usednum_after;
    static final int BDD_REORDER_NONE = 0;
    static final int BDD_REORDER_WIN2 = 1;
    static final int BDD_REORDER_WIN2ITE = 2;
    static final int BDD_REORDER_SIFT = 3;
    static final int BDD_REORDER_SIFTITE = 4;
    static final int BDD_REORDER_WIN3 = 5;
    static final int BDD_REORDER_WIN3ITE = 6;
    static final int BDD_REORDER_RANDOM = 7;
    static final int BDD_REORDER_FREE = 0;
    static final int BDD_REORDER_FIXED = 1;
    boolean resizedInMakenode;
    int lh_nodenum;
    int lh_freepos;
    int[] loadvar2level;
    LoadHash[] lh_table;
    Random rng = new Random();
    static final int CHECKTIMES = 20;

    private JFactory() {
    }

    public static BDDFactory init(int nodenum, int cachesize) {
        JFactory f = new JFactory();
        ((BDDFactory)f).initialize(nodenum, cachesize);
        return f;
    }

    @Override
    public BDDPairing makePair() {
        bddPair p = new bddPair();
        p.result = new int[this.bddvarnum];
        for (int n = 0; n < this.bddvarnum; ++n) {
            p.result[n] = this.ZDD ? this.bdd_addref(this.zdd_makenode(n, 0, 1)) : this.bdd_ithvar(this.bddlevel2var[n]);
        }
        p.id = this.update_pairsid();
        p.last = -1;
        this.bdd_register_pair(p);
        return p;
    }

    @Override
    protected void addref_impl(int v) {
        this.bdd_addref(v);
    }

    @Override
    protected void delref_impl(int v) {
        this.bdd_delref(v);
    }

    @Override
    protected int zero_impl() {
        return 0;
    }

    @Override
    protected int one_impl() {
        return 1;
    }

    @Override
    protected int universe_impl() {
        return this.univ;
    }

    @Override
    protected int invalid_bdd_impl() {
        return -1;
    }

    @Override
    protected int var_impl(int v) {
        return this.bdd_var(v);
    }

    @Override
    protected int level_impl(int v) {
        return this.LEVEL(v);
    }

    @Override
    protected int low_impl(int v) {
        return this.bdd_low(v);
    }

    @Override
    protected int high_impl(int v) {
        return this.bdd_high(v);
    }

    @Override
    protected int ithVar_impl(int var) {
        return this.bdd_ithvar(var);
    }

    @Override
    protected int nithVar_impl(int var) {
        return this.bdd_nithvar(var);
    }

    @Override
    protected int makenode_impl(int lev, int lo, int hi) {
        if (this.ZDD) {
            return this.zdd_makenode(lev, lo, hi);
        }
        return this.bdd_makenode(lev, lo, hi);
    }

    @Override
    protected int ite_impl(int v1, int v2, int v3) {
        return this.bdd_ite(v1, v2, v3);
    }

    @Override
    protected int apply_impl(int v1, int v2, BDDFactory.BDDOp opr) {
        return this.bdd_apply(v1, v2, opr.id);
    }

    @Override
    protected int not_impl(int v1) {
        return this.bdd_not(v1);
    }

    @Override
    protected int applyAll_impl(int v1, int v2, BDDFactory.BDDOp opr, int v3) {
        return this.bdd_appall(v1, v2, opr.id, v3);
    }

    @Override
    protected int applyEx_impl(int v1, int v2, BDDFactory.BDDOp opr, int v3) {
        return this.bdd_appex(v1, v2, opr.id, v3);
    }

    @Override
    protected int applyUni_impl(int v1, int v2, BDDFactory.BDDOp opr, int v3) {
        return this.bdd_appuni(v1, v2, opr.id, v3);
    }

    @Override
    protected int compose_impl(int v1, int v2, int var) {
        return this.bdd_compose(v1, v2, var);
    }

    @Override
    protected int constrain_impl(int v1, int v2) {
        return this.bdd_constrain(v1, v2);
    }

    @Override
    protected int restrict_impl(int v1, int v2) {
        return this.bdd_restrict(v1, v2);
    }

    @Override
    protected int simplify_impl(int v1, int v2) {
        return this.bdd_simplify(v1, v2);
    }

    @Override
    protected int support_impl(int v) {
        return this.bdd_support(v);
    }

    @Override
    protected int exist_impl(int v1, int v2) {
        return this.bdd_exist(v1, v2);
    }

    @Override
    protected int forAll_impl(int v1, int v2) {
        return this.bdd_forall(v1, v2);
    }

    @Override
    protected int unique_impl(int v1, int v2) {
        return this.bdd_unique(v1, v2);
    }

    @Override
    protected int fullSatOne_impl(int v) {
        return this.bdd_fullsatone(v);
    }

    @Override
    protected int replace_impl(int v, BDDPairing p) {
        return this.bdd_replace(v, (bddPair)p);
    }

    @Override
    protected int veccompose_impl(int v, BDDPairing p) {
        return this.bdd_veccompose(v, (bddPair)p);
    }

    @Override
    protected int nodeCount_impl(int v) {
        return this.bdd_nodecount(v);
    }

    @Override
    protected double pathCount_impl(int v) {
        return this.bdd_pathcount(v);
    }

    @Override
    protected double satCount_impl(int v) {
        return this.bdd_satcount(v);
    }

    @Override
    protected int satOne_impl(int v) {
        return this.bdd_satone(v);
    }

    @Override
    protected int satOne_impl2(int v1, int v2, boolean pol) {
        return this.bdd_satoneset(v1, v2, pol);
    }

    @Override
    protected int nodeCount_impl2(int[] v) {
        return this.bdd_anodecount(v);
    }

    @Override
    protected int[] varProfile_impl(int v) {
        return this.bdd_varprofile(v);
    }

    @Override
    protected void printTable_impl(int v) {
        this.bdd_fprinttable(System.out, v);
    }

    @Override
    protected int relnext_impl(int states, int relation, int vars) {
        return this.bdd_relnext(states, relation, vars);
    }

    @Override
    protected int relnextUnion_impl(int states, int relation, int union, int vars) {
        return this.bdd_relnextUnion(states, relation, union, vars);
    }

    @Override
    protected int relnextIntersection_impl(int states, int relation, int restriction, int vars) {
        return this.bdd_relnextIntersection(states, relation, restriction, vars);
    }

    @Override
    protected int relprev_impl(int relation, int states, int vars) {
        return this.bdd_relprev(relation, states, vars);
    }

    @Override
    protected int relprevUnion_impl(int relation, int states, int union, int vars) {
        return this.bdd_relprevUnion(relation, states, union, vars);
    }

    @Override
    protected int relprevIntersection_impl(int relation, int states, int restriction, int vars) {
        return this.bdd_relprevIntersection(relation, states, restriction, vars);
    }

    @Override
    protected int saturationForward_impl(int states, int[] relations, int[] vars, int instance) {
        return this.bdd_saturationForward(states, relations, vars, instance);
    }

    @Override
    protected int boundedSaturationForward_impl(int states, int bound, int[] relations, int[] vars, int instance) {
        return this.bdd_boundedSaturationForward(states, bound, relations, vars, instance);
    }

    @Override
    protected int saturationBackward_impl(int states, int[] relations, int[] vars, int instance) {
        return this.bdd_saturationBackward(states, relations, vars, instance);
    }

    @Override
    protected int boundedSaturationBackward_impl(int states, int bound, int[] relations, int[] vars, int instance) {
        return this.bdd_boundedSaturationBackward(states, bound, relations, vars, instance);
    }

    @Override
    protected void initialize(int initnodesize, int cs) {
        this.bdd_init(initnodesize, cs);
    }

    @Override
    public void addVarBlock(int first, int last, boolean fixed) {
        this.bdd_intaddvarblock(first, last, fixed);
    }

    @Override
    public void varBlockAll() {
        this.bdd_varblockall();
    }

    @Override
    public void clearVarBlocks() {
        this.bdd_clrvarblocks();
    }

    @Override
    public void printOrder() {
        this.bdd_fprintorder(System.out);
    }

    @Override
    public int getNodeTableSize() {
        return this.bdd_getallocnum();
    }

    @Override
    public int setNodeTableSize(int size) {
        return this.bdd_setallocnum(size);
    }

    @Override
    public int setCacheSize(int v) {
        return this.bdd_setcachesize(v);
    }

    @Override
    public boolean isZDD() {
        return this.ZDD;
    }

    @Override
    public boolean isInitialized() {
        return this.bddrunning;
    }

    @Override
    public void setError(int code) {
        this.bdderrorcond = code;
    }

    @Override
    public void clearError() {
        this.bdderrorcond = 0;
    }

    @Override
    public int setMaxNodeNum(int size) {
        return this.bdd_setmaxnodenum(size);
    }

    @Override
    public double setMinFreeNodes(double x) {
        return (double)this.bdd_setminfreenodes((int)(x * 100.0)) / 100.0;
    }

    @Override
    public int setMaxIncrease(int x) {
        return this.bdd_setmaxincrease(x);
    }

    @Override
    public double setIncreaseFactor(double x) {
        return this.bdd_setincreasefactor(x);
    }

    @Override
    public int getNodeNum() {
        return this.bdd_getnodenum();
    }

    @Override
    public int getCacheSize() {
        return this.cachesize;
    }

    @Override
    public int reorderGain() {
        return this.bdd_reorder_gain();
    }

    @Override
    public void printStat() {
        this.bdd_fprintstat(System.out);
    }

    @Override
    public double setCacheRatio(double x) {
        return this.bdd_setcacheratio(x);
    }

    @Override
    public int varNum() {
        return this.bdd_varnum();
    }

    @Override
    public int setVarNum(int num) {
        return this.bdd_setvarnum(num);
    }

    @Override
    public void printAll() {
        this.bdd_fprintall(System.out);
    }

    @Override
    public BDD load(BufferedReader in, int[] translate) throws IOException {
        return this.makeBDD(this.bdd_load(in, translate));
    }

    @Override
    public void save(BufferedWriter out, BDD b) throws IOException {
        this.bdd_save(out, JFactory.unwrap(b));
    }

    @Override
    public void setVarOrder(int[] neworder) {
        this.bdd_setvarorder(neworder);
    }

    @Override
    public int level2Var(int level) {
        return this.bddlevel2var[level];
    }

    @Override
    public int var2Level(int var) {
        return this.bddvar2level[var];
    }

    @Override
    public int getReorderTimes() {
        return this.bddreordertimes;
    }

    @Override
    public void disableReorder() {
        this.bdd_disable_reorder();
    }

    @Override
    public void enableReorder() {
        this.bdd_enable_reorder();
    }

    @Override
    public int reorderVerbose(int v) {
        return this.bdd_reorder_verbose(v);
    }

    @Override
    public void reorder(BDDFactory.ReorderMethod m) {
        if (this.varNum() > 1) {
            this.bdd_reorder(m.id);
        }
    }

    @Override
    public void autoReorder(BDDFactory.ReorderMethod method) {
        this.bdd_autoreorder(method.id);
    }

    @Override
    public void autoReorder(BDDFactory.ReorderMethod method, int max) {
        this.bdd_autoreorder_times(method.id, max);
    }

    @Override
    public void swapVar(int v1, int v2) {
        this.bdd_swapvar(v1, v2);
    }

    @Override
    public BDDFactory.ReorderMethod getReorderMethod() {
        switch (this.bddreordermethod) {
            case 0: {
                return REORDER_NONE;
            }
            case 1: {
                return REORDER_WIN2;
            }
            case 2: {
                return REORDER_WIN2ITE;
            }
            case 5: {
                return REORDER_WIN3;
            }
            case 6: {
                return REORDER_WIN3ITE;
            }
            case 3: {
                return REORDER_SIFT;
            }
            case 4: {
                return REORDER_SIFTITE;
            }
            case 7: {
                return REORDER_RANDOM;
            }
        }
        throw new BDDException();
    }

    public void validateAll() {
        this.bdd_validate_all();
    }

    public void validateBDD(BDD b) {
        this.bdd_validate(JFactory.unwrap(b));
    }

    public JFactory cloneFactory() {
        JFactory INSTANCE = new JFactory();
        if (this.applycache != null) {
            INSTANCE.applycache = this.applycache.copy();
        }
        if (this.itecache != null) {
            INSTANCE.itecache = this.itecache.copy();
        }
        if (this.quantcache != null) {
            INSTANCE.quantcache = this.quantcache.copy();
        }
        INSTANCE.appexcache = this.appexcache.copy();
        if (this.replacecache != null) {
            INSTANCE.replacecache = this.replacecache.copy();
        }
        if (this.misccache != null) {
            INSTANCE.misccache = this.misccache.copy();
        }
        if (this.countcache != null) {
            INSTANCE.countcache = this.countcache.copy();
        }
        INSTANCE.rng = new Random();
        INSTANCE.verbose = this.verbose;
        INSTANCE.cachestats.copyFrom(this.cachestats);
        INSTANCE.maxusedbddnodesstats.copyFrom(this.maxusedbddnodesstats);
        INSTANCE.maxmemorystats.copyFrom(this.maxmemorystats);
        INSTANCE.bddrunning = this.bddrunning;
        INSTANCE.bdderrorcond = this.bdderrorcond;
        INSTANCE.bddnodesize = this.bddnodesize;
        INSTANCE.bddmaxnodesize = this.bddmaxnodesize;
        INSTANCE.bddmaxnodeincrease = this.bddmaxnodeincrease;
        INSTANCE.bddfreepos = this.bddfreepos;
        INSTANCE.bddfreenum = this.bddfreenum;
        INSTANCE.bddproduced = this.bddproduced;
        INSTANCE.bddvarnum = this.bddvarnum;
        INSTANCE.gbcollectnum = this.gbcollectnum;
        INSTANCE.cachesize = this.cachesize;
        INSTANCE.gbcclock = this.gbcclock;
        INSTANCE.usednodes_nextreorder = this.usednodes_nextreorder;
        INSTANCE.bddrefstacktop = this.bddrefstacktop;
        INSTANCE.bddresized = this.bddresized;
        INSTANCE.minfreenodes = this.minfreenodes;
        INSTANCE.bddnodes = new int[this.bddnodes.length];
        System.arraycopy(this.bddnodes, 0, INSTANCE.bddnodes, 0, this.bddnodes.length);
        INSTANCE.bddrefstack = new int[this.bddrefstack.length];
        System.arraycopy(this.bddrefstack, 0, INSTANCE.bddrefstack, 0, this.bddrefstack.length);
        INSTANCE.bddvar2level = new int[this.bddvar2level.length];
        System.arraycopy(this.bddvar2level, 0, INSTANCE.bddvar2level, 0, this.bddvar2level.length);
        INSTANCE.bddlevel2var = new int[this.bddlevel2var.length];
        System.arraycopy(this.bddlevel2var, 0, INSTANCE.bddlevel2var, 0, this.bddlevel2var.length);
        INSTANCE.bddvarset = new int[this.bddvarset.length];
        System.arraycopy(this.bddvarset, 0, INSTANCE.bddvarset, 0, this.bddvarset.length);
        INSTANCE.domain = new BDDDomain[this.domain.length];
        for (int i = 0; i < INSTANCE.domain.length; ++i) {
            INSTANCE.domain[i] = INSTANCE.createDomain(i, this.domain[i].realsize);
        }
        return INSTANCE;
    }

    public BDD copyNode(BDD that) {
        return this.makeBDD(JFactory.unwrap(that));
    }

    public void reverseAllDomains() {
        this.reorder_init();
        for (int i = 0; i < this.fdvarnum; ++i) {
            this.reverseDomain0(this.domain[i]);
        }
        this.reorder_done();
    }

    public void reverseDomain(BDDDomain d) {
        this.reorder_init();
        this.reverseDomain0(d);
        this.reorder_done();
    }

    protected void reverseDomain0(BDDDomain d) {
        int i;
        int n = d.varNum();
        BddTree[] trees = new BddTree[n];
        int v = d.ivar[0];
        this.addVarBlock(v, v, true);
        trees[0] = this.getBlock(this.vartree, v, v);
        BddTree parent = this.getParent(trees[0]);
        for (i = 1; i < n; ++i) {
            v = d.ivar[i];
            this.addVarBlock(v, v, true);
            trees[i] = this.getBlock(this.vartree, v, v);
            BddTree parent2 = this.getParent(trees[i]);
            if (parent == parent2) continue;
            throw new BDDException();
        }
        for (i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                this.blockdown(trees[i]);
            }
        }
        BddTree newchild = trees[n - 1];
        while (newchild.prev != null) {
            newchild = newchild.prev;
        }
        if (parent == null) {
            this.vartree = newchild;
        } else {
            parent.nextlevel = newchild;
        }
    }

    public void setVarOrder(String ordering) {
        BDDDomain d;
        LinkedList<BDDDomain> last;
        boolean[] done;
        LinkedList<Object> result;
        block9: {
            String s;
            result = new LinkedList<Object>();
            int nDomains = this.numberOfDomains();
            StringTokenizer st = new StringTokenizer(ordering, "x_", true);
            done = new boolean[nDomains];
            last = null;
            while (true) {
                s = st.nextToken();
                int j = 0;
                while (true) {
                    if (j == nDomains) {
                        throw new BDDException("bad domain: " + s);
                    }
                    d = this.getDomain(j);
                    if (s.equals(d.getName())) break;
                    ++j;
                }
                if (done[d.getIndex()]) {
                    throw new BDDException("duplicate domain: " + s);
                }
                done[d.getIndex()] = true;
                if (last != null) {
                    last.add(d);
                }
                if (!st.hasMoreTokens()) break block9;
                s = st.nextToken();
                if (s.equals("x")) {
                    if (last != null) continue;
                    last = new LinkedList<BDDDomain>();
                    last.add(d);
                    result.add(last);
                    continue;
                }
                if (!s.equals("_")) break;
                if (last == null) {
                    result.add(d);
                }
                last = null;
            }
            throw new BDDException("bad token: " + s);
        }
        if (last == null) {
            result.add(d);
        }
        for (int i = 0; i < done.length; ++i) {
            if (done[i]) continue;
            throw new BDDException("missing domain #" + i + ": " + this.getDomain(i));
        }
        this.setVarOrder(result);
    }

    public void setVarOrder(List<Object> domains) {
        BddTree[] my_vartree = new BddTree[this.fdvarnum];
        boolean[] interleaved = new boolean[this.fdvarnum];
        int k = 0;
        for (Object o : domains) {
            Set<BDDDomain> c = o instanceof BDDDomain ? Collections.singleton((BDDDomain)o) : (Set<BDDDomain>)o;
            Iterator j = c.iterator();
            while (j.hasNext()) {
                BddTree b;
                BDDDomain d = (BDDDomain)j.next();
                int low = d.ivar[0];
                int high = d.ivar[d.ivar.length - 1];
                this.bdd_intaddvarblock(low, high, false);
                my_vartree[k] = b = this.getBlock(this.vartree, low, high);
                interleaved[k] = j.hasNext();
                ++k;
            }
        }
        if (k <= 1) {
            return;
        }
        BddTree parent = this.getParent(my_vartree[0]);
        for (int i = 0; i < k; ++i) {
            if (parent == this.getParent(my_vartree[i])) continue;
            throw new BDDException("var block " + my_vartree[i].firstVar + ".." + my_vartree[i].lastVar + " is in wrong place in tree");
        }
        this.reorder_init();
        BddTree prev = null;
        boolean prev_interleaved = false;
        for (int i = 0; i < k; ++i) {
            BddTree t = my_vartree[i];
            while (t.prev != prev) {
                this.blockdown(t.prev);
            }
            boolean inter = interleaved[i];
            if (prev_interleaved) {
                this.blockinterleave(t.prev);
                prev = t.prev;
            } else {
                prev = t;
            }
            prev_interleaved = inter;
        }
        BddTree newchild = my_vartree[0];
        if (parent == null) {
            this.vartree = newchild;
        } else {
            parent.nextlevel = newchild;
        }
        this.reorder_done();
    }

    protected BddTree getParent(BddTree child) {
        BddTree p = this.vartree;
        while (p != null) {
            if (p == child) {
                return null;
            }
            BddTree q = this.getParent(p, child);
            if (q != null) {
                return q;
            }
            p = p.next;
        }
        throw new BDDException("Cannot find tree node " + child);
    }

    protected BddTree getParent(BddTree parent, BddTree child) {
        if (parent.nextlevel == null) {
            return null;
        }
        BddTree p = parent.nextlevel;
        while (p != null) {
            if (p == child) {
                return parent;
            }
            BddTree q = this.getParent(p, child);
            if (q != null) {
                return q;
            }
            p = p.next;
        }
        return null;
    }

    protected BddTree getBlock(BddTree t, int low, int high) {
        if (t == null) {
            return null;
        }
        BddTree p = t;
        while (p != null) {
            if (p.firstVar == low && p.lastVar == high) {
                return p;
            }
            BddTree q = this.getBlock(p.nextlevel, low, high);
            if (q != null) {
                return q;
            }
            p = p.next;
        }
        return null;
    }

    private final boolean HASREF(int node) {
        boolean r = (this.bddnodes[node * 5 + 0] & 0xFFC00000) != 0;
        return r;
    }

    private final void SETMAXREF(int node) {
        int n = node * 5 + 0;
        this.bddnodes[n] = this.bddnodes[n] | 0xFFC00000;
    }

    private final void CLEARREF(int node) {
        int n = node * 5 + 0;
        this.bddnodes[n] = this.bddnodes[n] & 0x3FFFFF;
    }

    private final void INCREF(int node) {
        if ((this.bddnodes[node * 5 + 0] & 0xFFC00000) != -4194304) {
            int n = node * 5 + 0;
            this.bddnodes[n] = this.bddnodes[n] + 0x400000;
        }
    }

    private final void DECREF(int node) {
        int rc = this.bddnodes[node * 5 + 0] & 0xFFC00000;
        if (rc != -4194304 && rc != 0) {
            int n = node * 5 + 0;
            this.bddnodes[n] = this.bddnodes[n] - 0x400000;
        }
    }

    private final int GETREF(int node) {
        return this.bddnodes[node * 5 + 0] >>> 22;
    }

    private final int LEVEL(int node) {
        return this.bddnodes[node * 5 + 0] & 0x1FFFFF;
    }

    private final int LEVELANDMARK(int node) {
        return this.bddnodes[node * 5 + 0] & 0x3FFFFF;
    }

    private final void SETLEVELANDMARK(int node, int val) {
        int n = node * 5 + 0;
        this.bddnodes[n] = this.bddnodes[n] & 0xFFC00000;
        int n2 = node * 5 + 0;
        this.bddnodes[n2] = this.bddnodes[n2] | val;
    }

    private final void SETMARK(int n) {
        int n2 = n * 5 + 0;
        this.bddnodes[n2] = this.bddnodes[n2] | 0x200000;
    }

    private final void UNMARK(int n) {
        int n2 = n * 5 + 0;
        this.bddnodes[n2] = this.bddnodes[n2] & 0xFFDFFFFF;
    }

    private final boolean MARKED(int n) {
        return (this.bddnodes[n * 5 + 0] & 0x200000) != 0;
    }

    private final int LOW(int r) {
        return this.bddnodes[r * 5 + 1];
    }

    private final void SETLOW(int r, int v) {
        this.bddnodes[r * 5 + 1] = v;
    }

    private final int HIGH(int r) {
        return this.bddnodes[r * 5 + 2];
    }

    private final void SETHIGH(int r, int v) {
        this.bddnodes[r * 5 + 2] = v;
    }

    private final int HASH(int r) {
        return this.bddnodes[r * 5 + 3];
    }

    private final void SETHASH(int r, int v) {
        this.bddnodes[r * 5 + 3] = v;
    }

    private final int NEXT(int r) {
        return this.bddnodes[r * 5 + 4];
    }

    private final void SETNEXT(int r, int v) {
        this.bddnodes[r * 5 + 4] = v;
    }

    private final int VARr(int n) {
        return this.LEVELANDMARK(n);
    }

    void SETVARr(int n, int val) {
        this.SETLEVELANDMARK(n, val);
    }

    static final void _assert(boolean b) {
        if (!b) {
            throw new InternalError();
        }
    }

    static final int PAIR(int a, int b) {
        return (a + b) * (a + b + 1) / 2 + a;
    }

    static final int TRIPLE(int a, int b, int c) {
        return JFactory.PAIR(c, JFactory.PAIR(a, b));
    }

    static final int QUADRUPLE(int a, int b, int c, int d) {
        return JFactory.PAIR(d, JFactory.TRIPLE(a, b, c));
    }

    static final int QUINTUPLE(int a, int b, int c, int d, int e) {
        return JFactory.PAIR(e, JFactory.QUADRUPLE(a, b, c, d));
    }

    final int NODEHASH(int lvl, int l, int h) {
        return Math.abs(JFactory.TRIPLE(lvl, l, h) % this.bddnodesize);
    }

    int bdd_ithvar(int var) {
        if (var < 0 || var >= this.bddvarnum) {
            JFactory.bdd_error(-2);
            return 0;
        }
        return this.bddvarset[var * 2];
    }

    int bdd_nithvar(int var) {
        if (var < 0 || var >= this.bddvarnum) {
            JFactory.bdd_error(-2);
            return 0;
        }
        return this.bddvarset[var * 2 + 1];
    }

    int bdd_varnum() {
        return this.bddvarnum;
    }

    static int bdd_error(int v) {
        throw new JavaBDDException(v);
    }

    static boolean ISZERO(int r) {
        return r == 0;
    }

    static boolean ISONE(int r) {
        return r == 1;
    }

    static boolean ISCONST(int r) {
        return r < 2;
    }

    void CHECK(int r) {
        if (!this.bddrunning) {
            JFactory.bdd_error(-5);
        } else if (r < 0 || r >= this.bddnodesize) {
            JFactory.bdd_error(-18);
        } else if (r >= 2 && this.LOW(r) == -1) {
            JFactory.bdd_error(-18);
        }
    }

    void CHECKa(int r) {
        this.CHECK(r);
    }

    int bdd_var(int root) {
        this.CHECK(root);
        if (root < 2) {
            JFactory.bdd_error(-18);
        }
        return this.bddlevel2var[this.LEVEL(root)];
    }

    int bdd_low(int root) {
        this.CHECK(root);
        if (root < 2) {
            return JFactory.bdd_error(-18);
        }
        return this.LOW(root);
    }

    int bdd_high(int root) {
        this.CHECK(root);
        if (root < 2) {
            return JFactory.bdd_error(-18);
        }
        return this.HIGH(root);
    }

    void checkresize() {
        if (this.bddresized) {
            this.bdd_operator_noderesize();
        }
        this.bddresized = false;
    }

    static final int NOTHASH(int r) {
        return r;
    }

    static final int APPLYHASH(int l, int r, int op) {
        return JFactory.TRIPLE(l, r, op);
    }

    static final int RESTRHASH(int r, int var) {
        return JFactory.PAIR(r, var);
    }

    static final int CONSTRAINHASH(int f, int c) {
        return JFactory.PAIR(f, c);
    }

    static final int QUANTHASH(int r) {
        return r;
    }

    static final int REPLACEHASH(int r) {
        return r;
    }

    static final int VECCOMPOSEHASH(int f) {
        return f;
    }

    static final int COMPOSEHASH(int f, int g) {
        return JFactory.PAIR(f, g);
    }

    static final int SATCOUHASH(int r) {
        return r;
    }

    static final int PATHCOUHASH(int r) {
        return r;
    }

    static final int APPEXHASH(int l, int r, int op) {
        return JFactory.TRIPLE(l, r, op);
    }

    static double log1p(double a) {
        return Math.log(1.0 + a);
    }

    final boolean INVARSET(int a) {
        return this.quantvarset[a] == this.quantvarsetID;
    }

    final boolean INSVARSET(int a) {
        return Math.abs(this.quantvarset[a]) == this.quantvarsetID;
    }

    int bdd_not(int r) {
        int res;
        int numReorder = 1;
        this.CHECKa(r);
        if (this.applycache == null) {
            this.applycache = this.BddCacheI_init(this.cachesize);
        }
        while (true) {
            try {
                this.INITREF();
                if (numReorder == 0) {
                    this.bdd_disable_reorder();
                }
                res = this.ZDD ? this.zdiff_rec(this.univ, r) : this.not_rec(r);
                if (numReorder != 0) break;
                this.bdd_enable_reorder();
            }
            catch (ReorderException x) {
                this.bdd_checkreorder();
                --numReorder;
                continue;
            }
            break;
        }
        this.checkresize();
        return res;
    }

    int not_rec(int r) {
        if (this.cachestats.enabled) {
            ++this.cachestats.opAccess;
        }
        if (JFactory.ISCONST(r)) {
            return 1 - r;
        }
        BddCacheDataI entry = this.BddCache_lookupI(this.applycache, JFactory.NOTHASH(r));
        if (entry.a == r && entry.c == 10) {
            if (this.cachestats.enabled) {
                ++this.cachestats.opHit;
            }
            return entry.res;
        }
        if (this.cachestats.enabled) {
            ++this.cachestats.opMiss;
        }
        this.PUSHREF(this.not_rec(this.LOW(r)));
        this.PUSHREF(this.not_rec(this.HIGH(r)));
        int res = this.bdd_makenode(this.LEVEL(r), this.READREF(2), this.READREF(1));
        this.POPREF(2);
        entry.a = r;
        entry.c = 10;
        entry.res = res;
        return res;
    }

    int bdd_ite(int f, int g, int h) {
        int res;
        int numReorder = 1;
        this.CHECKa(f);
        this.CHECKa(g);
        this.CHECKa(h);
        if (this.applycache == null) {
            this.applycache = this.BddCacheI_init(this.cachesize);
        }
        if (this.itecache == null) {
            this.itecache = this.BddCacheI_init(this.cachesize);
        }
        while (true) {
            try {
                this.INITREF();
                if (numReorder == 0) {
                    this.bdd_disable_reorder();
                }
                int n = res = this.ZDD ? this.zite_rec(f, g, h) : this.ite_rec(f, g, h);
                if (numReorder != 0) break;
                this.bdd_enable_reorder();
            }
            catch (ReorderException x) {
                this.bdd_checkreorder();
                --numReorder;
                continue;
            }
            break;
        }
        this.checkresize();
        return res;
    }

    int ite_rec(int f, int g, int h) {
        int res;
        if (this.cachestats.enabled) {
            ++this.cachestats.opAccess;
        }
        if (JFactory.ISONE(f)) {
            return g;
        }
        if (JFactory.ISZERO(f)) {
            return h;
        }
        if (g == h) {
            return g;
        }
        if (JFactory.ISONE(g) && JFactory.ISZERO(h)) {
            return f;
        }
        if (JFactory.ISZERO(g) && JFactory.ISONE(h)) {
            return this.not_rec(f);
        }
        BddCacheDataI entry = this.BddCache_lookupI(this.itecache, JFactory.QUADRUPLE(f, g, h, 12));
        if (entry.a == f && entry.b == g && entry.c == h && entry.d == 0 && entry.e == 12) {
            if (this.cachestats.enabled) {
                ++this.cachestats.opHit;
            }
            return entry.res;
        }
        if (this.cachestats.enabled) {
            ++this.cachestats.opMiss;
        }
        if (this.LEVEL(f) == this.LEVEL(g)) {
            if (this.LEVEL(f) == this.LEVEL(h)) {
                this.PUSHREF(this.ite_rec(this.LOW(f), this.LOW(g), this.LOW(h)));
                this.PUSHREF(this.ite_rec(this.HIGH(f), this.HIGH(g), this.HIGH(h)));
                res = this.bdd_makenode(this.LEVEL(f), this.READREF(2), this.READREF(1));
            } else if (this.LEVEL(f) < this.LEVEL(h)) {
                this.PUSHREF(this.ite_rec(this.LOW(f), this.LOW(g), h));
                this.PUSHREF(this.ite_rec(this.HIGH(f), this.HIGH(g), h));
                res = this.bdd_makenode(this.LEVEL(f), this.READREF(2), this.READREF(1));
            } else {
                this.PUSHREF(this.ite_rec(f, g, this.LOW(h)));
                this.PUSHREF(this.ite_rec(f, g, this.HIGH(h)));
                res = this.bdd_makenode(this.LEVEL(h), this.READREF(2), this.READREF(1));
            }
        } else if (this.LEVEL(f) < this.LEVEL(g)) {
            if (this.LEVEL(f) == this.LEVEL(h)) {
                this.PUSHREF(this.ite_rec(this.LOW(f), g, this.LOW(h)));
                this.PUSHREF(this.ite_rec(this.HIGH(f), g, this.HIGH(h)));
                res = this.bdd_makenode(this.LEVEL(f), this.READREF(2), this.READREF(1));
            } else if (this.LEVEL(f) < this.LEVEL(h)) {
                this.PUSHREF(this.ite_rec(this.LOW(f), g, h));
                this.PUSHREF(this.ite_rec(this.HIGH(f), g, h));
                res = this.bdd_makenode(this.LEVEL(f), this.READREF(2), this.READREF(1));
            } else {
                this.PUSHREF(this.ite_rec(f, g, this.LOW(h)));
                this.PUSHREF(this.ite_rec(f, g, this.HIGH(h)));
                res = this.bdd_makenode(this.LEVEL(h), this.READREF(2), this.READREF(1));
            }
        } else if (this.LEVEL(g) == this.LEVEL(h)) {
            this.PUSHREF(this.ite_rec(f, this.LOW(g), this.LOW(h)));
            this.PUSHREF(this.ite_rec(f, this.HIGH(g), this.HIGH(h)));
            res = this.bdd_makenode(this.LEVEL(g), this.READREF(2), this.READREF(1));
        } else if (this.LEVEL(g) < this.LEVEL(h)) {
            this.PUSHREF(this.ite_rec(f, this.LOW(g), h));
            this.PUSHREF(this.ite_rec(f, this.HIGH(g), h));
            res = this.bdd_makenode(this.LEVEL(g), this.READREF(2), this.READREF(1));
        } else {
            this.PUSHREF(this.ite_rec(f, g, this.LOW(h)));
            this.PUSHREF(this.ite_rec(f, g, this.HIGH(h)));
            res = this.bdd_makenode(this.LEVEL(h), this.READREF(2), this.READREF(1));
        }
        this.POPREF(2);
        entry.a = f;
        entry.b = g;
        entry.c = h;
        entry.d = 0;
        entry.e = 12;
        entry.res = res;
        return res;
    }

    int zite_rec(int f, int g, int h) {
        int res;
        if (this.cachestats.enabled) {
            ++this.cachestats.opAccess;
        }
        if (JFactory.ISONE(f)) {
            return g;
        }
        if (JFactory.ISZERO(f)) {
            return h;
        }
        if (g == h) {
            return g;
        }
        if (JFactory.ISONE(g) && JFactory.ISZERO(h)) {
            return f;
        }
        if (JFactory.ISZERO(g) && JFactory.ISONE(h)) {
            return this.zdiff_rec(this.univ, f);
        }
        int v = Math.min(this.LEVEL(g), this.LEVEL(h));
        if (this.LEVEL(f) < v) {
            return this.zite_rec(this.LOW(f), g, h);
        }
        BddCacheDataI entry = this.BddCache_lookupI(this.itecache, JFactory.QUADRUPLE(f, g, h, 12));
        if (entry.a == f && entry.b == g && entry.c == h && entry.d == 0 && entry.e == 12) {
            if (this.cachestats.enabled) {
                ++this.cachestats.opHit;
            }
            return entry.res;
        }
        if (this.cachestats.enabled) {
            ++this.cachestats.opMiss;
        }
        if (this.LEVEL(f) == this.LEVEL(g)) {
            if (this.LEVEL(f) == this.LEVEL(h)) {
                this.PUSHREF(this.zite_rec(this.LOW(f), this.LOW(g), this.LOW(h)));
                this.PUSHREF(this.zite_rec(this.HIGH(f), this.HIGH(g), this.HIGH(h)));
                res = this.zdd_makenode(this.LEVEL(f), this.READREF(2), this.READREF(1));
                this.POPREF(2);
            } else if (this.LEVEL(f) < this.LEVEL(h)) {
                this.PUSHREF(this.zite_rec(this.LOW(f), this.LOW(g), h));
                this.PUSHREF(this.zite_rec(this.HIGH(f), this.HIGH(g), 0));
                res = this.zdd_makenode(this.LEVEL(f), this.READREF(2), this.READREF(1));
                this.POPREF(2);
            } else {
                this.PUSHREF(this.zite_rec(f, g, this.LOW(h)));
                res = this.zdd_makenode(this.LEVEL(h), this.HIGH(h), this.READREF(1));
                this.POPREF(1);
            }
        } else if (this.LEVEL(f) < this.LEVEL(g)) {
            if (this.LEVEL(f) == this.LEVEL(h)) {
                this.PUSHREF(this.zite_rec(this.LOW(f), g, this.LOW(h)));
                this.PUSHREF(this.zite_rec(this.HIGH(f), 0, this.HIGH(h)));
                res = this.zdd_makenode(this.LEVEL(f), this.READREF(2), this.READREF(1));
                this.POPREF(2);
            } else if (this.LEVEL(f) < this.LEVEL(h)) {
                res = this.zite_rec(this.LOW(f), g, h);
            } else {
                this.PUSHREF(this.zite_rec(f, g, this.LOW(h)));
                res = this.zdd_makenode(this.LEVEL(h), this.HIGH(h), this.READREF(1));
                this.POPREF(1);
            }
        } else if (this.LEVEL(g) == this.LEVEL(h)) {
            this.PUSHREF(this.zite_rec(f, this.LOW(g), this.LOW(h)));
            res = this.zdd_makenode(this.LEVEL(g), this.HIGH(h), this.READREF(1));
            this.POPREF(1);
        } else if (this.LEVEL(g) < this.LEVEL(h)) {
            this.PUSHREF(this.zite_rec(f, this.LOW(g), h));
            res = this.zdd_makenode(this.LEVEL(g), 0, this.READREF(1));
            this.POPREF(1);
        } else {
            this.PUSHREF(this.zite_rec(f, g, this.LOW(h)));
            res = this.zdd_makenode(this.LEVEL(h), this.HIGH(h), this.READREF(1));
            this.POPREF(1);
        }
        entry.a = f;
        entry.b = g;
        entry.c = h;
        entry.d = 0;
        entry.e = 12;
        entry.res = res;
        return res;
    }

    int bdd_replace(int r, bddPair pair) {
        int res;
        int numReorder = 1;
        this.CHECKa(r);
        if (this.replacecache == null) {
            this.replacecache = this.BddCacheI_init(this.cachesize);
        }
        if (this.ZDD && this.applycache == null) {
            this.applycache = this.BddCacheI_init(this.cachesize);
        }
        while (true) {
            try {
                this.INITREF();
                this.replacepair = pair.result;
                this.replacelast = pair.last;
                this.replaceid = pair.id << 2 | 0;
                if (this.ZDD) {
                    this.applyop = 2;
                }
                if (numReorder == 0) {
                    this.bdd_disable_reorder();
                }
                res = this.replace_rec(r);
                if (numReorder != 0) break;
                this.bdd_enable_reorder();
            }
            catch (ReorderException x) {
                this.bdd_checkreorder();
                --numReorder;
                continue;
            }
            break;
        }
        this.checkresize();
        return res;
    }

    int replace_rec(int r) {
        if (this.cachestats.enabled) {
            ++this.cachestats.opAccess;
        }
        if (JFactory.ISCONST(r) || this.LEVEL(r) > this.replacelast) {
            return r;
        }
        BddCacheDataI entry = this.BddCache_lookupI(this.replacecache, JFactory.REPLACEHASH(r));
        if (entry.a == r && entry.c == this.replaceid) {
            if (this.cachestats.enabled) {
                ++this.cachestats.opHit;
            }
            return entry.res;
        }
        if (this.cachestats.enabled) {
            ++this.cachestats.opMiss;
        }
        this.PUSHREF(this.replace_rec(this.LOW(r)));
        this.PUSHREF(this.replace_rec(this.HIGH(r)));
        int res = this.ZDD ? this.zdd_correctify(this.LEVEL(this.replacepair[this.LEVEL(r)]), this.READREF(2), this.READREF(1)) : this.bdd_correctify(this.LEVEL(this.replacepair[this.LEVEL(r)]), this.READREF(2), this.READREF(1));
        this.POPREF(2);
        entry.a = r;
        entry.c = this.replaceid;
        entry.res = res;
        return res;
    }

    int bdd_correctify(int level, int l, int r) {
        int res;
        if (level < this.LEVEL(l) && level < this.LEVEL(r)) {
            return this.bdd_makenode(level, l, r);
        }
        if (level == this.LEVEL(l) || level == this.LEVEL(r)) {
            JFactory.bdd_error(-16);
            return 0;
        }
        if (this.LEVEL(l) == this.LEVEL(r)) {
            this.PUSHREF(this.bdd_correctify(level, this.LOW(l), this.LOW(r)));
            this.PUSHREF(this.bdd_correctify(level, this.HIGH(l), this.HIGH(r)));
            res = this.bdd_makenode(this.LEVEL(l), this.READREF(2), this.READREF(1));
        } else if (this.LEVEL(l) < this.LEVEL(r)) {
            this.PUSHREF(this.bdd_correctify(level, this.LOW(l), r));
            this.PUSHREF(this.bdd_correctify(level, this.HIGH(l), r));
            res = this.bdd_makenode(this.LEVEL(l), this.READREF(2), this.READREF(1));
        } else {
            this.PUSHREF(this.bdd_correctify(level, l, this.LOW(r)));
            this.PUSHREF(this.bdd_correctify(level, l, this.HIGH(r)));
            res = this.bdd_makenode(this.LEVEL(r), this.READREF(2), this.READREF(1));
        }
        this.POPREF(2);
        return res;
    }

    int zdd_correctify(int level, int l, int r) {
        this.PUSHREF(this.zdd_makenode(level, 0, 1));
        this.PUSHREF(this.zdd_change(r, this.READREF(1)));
        int res = this.zor_rec(this.READREF(1), l);
        this.POPREF(2);
        return res;
    }

    int zdd_change(int r, int zvar) {
        int res;
        if (JFactory.ISZERO(r)) {
            return r;
        }
        if (JFactory.ISONE(r)) {
            return zvar;
        }
        if (this.LEVEL(r) > this.LEVEL(zvar)) {
            res = this.zdd_makenode(this.LEVEL(zvar), 0, r);
        } else if (this.LEVEL(r) == this.LEVEL(zvar)) {
            res = this.zdd_makenode(this.LEVEL(zvar), this.HIGH(r), this.LOW(r));
        } else {
            this.PUSHREF(this.zdd_change(this.LOW(r), zvar));
            this.PUSHREF(this.zdd_change(this.HIGH(r), zvar));
            res = this.zdd_makenode(this.LEVEL(r), this.READREF(2), this.READREF(1));
            this.POPREF(2);
        }
        return res;
    }

    int bdd_apply(int l, int r, int op) {
        int res;
        int numReorder = 1;
        this.CHECKa(l);
        this.CHECKa(r);
        if (op < 0 || op > 9) {
            JFactory.bdd_error(-12);
            return 0;
        }
        if (this.applycache == null) {
            this.applycache = this.BddCacheI_init(this.cachesize);
        }
        while (true) {
            try {
                block23: {
                    block22: {
                        this.INITREF();
                        this.applyop = op;
                        if (numReorder == 0) {
                            this.bdd_disable_reorder();
                        }
                        if (!this.ZDD) break block22;
                        switch (op) {
                            case 0: {
                                res = this.zand_rec(l, r);
                                break block23;
                            }
                            case 2: {
                                res = this.zor_rec(l, r);
                                break block23;
                            }
                            case 7: {
                                res = this.zdiff_rec(l, r);
                                break block23;
                            }
                            case 5: {
                                int a = this.bdd_addref(this.zdiff_rec(l, r));
                                res = this.zdiff_rec(this.univ, a);
                                this.bdd_delref(a);
                                break block23;
                            }
                            case 9: {
                                int a = this.bdd_addref(this.zdiff_rec(r, l));
                                res = this.zdiff_rec(this.univ, a);
                                this.bdd_delref(a);
                                break block23;
                            }
                            case 8: {
                                res = this.zdiff_rec(r, l);
                                break block23;
                            }
                            case 3: {
                                int k = this.bdd_addref(this.zand_rec(l, r));
                                res = this.zdiff_rec(this.univ, k);
                                this.bdd_delref(k);
                                break block23;
                            }
                            case 4: {
                                int k = this.bdd_addref(this.zor_rec(l, r));
                                res = this.zdiff_rec(this.univ, k);
                                this.bdd_delref(k);
                                break block23;
                            }
                            case 1: {
                                int a = this.bdd_addref(this.zand_rec(l, r));
                                int b = this.bdd_addref(this.zor_rec(l, r));
                                res = this.zdiff_rec(b, a);
                                this.bdd_delref(a);
                                this.bdd_delref(b);
                                break block23;
                            }
                            case 6: {
                                int a = this.bdd_addref(this.zand_rec(l, r));
                                int b = this.bdd_addref(this.zor_rec(l, r));
                                int c = this.bdd_addref(this.zdiff_rec(b, a));
                                this.bdd_delref(a);
                                this.bdd_delref(b);
                                res = this.zdiff_rec(this.univ, c);
                                this.bdd_delref(c);
                                break block23;
                            }
                            default: {
                                throw new BDDException();
                            }
                        }
                    }
                    switch (op) {
                        case 0: {
                            res = this.and_rec(l, r);
                            break;
                        }
                        case 2: {
                            res = this.or_rec(l, r);
                            break;
                        }
                        default: {
                            res = this.apply_rec(l, r);
                        }
                    }
                }
                if (numReorder != 0) break;
                this.bdd_enable_reorder();
            }
            catch (ReorderException x) {
                this.bdd_checkreorder();
                --numReorder;
                continue;
            }
            break;
        }
        this.checkresize();
        return res;
    }

    int apply_rec(int l, int r) {
        int res;
        if (this.cachestats.enabled) {
            ++this.cachestats.opAccess;
        }
        switch (this.applyop) {
            case 1: {
                if (l == r) {
                    return 0;
                }
                if (JFactory.ISZERO(l)) {
                    return r;
                }
                if (!JFactory.ISZERO(r)) break;
                return l;
            }
            case 3: {
                if (!JFactory.ISZERO(l) && !JFactory.ISZERO(r)) break;
                return 1;
            }
            case 4: {
                if (!JFactory.ISONE(l) && !JFactory.ISONE(r)) break;
                return 0;
            }
            case 5: {
                if (JFactory.ISZERO(l)) {
                    return 1;
                }
                if (JFactory.ISONE(l)) {
                    return r;
                }
                if (!JFactory.ISONE(r)) break;
                return 1;
            }
        }
        if (JFactory.ISCONST(l) && JFactory.ISCONST(r)) {
            res = oprres[this.applyop][l << 1 | r];
        } else {
            BddCacheDataI entry = this.BddCache_lookupI(this.applycache, JFactory.APPLYHASH(l, r, this.applyop));
            if (entry.a == l && entry.b == r && entry.c == this.applyop) {
                if (this.cachestats.enabled) {
                    ++this.cachestats.opHit;
                }
                return entry.res;
            }
            if (this.cachestats.enabled) {
                ++this.cachestats.opMiss;
            }
            if (this.LEVEL(l) == this.LEVEL(r)) {
                this.PUSHREF(this.apply_rec(this.LOW(l), this.LOW(r)));
                this.PUSHREF(this.apply_rec(this.HIGH(l), this.HIGH(r)));
                res = this.bdd_makenode(this.LEVEL(l), this.READREF(2), this.READREF(1));
            } else if (this.LEVEL(l) < this.LEVEL(r)) {
                this.PUSHREF(this.apply_rec(this.LOW(l), r));
                this.PUSHREF(this.apply_rec(this.HIGH(l), r));
                res = this.bdd_makenode(this.LEVEL(l), this.READREF(2), this.READREF(1));
            } else {
                this.PUSHREF(this.apply_rec(l, this.LOW(r)));
                this.PUSHREF(this.apply_rec(l, this.HIGH(r)));
                res = this.bdd_makenode(this.LEVEL(r), this.READREF(2), this.READREF(1));
            }
            this.POPREF(2);
            entry.a = l;
            entry.b = r;
            entry.c = this.applyop;
            entry.res = res;
        }
        return res;
    }

    int and_rec(int l, int r) {
        int res;
        if (this.cachestats.enabled) {
            ++this.cachestats.opAccess;
        }
        if (l == r) {
            return l;
        }
        if (JFactory.ISZERO(l) || JFactory.ISZERO(r)) {
            return 0;
        }
        if (JFactory.ISONE(l)) {
            return r;
        }
        if (JFactory.ISONE(r)) {
            return l;
        }
        BddCacheDataI entry = this.BddCache_lookupI(this.applycache, JFactory.APPLYHASH(l, r, 0));
        if (entry.a == l && entry.b == r && entry.c == 0) {
            if (this.cachestats.enabled) {
                ++this.cachestats.opHit;
            }
            return entry.res;
        }
        if (this.cachestats.enabled) {
            ++this.cachestats.opMiss;
        }
        if (this.LEVEL(l) == this.LEVEL(r)) {
            this.PUSHREF(this.and_rec(this.LOW(l), this.LOW(r)));
            this.PUSHREF(this.and_rec(this.HIGH(l), this.HIGH(r)));
            res = this.bdd_makenode(this.LEVEL(l), this.READREF(2), this.READREF(1));
        } else if (this.LEVEL(l) < this.LEVEL(r)) {
            this.PUSHREF(this.and_rec(this.LOW(l), r));
            this.PUSHREF(this.and_rec(this.HIGH(l), r));
            res = this.bdd_makenode(this.LEVEL(l), this.READREF(2), this.READREF(1));
        } else {
            this.PUSHREF(this.and_rec(l, this.LOW(r)));
            this.PUSHREF(this.and_rec(l, this.HIGH(r)));
            res = this.bdd_makenode(this.LEVEL(r), this.READREF(2), this.READREF(1));
        }
        this.POPREF(2);
        entry.a = l;
        entry.b = r;
        entry.c = 0;
        entry.res = res;
        return res;
    }

    int zand_rec(int l, int r) {
        if (this.cachestats.enabled) {
            ++this.cachestats.opAccess;
        }
        if (l == r) {
            return l;
        }
        if (JFactory.ISZERO(l) || JFactory.ISZERO(r)) {
            return 0;
        }
        if (this.LEVEL(l) < this.LEVEL(r)) {
            return this.zand_rec(this.LOW(l), r);
        }
        if (this.LEVEL(l) > this.LEVEL(r)) {
            return this.zand_rec(l, this.LOW(r));
        }
        BddCacheDataI entry = this.BddCache_lookupI(this.applycache, JFactory.APPLYHASH(l, r, 0));
        if (entry.a == l && entry.b == r && entry.c == 0) {
            if (this.cachestats.enabled) {
                ++this.cachestats.opHit;
            }
            return entry.res;
        }
        if (this.cachestats.enabled) {
            ++this.cachestats.opMiss;
        }
        this.PUSHREF(this.zand_rec(this.LOW(l), this.LOW(r)));
        this.PUSHREF(this.zand_rec(this.HIGH(l), this.HIGH(r)));
        int res = this.zdd_makenode(this.LEVEL(l), this.READREF(2), this.READREF(1));
        this.POPREF(2);
        entry.a = l;
        entry.b = r;
        entry.c = 0;
        entry.res = res;
        return res;
    }

    int zrelprod_rec(int l, int r, int lev) {
        int res;
        if (this.cachestats.enabled) {
            ++this.cachestats.opAccess;
        }
        if (l == r) {
            return this.zquant_rec(l, lev);
        }
        if (JFactory.ISZERO(l) || JFactory.ISZERO(r)) {
            return 0;
        }
        int LEVEL_l = this.LEVEL(l);
        int LEVEL_r = this.LEVEL(r);
        while (true) {
            if (lev > this.quantlast) {
                this.applyop = 0;
                int res2 = this.zand_rec(l, r);
                this.applyop = 2;
                return res2;
            }
            if (lev >= LEVEL_l || lev >= LEVEL_r) break;
            if (this.INVARSET(lev)) {
                int res3 = this.zrelprod_rec(l, r, lev + 1);
                this.PUSHREF(res3);
                res3 = this.zdd_makenode(lev, res3, res3);
                this.POPREF(1);
                return res3;
            }
            ++lev;
        }
        BddCacheDataI entry = this.BddCache_lookupI(this.appexcache, JFactory.APPEXHASH(l, r, 0));
        if (entry.a == l && entry.b == r && entry.c == this.appexid) {
            if (this.cachestats.enabled) {
                ++this.cachestats.opHit;
            }
            return entry.res;
        }
        if (this.cachestats.enabled) {
            ++this.cachestats.opMiss;
        }
        if (LEVEL_l == LEVEL_r) {
            this.PUSHREF(this.zrelprod_rec(this.LOW(l), this.LOW(r), lev + 1));
            this.PUSHREF(this.zrelprod_rec(this.HIGH(l), this.HIGH(r), lev + 1));
            if (this.INVARSET(lev)) {
                res = this.zor_rec(this.READREF(2), this.READREF(1));
                this.POPREF(2);
                this.PUSHREF(res);
                res = this.zdd_makenode(lev, res, res);
                this.POPREF(1);
            } else {
                res = this.zdd_makenode(lev, this.READREF(2), this.READREF(1));
                this.POPREF(2);
            }
        } else {
            res = LEVEL_l < LEVEL_r ? this.zrelprod_rec(this.LOW(l), r, lev + 1) : this.zrelprod_rec(l, this.LOW(r), lev + 1);
            if (this.INVARSET(lev)) {
                this.PUSHREF(res);
                res = this.zdd_makenode(lev, res, res);
                this.POPREF(1);
            }
        }
        entry.a = l;
        entry.b = r;
        entry.c = this.appexid;
        entry.res = res;
        return res;
    }

    int or_rec(int l, int r) {
        int res;
        if (this.cachestats.enabled) {
            ++this.cachestats.opAccess;
        }
        if (l == r) {
            return l;
        }
        if (JFactory.ISONE(l) || JFactory.ISONE(r)) {
            return 1;
        }
        if (JFactory.ISZERO(l)) {
            return r;
        }
        if (JFactory.ISZERO(r)) {
            return l;
        }
        BddCacheDataI entry = this.BddCache_lookupI(this.applycache, JFactory.APPLYHASH(l, r, 2));
        if (entry.a == l && entry.b == r && entry.c == 2) {
            if (this.cachestats.enabled) {
                ++this.cachestats.opHit;
            }
            return entry.res;
        }
        if (this.cachestats.enabled) {
            ++this.cachestats.opMiss;
        }
        if (this.LEVEL(l) == this.LEVEL(r)) {
            this.PUSHREF(this.or_rec(this.LOW(l), this.LOW(r)));
            this.PUSHREF(this.or_rec(this.HIGH(l), this.HIGH(r)));
            res = this.bdd_makenode(this.LEVEL(l), this.READREF(2), this.READREF(1));
        } else if (this.LEVEL(l) < this.LEVEL(r)) {
            this.PUSHREF(this.or_rec(this.LOW(l), r));
            this.PUSHREF(this.or_rec(this.HIGH(l), r));
            res = this.bdd_makenode(this.LEVEL(l), this.READREF(2), this.READREF(1));
        } else {
            this.PUSHREF(this.or_rec(l, this.LOW(r)));
            this.PUSHREF(this.or_rec(l, this.HIGH(r)));
            res = this.bdd_makenode(this.LEVEL(r), this.READREF(2), this.READREF(1));
        }
        this.POPREF(2);
        entry.a = l;
        entry.b = r;
        entry.c = 2;
        entry.res = res;
        return res;
    }

    int zor_rec(int l, int r) {
        int res;
        if (this.cachestats.enabled) {
            ++this.cachestats.opAccess;
        }
        if (l == r) {
            return l;
        }
        if (JFactory.ISZERO(l)) {
            return r;
        }
        if (JFactory.ISZERO(r)) {
            return l;
        }
        BddCacheDataI entry = this.BddCache_lookupI(this.applycache, JFactory.APPLYHASH(l, r, 2));
        if (entry.a == l && entry.b == r && entry.c == 2) {
            if (this.cachestats.enabled) {
                ++this.cachestats.opHit;
            }
            return entry.res;
        }
        if (this.cachestats.enabled) {
            ++this.cachestats.opMiss;
        }
        if (this.LEVEL(l) == this.LEVEL(r)) {
            this.PUSHREF(this.zor_rec(this.LOW(l), this.LOW(r)));
            this.PUSHREF(this.zor_rec(this.HIGH(l), this.HIGH(r)));
            res = this.zdd_makenode(this.LEVEL(l), this.READREF(2), this.READREF(1));
            this.POPREF(2);
        } else {
            if (this.LEVEL(l) < this.LEVEL(r)) {
                this.PUSHREF(this.zor_rec(this.LOW(l), r));
                res = this.zdd_makenode(this.LEVEL(l), this.READREF(1), this.HIGH(l));
            } else {
                this.PUSHREF(this.zor_rec(l, this.LOW(r)));
                res = this.zdd_makenode(this.LEVEL(r), this.READREF(1), this.HIGH(r));
            }
            this.POPREF(1);
        }
        entry.a = l;
        entry.b = r;
        entry.c = 2;
        entry.res = res;
        return res;
    }

    int zdiff_rec(int l, int r) {
        int res;
        if (this.cachestats.enabled) {
            ++this.cachestats.opAccess;
        }
        if (JFactory.ISZERO(l) || l == r) {
            return 0;
        }
        if (JFactory.ISZERO(r)) {
            return l;
        }
        if (this.LEVEL(l) > this.LEVEL(r)) {
            return this.zdiff_rec(l, this.LOW(r));
        }
        BddCacheDataI entry = this.BddCache_lookupI(this.applycache, JFactory.APPLYHASH(l, r, 7));
        if (entry.a == l && entry.b == r && entry.c == 7) {
            if (this.cachestats.enabled) {
                ++this.cachestats.opHit;
            }
            return entry.res;
        }
        if (this.cachestats.enabled) {
            ++this.cachestats.opMiss;
        }
        if (this.LEVEL(l) == this.LEVEL(r)) {
            this.PUSHREF(this.zdiff_rec(this.LOW(l), this.LOW(r)));
            this.PUSHREF(this.zdiff_rec(this.HIGH(l), this.HIGH(r)));
            res = this.zdd_makenode(this.LEVEL(l), this.READREF(2), this.READREF(1));
            this.POPREF(2);
        } else {
            this.PUSHREF(this.zdiff_rec(this.LOW(l), r));
            res = this.zdd_makenode(this.LEVEL(l), this.READREF(1), this.HIGH(l));
            this.POPREF(1);
        }
        entry.a = l;
        entry.b = r;
        entry.c = 7;
        entry.res = res;
        return res;
    }

    int bdd_relnext(int states, int relation, int vars) {
        int result;
        this.CHECKa(states);
        this.CHECKa(relation);
        this.CHECKa(vars);
        if (this.applycache == null) {
            this.applycache = this.BddCacheI_init(this.cachesize);
        }
        if (this.itecache == null) {
            this.itecache = this.BddCacheI_init(this.cachesize);
        }
        this.applyop = 2;
        int numReorder = 1;
        while (true) {
            try {
                this.INITREF();
                if (numReorder == 0) {
                    this.bdd_disable_reorder();
                }
                result = this.relnext_rec(states, relation, vars);
                if (numReorder != 0) break;
                this.bdd_enable_reorder();
            }
            catch (ReorderException x) {
                this.bdd_checkreorder();
                --numReorder;
                continue;
            }
            break;
        }
        this.checkresize();
        return result;
    }

    int relnext_rec(int states, int relation, int vars) {
        int result;
        boolean sameHeight;
        int level;
        int level_relation;
        int level_states;
        block29: {
            if (this.cachestats.enabled) {
                ++this.cachestats.opAccess;
            }
            if (JFactory.ISZERO(states) || JFactory.ISZERO(relation)) {
                return 0;
            }
            if (JFactory.ISONE(states) && JFactory.ISONE(relation)) {
                return 1;
            }
            if (JFactory.ISCONST(vars)) {
                return states;
            }
            level_states = this.LEVEL(states);
            level = level_states < (level_relation = this.LEVEL(relation)) ? level_states : level_relation;
            sameHeight = false;
            do {
                int level_vars;
                if (level == (level_vars = this.LEVEL(vars)) || (level ^ 1) == level_vars) {
                    sameHeight = true;
                    break block29;
                }
                if (level < level_vars) break block29;
            } while (!JFactory.ISCONST(vars = this.HIGH(vars)));
            return states;
        }
        BddCacheDataI entry = this.BddCache_lookupI(this.itecache, JFactory.QUADRUPLE(states, relation, vars, 13));
        if (entry.a == states && entry.b == relation && entry.c == vars && entry.d == 0 && entry.e == 13) {
            if (this.cachestats.enabled) {
                ++this.cachestats.opHit;
            }
            return entry.res;
        }
        if (this.cachestats.enabled) {
            ++this.cachestats.opMiss;
        }
        if (sameHeight) {
            int r11;
            int r10;
            int r01;
            int r00;
            int r1;
            int r0;
            int s1;
            int s0;
            int level_oldvar = level & 0xFFFFFFFE;
            int level_newvar = level_oldvar + 1;
            if (!JFactory.ISCONST(states) && level_states == level_oldvar) {
                s0 = this.LOW(states);
                s1 = this.HIGH(states);
            } else {
                s0 = states;
                s1 = states;
            }
            if (!JFactory.ISCONST(relation) && level_relation == level_oldvar) {
                r0 = this.LOW(relation);
                r1 = this.HIGH(relation);
            } else {
                r0 = relation;
                r1 = relation;
            }
            if (!JFactory.ISCONST(r0) && this.LEVEL(r0) == level_newvar) {
                r00 = this.LOW(r0);
                r01 = this.HIGH(r0);
            } else {
                r00 = r0;
                r01 = r0;
            }
            if (!JFactory.ISCONST(r1) && this.LEVEL(r1) == level_newvar) {
                r10 = this.LOW(r1);
                r11 = this.HIGH(r1);
            } else {
                r10 = r1;
                r11 = r1;
            }
            int nextVars = this.HIGH(vars);
            if (this.LEVEL(vars) == level_newvar || this.LEVEL(nextVars) == level_newvar) {
                this.PUSHREF(this.relnext_rec(s0, r00, nextVars));
                this.PUSHREF(this.relnext_rec(s1, r10, nextVars));
                int result0 = this.or_rec(this.READREF(2), this.READREF(1));
                this.POPREF(2);
                this.PUSHREF(result0);
                this.PUSHREF(this.relnext_rec(s0, r01, nextVars));
                this.PUSHREF(this.relnext_rec(s1, r11, nextVars));
                int result1 = this.or_rec(this.READREF(2), this.READREF(1));
                this.POPREF(2);
                this.PUSHREF(result1);
                result = this.bdd_makenode(level_oldvar, result0, result1);
                this.POPREF(2);
            } else {
                this.PUSHREF(this.relnext_rec(s0, r00, nextVars));
                this.PUSHREF(this.relnext_rec(s1, r11, nextVars));
                result = this.bdd_makenode(level_oldvar, this.READREF(2), this.READREF(1));
                this.POPREF(2);
            }
        } else {
            int r1;
            int r0;
            int s1;
            int s0;
            if (!JFactory.ISCONST(states) && level_states == level) {
                s0 = this.LOW(states);
                s1 = this.HIGH(states);
            } else {
                s0 = states;
                s1 = states;
            }
            if (!JFactory.ISCONST(relation) && level_relation == level) {
                r0 = this.LOW(relation);
                r1 = this.HIGH(relation);
            } else {
                r0 = relation;
                r1 = relation;
            }
            if (r0 != r1) {
                if (s0 != s1) {
                    this.PUSHREF(this.relnext_rec(s0, r0, vars));
                    this.PUSHREF(this.relnext_rec(s0, r1, vars));
                    int result0 = this.or_rec(this.READREF(2), this.READREF(1));
                    this.POPREF(2);
                    this.PUSHREF(result0);
                    this.PUSHREF(this.relnext_rec(s1, r0, vars));
                    this.PUSHREF(this.relnext_rec(s1, r1, vars));
                    int result1 = this.or_rec(this.READREF(2), this.READREF(1));
                    this.POPREF(2);
                    this.PUSHREF(result1);
                    result = this.bdd_makenode(level, result0, result1);
                    this.POPREF(2);
                } else {
                    this.PUSHREF(this.relnext_rec(s0, r0, vars));
                    this.PUSHREF(this.relnext_rec(s1, r1, vars));
                    result = this.or_rec(this.READREF(2), this.READREF(1));
                    this.POPREF(2);
                }
            } else {
                this.PUSHREF(this.relnext_rec(s0, r0, vars));
                this.PUSHREF(this.relnext_rec(s1, r1, vars));
                result = this.bdd_makenode(level, this.READREF(2), this.READREF(1));
                this.POPREF(2);
            }
        }
        entry.a = states;
        entry.b = relation;
        entry.c = vars;
        entry.d = 0;
        entry.e = 13;
        entry.res = result;
        return result;
    }

    int bdd_relnextUnion(int states, int relation, int union, int vars) {
        int result;
        this.CHECKa(states);
        this.CHECKa(relation);
        this.CHECKa(union);
        this.CHECKa(vars);
        if (this.applycache == null) {
            this.applycache = this.BddCacheI_init(this.cachesize);
        }
        if (this.itecache == null) {
            this.itecache = this.BddCacheI_init(this.cachesize);
        }
        this.applyop = 2;
        int numReorder = 1;
        while (true) {
            try {
                this.INITREF();
                if (numReorder == 0) {
                    this.bdd_disable_reorder();
                }
                result = this.relnextUnion_rec(states, relation, union, vars);
                if (numReorder != 0) break;
                this.bdd_enable_reorder();
            }
            catch (ReorderException x) {
                this.bdd_checkreorder();
                --numReorder;
                continue;
            }
            break;
        }
        this.checkresize();
        return result;
    }

    int relnextUnion_rec(int states, int relation, int union, int vars) {
        int result;
        int level_union;
        boolean sameHeight;
        int level;
        int level_relation;
        int level_states;
        block37: {
            if (this.cachestats.enabled) {
                ++this.cachestats.opAccess;
            }
            if (JFactory.ISZERO(union)) {
                return this.relnext_rec(states, relation, vars);
            }
            if (JFactory.ISONE(union)) {
                return 1;
            }
            if (JFactory.ISZERO(states) || JFactory.ISZERO(relation)) {
                return union;
            }
            if (JFactory.ISONE(states) && JFactory.ISONE(relation)) {
                return 1;
            }
            if (JFactory.ISCONST(vars)) {
                return this.or_rec(states, union);
            }
            level_states = this.LEVEL(states);
            level = level_states < (level_relation = this.LEVEL(relation)) ? level_states : level_relation;
            sameHeight = false;
            do {
                int level_vars;
                if (level == (level_vars = this.LEVEL(vars)) || (level ^ 1) == level_vars) {
                    sameHeight = true;
                    break block37;
                }
                if (level < level_vars) break block37;
            } while (!JFactory.ISCONST(vars = this.HIGH(vars)));
            return this.or_rec(states, union);
        }
        BddCacheDataI entry = this.BddCache_lookupI(this.itecache, JFactory.QUINTUPLE(states, relation, union, vars, 17));
        if (entry.a == states && entry.b == relation && entry.c == union && entry.d == vars && entry.e == 17) {
            if (this.cachestats.enabled) {
                ++this.cachestats.opHit;
            }
            return entry.res;
        }
        if (this.cachestats.enabled) {
            ++this.cachestats.opMiss;
        }
        if ((level_union = this.LEVEL(union)) < (level & 0xFFFFFFFE)) {
            this.PUSHREF(this.relnextUnion_rec(states, relation, this.LOW(union), vars));
            this.PUSHREF(this.relnextUnion_rec(states, relation, this.HIGH(union), vars));
            result = this.bdd_makenode(level_union, this.READREF(2), this.READREF(1));
            this.POPREF(2);
        } else if (sameHeight) {
            int u1;
            int u0;
            int r11;
            int r10;
            int r01;
            int r00;
            int r1;
            int r0;
            int s1;
            int s0;
            int level_oldvar = level & 0xFFFFFFFE;
            int level_newvar = level_oldvar + 1;
            if (!JFactory.ISCONST(states) && level_states == level_oldvar) {
                s0 = this.LOW(states);
                s1 = this.HIGH(states);
            } else {
                s0 = states;
                s1 = states;
            }
            if (!JFactory.ISCONST(relation) && level_relation == level_oldvar) {
                r0 = this.LOW(relation);
                r1 = this.HIGH(relation);
            } else {
                r0 = relation;
                r1 = relation;
            }
            if (!JFactory.ISCONST(r0) && this.LEVEL(r0) == level_newvar) {
                r00 = this.LOW(r0);
                r01 = this.HIGH(r0);
            } else {
                r00 = r0;
                r01 = r0;
            }
            if (!JFactory.ISCONST(r1) && this.LEVEL(r1) == level_newvar) {
                r10 = this.LOW(r1);
                r11 = this.HIGH(r1);
            } else {
                r10 = r1;
                r11 = r1;
            }
            if (level_union == level_oldvar) {
                u0 = this.LOW(union);
                u1 = this.HIGH(union);
            } else {
                u0 = union;
                u1 = union;
            }
            int nextVars = this.HIGH(vars);
            if (this.LEVEL(vars) == level_newvar || this.LEVEL(nextVars) == level_newvar) {
                this.PUSHREF(this.relnextUnion_rec(s0, r00, u0, nextVars));
                this.PUSHREF(this.relnextUnion_rec(s1, r10, u0, nextVars));
                int result0 = this.or_rec(this.READREF(2), this.READREF(1));
                this.POPREF(2);
                this.PUSHREF(result0);
                this.PUSHREF(this.relnextUnion_rec(s0, r01, u1, nextVars));
                this.PUSHREF(this.relnextUnion_rec(s1, r11, u1, nextVars));
                int result1 = this.or_rec(this.READREF(2), this.READREF(1));
                this.POPREF(2);
                this.PUSHREF(result1);
                result = this.bdd_makenode(level_oldvar, result0, result1);
                this.POPREF(2);
            } else {
                this.PUSHREF(this.relnextUnion_rec(s0, r00, u0, nextVars));
                this.PUSHREF(this.relnextUnion_rec(s1, r11, u1, nextVars));
                result = this.bdd_makenode(level_oldvar, this.READREF(2), this.READREF(1));
                this.POPREF(2);
            }
        } else {
            int u1;
            int u0;
            int r1;
            int r0;
            int s1;
            int s0;
            if (!JFactory.ISCONST(states) && level_states == level) {
                s0 = this.LOW(states);
                s1 = this.HIGH(states);
            } else {
                s0 = states;
                s1 = states;
            }
            if (!JFactory.ISCONST(relation) && level_relation == level) {
                r0 = this.LOW(relation);
                r1 = this.HIGH(relation);
            } else {
                r0 = relation;
                r1 = relation;
            }
            if (level_union == level) {
                u0 = this.LOW(union);
                u1 = this.HIGH(union);
            } else {
                u0 = union;
                u1 = union;
            }
            if (r0 != r1) {
                if (s0 != s1) {
                    this.PUSHREF(this.relnextUnion_rec(s0, r0, u0, vars));
                    this.PUSHREF(this.relnextUnion_rec(s0, r1, u0, vars));
                    int result0 = this.or_rec(this.READREF(2), this.READREF(1));
                    this.POPREF(2);
                    this.PUSHREF(result0);
                    this.PUSHREF(this.relnextUnion_rec(s1, r0, u1, vars));
                    this.PUSHREF(this.relnextUnion_rec(s1, r1, u1, vars));
                    int result1 = this.or_rec(this.READREF(2), this.READREF(1));
                    this.POPREF(2);
                    this.PUSHREF(result1);
                    result = this.bdd_makenode(level, result0, result1);
                    this.POPREF(2);
                } else {
                    this.PUSHREF(this.relnextUnion_rec(s0, r0, u0, vars));
                    this.PUSHREF(this.relnextUnion_rec(s1, r1, u1, vars));
                    result = this.or_rec(this.READREF(2), this.READREF(1));
                    this.POPREF(2);
                }
            } else {
                this.PUSHREF(this.relnextUnion_rec(s0, r0, u0, vars));
                this.PUSHREF(this.relnextUnion_rec(s1, r1, u1, vars));
                result = this.bdd_makenode(level, this.READREF(2), this.READREF(1));
                this.POPREF(2);
            }
        }
        entry.a = states;
        entry.b = relation;
        entry.c = union;
        entry.d = vars;
        entry.e = 17;
        entry.res = result;
        return result;
    }

    int bdd_relnextIntersection(int states, int relation, int restriction, int vars) {
        int result;
        this.CHECKa(states);
        this.CHECKa(relation);
        this.CHECKa(restriction);
        this.CHECKa(vars);
        if (this.applycache == null) {
            this.applycache = this.BddCacheI_init(this.cachesize);
        }
        if (this.itecache == null) {
            this.itecache = this.BddCacheI_init(this.cachesize);
        }
        this.applyop = 2;
        int numReorder = 1;
        while (true) {
            try {
                this.INITREF();
                if (numReorder == 0) {
                    this.bdd_disable_reorder();
                }
                result = this.relnextIntersection_rec(states, relation, restriction, vars);
                if (numReorder != 0) break;
                this.bdd_enable_reorder();
            }
            catch (ReorderException x) {
                this.bdd_checkreorder();
                --numReorder;
                continue;
            }
            break;
        }
        this.checkresize();
        return result;
    }

    int relnextIntersection_rec(int states, int relation, int restriction, int vars) {
        int result;
        int level_restriction;
        boolean sameHeight;
        int level;
        int level_relation;
        int level_states;
        block36: {
            if (this.cachestats.enabled) {
                ++this.cachestats.opAccess;
            }
            if (JFactory.ISONE(restriction)) {
                return this.relnext_rec(states, relation, vars);
            }
            if (JFactory.ISZERO(states) || JFactory.ISZERO(relation) || JFactory.ISZERO(restriction)) {
                return 0;
            }
            if (JFactory.ISONE(states) && JFactory.ISONE(relation)) {
                return restriction;
            }
            if (JFactory.ISCONST(vars)) {
                this.applyop = 0;
                int result2 = this.and_rec(states, restriction);
                this.applyop = 2;
                return result2;
            }
            level_states = this.LEVEL(states);
            level = level_states < (level_relation = this.LEVEL(relation)) ? level_states : level_relation;
            sameHeight = false;
            do {
                int level_vars;
                if (level == (level_vars = this.LEVEL(vars)) || (level ^ 1) == level_vars) {
                    sameHeight = true;
                    break block36;
                }
                if (level < level_vars) break block36;
            } while (!JFactory.ISCONST(vars = this.HIGH(vars)));
            this.applyop = 0;
            int result3 = this.and_rec(states, restriction);
            this.applyop = 2;
            return result3;
        }
        BddCacheDataI entry = this.BddCache_lookupI(this.itecache, JFactory.QUINTUPLE(states, relation, restriction, vars, 15));
        if (entry.a == states && entry.b == relation && entry.c == restriction && entry.d == vars && entry.e == 15) {
            if (this.cachestats.enabled) {
                ++this.cachestats.opHit;
            }
            return entry.res;
        }
        if (this.cachestats.enabled) {
            ++this.cachestats.opMiss;
        }
        if ((level_restriction = this.LEVEL(restriction)) < (level & 0xFFFFFFFE)) {
            this.PUSHREF(this.relnextIntersection_rec(states, relation, this.LOW(restriction), vars));
            this.PUSHREF(this.relnextIntersection_rec(states, relation, this.HIGH(restriction), vars));
            result = this.bdd_makenode(level_restriction, this.READREF(2), this.READREF(1));
            this.POPREF(2);
        } else if (sameHeight) {
            int u1;
            int u0;
            int r11;
            int r10;
            int r01;
            int r00;
            int r1;
            int r0;
            int s1;
            int s0;
            int level_oldvar = level & 0xFFFFFFFE;
            int level_newvar = level_oldvar + 1;
            if (!JFactory.ISCONST(states) && level_states == level_oldvar) {
                s0 = this.LOW(states);
                s1 = this.HIGH(states);
            } else {
                s0 = states;
                s1 = states;
            }
            if (!JFactory.ISCONST(relation) && level_relation == level_oldvar) {
                r0 = this.LOW(relation);
                r1 = this.HIGH(relation);
            } else {
                r0 = relation;
                r1 = relation;
            }
            if (!JFactory.ISCONST(r0) && this.LEVEL(r0) == level_newvar) {
                r00 = this.LOW(r0);
                r01 = this.HIGH(r0);
            } else {
                r00 = r0;
                r01 = r0;
            }
            if (!JFactory.ISCONST(r1) && this.LEVEL(r1) == level_newvar) {
                r10 = this.LOW(r1);
                r11 = this.HIGH(r1);
            } else {
                r10 = r1;
                r11 = r1;
            }
            if (level_restriction == level_oldvar) {
                u0 = this.LOW(restriction);
                u1 = this.HIGH(restriction);
            } else {
                u0 = restriction;
                u1 = restriction;
            }
            int nextVars = this.HIGH(vars);
            if (this.LEVEL(vars) == level_newvar || this.LEVEL(nextVars) == level_newvar) {
                this.PUSHREF(this.relnextIntersection_rec(s0, r00, u0, nextVars));
                this.PUSHREF(this.relnextIntersection_rec(s1, r10, u0, nextVars));
                int result0 = this.or_rec(this.READREF(2), this.READREF(1));
                this.POPREF(2);
                this.PUSHREF(result0);
                this.PUSHREF(this.relnextIntersection_rec(s0, r01, u1, nextVars));
                this.PUSHREF(this.relnextIntersection_rec(s1, r11, u1, nextVars));
                int result1 = this.or_rec(this.READREF(2), this.READREF(1));
                this.POPREF(2);
                this.PUSHREF(result1);
                result = this.bdd_makenode(level_oldvar, result0, result1);
                this.POPREF(2);
            } else {
                this.PUSHREF(this.relnextIntersection_rec(s0, r00, u0, nextVars));
                this.PUSHREF(this.relnextIntersection_rec(s1, r11, u1, nextVars));
                result = this.bdd_makenode(level_oldvar, this.READREF(2), this.READREF(1));
                this.POPREF(2);
            }
        } else {
            int u1;
            int u0;
            int r1;
            int r0;
            int s1;
            int s0;
            if (!JFactory.ISCONST(states) && level_states == level) {
                s0 = this.LOW(states);
                s1 = this.HIGH(states);
            } else {
                s0 = states;
                s1 = states;
            }
            if (!JFactory.ISCONST(relation) && level_relation == level) {
                r0 = this.LOW(relation);
                r1 = this.HIGH(relation);
            } else {
                r0 = relation;
                r1 = relation;
            }
            if (level_restriction == level) {
                u0 = this.LOW(restriction);
                u1 = this.HIGH(restriction);
            } else {
                u0 = restriction;
                u1 = restriction;
            }
            if (r0 != r1) {
                if (s0 != s1) {
                    this.PUSHREF(this.relnextIntersection_rec(s0, r0, u0, vars));
                    this.PUSHREF(this.relnextIntersection_rec(s0, r1, u0, vars));
                    int result0 = this.or_rec(this.READREF(2), this.READREF(1));
                    this.POPREF(2);
                    this.PUSHREF(result0);
                    this.PUSHREF(this.relnextIntersection_rec(s1, r0, u1, vars));
                    this.PUSHREF(this.relnextIntersection_rec(s1, r1, u1, vars));
                    int result1 = this.or_rec(this.READREF(2), this.READREF(1));
                    this.POPREF(2);
                    this.PUSHREF(result1);
                    result = this.bdd_makenode(level, result0, result1);
                    this.POPREF(2);
                } else {
                    this.PUSHREF(this.relnextIntersection_rec(s0, r0, u0, vars));
                    this.PUSHREF(this.relnextIntersection_rec(s1, r1, u1, vars));
                    result = this.or_rec(this.READREF(2), this.READREF(1));
                    this.POPREF(2);
                }
            } else {
                this.PUSHREF(this.relnextIntersection_rec(s0, r0, u0, vars));
                this.PUSHREF(this.relnextIntersection_rec(s1, r1, u1, vars));
                result = this.bdd_makenode(level, this.READREF(2), this.READREF(1));
                this.POPREF(2);
            }
        }
        entry.a = states;
        entry.b = relation;
        entry.c = restriction;
        entry.d = vars;
        entry.e = 15;
        entry.res = result;
        return result;
    }

    int bdd_relprev(int relation, int states, int vars) {
        int result;
        this.CHECKa(relation);
        this.CHECKa(states);
        this.CHECKa(vars);
        if (this.applycache == null) {
            this.applycache = this.BddCacheI_init(this.cachesize);
        }
        if (this.itecache == null) {
            this.itecache = this.BddCacheI_init(this.cachesize);
        }
        this.applyop = 2;
        int numReorder = 1;
        while (true) {
            try {
                this.INITREF();
                if (numReorder == 0) {
                    this.bdd_disable_reorder();
                }
                result = this.relprev_rec(relation, states, vars);
                if (numReorder != 0) break;
                this.bdd_enable_reorder();
            }
            catch (ReorderException x) {
                this.bdd_checkreorder();
                --numReorder;
                continue;
            }
            break;
        }
        this.checkresize();
        return result;
    }

    int relprev_rec(int relation, int states, int vars) {
        int result;
        boolean sameHeight;
        int level;
        int level_states;
        int level_relation;
        block30: {
            if (this.cachestats.enabled) {
                ++this.cachestats.opAccess;
            }
            if (JFactory.ISZERO(relation) || JFactory.ISZERO(states)) {
                return 0;
            }
            if (JFactory.ISONE(relation) && JFactory.ISONE(states)) {
                return 1;
            }
            if (JFactory.ISCONST(vars)) {
                return states;
            }
            level_relation = this.LEVEL(relation);
            level = level_relation < (level_states = this.LEVEL(states)) ? level_relation : level_states;
            sameHeight = false;
            do {
                int level_vars;
                if (level == (level_vars = this.LEVEL(vars)) || (level ^ 1) == level_vars) {
                    sameHeight = true;
                    break block30;
                }
                if (level < level_vars) break block30;
            } while (!JFactory.ISCONST(vars = this.HIGH(vars)));
            return states;
        }
        BddCacheDataI entry = this.BddCache_lookupI(this.itecache, JFactory.QUADRUPLE(relation, states, vars, 14));
        if (entry.a == relation && entry.b == states && entry.c == vars && entry.d == 0 && entry.e == 14) {
            if (this.cachestats.enabled) {
                ++this.cachestats.opHit;
            }
            return entry.res;
        }
        if (this.cachestats.enabled) {
            ++this.cachestats.opMiss;
        }
        if (sameHeight) {
            boolean quantify;
            int r11;
            int r10;
            int r01;
            int r00;
            int s1;
            int s0;
            int r1;
            int r0;
            int level_oldvar = level & 0xFFFFFFFE;
            int level_newvar = level_oldvar + 1;
            if (!JFactory.ISCONST(relation) && level_relation == level_oldvar) {
                r0 = this.LOW(relation);
                r1 = this.HIGH(relation);
            } else {
                r0 = relation;
                r1 = relation;
            }
            if (!JFactory.ISCONST(states) && level_states == level_oldvar) {
                s0 = this.LOW(states);
                s1 = this.HIGH(states);
            } else {
                s0 = states;
                s1 = states;
            }
            if (!JFactory.ISCONST(r0) && this.LEVEL(r0) == level_newvar) {
                r00 = this.LOW(r0);
                r01 = this.HIGH(r0);
            } else {
                r00 = r0;
                r01 = r0;
            }
            if (!JFactory.ISCONST(r1) && this.LEVEL(r1) == level_newvar) {
                r10 = this.LOW(r1);
                r11 = this.HIGH(r1);
            } else {
                r10 = r1;
                r11 = r1;
            }
            int nextVars = this.HIGH(vars);
            boolean bl = quantify = this.LEVEL(vars) == level_newvar || this.LEVEL(nextVars) == level_newvar;
            if (this.LEVEL(nextVars) == level_newvar) {
                nextVars = this.HIGH(nextVars);
            }
            if (quantify) {
                this.PUSHREF(this.relprev_rec(r00, s0, nextVars));
                this.PUSHREF(this.relprev_rec(r01, s1, nextVars));
                int result0 = this.or_rec(this.READREF(2), this.READREF(1));
                this.POPREF(2);
                this.PUSHREF(result0);
                this.PUSHREF(this.relprev_rec(r10, s0, nextVars));
                this.PUSHREF(this.relprev_rec(r11, s1, nextVars));
                int result1 = this.or_rec(this.READREF(2), this.READREF(1));
                this.POPREF(2);
                this.PUSHREF(result1);
                result = this.bdd_makenode(level_oldvar, result0, result1);
                this.POPREF(2);
            } else {
                this.PUSHREF(this.relprev_rec(r00, s0, nextVars));
                this.PUSHREF(this.relprev_rec(r11, s1, nextVars));
                result = this.bdd_makenode(level_oldvar, this.READREF(2), this.READREF(1));
                this.POPREF(2);
            }
        } else {
            int s1;
            int s0;
            int r1;
            int r0;
            if (!JFactory.ISCONST(relation) && level_relation == level) {
                r0 = this.LOW(relation);
                r1 = this.HIGH(relation);
            } else {
                r0 = relation;
                r1 = relation;
            }
            if (!JFactory.ISCONST(states) && level_states == level) {
                s0 = this.LOW(states);
                s1 = this.HIGH(states);
            } else {
                s0 = states;
                s1 = states;
            }
            if (r0 != r1) {
                if (s0 != s1) {
                    this.PUSHREF(this.relprev_rec(r0, s0, vars));
                    this.PUSHREF(this.relprev_rec(r1, s0, vars));
                    int result0 = this.or_rec(this.READREF(2), this.READREF(1));
                    this.POPREF(2);
                    this.PUSHREF(result0);
                    this.PUSHREF(this.relprev_rec(r0, s1, vars));
                    this.PUSHREF(this.relprev_rec(r1, s1, vars));
                    int result1 = this.or_rec(this.READREF(2), this.READREF(1));
                    this.POPREF(2);
                    this.PUSHREF(result1);
                    result = this.bdd_makenode(level, result0, result1);
                    this.POPREF(2);
                } else {
                    this.PUSHREF(this.relprev_rec(r0, s0, vars));
                    this.PUSHREF(this.relprev_rec(r1, s1, vars));
                    result = this.or_rec(this.READREF(2), this.READREF(1));
                    this.POPREF(2);
                }
            } else {
                this.PUSHREF(this.relprev_rec(r0, s0, vars));
                this.PUSHREF(this.relprev_rec(r1, s1, vars));
                result = this.bdd_makenode(level, this.READREF(2), this.READREF(1));
                this.POPREF(2);
            }
        }
        entry.a = relation;
        entry.b = states;
        entry.c = vars;
        entry.d = 0;
        entry.e = 14;
        entry.res = result;
        return result;
    }

    int bdd_relprevUnion(int relation, int states, int union, int vars) {
        int result;
        this.CHECKa(relation);
        this.CHECKa(states);
        this.CHECKa(union);
        this.CHECKa(vars);
        if (this.applycache == null) {
            this.applycache = this.BddCacheI_init(this.cachesize);
        }
        if (this.itecache == null) {
            this.itecache = this.BddCacheI_init(this.cachesize);
        }
        this.applyop = 2;
        int numReorder = 1;
        while (true) {
            try {
                this.INITREF();
                if (numReorder == 0) {
                    this.bdd_disable_reorder();
                }
                result = this.relprevUnion_rec(relation, states, union, vars);
                if (numReorder != 0) break;
                this.bdd_enable_reorder();
            }
            catch (ReorderException x) {
                this.bdd_checkreorder();
                --numReorder;
                continue;
            }
            break;
        }
        this.checkresize();
        return result;
    }

    int relprevUnion_rec(int relation, int states, int union, int vars) {
        int result;
        int level_union;
        boolean sameHeight;
        int level;
        int level_states;
        int level_relation;
        block38: {
            if (this.cachestats.enabled) {
                ++this.cachestats.opAccess;
            }
            if (JFactory.ISZERO(union)) {
                return this.relprev_rec(relation, states, vars);
            }
            if (JFactory.ISONE(union)) {
                return 1;
            }
            if (JFactory.ISZERO(states) || JFactory.ISZERO(relation)) {
                return union;
            }
            if (JFactory.ISONE(states) && JFactory.ISONE(relation)) {
                return 1;
            }
            if (JFactory.ISCONST(vars)) {
                return this.or_rec(states, union);
            }
            level_relation = this.LEVEL(relation);
            level = level_relation < (level_states = this.LEVEL(states)) ? level_relation : level_states;
            sameHeight = false;
            do {
                int level_vars;
                if (level == (level_vars = this.LEVEL(vars)) || (level ^ 1) == level_vars) {
                    sameHeight = true;
                    break block38;
                }
                if (level < level_vars) break block38;
            } while (!JFactory.ISCONST(vars = this.HIGH(vars)));
            return this.or_rec(states, union);
        }
        BddCacheDataI entry = this.BddCache_lookupI(this.itecache, JFactory.QUINTUPLE(relation, states, union, vars, 18));
        if (entry.a == relation && entry.b == states && entry.c == union && entry.d == vars && entry.e == 18) {
            if (this.cachestats.enabled) {
                ++this.cachestats.opHit;
            }
            return entry.res;
        }
        if (this.cachestats.enabled) {
            ++this.cachestats.opMiss;
        }
        if ((level_union = this.LEVEL(union)) < (level & 0xFFFFFFFE)) {
            this.PUSHREF(this.relprevUnion_rec(relation, states, this.LOW(union), vars));
            this.PUSHREF(this.relprevUnion_rec(relation, states, this.HIGH(union), vars));
            result = this.bdd_makenode(level_union, this.READREF(2), this.READREF(1));
            this.POPREF(2);
        } else if (sameHeight) {
            boolean quantify;
            int u1;
            int u0;
            int r11;
            int r10;
            int r01;
            int r00;
            int s1;
            int s0;
            int r1;
            int r0;
            int level_oldvar = level & 0xFFFFFFFE;
            int level_newvar = level_oldvar + 1;
            if (!JFactory.ISCONST(relation) && level_relation == level_oldvar) {
                r0 = this.LOW(relation);
                r1 = this.HIGH(relation);
            } else {
                r0 = relation;
                r1 = relation;
            }
            if (!JFactory.ISCONST(states) && level_states == level_oldvar) {
                s0 = this.LOW(states);
                s1 = this.HIGH(states);
            } else {
                s0 = states;
                s1 = states;
            }
            if (!JFactory.ISCONST(r0) && this.LEVEL(r0) == level_newvar) {
                r00 = this.LOW(r0);
                r01 = this.HIGH(r0);
            } else {
                r00 = r0;
                r01 = r0;
            }
            if (!JFactory.ISCONST(r1) && this.LEVEL(r1) == level_newvar) {
                r10 = this.LOW(r1);
                r11 = this.HIGH(r1);
            } else {
                r10 = r1;
                r11 = r1;
            }
            if (level_union == level_oldvar) {
                u0 = this.LOW(union);
                u1 = this.HIGH(union);
            } else {
                u0 = union;
                u1 = union;
            }
            int nextVars = this.HIGH(vars);
            boolean bl = quantify = this.LEVEL(vars) == level_newvar || this.LEVEL(nextVars) == level_newvar;
            if (this.LEVEL(nextVars) == level_newvar) {
                nextVars = this.HIGH(nextVars);
            }
            if (quantify) {
                this.PUSHREF(this.relprevUnion_rec(r00, s0, u0, nextVars));
                this.PUSHREF(this.relprevUnion_rec(r01, s1, u0, nextVars));
                int result0 = this.or_rec(this.READREF(2), this.READREF(1));
                this.POPREF(2);
                this.PUSHREF(result0);
                this.PUSHREF(this.relprevUnion_rec(r10, s0, u1, nextVars));
                this.PUSHREF(this.relprevUnion_rec(r11, s1, u1, nextVars));
                int result1 = this.or_rec(this.READREF(2), this.READREF(1));
                this.POPREF(2);
                this.PUSHREF(result1);
                result = this.bdd_makenode(level_oldvar, result0, result1);
                this.POPREF(2);
            } else {
                this.PUSHREF(this.relprevUnion_rec(r00, s0, u0, nextVars));
                this.PUSHREF(this.relprevUnion_rec(r11, s1, u1, nextVars));
                result = this.bdd_makenode(level_oldvar, this.READREF(2), this.READREF(1));
                this.POPREF(2);
            }
        } else {
            int u1;
            int u0;
            int s1;
            int s0;
            int r1;
            int r0;
            if (!JFactory.ISCONST(relation) && level_relation == level) {
                r0 = this.LOW(relation);
                r1 = this.HIGH(relation);
            } else {
                r0 = relation;
                r1 = relation;
            }
            if (!JFactory.ISCONST(states) && level_states == level) {
                s0 = this.LOW(states);
                s1 = this.HIGH(states);
            } else {
                s0 = states;
                s1 = states;
            }
            if (level_union == level) {
                u0 = this.LOW(union);
                u1 = this.HIGH(union);
            } else {
                u0 = union;
                u1 = union;
            }
            if (r0 != r1) {
                if (s0 != s1) {
                    this.PUSHREF(this.relprevUnion_rec(r0, s0, u0, vars));
                    this.PUSHREF(this.relprevUnion_rec(r1, s0, u0, vars));
                    int result0 = this.or_rec(this.READREF(2), this.READREF(1));
                    this.POPREF(2);
                    this.PUSHREF(result0);
                    this.PUSHREF(this.relprevUnion_rec(r0, s1, u1, vars));
                    this.PUSHREF(this.relprevUnion_rec(r1, s1, u1, vars));
                    int result1 = this.or_rec(this.READREF(2), this.READREF(1));
                    this.POPREF(2);
                    this.PUSHREF(result1);
                    result = this.bdd_makenode(level, result0, result1);
                    this.POPREF(2);
                } else {
                    this.PUSHREF(this.relprevUnion_rec(r0, s0, u0, vars));
                    this.PUSHREF(this.relprevUnion_rec(r1, s1, u1, vars));
                    result = this.or_rec(this.READREF(2), this.READREF(1));
                    this.POPREF(2);
                }
            } else {
                this.PUSHREF(this.relprevUnion_rec(r0, s0, u0, vars));
                this.PUSHREF(this.relprevUnion_rec(r1, s1, u1, vars));
                result = this.bdd_makenode(level, this.READREF(2), this.READREF(1));
                this.POPREF(2);
            }
        }
        entry.a = relation;
        entry.b = states;
        entry.c = union;
        entry.d = vars;
        entry.e = 18;
        entry.res = result;
        return result;
    }

    int bdd_relprevIntersection(int relation, int states, int restriction, int vars) {
        int result;
        this.CHECKa(relation);
        this.CHECKa(states);
        this.CHECKa(restriction);
        this.CHECKa(vars);
        if (this.applycache == null) {
            this.applycache = this.BddCacheI_init(this.cachesize);
        }
        if (this.itecache == null) {
            this.itecache = this.BddCacheI_init(this.cachesize);
        }
        this.applyop = 2;
        int numReorder = 1;
        while (true) {
            try {
                this.INITREF();
                if (numReorder == 0) {
                    this.bdd_disable_reorder();
                }
                result = this.relprevIntersection_rec(relation, states, restriction, vars);
                if (numReorder != 0) break;
                this.bdd_enable_reorder();
            }
            catch (ReorderException x) {
                this.bdd_checkreorder();
                --numReorder;
                continue;
            }
            break;
        }
        this.checkresize();
        return result;
    }

    int relprevIntersection_rec(int relation, int states, int restriction, int vars) {
        int result;
        int level_restriction;
        boolean sameHeight;
        int level;
        int level_states;
        int level_relation;
        block37: {
            if (JFactory.ISONE(restriction)) {
                return this.relprev_rec(relation, states, vars);
            }
            if (this.cachestats.enabled) {
                ++this.cachestats.opAccess;
            }
            if (JFactory.ISZERO(relation) || JFactory.ISZERO(states) || JFactory.ISZERO(restriction)) {
                return 0;
            }
            if (JFactory.ISONE(relation) && JFactory.ISONE(states)) {
                return restriction;
            }
            if (JFactory.ISCONST(vars)) {
                this.applyop = 0;
                int result2 = this.and_rec(states, restriction);
                this.applyop = 2;
                return result2;
            }
            level_relation = this.LEVEL(relation);
            level = level_relation < (level_states = this.LEVEL(states)) ? level_relation : level_states;
            sameHeight = false;
            do {
                int level_vars;
                if (level == (level_vars = this.LEVEL(vars)) || (level ^ 1) == level_vars) {
                    sameHeight = true;
                    break block37;
                }
                if (level < level_vars) break block37;
            } while (!JFactory.ISCONST(vars = this.HIGH(vars)));
            this.applyop = 0;
            int result3 = this.and_rec(states, restriction);
            this.applyop = 2;
            return result3;
        }
        BddCacheDataI entry = this.BddCache_lookupI(this.itecache, JFactory.QUINTUPLE(relation, states, restriction, vars, 16));
        if (entry.a == relation && entry.b == states && entry.c == restriction && entry.d == vars && entry.e == 16) {
            if (this.cachestats.enabled) {
                ++this.cachestats.opHit;
            }
            return entry.res;
        }
        if (this.cachestats.enabled) {
            ++this.cachestats.opMiss;
        }
        if ((level_restriction = this.LEVEL(restriction)) < (level & 0xFFFFFFFE)) {
            this.PUSHREF(this.relprevIntersection_rec(relation, states, this.LOW(restriction), vars));
            this.PUSHREF(this.relprevIntersection_rec(relation, states, this.HIGH(restriction), vars));
            result = this.bdd_makenode(level_restriction, this.READREF(2), this.READREF(1));
            this.POPREF(2);
        } else if (sameHeight) {
            boolean quantify;
            int u1;
            int u0;
            int r11;
            int r10;
            int r01;
            int r00;
            int s1;
            int s0;
            int r1;
            int r0;
            int level_oldvar = level & 0xFFFFFFFE;
            int level_newvar = level_oldvar + 1;
            if (!JFactory.ISCONST(relation) && level_relation == level_oldvar) {
                r0 = this.LOW(relation);
                r1 = this.HIGH(relation);
            } else {
                r0 = relation;
                r1 = relation;
            }
            if (!JFactory.ISCONST(states) && level_states == level_oldvar) {
                s0 = this.LOW(states);
                s1 = this.HIGH(states);
            } else {
                s0 = states;
                s1 = states;
            }
            if (!JFactory.ISCONST(r0) && this.LEVEL(r0) == level_newvar) {
                r00 = this.LOW(r0);
                r01 = this.HIGH(r0);
            } else {
                r00 = r0;
                r01 = r0;
            }
            if (!JFactory.ISCONST(r1) && this.LEVEL(r1) == level_newvar) {
                r10 = this.LOW(r1);
                r11 = this.HIGH(r1);
            } else {
                r10 = r1;
                r11 = r1;
            }
            if (level_restriction == level_oldvar) {
                u0 = this.LOW(restriction);
                u1 = this.HIGH(restriction);
            } else {
                u0 = restriction;
                u1 = restriction;
            }
            int nextVars = this.HIGH(vars);
            boolean bl = quantify = this.LEVEL(vars) == level_newvar || this.LEVEL(nextVars) == level_newvar;
            if (this.LEVEL(nextVars) == level_newvar) {
                nextVars = this.HIGH(nextVars);
            }
            if (quantify) {
                this.PUSHREF(this.relprevIntersection_rec(r00, s0, u0, nextVars));
                this.PUSHREF(this.relprevIntersection_rec(r01, s1, u0, nextVars));
                int result0 = this.or_rec(this.READREF(2), this.READREF(1));
                this.POPREF(2);
                this.PUSHREF(result0);
                this.PUSHREF(this.relprevIntersection_rec(r10, s0, u1, nextVars));
                this.PUSHREF(this.relprevIntersection_rec(r11, s1, u1, nextVars));
                int result1 = this.or_rec(this.READREF(2), this.READREF(1));
                this.POPREF(2);
                this.PUSHREF(result1);
                result = this.bdd_makenode(level_oldvar, result0, result1);
                this.POPREF(2);
            } else {
                this.PUSHREF(this.relprevIntersection_rec(r00, s0, u0, nextVars));
                this.PUSHREF(this.relprevIntersection_rec(r11, s1, u1, nextVars));
                result = this.bdd_makenode(level_oldvar, this.READREF(2), this.READREF(1));
                this.POPREF(2);
            }
        } else {
            int u1;
            int u0;
            int s1;
            int s0;
            int r1;
            int r0;
            if (!JFactory.ISCONST(relation) && level_relation == level) {
                r0 = this.LOW(relation);
                r1 = this.HIGH(relation);
            } else {
                r0 = relation;
                r1 = relation;
            }
            if (!JFactory.ISCONST(states) && level_states == level) {
                s0 = this.LOW(states);
                s1 = this.HIGH(states);
            } else {
                s0 = states;
                s1 = states;
            }
            if (level_restriction == level) {
                u0 = this.LOW(restriction);
                u1 = this.HIGH(restriction);
            } else {
                u0 = restriction;
                u1 = restriction;
            }
            if (r0 != r1) {
                if (s0 != s1) {
                    this.PUSHREF(this.relprevIntersection_rec(r0, s0, u0, vars));
                    this.PUSHREF(this.relprevIntersection_rec(r1, s0, u0, vars));
                    int result0 = this.or_rec(this.READREF(2), this.READREF(1));
                    this.POPREF(2);
                    this.PUSHREF(result0);
                    this.PUSHREF(this.relprevIntersection_rec(r0, s1, u1, vars));
                    this.PUSHREF(this.relprevIntersection_rec(r1, s1, u1, vars));
                    int result1 = this.or_rec(this.READREF(2), this.READREF(1));
                    this.POPREF(2);
                    this.PUSHREF(result1);
                    result = this.bdd_makenode(level, result0, result1);
                    this.POPREF(2);
                } else {
                    this.PUSHREF(this.relprevIntersection_rec(r0, s0, u0, vars));
                    this.PUSHREF(this.relprevIntersection_rec(r1, s1, u1, vars));
                    result = this.or_rec(this.READREF(2), this.READREF(1));
                    this.POPREF(2);
                }
            } else {
                this.PUSHREF(this.relprevIntersection_rec(r0, s0, u0, vars));
                this.PUSHREF(this.relprevIntersection_rec(r1, s1, u1, vars));
                result = this.bdd_makenode(level, this.READREF(2), this.READREF(1));
                this.POPREF(2);
            }
        }
        entry.a = relation;
        entry.b = states;
        entry.c = restriction;
        entry.d = vars;
        entry.e = 16;
        entry.res = result;
        return result;
    }

    int bdd_saturationForward(int states, int[] relations, int[] vars, int instance) {
        int result;
        int i;
        JFactory._assert(relations.length == vars.length);
        this.CHECKa(states);
        for (i = 0; i < relations.length; ++i) {
            this.CHECKa(relations[i]);
            this.CHECKa(vars[i]);
        }
        for (i = 0; i < vars.length - 1; ++i) {
            JFactory._assert(this.LEVEL(vars[i]) <= this.LEVEL(vars[i + 1]));
        }
        if (this.applycache == null) {
            this.applycache = this.BddCacheI_init(this.cachesize);
        }
        if (this.itecache == null) {
            this.itecache = this.BddCacheI_init(this.cachesize);
        }
        this.applyop = 2;
        int numReorder = 1;
        while (true) {
            try {
                this.INITREF();
                if (numReorder == 0) {
                    this.bdd_disable_reorder();
                }
                result = this.saturationForward_rec(states, relations, vars, instance, 0);
                if (numReorder != 0) break;
                this.bdd_enable_reorder();
            }
            catch (ReorderException x) {
                this.bdd_checkreorder();
                --numReorder;
                continue;
            }
            break;
        }
        this.checkresize();
        return result;
    }

    int saturationForward_rec(int states, int[] relations, int[] vars, int instance, int current) {
        int result;
        if (this.cachestats.enabled) {
            ++this.cachestats.opAccess;
        }
        if (JFactory.ISZERO(states) || JFactory.ISONE(states)) {
            return states;
        }
        if (current == relations.length) {
            return states;
        }
        BddCacheDataI entry = this.BddCache_lookupI(this.itecache, JFactory.QUADRUPLE(states, instance, current, 19));
        if (entry.a == states && entry.b == instance && entry.c == current && entry.d == 0 && entry.e == 19) {
            if (this.cachestats.enabled) {
                ++this.cachestats.opHit;
            }
            return entry.res;
        }
        if (this.cachestats.enabled) {
            ++this.cachestats.opMiss;
        }
        if (this.LEVEL(states) < this.LEVEL(vars[current])) {
            this.PUSHREF(this.saturationForward_rec(this.LOW(states), relations, vars, instance, current));
            this.PUSHREF(this.saturationForward_rec(this.HIGH(states), relations, vars, instance, current));
            result = this.bdd_makenode(this.LEVEL(states), this.READREF(2), this.READREF(1));
            this.POPREF(2);
        } else {
            int previousResult;
            int next;
            for (next = current; next < vars.length && this.LEVEL(vars[next]) == this.LEVEL(vars[current]); ++next) {
            }
            result = states;
            do {
                this.PUSHREF(result);
                result = this.saturationForward_rec(result, relations, vars, instance, next);
                this.POPREF(1);
                previousResult = result;
                this.PUSHREF(previousResult);
                for (int i = current; i < next; ++i) {
                    this.PUSHREF(result);
                    result = this.relnextUnion_rec(result, relations[i], result, vars[i]);
                    this.POPREF(1);
                }
                this.POPREF(1);
            } while (result != previousResult);
        }
        entry.a = states;
        entry.b = instance;
        entry.c = current;
        entry.d = 0;
        entry.e = 19;
        entry.res = result;
        return result;
    }

    int bdd_boundedSaturationForward(int states, int bound, int[] relations, int[] vars, int instance) {
        int result;
        int i;
        JFactory._assert(relations.length == vars.length);
        this.CHECKa(states);
        this.CHECKa(bound);
        for (i = 0; i < relations.length; ++i) {
            this.CHECKa(relations[i]);
            this.CHECKa(vars[i]);
        }
        for (i = 0; i < vars.length - 1; ++i) {
            JFactory._assert(this.LEVEL(vars[i]) <= this.LEVEL(vars[i + 1]));
        }
        if (this.applycache == null) {
            this.applycache = this.BddCacheI_init(this.cachesize);
        }
        if (this.itecache == null) {
            this.itecache = this.BddCacheI_init(this.cachesize);
        }
        this.applyop = 2;
        int numReorder = 1;
        while (true) {
            try {
                this.INITREF();
                if (numReorder == 0) {
                    this.bdd_disable_reorder();
                }
                result = this.boundedSaturationForward_rec(states, bound, relations, vars, instance, 0);
                if (numReorder != 0) break;
                this.bdd_enable_reorder();
            }
            catch (ReorderException x) {
                this.bdd_checkreorder();
                --numReorder;
                continue;
            }
            break;
        }
        this.checkresize();
        return result;
    }

    int boundedSaturationForward_rec(int states, int bound, int[] relations, int[] vars, int instance, int current) {
        int result;
        int level_bound;
        int level_states;
        int level;
        if (this.cachestats.enabled) {
            ++this.cachestats.opAccess;
        }
        if (JFactory.ISZERO(states) || JFactory.ISZERO(bound)) {
            return 0;
        }
        if (JFactory.ISONE(states)) {
            return 1;
        }
        if (JFactory.ISONE(bound)) {
            return this.saturationForward_rec(states, relations, vars, instance, current);
        }
        if (current == relations.length) {
            return states;
        }
        BddCacheDataI entry = this.BddCache_lookupI(this.itecache, JFactory.QUINTUPLE(states, bound, instance, current, 20));
        if (entry.a == states && entry.b == bound && entry.c == instance && entry.d == current && entry.e == 20) {
            if (this.cachestats.enabled) {
                ++this.cachestats.opHit;
            }
            return entry.res;
        }
        if (this.cachestats.enabled) {
            ++this.cachestats.opMiss;
        }
        int n = level = (level_states = this.LEVEL(states)) < (level_bound = this.LEVEL(bound)) ? level_states : level_bound;
        if (level < this.LEVEL(vars[current])) {
            int b1;
            int b0;
            int s1;
            int s0;
            if (level_states == level) {
                s0 = this.LOW(states);
                s1 = this.HIGH(states);
            } else {
                s0 = states;
                s1 = states;
            }
            if (level_bound == level) {
                b0 = this.LOW(bound);
                b1 = this.HIGH(bound);
            } else {
                b0 = bound;
                b1 = bound;
            }
            this.PUSHREF(this.boundedSaturationForward_rec(s0, b0, relations, vars, instance, current));
            this.PUSHREF(this.boundedSaturationForward_rec(s1, b1, relations, vars, instance, current));
            result = this.bdd_makenode(level, this.READREF(2), this.READREF(1));
            this.POPREF(2);
        } else {
            int previousResult;
            int next;
            for (next = current; next < vars.length && this.LEVEL(vars[next]) == this.LEVEL(vars[current]); ++next) {
            }
            result = states;
            do {
                this.PUSHREF(result);
                result = this.boundedSaturationForward_rec(result, bound, relations, vars, instance, next);
                this.POPREF(1);
                previousResult = result;
                this.PUSHREF(previousResult);
                for (int i = current; i < next; ++i) {
                    this.PUSHREF(result);
                    result = this.or_rec(this.PUSHREF(this.relnextIntersection_rec(result, relations[i], bound, vars[i])), result);
                    this.POPREF(2);
                }
                this.POPREF(1);
            } while (result != previousResult);
        }
        entry.a = states;
        entry.b = bound;
        entry.c = instance;
        entry.d = current;
        entry.e = 20;
        entry.res = result;
        return result;
    }

    int bdd_saturationBackward(int states, int[] relations, int[] vars, int instance) {
        int result;
        int i;
        JFactory._assert(relations.length == vars.length);
        this.CHECKa(states);
        for (i = 0; i < relations.length; ++i) {
            this.CHECKa(relations[i]);
            this.CHECKa(vars[i]);
        }
        for (i = 0; i < vars.length - 1; ++i) {
            JFactory._assert(this.LEVEL(vars[i]) <= this.LEVEL(vars[i + 1]));
        }
        if (this.applycache == null) {
            this.applycache = this.BddCacheI_init(this.cachesize);
        }
        if (this.itecache == null) {
            this.itecache = this.BddCacheI_init(this.cachesize);
        }
        this.applyop = 2;
        int numReorder = 1;
        while (true) {
            try {
                this.INITREF();
                if (numReorder == 0) {
                    this.bdd_disable_reorder();
                }
                result = this.saturationBackward_rec(states, relations, vars, instance, 0);
                if (numReorder != 0) break;
                this.bdd_enable_reorder();
            }
            catch (ReorderException x) {
                this.bdd_checkreorder();
                --numReorder;
                continue;
            }
            break;
        }
        this.checkresize();
        return result;
    }

    int saturationBackward_rec(int states, int[] relations, int[] vars, int instance, int current) {
        int result;
        if (this.cachestats.enabled) {
            ++this.cachestats.opAccess;
        }
        if (JFactory.ISZERO(states) || JFactory.ISONE(states)) {
            return states;
        }
        if (current == relations.length) {
            return states;
        }
        BddCacheDataI entry = this.BddCache_lookupI(this.itecache, JFactory.QUADRUPLE(states, instance, current, 21));
        if (entry.a == states && entry.b == instance && entry.c == current && entry.d == 0 && entry.e == 21) {
            if (this.cachestats.enabled) {
                ++this.cachestats.opHit;
            }
            return entry.res;
        }
        if (this.cachestats.enabled) {
            ++this.cachestats.opMiss;
        }
        if (this.LEVEL(states) < this.LEVEL(vars[current])) {
            this.PUSHREF(this.saturationBackward_rec(this.LOW(states), relations, vars, instance, current));
            this.PUSHREF(this.saturationBackward_rec(this.HIGH(states), relations, vars, instance, current));
            result = this.bdd_makenode(this.LEVEL(states), this.READREF(2), this.READREF(1));
            this.POPREF(2);
        } else {
            int previousResult;
            int next;
            for (next = current; next < vars.length && this.LEVEL(vars[next]) == this.LEVEL(vars[current]); ++next) {
            }
            result = states;
            do {
                this.PUSHREF(result);
                result = this.saturationBackward_rec(result, relations, vars, instance, next);
                this.POPREF(1);
                previousResult = result;
                this.PUSHREF(previousResult);
                for (int i = current; i < next; ++i) {
                    this.PUSHREF(result);
                    result = this.relprevUnion_rec(relations[i], result, result, vars[i]);
                    this.POPREF(1);
                }
                this.POPREF(1);
            } while (result != previousResult);
        }
        entry.a = states;
        entry.b = instance;
        entry.c = current;
        entry.d = 0;
        entry.e = 21;
        entry.res = result;
        return result;
    }

    int bdd_boundedSaturationBackward(int states, int bound, int[] relations, int[] vars, int instance) {
        int result;
        int i;
        JFactory._assert(relations.length == vars.length);
        this.CHECKa(states);
        this.CHECKa(bound);
        for (i = 0; i < relations.length; ++i) {
            this.CHECKa(relations[i]);
            this.CHECKa(vars[i]);
        }
        for (i = 0; i < vars.length - 1; ++i) {
            JFactory._assert(this.LEVEL(vars[i]) <= this.LEVEL(vars[i + 1]));
        }
        if (this.applycache == null) {
            this.applycache = this.BddCacheI_init(this.cachesize);
        }
        if (this.itecache == null) {
            this.itecache = this.BddCacheI_init(this.cachesize);
        }
        this.applyop = 2;
        int numReorder = 1;
        while (true) {
            try {
                this.INITREF();
                if (numReorder == 0) {
                    this.bdd_disable_reorder();
                }
                result = this.boundedSaturationBackward_rec(states, bound, relations, vars, instance, 0);
                if (numReorder != 0) break;
                this.bdd_enable_reorder();
            }
            catch (ReorderException x) {
                this.bdd_checkreorder();
                --numReorder;
                continue;
            }
            break;
        }
        this.checkresize();
        return result;
    }

    int boundedSaturationBackward_rec(int states, int bound, int[] relations, int[] vars, int instance, int current) {
        int result;
        int level_bound;
        int level_states;
        int level;
        if (this.cachestats.enabled) {
            ++this.cachestats.opAccess;
        }
        if (JFactory.ISZERO(states) || JFactory.ISZERO(bound)) {
            return 0;
        }
        if (JFactory.ISONE(states)) {
            return 1;
        }
        if (JFactory.ISONE(bound)) {
            return this.saturationBackward_rec(states, relations, vars, instance, current);
        }
        if (current == relations.length) {
            return states;
        }
        BddCacheDataI entry = this.BddCache_lookupI(this.itecache, JFactory.QUINTUPLE(states, bound, instance, current, 22));
        if (entry.a == states && entry.b == bound && entry.c == instance && entry.d == current && entry.e == 22) {
            if (this.cachestats.enabled) {
                ++this.cachestats.opHit;
            }
            return entry.res;
        }
        if (this.cachestats.enabled) {
            ++this.cachestats.opMiss;
        }
        int n = level = (level_states = this.LEVEL(states)) < (level_bound = this.LEVEL(bound)) ? level_states : level_bound;
        if (level < this.LEVEL(vars[current])) {
            int b1;
            int b0;
            int s1;
            int s0;
            if (level_states == level) {
                s0 = this.LOW(states);
                s1 = this.HIGH(states);
            } else {
                s0 = states;
                s1 = states;
            }
            if (level_bound == level) {
                b0 = this.LOW(bound);
                b1 = this.HIGH(bound);
            } else {
                b0 = bound;
                b1 = bound;
            }
            this.PUSHREF(this.boundedSaturationBackward_rec(s0, b0, relations, vars, instance, current));
            this.PUSHREF(this.boundedSaturationBackward_rec(s1, b1, relations, vars, instance, current));
            result = this.bdd_makenode(level, this.READREF(2), this.READREF(1));
            this.POPREF(2);
        } else {
            int previousResult;
            int next;
            for (next = current; next < vars.length && this.LEVEL(vars[next]) == this.LEVEL(vars[current]); ++next) {
            }
            result = states;
            do {
                this.PUSHREF(result);
                result = this.boundedSaturationBackward_rec(result, bound, relations, vars, instance, next);
                this.POPREF(1);
                previousResult = result;
                this.PUSHREF(previousResult);
                for (int i = current; i < next; ++i) {
                    this.PUSHREF(result);
                    result = this.or_rec(this.PUSHREF(this.relprevIntersection_rec(relations[i], result, bound, vars[i])), result);
                    this.POPREF(2);
                }
                this.POPREF(1);
            } while (result != previousResult);
        }
        entry.a = states;
        entry.b = bound;
        entry.c = instance;
        entry.d = current;
        entry.e = 22;
        entry.res = result;
        return result;
    }

    int relprod_rec(int l, int r) {
        int res;
        if (this.cachestats.enabled) {
            ++this.cachestats.opAccess;
        }
        if (l == 0 || r == 0) {
            return 0;
        }
        if (l == r) {
            return this.quant_rec(l);
        }
        if (l == 1) {
            return this.quant_rec(r);
        }
        if (r == 1) {
            return this.quant_rec(l);
        }
        int LEVEL_l = this.LEVEL(l);
        int LEVEL_r = this.LEVEL(r);
        if (LEVEL_l > this.quantlast && LEVEL_r > this.quantlast) {
            this.applyop = 0;
            res = this.and_rec(l, r);
            this.applyop = 2;
        } else {
            BddCacheDataI entry = this.BddCache_lookupI(this.appexcache, JFactory.APPEXHASH(l, r, 0));
            if (entry.a == l && entry.b == r && entry.c == this.appexid) {
                if (this.cachestats.enabled) {
                    ++this.cachestats.opHit;
                }
                return entry.res;
            }
            if (this.cachestats.enabled) {
                ++this.cachestats.opMiss;
            }
            if (LEVEL_l == LEVEL_r) {
                this.PUSHREF(this.relprod_rec(this.LOW(l), this.LOW(r)));
                this.PUSHREF(this.relprod_rec(this.HIGH(l), this.HIGH(r)));
                res = this.INVARSET(LEVEL_l) ? this.or_rec(this.READREF(2), this.READREF(1)) : this.bdd_makenode(LEVEL_l, this.READREF(2), this.READREF(1));
            } else if (LEVEL_l < LEVEL_r) {
                this.PUSHREF(this.relprod_rec(this.LOW(l), r));
                this.PUSHREF(this.relprod_rec(this.HIGH(l), r));
                res = this.INVARSET(LEVEL_l) ? this.or_rec(this.READREF(2), this.READREF(1)) : this.bdd_makenode(LEVEL_l, this.READREF(2), this.READREF(1));
            } else {
                this.PUSHREF(this.relprod_rec(l, this.LOW(r)));
                this.PUSHREF(this.relprod_rec(l, this.HIGH(r)));
                res = this.INVARSET(LEVEL_r) ? this.or_rec(this.READREF(2), this.READREF(1)) : this.bdd_makenode(LEVEL_r, this.READREF(2), this.READREF(1));
            }
            this.POPREF(2);
            entry.a = l;
            entry.b = r;
            entry.c = this.appexid;
            entry.res = res;
        }
        return res;
    }

    int bdd_relprod(int a, int b, int var) {
        return this.bdd_appex(a, b, 0, var);
    }

    int bdd_appex(int l, int r, int opr, int var) {
        int res;
        int numReorder = 1;
        this.CHECKa(l);
        this.CHECKa(r);
        this.CHECKa(var);
        if (opr < 0 || opr > 9) {
            JFactory.bdd_error(-12);
            return 0;
        }
        if (var < 2) {
            return this.bdd_apply(l, r, opr);
        }
        if (this.applycache == null) {
            this.applycache = this.BddCacheI_init(this.cachesize);
        }
        if (this.appexcache == null) {
            this.appexcache = this.BddCacheI_init(this.cachesize);
        }
        if (this.quantcache == null) {
            this.quantcache = this.BddCacheI_init(this.cachesize);
        }
        while (true) {
            if (this.varset2vartable(var) < 0) {
                return 0;
            }
            try {
                this.INITREF();
                this.applyop = 2;
                this.appexop = opr;
                this.appexid = var << 5 | this.appexop << 1;
                this.quantid = this.appexid << 3 | 3;
                if (numReorder == 0) {
                    this.bdd_disable_reorder();
                }
                res = opr == 0 ? (this.ZDD ? this.zrelprod_rec(l, r, 0) : this.relprod_rec(l, r)) : this.appquant_rec(l, r);
                if (numReorder != 0) break;
                this.bdd_enable_reorder();
            }
            catch (ReorderException x) {
                this.bdd_checkreorder();
                --numReorder;
                continue;
            }
            break;
        }
        this.checkresize();
        return res;
    }

    int varset2vartable(int r) {
        if (r < 2) {
            return JFactory.bdd_error(-13);
        }
        ++this.quantvarsetID;
        if (this.quantvarsetID == Integer.MAX_VALUE) {
            for (int i = 0; i < this.bddvarnum; ++i) {
                this.quantvarset[i] = 0;
            }
            this.quantvarsetID = 1;
        }
        this.quantlast = -1;
        int n = r;
        while (n > 1) {
            this.quantvarset[this.LEVEL((int)n)] = this.quantvarsetID;
            this.quantlast = this.LEVEL(n);
            n = this.HIGH(n);
        }
        return 0;
    }

    int varset2svartable(int r) {
        if (r < 2) {
            return JFactory.bdd_error(-13);
        }
        ++this.quantvarsetID;
        if (this.quantvarsetID == 0x3FFFFFFF) {
            for (int i = 0; i < this.bddvarnum; ++i) {
                this.quantvarset[i] = 0;
            }
            this.quantvarsetID = 1;
        }
        this.quantlast = 0;
        int n = r;
        while (!JFactory.ISCONST(n)) {
            if (JFactory.ISZERO(this.LOW(n))) {
                this.quantvarset[this.LEVEL((int)n)] = this.quantvarsetID;
                n = this.HIGH(n);
            } else {
                this.quantvarset[this.LEVEL((int)n)] = -this.quantvarsetID;
                n = this.LOW(n);
            }
            this.quantlast = this.LEVEL(n);
        }
        return 0;
    }

    int appquant_rec(int l, int r) {
        int res;
        if (this.cachestats.enabled) {
            ++this.cachestats.opAccess;
        }
        switch (this.appexop) {
            case 2: {
                if (l == 1 || r == 1) {
                    return 1;
                }
                if (l == r) {
                    return this.quant_rec(l);
                }
                if (l == 0) {
                    return this.quant_rec(r);
                }
                if (r != 0) break;
                return this.quant_rec(l);
            }
            case 1: {
                if (l == r) {
                    return 0;
                }
                if (l == 0) {
                    return this.quant_rec(r);
                }
                if (r != 0) break;
                return this.quant_rec(l);
            }
            case 3: {
                if (l != 0 && r != 0) break;
                return 1;
            }
            case 4: {
                if (l != 1 && r != 1) break;
                return 0;
            }
        }
        if (JFactory.ISCONST(l) && JFactory.ISCONST(r)) {
            res = oprres[this.appexop][l << 1 | r];
        } else if (this.LEVEL(l) > this.quantlast && this.LEVEL(r) > this.quantlast) {
            int oldop = this.applyop;
            this.applyop = this.appexop;
            switch (this.applyop) {
                case 0: {
                    res = this.and_rec(l, r);
                    break;
                }
                case 2: {
                    res = this.or_rec(l, r);
                    break;
                }
                default: {
                    res = this.apply_rec(l, r);
                }
            }
            this.applyop = oldop;
        } else {
            int lev;
            BddCacheDataI entry = this.BddCache_lookupI(this.appexcache, JFactory.APPEXHASH(l, r, this.appexop));
            if (entry.a == l && entry.b == r && entry.c == this.appexid) {
                if (this.cachestats.enabled) {
                    ++this.cachestats.opHit;
                }
                return entry.res;
            }
            if (this.cachestats.enabled) {
                ++this.cachestats.opMiss;
            }
            if (this.LEVEL(l) == this.LEVEL(r)) {
                this.PUSHREF(this.appquant_rec(this.LOW(l), this.LOW(r)));
                this.PUSHREF(this.appquant_rec(this.HIGH(l), this.HIGH(r)));
                lev = this.LEVEL(l);
            } else if (this.LEVEL(l) < this.LEVEL(r)) {
                this.PUSHREF(this.appquant_rec(this.LOW(l), r));
                this.PUSHREF(this.appquant_rec(this.HIGH(l), r));
                lev = this.LEVEL(l);
            } else {
                this.PUSHREF(this.appquant_rec(l, this.LOW(r)));
                this.PUSHREF(this.appquant_rec(l, this.HIGH(r)));
                lev = this.LEVEL(r);
            }
            if (this.INVARSET(lev)) {
                int r2 = this.READREF(2);
                int r1 = this.READREF(1);
                switch (this.applyop) {
                    case 0: {
                        res = this.and_rec(r2, r1);
                        break;
                    }
                    case 2: {
                        res = this.or_rec(r2, r1);
                        break;
                    }
                    default: {
                        res = this.apply_rec(r2, r1);
                        break;
                    }
                }
            } else {
                res = this.bdd_makenode(lev, this.READREF(2), this.READREF(1));
            }
            this.POPREF(2);
            entry.a = l;
            entry.b = r;
            entry.c = this.appexid;
            entry.res = res;
        }
        return res;
    }

    int appuni_rec(int l, int r, int var) {
        int res;
        if (this.cachestats.enabled) {
            ++this.cachestats.opAccess;
        }
        int LEVEL_l = this.LEVEL(l);
        int LEVEL_r = this.LEVEL(r);
        int LEVEL_var = this.LEVEL(var);
        if (LEVEL_l > LEVEL_var && LEVEL_r > LEVEL_var) {
            return 0;
        }
        if (JFactory.ISCONST(l) && JFactory.ISCONST(r)) {
            res = oprres[this.appexop][l << 1 | r];
        } else if (JFactory.ISCONST(var)) {
            int oldop = this.applyop;
            this.applyop = this.appexop;
            switch (this.applyop) {
                case 0: {
                    res = this.and_rec(l, r);
                    break;
                }
                case 2: {
                    res = this.or_rec(l, r);
                    break;
                }
                default: {
                    res = this.apply_rec(l, r);
                }
            }
            this.applyop = oldop;
        } else {
            int lev;
            BddCacheDataI entry = this.BddCache_lookupI(this.appexcache, JFactory.APPEXHASH(l, r, this.appexop));
            if (entry.a == l && entry.b == r && entry.c == this.appexid) {
                if (this.cachestats.enabled) {
                    ++this.cachestats.opHit;
                }
                return entry.res;
            }
            if (this.cachestats.enabled) {
                ++this.cachestats.opMiss;
            }
            if (LEVEL_l == LEVEL_r) {
                if (LEVEL_l == LEVEL_var) {
                    lev = -1;
                    var = this.HIGH(var);
                } else {
                    lev = LEVEL_l;
                }
                this.PUSHREF(this.appuni_rec(this.LOW(l), this.LOW(r), var));
                this.PUSHREF(this.appuni_rec(this.HIGH(l), this.HIGH(r), var));
                lev = LEVEL_l;
            } else if (LEVEL_l < LEVEL_r) {
                if (LEVEL_l == LEVEL_var) {
                    lev = -1;
                    var = this.HIGH(var);
                } else {
                    lev = LEVEL_l;
                }
                this.PUSHREF(this.appuni_rec(this.LOW(l), r, var));
                this.PUSHREF(this.appuni_rec(this.HIGH(l), r, var));
            } else {
                if (LEVEL_r == LEVEL_var) {
                    lev = -1;
                    var = this.HIGH(var);
                } else {
                    lev = LEVEL_r;
                }
                this.PUSHREF(this.appuni_rec(l, this.LOW(r), var));
                this.PUSHREF(this.appuni_rec(l, this.HIGH(r), var));
            }
            if (lev == -1) {
                int r2 = this.READREF(2);
                int r1 = this.READREF(1);
                switch (this.applyop) {
                    case 0: {
                        res = this.and_rec(r2, r1);
                        break;
                    }
                    case 2: {
                        res = this.or_rec(r2, r1);
                        break;
                    }
                    default: {
                        res = this.apply_rec(r2, r1);
                        break;
                    }
                }
            } else {
                res = this.bdd_makenode(lev, this.READREF(2), this.READREF(1));
            }
            this.POPREF(2);
            entry.a = l;
            entry.b = r;
            entry.c = this.appexid;
            entry.res = res;
        }
        return res;
    }

    int unique_rec(int r, int q) {
        int res;
        int LEVEL_q;
        int LEVEL_r;
        if (this.cachestats.enabled) {
            ++this.cachestats.opAccess;
        }
        if ((LEVEL_r = this.LEVEL(r)) > (LEVEL_q = this.LEVEL(q))) {
            return 0;
        }
        if (r < 2 || q < 2) {
            return r;
        }
        BddCacheDataI entry = this.BddCache_lookupI(this.quantcache, JFactory.QUANTHASH(r));
        if (entry.a == r && entry.c == this.quantid) {
            if (this.cachestats.enabled) {
                ++this.cachestats.opHit;
            }
            return entry.res;
        }
        if (this.cachestats.enabled) {
            ++this.cachestats.opMiss;
        }
        if (LEVEL_r == LEVEL_q) {
            this.PUSHREF(this.unique_rec(this.LOW(r), this.HIGH(q)));
            this.PUSHREF(this.unique_rec(this.HIGH(r), this.HIGH(q)));
            res = this.apply_rec(this.READREF(2), this.READREF(1));
        } else {
            this.PUSHREF(this.unique_rec(this.LOW(r), q));
            this.PUSHREF(this.unique_rec(this.HIGH(r), q));
            res = this.bdd_makenode(this.LEVEL(r), this.READREF(2), this.READREF(1));
        }
        this.POPREF(2);
        entry.a = r;
        entry.c = this.quantid;
        entry.res = res;
        return res;
    }

    int quant_rec(int r) {
        int res;
        if (this.cachestats.enabled) {
            ++this.cachestats.opAccess;
        }
        if (r < 2 || this.LEVEL(r) > this.quantlast) {
            return r;
        }
        BddCacheDataI entry = this.BddCache_lookupI(this.quantcache, JFactory.QUANTHASH(r));
        if (entry.a == r && entry.c == this.quantid) {
            if (this.cachestats.enabled) {
                ++this.cachestats.opHit;
            }
            return entry.res;
        }
        if (this.cachestats.enabled) {
            ++this.cachestats.opMiss;
        }
        this.PUSHREF(this.quant_rec(this.LOW(r)));
        this.PUSHREF(this.quant_rec(this.HIGH(r)));
        if (this.INVARSET(this.LEVEL(r))) {
            int r2 = this.READREF(2);
            int r1 = this.READREF(1);
            switch (this.applyop) {
                case 0: {
                    res = this.and_rec(r2, r1);
                    break;
                }
                case 2: {
                    res = this.or_rec(r2, r1);
                    break;
                }
                default: {
                    res = this.apply_rec(r2, r1);
                    break;
                }
            }
        } else {
            res = this.bdd_makenode(this.LEVEL(r), this.READREF(2), this.READREF(1));
        }
        this.POPREF(2);
        entry.a = r;
        entry.c = this.quantid;
        entry.res = res;
        return res;
    }

    int zquant_rec(int r, int lev) {
        int res;
        if (this.cachestats.enabled) {
            ++this.cachestats.opAccess;
        }
        while (true) {
            if (lev > this.quantlast) {
                return r;
            }
            if (lev == this.LEVEL(r)) break;
            if (this.INVARSET(lev)) {
                switch (this.applyop) {
                    case 0: {
                        return 0;
                    }
                    case 2: {
                        this.PUSHREF(this.zquant_rec(r, lev + 1));
                        int res2 = this.zdd_makenode(lev, this.READREF(1), this.READREF(1));
                        this.POPREF(1);
                        return res2;
                    }
                }
                throw new BDDException();
            }
            ++lev;
        }
        if (r < 2) {
            return r;
        }
        BddCacheDataI entry = this.BddCache_lookupI(this.quantcache, JFactory.QUANTHASH(r));
        if (entry.a == r && entry.c == this.quantid) {
            if (this.cachestats.enabled) {
                ++this.cachestats.opHit;
            }
            return entry.res;
        }
        if (this.cachestats.enabled) {
            ++this.cachestats.opMiss;
        }
        int nlev = this.LEVEL(r) + 1;
        this.PUSHREF(this.zquant_rec(this.LOW(r), nlev));
        this.PUSHREF(this.zquant_rec(this.HIGH(r), nlev));
        if (this.INVARSET(this.LEVEL(r))) {
            int r2 = this.READREF(2);
            int r1 = this.READREF(1);
            switch (this.applyop) {
                case 0: {
                    res = this.zand_rec(r2, r1);
                    break;
                }
                case 2: {
                    res = this.zor_rec(r2, r1);
                    break;
                }
                default: {
                    throw new BDDException();
                }
            }
            this.POPREF(2);
            this.PUSHREF(res);
            res = this.zdd_makenode(this.LEVEL(r), this.READREF(1), this.READREF(1));
            this.POPREF(1);
        } else {
            res = this.zdd_makenode(this.LEVEL(r), this.READREF(2), this.READREF(1));
            this.POPREF(2);
        }
        entry.a = r;
        entry.c = this.quantid;
        entry.res = res;
        return res;
    }

    int bdd_constrain(int f, int c) {
        int res;
        int numReorder = 1;
        this.CHECKa(f);
        this.CHECKa(c);
        if (this.misccache == null) {
            this.misccache = this.BddCacheI_init(this.cachesize);
        }
        while (true) {
            try {
                this.INITREF();
                this.miscid = 0;
                if (numReorder == 0) {
                    this.bdd_disable_reorder();
                }
                res = this.constrain_rec(f, c);
                if (numReorder != 0) break;
                this.bdd_enable_reorder();
            }
            catch (ReorderException x) {
                this.bdd_checkreorder();
                --numReorder;
                continue;
            }
            break;
        }
        this.checkresize();
        return res;
    }

    int constrain_rec(int f, int c) {
        int res;
        if (this.cachestats.enabled) {
            ++this.cachestats.opAccess;
        }
        if (JFactory.ISONE(c)) {
            return f;
        }
        if (JFactory.ISCONST(f)) {
            return f;
        }
        if (c == f) {
            return 1;
        }
        if (JFactory.ISZERO(c)) {
            return 0;
        }
        BddCacheDataI entry = this.BddCache_lookupI(this.misccache, JFactory.CONSTRAINHASH(f, c));
        if (entry.a == f && entry.b == c && entry.c == this.miscid) {
            if (this.cachestats.enabled) {
                ++this.cachestats.opHit;
            }
            return entry.res;
        }
        if (this.cachestats.enabled) {
            ++this.cachestats.opMiss;
        }
        if (this.LEVEL(f) == this.LEVEL(c)) {
            if (JFactory.ISZERO(this.LOW(c))) {
                res = this.constrain_rec(this.HIGH(f), this.HIGH(c));
            } else if (JFactory.ISZERO(this.HIGH(c))) {
                res = this.constrain_rec(this.LOW(f), this.LOW(c));
            } else {
                this.PUSHREF(this.constrain_rec(this.LOW(f), this.LOW(c)));
                this.PUSHREF(this.constrain_rec(this.HIGH(f), this.HIGH(c)));
                res = this.bdd_makenode(this.LEVEL(f), this.READREF(2), this.READREF(1));
                this.POPREF(2);
            }
        } else if (this.LEVEL(f) < this.LEVEL(c)) {
            this.PUSHREF(this.constrain_rec(this.LOW(f), c));
            this.PUSHREF(this.constrain_rec(this.HIGH(f), c));
            res = this.bdd_makenode(this.LEVEL(f), this.READREF(2), this.READREF(1));
            this.POPREF(2);
        } else if (JFactory.ISZERO(this.LOW(c))) {
            res = this.constrain_rec(f, this.HIGH(c));
        } else if (JFactory.ISZERO(this.HIGH(c))) {
            res = this.constrain_rec(f, this.LOW(c));
        } else {
            this.PUSHREF(this.constrain_rec(f, this.LOW(c)));
            this.PUSHREF(this.constrain_rec(f, this.HIGH(c)));
            res = this.bdd_makenode(this.LEVEL(c), this.READREF(2), this.READREF(1));
            this.POPREF(2);
        }
        entry.a = f;
        entry.b = c;
        entry.c = this.miscid;
        entry.res = res;
        return res;
    }

    int bdd_compose(int f, int g, int var) {
        int res;
        int numReorder = 1;
        this.CHECKa(f);
        this.CHECKa(g);
        if (var < 0 || var >= this.bddvarnum) {
            JFactory.bdd_error(-2);
            return 0;
        }
        if (this.applycache == null) {
            this.applycache = this.BddCacheI_init(this.cachesize);
        }
        if (this.itecache == null) {
            this.itecache = this.BddCacheI_init(this.cachesize);
        }
        while (true) {
            try {
                this.INITREF();
                this.composelevel = this.bddvar2level[var];
                this.replaceid = this.composelevel << 2 | 1;
                if (numReorder == 0) {
                    this.bdd_disable_reorder();
                }
                res = this.compose_rec(f, g);
                if (numReorder != 0) break;
                this.bdd_enable_reorder();
            }
            catch (ReorderException x) {
                this.bdd_checkreorder();
                --numReorder;
                continue;
            }
            break;
        }
        this.checkresize();
        return res;
    }

    int compose_rec(int f, int g) {
        int res;
        if (this.cachestats.enabled) {
            ++this.cachestats.opAccess;
        }
        if (this.LEVEL(f) > this.composelevel) {
            return f;
        }
        BddCacheDataI entry = this.BddCache_lookupI(this.replacecache, JFactory.COMPOSEHASH(f, g));
        if (entry.a == f && entry.b == g && entry.c == this.replaceid) {
            if (this.cachestats.enabled) {
                ++this.cachestats.opHit;
            }
            return entry.res;
        }
        if (this.cachestats.enabled) {
            ++this.cachestats.opMiss;
        }
        if (this.LEVEL(f) < this.composelevel) {
            if (this.LEVEL(f) == this.LEVEL(g)) {
                this.PUSHREF(this.compose_rec(this.LOW(f), this.LOW(g)));
                this.PUSHREF(this.compose_rec(this.HIGH(f), this.HIGH(g)));
                res = this.bdd_makenode(this.LEVEL(f), this.READREF(2), this.READREF(1));
            } else if (this.LEVEL(f) < this.LEVEL(g)) {
                this.PUSHREF(this.compose_rec(this.LOW(f), g));
                this.PUSHREF(this.compose_rec(this.HIGH(f), g));
                res = this.bdd_makenode(this.LEVEL(f), this.READREF(2), this.READREF(1));
            } else {
                this.PUSHREF(this.compose_rec(f, this.LOW(g)));
                this.PUSHREF(this.compose_rec(f, this.HIGH(g)));
                res = this.bdd_makenode(this.LEVEL(g), this.READREF(2), this.READREF(1));
            }
            this.POPREF(2);
        } else {
            res = this.ite_rec(g, this.HIGH(f), this.LOW(f));
        }
        entry.a = f;
        entry.b = g;
        entry.c = this.replaceid;
        entry.res = res;
        return res;
    }

    int bdd_veccompose(int f, bddPair pair) {
        int res;
        int numReorder = 1;
        this.CHECKa(f);
        if (this.applycache == null) {
            this.applycache = this.BddCacheI_init(this.cachesize);
        }
        if (this.itecache == null) {
            this.itecache = this.BddCacheI_init(this.cachesize);
        }
        if (this.replacecache == null) {
            this.replacecache = this.BddCacheI_init(this.cachesize);
        }
        while (true) {
            try {
                this.INITREF();
                this.replacepair = pair.result;
                this.replaceid = pair.id << 2 | 2;
                this.replacelast = pair.last;
                if (numReorder == 0) {
                    this.bdd_disable_reorder();
                }
                res = this.veccompose_rec(f);
                if (numReorder != 0) break;
                this.bdd_enable_reorder();
            }
            catch (ReorderException x) {
                this.bdd_checkreorder();
                --numReorder;
                continue;
            }
            break;
        }
        this.checkresize();
        return res;
    }

    int veccompose_rec(int f) {
        if (this.cachestats.enabled) {
            ++this.cachestats.opAccess;
        }
        if (this.LEVEL(f) > this.replacelast) {
            return f;
        }
        BddCacheDataI entry = this.BddCache_lookupI(this.replacecache, JFactory.VECCOMPOSEHASH(f));
        if (entry.a == f && entry.c == this.replaceid) {
            if (this.cachestats.enabled) {
                ++this.cachestats.opHit;
            }
            return entry.res;
        }
        if (this.cachestats.enabled) {
            ++this.cachestats.opMiss;
        }
        this.PUSHREF(this.veccompose_rec(this.LOW(f)));
        this.PUSHREF(this.veccompose_rec(this.HIGH(f)));
        int res = this.ite_rec(this.replacepair[this.LEVEL(f)], this.READREF(1), this.READREF(2));
        this.POPREF(2);
        entry.a = f;
        entry.c = this.replaceid;
        entry.res = res;
        return res;
    }

    int bdd_exist(int r, int var) {
        int res;
        int numReorder = 1;
        this.CHECKa(r);
        this.CHECKa(var);
        if (var < 2) {
            return r;
        }
        if (this.applycache == null) {
            this.applycache = this.BddCacheI_init(this.cachesize);
        }
        if (this.quantcache == null) {
            this.quantcache = this.BddCacheI_init(this.cachesize);
        }
        while (true) {
            if (this.varset2vartable(var) < 0) {
                return 0;
            }
            try {
                this.INITREF();
                this.quantid = var << 3 | 0;
                this.applyop = 2;
                if (numReorder == 0) {
                    this.bdd_disable_reorder();
                }
                int n = res = this.ZDD ? this.zquant_rec(r, 0) : this.quant_rec(r);
                if (numReorder != 0) break;
                this.bdd_enable_reorder();
            }
            catch (ReorderException x) {
                this.bdd_checkreorder();
                --numReorder;
                continue;
            }
            break;
        }
        this.checkresize();
        return res;
    }

    int bdd_forall(int r, int var) {
        int res;
        int numReorder = 1;
        this.CHECKa(r);
        this.CHECKa(var);
        if (var < 2) {
            return r;
        }
        if (this.applycache == null) {
            this.applycache = this.BddCacheI_init(this.cachesize);
        }
        if (this.quantcache == null) {
            this.quantcache = this.BddCacheI_init(this.cachesize);
        }
        while (true) {
            if (this.varset2vartable(var) < 0) {
                return 0;
            }
            try {
                this.INITREF();
                this.quantid = var << 3 | 1;
                this.applyop = 0;
                if (numReorder == 0) {
                    this.bdd_disable_reorder();
                }
                int n = res = this.ZDD ? this.zquant_rec(r, 0) : this.quant_rec(r);
                if (numReorder != 0) break;
                this.bdd_enable_reorder();
            }
            catch (ReorderException x) {
                this.bdd_checkreorder();
                --numReorder;
                continue;
            }
            break;
        }
        this.checkresize();
        return res;
    }

    int bdd_unique(int r, int var) {
        int res;
        int numReorder = 1;
        this.CHECKa(r);
        this.CHECKa(var);
        if (var < 2) {
            return r;
        }
        if (this.applycache == null) {
            this.applycache = this.BddCacheI_init(this.cachesize);
        }
        if (this.quantcache == null) {
            this.quantcache = this.BddCacheI_init(this.cachesize);
        }
        while (true) {
            try {
                this.INITREF();
                this.quantid = var << 3 | 2;
                this.applyop = 1;
                if (numReorder == 0) {
                    this.bdd_disable_reorder();
                }
                res = this.unique_rec(r, var);
                if (numReorder != 0) break;
                this.bdd_enable_reorder();
            }
            catch (ReorderException x) {
                this.bdd_checkreorder();
                --numReorder;
                continue;
            }
            break;
        }
        this.checkresize();
        return res;
    }

    int bdd_restrict(int r, int var) {
        int res;
        int numReorder = 1;
        this.CHECKa(r);
        this.CHECKa(var);
        if (var < 2) {
            return r;
        }
        if (this.misccache == null) {
            this.misccache = this.BddCacheI_init(this.cachesize);
        }
        while (true) {
            if (this.varset2svartable(var) < 0) {
                return 0;
            }
            try {
                this.INITREF();
                this.miscid = var << 3 | 1;
                if (numReorder == 0) {
                    this.bdd_disable_reorder();
                }
                res = this.restrict_rec(r);
                if (numReorder != 0) break;
                this.bdd_enable_reorder();
            }
            catch (ReorderException x) {
                this.bdd_checkreorder();
                --numReorder;
                continue;
            }
            break;
        }
        this.checkresize();
        return res;
    }

    int restrict_rec(int r) {
        int res;
        if (this.cachestats.enabled) {
            ++this.cachestats.opAccess;
        }
        if (JFactory.ISCONST(r) || this.LEVEL(r) > this.quantlast) {
            return r;
        }
        BddCacheDataI entry = this.BddCache_lookupI(this.misccache, JFactory.RESTRHASH(r, this.miscid));
        if (entry.a == r && entry.c == this.miscid) {
            if (this.cachestats.enabled) {
                ++this.cachestats.opHit;
            }
            return entry.res;
        }
        if (this.cachestats.enabled) {
            ++this.cachestats.opMiss;
        }
        if (this.INSVARSET(this.LEVEL(r))) {
            res = this.quantvarset[this.LEVEL(r)] > 0 ? this.restrict_rec(this.HIGH(r)) : this.restrict_rec(this.LOW(r));
        } else {
            this.PUSHREF(this.restrict_rec(this.LOW(r)));
            this.PUSHREF(this.restrict_rec(this.HIGH(r)));
            res = this.bdd_makenode(this.LEVEL(r), this.READREF(2), this.READREF(1));
            this.POPREF(2);
        }
        entry.a = r;
        entry.c = this.miscid;
        entry.res = res;
        return res;
    }

    int bdd_simplify(int f, int d) {
        int res;
        int numReorder = 1;
        this.CHECKa(f);
        this.CHECKa(d);
        if (this.applycache == null) {
            this.applycache = this.BddCacheI_init(this.cachesize);
        }
        while (true) {
            try {
                this.INITREF();
                this.applyop = 2;
                if (numReorder == 0) {
                    this.bdd_disable_reorder();
                }
                res = this.simplify_rec(f, d);
                if (numReorder != 0) break;
                this.bdd_enable_reorder();
            }
            catch (ReorderException x) {
                this.bdd_checkreorder();
                --numReorder;
                continue;
            }
            break;
        }
        this.checkresize();
        return res;
    }

    int simplify_rec(int f, int d) {
        int res;
        if (this.cachestats.enabled) {
            ++this.cachestats.opAccess;
        }
        if (JFactory.ISONE(d) || JFactory.ISCONST(f)) {
            return f;
        }
        if (d == f) {
            return 1;
        }
        if (JFactory.ISZERO(d)) {
            return 0;
        }
        BddCacheDataI entry = this.BddCache_lookupI(this.applycache, JFactory.APPLYHASH(f, d, 11));
        if (entry.a == f && entry.b == d && entry.c == 11) {
            if (this.cachestats.enabled) {
                ++this.cachestats.opHit;
            }
            return entry.res;
        }
        if (this.cachestats.enabled) {
            ++this.cachestats.opMiss;
        }
        if (this.LEVEL(f) == this.LEVEL(d)) {
            if (JFactory.ISZERO(this.LOW(d))) {
                res = this.simplify_rec(this.HIGH(f), this.HIGH(d));
            } else if (JFactory.ISZERO(this.HIGH(d))) {
                res = this.simplify_rec(this.LOW(f), this.LOW(d));
            } else {
                this.PUSHREF(this.simplify_rec(this.LOW(f), this.LOW(d)));
                this.PUSHREF(this.simplify_rec(this.HIGH(f), this.HIGH(d)));
                res = this.bdd_makenode(this.LEVEL(f), this.READREF(2), this.READREF(1));
                this.POPREF(2);
            }
        } else if (this.LEVEL(f) < this.LEVEL(d)) {
            this.PUSHREF(this.simplify_rec(this.LOW(f), d));
            this.PUSHREF(this.simplify_rec(this.HIGH(f), d));
            res = this.bdd_makenode(this.LEVEL(f), this.READREF(2), this.READREF(1));
            this.POPREF(2);
        } else {
            this.PUSHREF(this.or_rec(this.LOW(d), this.HIGH(d)));
            res = this.simplify_rec(f, this.READREF(1));
            this.POPREF(1);
        }
        entry.a = f;
        entry.b = d;
        entry.c = 11;
        entry.res = res;
        return res;
    }

    int bdd_support(int r) {
        int res = 1;
        this.CHECKa(r);
        if (r < 2) {
            return 1;
        }
        if (this.supportSize < this.bddvarnum) {
            this.supportSet = new int[this.bddvarnum];
            this.supportSize = this.bddvarnum;
            this.supportID = 0;
        }
        if (this.supportID == 0xFFFFFFF) {
            for (int i = 0; i < this.bddvarnum; ++i) {
                this.supportSet[i] = 0;
            }
            this.supportID = 0;
        }
        ++this.supportID;
        this.supportMax = this.supportMin = this.LEVEL(r);
        if (this.ZDD) {
            this.zsupport_rec(r, 0, this.supportSet);
        } else {
            this.support_rec(r, this.supportSet);
        }
        this.bdd_unmark(r);
        this.bdd_disable_reorder();
        for (int n = this.supportMax; n >= this.supportMin; --n) {
            if (this.supportSet[n] != this.supportID) continue;
            this.bdd_addref(res);
            int tmp = this.makenode_impl(n, 0, res);
            this.bdd_delref(res);
            res = tmp;
        }
        this.bdd_enable_reorder();
        return res;
    }

    void support_rec(int r, int[] support) {
        if (r < 2) {
            return;
        }
        if (this.MARKED(r) || this.LOW(r) == -1) {
            return;
        }
        support[this.LEVEL((int)r)] = this.supportID;
        if (this.LEVEL(r) > this.supportMax) {
            this.supportMax = this.LEVEL(r);
        }
        this.SETMARK(r);
        this.support_rec(this.LOW(r), support);
        this.support_rec(this.HIGH(r), support);
    }

    void zsupport_rec(int r, int lev, int[] support) {
        if (!JFactory.ISZERO(r)) {
            while (lev != this.LEVEL(r)) {
                if (lev > this.supportMax) {
                    this.supportMax = lev;
                }
                support[lev++] = this.supportID;
            }
        }
        if (r < 2) {
            return;
        }
        if (this.MARKED(r) || this.LOW(r) == -1) {
            return;
        }
        if (this.LOW(r) == this.HIGH(r)) {
            this.SETMARK(r);
            this.zsupport_rec(this.LOW(r), this.LEVEL(r) + 1, support);
            return;
        }
        support[this.LEVEL((int)r)] = this.supportID;
        if (this.LEVEL(r) > this.supportMax) {
            this.supportMax = this.LEVEL(r);
        }
        this.SETMARK(r);
        this.zsupport_rec(this.LOW(r), this.LEVEL(r) + 1, support);
        this.zsupport_rec(this.HIGH(r), this.LEVEL(r) + 1, support);
    }

    int bdd_appall(int l, int r, int opr, int var) {
        int res;
        int numReorder = 1;
        this.CHECKa(l);
        this.CHECKa(r);
        this.CHECKa(var);
        if (opr < 0 || opr > 9) {
            JFactory.bdd_error(-12);
            return 0;
        }
        if (var < 2) {
            return this.bdd_apply(l, r, opr);
        }
        if (this.applycache == null) {
            this.applycache = this.BddCacheI_init(this.cachesize);
        }
        if (this.appexcache == null) {
            this.appexcache = this.BddCacheI_init(this.cachesize);
        }
        if (this.quantcache == null) {
            this.quantcache = this.BddCacheI_init(this.cachesize);
        }
        while (true) {
            if (this.varset2vartable(var) < 0) {
                return 0;
            }
            try {
                this.INITREF();
                this.applyop = 0;
                this.appexop = opr;
                this.appexid = var << 5 | this.appexop << 1 | 1;
                this.quantid = this.appexid << 3 | 4;
                if (numReorder == 0) {
                    this.bdd_disable_reorder();
                }
                res = this.appquant_rec(l, r);
                if (numReorder != 0) break;
                this.bdd_enable_reorder();
            }
            catch (ReorderException x) {
                this.bdd_checkreorder();
                --numReorder;
                continue;
            }
            break;
        }
        this.checkresize();
        return res;
    }

    int bdd_appuni(int l, int r, int opr, int var) {
        int res;
        int numReorder = 1;
        this.CHECKa(l);
        this.CHECKa(r);
        this.CHECKa(var);
        if (opr < 0 || opr > 9) {
            JFactory.bdd_error(-12);
            return 0;
        }
        if (var < 2) {
            return this.bdd_apply(l, r, opr);
        }
        if (this.applycache == null) {
            this.applycache = this.BddCacheI_init(this.cachesize);
        }
        if (this.appexcache == null) {
            this.appexcache = this.BddCacheI_init(this.cachesize);
        }
        if (this.quantcache == null) {
            this.quantcache = this.BddCacheI_init(this.cachesize);
        }
        while (true) {
            try {
                this.INITREF();
                this.applyop = 1;
                this.appexop = opr;
                this.appexid = var << 5 | this.appexop << 1 | 1;
                this.quantid = this.appexid << 3 | 5;
                if (numReorder == 0) {
                    this.bdd_disable_reorder();
                }
                res = this.appuni_rec(l, r, var);
                if (numReorder != 0) break;
                this.bdd_enable_reorder();
            }
            catch (ReorderException x) {
                this.bdd_checkreorder();
                --numReorder;
                continue;
            }
            break;
        }
        this.checkresize();
        return res;
    }

    int bdd_satone(int r) {
        this.CHECKa(r);
        if (r < 2) {
            return r;
        }
        this.bdd_disable_reorder();
        this.INITREF();
        int res = this.satone_rec(r);
        this.bdd_enable_reorder();
        this.checkresize();
        return res;
    }

    int satone_rec(int r) {
        if (JFactory.ISCONST(r)) {
            return r;
        }
        if (JFactory.ISZERO(this.LOW(r))) {
            int res = this.satone_rec(this.HIGH(r));
            int m = this.makenode_impl(this.LEVEL(r), 0, res);
            this.PUSHREF(m);
            return m;
        }
        int res = this.satone_rec(this.LOW(r));
        int m = this.makenode_impl(this.LEVEL(r), res, this.ZDD && this.LOW(r) == this.HIGH(r) ? res : 0);
        this.PUSHREF(m);
        return m;
    }

    int bdd_satoneset(int r, int var, boolean pol) {
        this.CHECKa(r);
        if (JFactory.ISZERO(r)) {
            return r;
        }
        this.bdd_disable_reorder();
        this.INITREF();
        this.satPolarity = pol;
        int res = this.satoneset_rec(r, var);
        this.bdd_enable_reorder();
        this.checkresize();
        return res;
    }

    int satoneset_rec(int r, int var) {
        if (JFactory.ISCONST(r) && JFactory.ISCONST(var)) {
            return r;
        }
        if (this.LEVEL(r) < this.LEVEL(var)) {
            if (JFactory.ISZERO(this.LOW(r))) {
                int res = this.satoneset_rec(this.HIGH(r), var);
                int m = this.makenode_impl(this.LEVEL(r), 0, res);
                this.PUSHREF(m);
                return m;
            }
            int res = this.satoneset_rec(this.LOW(r), var);
            int m = this.makenode_impl(this.LEVEL(r), res, this.ZDD && this.LOW(r) == this.HIGH(r) ? res : 0);
            this.PUSHREF(m);
            return m;
        }
        if (this.LEVEL(var) < this.LEVEL(r)) {
            int res = this.satoneset_rec(r, this.HIGH(var));
            if (!this.ZDD && this.satPolarity) {
                int m = this.makenode_impl(this.LEVEL(var), 0, res);
                this.PUSHREF(m);
                return m;
            }
            int m = this.makenode_impl(this.LEVEL(var), res, 0);
            this.PUSHREF(m);
            return m;
        }
        if (JFactory.ISZERO(this.LOW(r))) {
            int res = this.satoneset_rec(this.HIGH(r), this.HIGH(var));
            int m = this.makenode_impl(this.LEVEL(r), 0, res);
            this.PUSHREF(m);
            return m;
        }
        int res = this.satoneset_rec(this.LOW(r), this.HIGH(var));
        int m = this.ZDD && this.satPolarity && this.LOW(r) == this.HIGH(r) ? this.zdd_makenode(this.LEVEL(r), 0, res) : this.makenode_impl(this.LEVEL(r), res, 0);
        this.PUSHREF(m);
        return m;
    }

    int bdd_fullsatone(int r) {
        this.CHECKa(r);
        if (r == 0) {
            return 0;
        }
        this.bdd_disable_reorder();
        this.INITREF();
        int res = this.fullsatone_rec(r);
        for (int v = this.LEVEL(r) - 1; v >= 0; --v) {
            res = this.PUSHREF(this.makenode_impl(v, res, 0));
        }
        this.bdd_enable_reorder();
        this.checkresize();
        return res;
    }

    int fullsatone_rec(int r) {
        if (r < 2) {
            return r;
        }
        if (this.LOW(r) != 0) {
            int res = this.fullsatone_rec(this.LOW(r));
            for (int v = this.LEVEL(this.LOW(r)) - 1; v > this.LEVEL(r); --v) {
                res = this.PUSHREF(this.makenode_impl(v, res, 0));
            }
            return this.PUSHREF(this.makenode_impl(this.LEVEL(r), res, 0));
        }
        int res = this.fullsatone_rec(this.HIGH(r));
        for (int v = this.LEVEL(this.HIGH(r)) - 1; v > this.LEVEL(r); --v) {
            res = this.PUSHREF(this.makenode_impl(v, res, 0));
        }
        return this.PUSHREF(this.makenode_impl(this.LEVEL(r), 0, res));
    }

    void bdd_gbc_rehash() {
        this.bddfreepos = 0;
        this.bddfreenum = 0;
        for (int n = this.bddnodesize - 1; n >= 2; --n) {
            if (this.LOW(n) != -1) {
                int hash2 = this.NODEHASH(this.LEVEL(n), this.LOW(n), this.HIGH(n));
                this.SETNEXT(n, this.HASH(hash2));
                this.SETHASH(hash2, n);
                continue;
            }
            this.SETNEXT(n, this.bddfreepos);
            this.bddfreepos = n;
            ++this.bddfreenum;
        }
    }

    long clock() {
        return System.currentTimeMillis();
    }

    void INITREF() {
        this.bddrefstacktop = 0;
    }

    int PUSHREF(int a) {
        this.bddrefstack[this.bddrefstacktop++] = a;
        return a;
    }

    int READREF(int a) {
        return this.bddrefstack[this.bddrefstacktop - a];
    }

    void POPREF(int a) {
        this.bddrefstacktop -= a;
    }

    int bdd_nodecount(int r) {
        int[] num = new int[1];
        this.CHECK(r);
        this.bdd_markcount(r, num);
        this.bdd_unmark(r);
        return num[0];
    }

    int bdd_anodecount(int[] r) {
        int n;
        int[] cou = new int[1];
        for (n = 0; n < r.length; ++n) {
            this.bdd_markcount(r[n], cou);
        }
        for (n = 0; n < r.length; ++n) {
            this.bdd_unmark(r[n]);
        }
        return cou[0];
    }

    int[] bdd_varprofile(int r) {
        this.CHECK(r);
        int[] varprofile = new int[this.bddvarnum];
        this.varprofile_rec(r, varprofile);
        this.bdd_unmark(r);
        return varprofile;
    }

    void varprofile_rec(int r, int[] varprofile) {
        if (r < 2) {
            return;
        }
        if (this.MARKED(r)) {
            return;
        }
        int n = this.bddlevel2var[this.LEVEL(r)];
        varprofile[n] = varprofile[n] + 1;
        this.SETMARK(r);
        this.varprofile_rec(this.LOW(r), varprofile);
        this.varprofile_rec(this.HIGH(r), varprofile);
    }

    double bdd_pathcount(int r) {
        this.CHECK(r);
        this.miscid = 4;
        if (this.countcache == null) {
            this.countcache = this.BddCacheD_init(this.cachesize);
        }
        return this.bdd_pathcount_rec(r);
    }

    double bdd_pathcount_rec(int r) {
        if (JFactory.ISZERO(r)) {
            return 0.0;
        }
        if (JFactory.ISONE(r)) {
            return 1.0;
        }
        BddCacheDataD entry = this.BddCache_lookupD(this.countcache, JFactory.PATHCOUHASH(r));
        if (entry.a == r && entry.c == this.miscid) {
            return entry.dres;
        }
        double size = this.bdd_pathcount_rec(this.LOW(r)) + this.bdd_pathcount_rec(this.HIGH(r));
        entry.a = r;
        entry.c = this.miscid;
        entry.dres = size;
        return size;
    }

    double bdd_satcount(int r) {
        if (this.ZDD) {
            return this.bdd_pathcount(r);
        }
        double size = 1.0;
        this.CHECK(r);
        if (this.countcache == null) {
            this.countcache = this.BddCacheD_init(this.cachesize);
        }
        this.miscid = 2;
        if (!this.ZDD) {
            size = Math.pow(2.0, this.LEVEL(r));
        }
        return size * this.satcount_rec(r);
    }

    double bdd_satcountset(int r, int varset) {
        double unused = this.bddvarnum;
        if (JFactory.ISCONST(varset) || JFactory.ISZERO(r)) {
            return 0.0;
        }
        int n = varset;
        while (!JFactory.ISCONST(n)) {
            unused -= 1.0;
            n = this.HIGH(n);
        }
        unused = this.bdd_satcount(r) / Math.pow(2.0, unused);
        return unused >= 1.0 ? unused : 1.0;
    }

    double satcount_rec(int root) {
        if (root < 2) {
            return root;
        }
        BddCacheDataD entry = this.BddCache_lookupD(this.countcache, JFactory.SATCOUHASH(root));
        if (entry.a == root && entry.c == this.miscid) {
            return entry.dres;
        }
        double size = 0.0;
        double s = 1.0;
        if (!this.ZDD) {
            s *= Math.pow(2.0, this.LEVEL(this.LOW(root)) - this.LEVEL(root) - 1);
        }
        size += s * this.satcount_rec(this.LOW(root));
        s = 1.0;
        if (!this.ZDD) {
            s *= Math.pow(2.0, this.LEVEL(this.HIGH(root)) - this.LEVEL(root) - 1);
        }
        entry.a = root;
        entry.c = this.miscid;
        entry.dres = size += s * this.satcount_rec(this.HIGH(root));
        return size;
    }

    void bdd_gbc() {
        int n;
        long c1 = this.clock();
        this.gcstats.nodes = this.bddnodesize;
        this.gcstats.freenodes = this.bddfreenum;
        this.gcstats.time = 0L;
        this.gcstats.sumtime = this.gbcclock;
        this.gcstats.num = this.gbcollectnum;
        this.invokeGcStatsCallbacks(true);
        this.handleDeferredFree();
        for (int r = 0; r < this.bddrefstacktop; ++r) {
            this.bdd_mark(this.bddrefstack[r]);
        }
        for (n = 0; n < this.bddnodesize; ++n) {
            if (this.HASREF(n)) {
                this.bdd_mark(n);
            }
            this.SETHASH(n, 0);
        }
        this.bddfreepos = 0;
        this.bddfreenum = 0;
        for (n = this.bddnodesize - 1; n >= 2; --n) {
            if (this.MARKED(n) && this.LOW(n) != -1) {
                this.UNMARK(n);
                int hash2 = this.NODEHASH(this.LEVEL(n), this.LOW(n), this.HIGH(n));
                this.SETNEXT(n, this.HASH(hash2));
                this.SETHASH(hash2, n);
                continue;
            }
            this.SETLOW(n, -1);
            this.SETNEXT(n, this.bddfreepos);
            this.bddfreepos = n;
            ++this.bddfreenum;
        }
        if (FLUSH_CACHE_ON_GC) {
            this.bdd_operator_reset();
        } else {
            this.bdd_operator_clean();
        }
        long c2 = this.clock();
        this.gbcclock += c2 - c1;
        ++this.gbcollectnum;
        this.gcstats.nodes = this.bddnodesize;
        this.gcstats.freenodes = this.bddfreenum;
        this.gcstats.time = c2 - c1;
        this.gcstats.sumtime = this.gbcclock;
        this.gcstats.num = this.gbcollectnum;
        this.invokeGcStatsCallbacks(false);
    }

    int bdd_addref(int root) {
        if (root == -1) {
            JFactory.bdd_error(-9);
        }
        if (root < 2 || !this.bddrunning) {
            return root;
        }
        if (root >= this.bddnodesize) {
            return JFactory.bdd_error(-18);
        }
        if (this.LOW(root) == -1) {
            return JFactory.bdd_error(-18);
        }
        this.INCREF(root);
        if (this.verbose > 1) {
            System.out.println("INCREF(" + root + ") = " + this.GETREF(root));
        }
        return root;
    }

    int bdd_used_nodes_count() {
        for (int r = 0; r < this.bddrefstacktop; ++r) {
            this.bdd_mark(this.bddrefstack[r]);
        }
        for (int n = 0; n < this.bddnodesize; ++n) {
            if (!this.HASREF(n)) continue;
            this.bdd_mark(n);
        }
        int bddCount = 2;
        for (int n = this.bddnodesize - 1; n >= 2; --n) {
            if (!this.MARKED(n) || this.LOW(n) == -1) continue;
            this.UNMARK(n);
            ++bddCount;
        }
        return bddCount;
    }

    int bdd_delref(int root) {
        this.bdd_add_perf_stats();
        if (root == -1) {
            JFactory.bdd_error(-9);
        }
        if (root < 2 || !this.bddrunning) {
            return root;
        }
        if (root >= this.bddnodesize) {
            return JFactory.bdd_error(-18);
        }
        if (this.LOW(root) == -1) {
            return JFactory.bdd_error(-18);
        }
        if (!this.HASREF(root)) {
            JFactory.bdd_error(-9);
        }
        this.DECREF(root);
        if (this.verbose > 1) {
            System.out.println("DECREF(" + root + ") = " + this.GETREF(root));
        }
        return root;
    }

    void bdd_mark(int i) {
        if (i < 2) {
            return;
        }
        if (this.MARKED(i) || this.LOW(i) == -1) {
            return;
        }
        this.SETMARK(i);
        this.bdd_mark(this.LOW(i));
        this.bdd_mark(this.HIGH(i));
    }

    void bdd_markcount(int i, int[] cou) {
        if (i < 2) {
            return;
        }
        if (this.MARKED(i) || this.LOW(i) == -1) {
            return;
        }
        this.SETMARK(i);
        cou[0] = cou[0] + 1;
        this.bdd_markcount(this.LOW(i), cou);
        this.bdd_markcount(this.HIGH(i), cou);
    }

    void bdd_unmark(int i) {
        if (i < 2) {
            return;
        }
        if (!this.MARKED(i) || this.LOW(i) == -1) {
            return;
        }
        this.UNMARK(i);
        this.bdd_unmark(this.LOW(i));
        this.bdd_unmark(this.HIGH(i));
    }

    int bdd_makenode(int level, int low, int high) {
        if (this.cachestats.enabled) {
            ++this.cachestats.uniqueAccess;
        }
        if (low == high) {
            return low;
        }
        return this.makenode(level, low, high);
    }

    int zdd_makenode(int level, int low, int high) {
        if (this.cachestats.enabled) {
            ++this.cachestats.uniqueAccess;
        }
        if (high == 0) {
            return low;
        }
        return this.makenode(level, low, high);
    }

    private int makenode(int level, int low, int high) {
        int hash2 = this.NODEHASH(level, low, high);
        int res = this.HASH(hash2);
        while (res != 0) {
            if (this.LEVEL(res) == level && this.LOW(res) == low && this.HIGH(res) == high) {
                if (this.cachestats.enabled) {
                    ++this.cachestats.uniqueHit;
                }
                return res;
            }
            res = this.NEXT(res);
            if (!this.cachestats.enabled) continue;
            ++this.cachestats.uniqueChain;
        }
        if (this.cachestats.enabled) {
            ++this.cachestats.uniqueMiss;
        }
        if (this.bddfreepos == 0) {
            if (this.bdderrorcond != 0) {
                return 0;
            }
            this.bdd_gbc();
            if (this.bddnodesize - this.bddfreenum >= this.usednodes_nextreorder && this.bdd_reorder_ready()) {
                throw new ReorderException();
            }
            if ((long)this.bddfreenum * 100L / (long)this.bddnodesize <= (long)this.minfreenodes) {
                this.bdd_noderesize(true);
                hash2 = this.NODEHASH(level, low, high);
            }
            if (this.bddfreepos == 0) {
                JFactory.bdd_error(-17);
                this.bdderrorcond = Math.abs(-17);
                return 0;
            }
        }
        res = this.bddfreepos;
        this.bddfreepos = this.NEXT(this.bddfreepos);
        --this.bddfreenum;
        ++this.bddproduced;
        this.SETLEVELANDMARK(res, level);
        this.SETLOW(res, low);
        this.SETHIGH(res, high);
        this.SETNEXT(res, this.HASH(hash2));
        this.SETHASH(hash2, res);
        return res;
    }

    int bdd_noderesize(boolean doRehash) {
        int oldsize = this.bddnodesize;
        int newsize = this.bddnodesize;
        if (this.bddmaxnodesize > 0 && newsize >= this.bddmaxnodesize) {
            return -1;
        }
        newsize = this.increasefactor > 0.0 ? (newsize += (int)((double)newsize * this.increasefactor)) : (newsize <<= 1);
        if (this.bddmaxnodeincrease > 0 && newsize > oldsize + this.bddmaxnodeincrease) {
            newsize = oldsize + this.bddmaxnodeincrease;
        }
        if (this.bddmaxnodesize > 0 && newsize > this.bddmaxnodesize) {
            newsize = this.bddmaxnodesize;
        }
        return this.doResize(doRehash, oldsize, newsize);
    }

    int doResize(boolean doRehash, int oldsize, int newsize) {
        int n;
        if ((newsize = this.bdd_prime_lte(newsize)) < 0) {
            newsize = 0x19999997;
        }
        if (newsize >= 0x19999997) {
            if (oldsize == 0x19999997) {
                throw new OutOfMemoryError(String.format(Locale.US, "Maximum size of node array reached (%,d nodes).", 0x19999997));
            }
            newsize = 0x19999997;
        }
        if (oldsize > newsize) {
            return 0;
        }
        this.invokeResizeStatsCallbacks(oldsize, newsize);
        int[] newnodes = new int[newsize * 5];
        System.arraycopy(this.bddnodes, 0, newnodes, 0, this.bddnodes.length);
        this.bddnodes = newnodes;
        this.bddnodesize = newsize;
        if (doRehash) {
            for (n = 0; n < oldsize; ++n) {
                this.SETHASH(n, 0);
            }
        }
        for (n = oldsize; n < this.bddnodesize; ++n) {
            this.SETLOW(n, -1);
            this.SETNEXT(n, n + 1);
        }
        this.SETNEXT(this.bddnodesize - 1, this.bddfreepos);
        this.bddfreepos = oldsize;
        this.bddfreenum += this.bddnodesize - oldsize;
        if (doRehash) {
            this.bdd_gbc_rehash();
        }
        this.bddresized = true;
        return 0;
    }

    void bdd_init(int initnodesize, int cs) {
        if (this.bddrunning) {
            JFactory.bdd_error(-5);
        }
        this.bddnodesize = this.bdd_prime_gte(initnodesize);
        this.bddnodes = new int[this.bddnodesize * 5];
        this.bddresized = false;
        for (int n = 0; n < this.bddnodesize; ++n) {
            this.SETLOW(n, -1);
            this.SETNEXT(n, n + 1);
        }
        this.SETNEXT(this.bddnodesize - 1, 0);
        this.SETMAXREF(0);
        this.SETMAXREF(1);
        this.SETLOW(0, 0);
        this.SETHIGH(0, 0);
        this.SETLOW(1, 1);
        this.SETHIGH(1, 1);
        this.bdd_operator_init(cs);
        this.bddfreepos = 2;
        this.bddfreenum = this.bddnodesize - 2;
        this.bddrunning = true;
        this.bddvarnum = 0;
        this.gbcollectnum = 0;
        this.gbcclock = 0L;
        this.cachesize = cs;
        this.usednodes_nextreorder = this.bddnodesize;
        this.bddmaxnodeincrease = 10000000;
        this.bdderrorcond = 0;
        if (this.cachestats.enabled) {
            // empty if block
        }
        this.bdd_pairs_init();
        this.bdd_reorder_init();
    }

    void bdd_operator_init(int cachesize) {
        this.quantvarsetID = 0;
        this.quantvarset = null;
        this.cacheratio = 0.0;
        this.supportSet = null;
        this.supportSize = 0;
    }

    void bdd_operator_done() {
        if (this.quantvarset != null) {
            this.quantvarset = null;
        }
        this.BddCache_done(this.applycache);
        this.applycache = null;
        this.BddCache_done(this.itecache);
        this.itecache = null;
        this.BddCache_done(this.quantcache);
        this.quantcache = null;
        this.BddCache_done(this.appexcache);
        this.appexcache = null;
        this.BddCache_done(this.replacecache);
        this.replacecache = null;
        this.BddCache_done(this.misccache);
        this.misccache = null;
        this.BddCache_done(this.countcache);
        this.countcache = null;
        if (this.supportSet != null) {
            this.supportSet = null;
            this.supportSize = 0;
        }
    }

    void bdd_operator_reset() {
        this.BddCache_reset(this.applycache);
        this.BddCache_reset(this.itecache);
        this.BddCache_reset(this.quantcache);
        this.BddCache_reset(this.appexcache);
        this.BddCache_reset(this.replacecache);
        this.BddCache_reset(this.misccache);
        this.BddCache_reset(this.countcache);
    }

    void bdd_operator_clean() {
        this.BddCache_clean_ab(this.applycache);
        this.BddCache_clean_abc(this.itecache);
        this.BddCache_clean_a(this.quantcache);
        this.BddCache_clean_ab(this.appexcache);
        this.BddCache_clean_ab(this.replacecache);
        this.BddCache_clean_ab(this.misccache);
        this.BddCache_clean_d(this.countcache);
    }

    void bdd_operator_varresize() {
        this.quantvarset = new int[this.bddvarnum];
        this.quantvarsetID = 0;
        this.BddCache_reset(this.countcache);
    }

    int bdd_setcachesize(int newcachesize) {
        int old = this.cachesize;
        this.BddCache_resize(this.applycache, newcachesize);
        this.BddCache_resize(this.itecache, newcachesize);
        this.BddCache_resize(this.quantcache, newcachesize);
        this.BddCache_resize(this.appexcache, newcachesize);
        this.BddCache_resize(this.replacecache, newcachesize);
        this.BddCache_resize(this.misccache, newcachesize);
        this.BddCache_resize(this.countcache, newcachesize);
        return old;
    }

    void bdd_operator_noderesize() {
        if (this.cacheratio > 0.0) {
            int newcachesize = (int)((double)this.bddnodesize * this.cacheratio);
            this.BddCache_resize(this.applycache, newcachesize);
            this.BddCache_resize(this.itecache, newcachesize);
            this.BddCache_resize(this.quantcache, newcachesize);
            this.BddCache_resize(this.appexcache, newcachesize);
            this.BddCache_resize(this.replacecache, newcachesize);
            this.BddCache_resize(this.misccache, newcachesize);
            this.BddCache_resize(this.countcache, newcachesize);
        }
    }

    BddCache BddCacheI_init(int size) {
        size = this.bdd_prime_gte(size);
        BddCache cache = new BddCache();
        cache.table = new BddCacheDataI[size];
        for (int n = 0; n < size; ++n) {
            cache.table[n] = new BddCacheDataI();
            cache.table[n].a = -1;
        }
        cache.tablesize = size;
        return cache;
    }

    BddCache BddCacheD_init(int size) {
        size = this.bdd_prime_gte(size);
        BddCache cache = new BddCache();
        cache.table = new BddCacheDataD[size];
        for (int n = 0; n < size; ++n) {
            cache.table[n] = new BddCacheDataD();
            cache.table[n].a = -1;
        }
        cache.tablesize = size;
        return cache;
    }

    void BddCache_done(BddCache cache) {
        if (cache == null) {
            return;
        }
        cache.table = null;
        cache.tablesize = 0;
    }

    int BddCache_resize(BddCache cache, int newsize) {
        if (cache == null) {
            return 0;
        }
        boolean is_d = cache.table instanceof BddCacheDataD[];
        cache.table = null;
        newsize = this.bdd_prime_gte(newsize);
        cache.table = is_d ? new BddCacheDataD[newsize] : new BddCacheDataI[newsize];
        for (int n = 0; n < newsize; ++n) {
            cache.table[n] = is_d ? new BddCacheDataD() : new BddCacheDataI();
            cache.table[n].a = -1;
        }
        cache.tablesize = newsize;
        return 0;
    }

    BddCacheDataI BddCache_lookupI(BddCache cache, int hash) {
        return (BddCacheDataI)cache.table[Math.abs(hash % cache.tablesize)];
    }

    BddCacheDataD BddCache_lookupD(BddCache cache, int hash) {
        return (BddCacheDataD)cache.table[Math.abs(hash % cache.tablesize)];
    }

    void BddCache_reset(BddCache cache) {
        if (cache == null) {
            return;
        }
        for (int n = 0; n < cache.tablesize; ++n) {
            cache.table[n].a = -1;
        }
    }

    void BddCache_clean_d(BddCache cache) {
        if (cache == null) {
            return;
        }
        for (int n = 0; n < cache.tablesize; ++n) {
            int a = cache.table[n].a;
            if (a < 0 || this.LOW(a) != -1) continue;
            cache.table[n].a = -1;
        }
    }

    void BddCache_clean_a(BddCache cache) {
        if (cache == null) {
            return;
        }
        for (int n = 0; n < cache.tablesize; ++n) {
            int a = cache.table[n].a;
            if (a < 0 || this.LOW(a) != -1 && this.LOW(((BddCacheDataI)cache.table[n]).res) != -1) continue;
            cache.table[n].a = -1;
        }
    }

    void BddCache_clean_ab(BddCache cache) {
        if (cache == null) {
            return;
        }
        for (int n = 0; n < cache.tablesize; ++n) {
            int a = cache.table[n].a;
            if (a < 0 || this.LOW(a) != -1 && (cache.table[n].b == 0 || this.LOW(cache.table[n].b) != -1) && this.LOW(((BddCacheDataI)cache.table[n]).res) != -1) continue;
            cache.table[n].a = -1;
        }
    }

    void BddCache_clean_abc(BddCache cache) {
        if (cache == null) {
            return;
        }
        for (int n = 0; n < cache.tablesize; ++n) {
            int a = cache.table[n].a;
            if (a < 0 || this.LOW(a) != -1 && this.LOW(cache.table[n].b) != -1 && this.LOW(cache.table[n].c) != -1 && this.LOW(((BddCacheDataI)cache.table[n]).res) != -1) continue;
            cache.table[n].a = -1;
        }
    }

    void bdd_setpair(bddPair pair, int oldvar, int newvar) {
        if (pair == null) {
            return;
        }
        if (oldvar < 0 || oldvar > this.bddvarnum - 1) {
            JFactory.bdd_error(-2);
        }
        if (newvar < 0 || newvar > this.bddvarnum - 1) {
            JFactory.bdd_error(-2);
        }
        if (this.ZDD) {
            int oldlev = this.bddvar2level[oldvar];
            int newlev = this.bddvar2level[newvar];
            int newIndex = newlev;
            if (this.LEVEL(pair.result[newIndex]) != newlev) {
                for (newIndex = 0; newIndex < this.bddvarnum && this.LEVEL(pair.result[newIndex]) != newlev; ++newIndex) {
                }
            }
            int tmp = pair.result[oldlev];
            pair.result[oldlev] = pair.result[newIndex];
            pair.result[newIndex] = tmp;
            if (newlev > pair.last) {
                pair.last = newlev;
            }
        } else {
            this.bdd_delref(pair.result[this.bddvar2level[oldvar]]);
            pair.result[this.bddvar2level[oldvar]] = this.bdd_ithvar(newvar);
        }
        pair.id = this.update_pairsid();
        if (this.bddvar2level[oldvar] > pair.last) {
            pair.last = this.bddvar2level[oldvar];
        }
    }

    void bdd_setbddpair(bddPair pair, int oldvar, int newvar) {
        if (pair == null) {
            return;
        }
        if (this.ZDD) {
            throw new BDDException("setbddpair not supported with ZDDs");
        }
        this.CHECK(newvar);
        if (oldvar < 0 || oldvar >= this.bddvarnum) {
            JFactory.bdd_error(-2);
        }
        int oldlevel = this.bddvar2level[oldvar];
        this.bdd_delref(pair.result[oldlevel]);
        pair.result[oldlevel] = this.bdd_addref(newvar);
        pair.id = this.update_pairsid();
        if (oldlevel > pair.last) {
            pair.last = oldlevel;
        }
    }

    void bdd_resetpair(bddPair p) {
        for (int n = 0; n < this.bddvarnum; ++n) {
            if (this.ZDD) {
                this.bdd_delref(p.result[n]);
                p.result[n] = this.bdd_addref(this.zdd_makenode(n, 0, 1));
                continue;
            }
            p.result[n] = this.bdd_ithvar(this.bddlevel2var[n]);
        }
        p.last = 0;
    }

    void bdd_pairs_init() {
        this.pairsid = 0;
        this.pairs = null;
    }

    void bdd_pairs_done() {
        bddPair p = this.pairs;
        while (p != null) {
            bddPair next = p.next;
            for (int n = 0; n < this.bddvarnum; ++n) {
                this.bdd_delref(p.result[n]);
            }
            p.result = null;
            p = next;
        }
    }

    int update_pairsid() {
        ++this.pairsid;
        if (this.pairsid == 0x1FFFFFFF) {
            this.pairsid = 0;
            bddPair p = this.pairs;
            while (p != null) {
                ++this.pairsid;
                p.id = p.id;
                p = p.next;
            }
            this.BddCache_reset(this.replacecache);
        }
        return this.pairsid;
    }

    void bdd_register_pair(bddPair p) {
        p.next = this.pairs;
        this.pairs = p;
    }

    void bdd_pairs_vardown(int level) {
        bddPair p = this.pairs;
        while (p != null) {
            int tmp = p.result[level];
            p.result[level] = p.result[level + 1];
            p.result[level + 1] = tmp;
            if (p.last == level) {
                ++p.last;
            }
            p = p.next;
        }
    }

    int bdd_pairs_resize(int oldsize, int newsize) {
        bddPair p = this.pairs;
        while (p != null) {
            int[] new_result = new int[newsize];
            System.arraycopy(p.result, 0, new_result, 0, oldsize);
            p.result = new_result;
            for (int n = oldsize; n < newsize; ++n) {
                p.result[n] = this.ZDD ? this.bdd_addref(this.zdd_makenode(n, 0, 1)) : this.bdd_ithvar(this.bddlevel2var[n]);
            }
            p = p.next;
        }
        return 0;
    }

    void bdd_disable_reorder() {
        this.reorderdisabled = 1;
    }

    void bdd_enable_reorder() {
        this.reorderdisabled = 0;
    }

    void bdd_checkreorder() {
        this.bdd_reorder_auto();
        this.usednodes_nextreorder = 2 * (this.bddnodesize - this.bddfreenum);
        if (this.bdd_reorder_gain() < 20) {
            this.usednodes_nextreorder += this.usednodes_nextreorder * (20 - this.bdd_reorder_gain()) / 20;
        }
    }

    boolean bdd_reorder_ready() {
        return this.bddreordermethod != 0 && this.vartree != null && this.bddreordertimes != 0 && this.reorderdisabled == 0;
    }

    void bdd_reorder(int method) {
        int savemethod = this.bddreordermethod;
        int savetimes = this.bddreordertimes;
        this.bddreordermethod = method;
        this.bddreordertimes = 1;
        BddTree top = this.bddtree_new(-1);
        if (top != null && this.reorder_init() >= 0) {
            this.usednum_before = this.bddnodesize - this.bddfreenum;
            top.firstLevel = 0;
            top.firstVar = 0;
            top.lastVar = top.lastLevel = this.bdd_varnum() - 1;
            top.fixed = false;
            top.interleaved = false;
            top.next = null;
            top.nextlevel = this.vartree;
            this.reorder_block(top, method);
            this.vartree = top.nextlevel;
            this.usednum_after = this.bddnodesize - this.bddfreenum;
            this.reorder_done();
            this.bddreordermethod = savemethod;
            this.bddreordertimes = savetimes;
        }
    }

    BddTree bddtree_new(int id) {
        BddTree t = new BddTree();
        t.lastLevel = -1;
        t.firstLevel = -1;
        t.lastVar = -1;
        t.firstVar = -1;
        t.fixed = true;
        t.id = id;
        return t;
    }

    BddTree reorder_block(BddTree t, int method) {
        if (t == null) {
            return null;
        }
        if (!t.fixed && t.nextlevel != null) {
            switch (method) {
                case 1: {
                    t.nextlevel = this.reorder_win2(t.nextlevel);
                    break;
                }
                case 2: {
                    t.nextlevel = this.reorder_win2ite(t.nextlevel);
                    break;
                }
                case 3: {
                    t.nextlevel = this.reorder_sift(t.nextlevel);
                    break;
                }
                case 4: {
                    t.nextlevel = this.reorder_siftite(t.nextlevel);
                    break;
                }
                case 5: {
                    t.nextlevel = this.reorder_win3(t.nextlevel);
                    break;
                }
                case 6: {
                    t.nextlevel = this.reorder_win3ite(t.nextlevel);
                    break;
                }
                case 7: {
                    t.nextlevel = this.reorder_random(t.nextlevel);
                }
            }
        }
        BddTree dis = t.nextlevel;
        while (dis != null) {
            this.reorder_block(dis, method);
            dis = dis.next;
        }
        if (t.seq != null) {
            this.varseq_qsort(t.seq, 0, t.lastVar - t.firstVar + 1);
            t.firstLevel = this.bddvar2level[t.seq[0]];
            t.lastLevel = this.bddvar2level[t.seq[t.lastVar - t.firstVar]];
        }
        return t;
    }

    void varseq_qsort(int[] target, int from, int to) {
        switch (to - from) {
            case 0: {
                return;
            }
            case 1: {
                return;
            }
            case 2: {
                if (this.bddvar2level[target[from]] <= this.bddvar2level[target[from + 1]]) {
                    return;
                }
                int x = target[from];
                target[from] = target[from + 1];
                target[from + 1] = x;
                return;
            }
        }
        int r = target[from];
        int s = target[(from + to) / 2];
        int t = target[to - 1];
        if (this.bddvar2level[r] <= this.bddvar2level[s]) {
            if (this.bddvar2level[s] > this.bddvar2level[t]) {
                if (this.bddvar2level[r] <= this.bddvar2level[t]) {
                    target[to - 1] = s;
                    target[(from + to) / 2] = t;
                } else {
                    target[to - 1] = s;
                    target[from] = t;
                    target[(from + to) / 2] = r;
                }
            }
        } else if (this.bddvar2level[r] <= this.bddvar2level[t]) {
            target[(from + to) / 2] = r;
            target[from] = s;
        } else if (this.bddvar2level[s] <= this.bddvar2level[t]) {
            target[to - 1] = r;
            target[(from + to) / 2] = t;
            target[from] = s;
        } else {
            target[to - 1] = r;
            target[from] = t;
        }
        int mid = target[(from + to) / 2];
        int i = from + 1;
        int j = to - 1;
        while (i + 1 != j) {
            int x;
            if (target[i] == mid) {
                target[i] = target[i + 1];
                target[i + 1] = mid;
            }
            if ((x = target[i]) <= mid) {
                ++i;
                continue;
            }
            x = target[--j];
            target[j] = target[i];
            target[i] = x;
        }
        this.varseq_qsort(target, from, i);
        this.varseq_qsort(target, i + 1, to);
    }

    BddTree reorder_win2(BddTree t) {
        BddTree dis = t;
        BddTree first = t;
        if (t == null) {
            return t;
        }
        if (this.verbose > 1) {
            System.out.println("Win2 start: " + this.reorder_nodenum() + " nodes");
            System.out.flush();
        }
        while (dis.next != null) {
            int best = this.reorder_nodenum();
            this.blockdown(dis);
            if (best < this.reorder_nodenum()) {
                this.blockdown(dis.prev);
                dis = dis.next;
            } else if (first == dis) {
                first = dis.prev;
            }
            if (this.verbose <= 1) continue;
            System.out.print(".");
            System.out.flush();
        }
        if (this.verbose > 1) {
            System.out.println();
            System.out.println("Win2 end: " + this.reorder_nodenum() + " nodes");
            System.out.flush();
        }
        return first;
    }

    BddTree reorder_win3(BddTree t) {
        BddTree dis = t;
        BddTree first = t;
        if (t == null) {
            return t;
        }
        if (this.verbose > 1) {
            System.out.println("Win3 start: " + this.reorder_nodenum() + " nodes");
            System.out.flush();
        }
        while (dis.next != null) {
            BddTree[] f = new BddTree[]{first};
            dis = this.reorder_swapwin3(dis, f);
            first = f[0];
            if (this.verbose <= 1) continue;
            System.out.print(".");
            System.out.flush();
        }
        if (this.verbose > 1) {
            System.out.println();
            System.out.println("Win3 end: " + this.reorder_nodenum() + " nodes");
            System.out.flush();
        }
        return first;
    }

    BddTree reorder_win3ite(BddTree t) {
        int lastsize;
        BddTree dis = t;
        BddTree first = t;
        if (t == null) {
            return t;
        }
        if (this.verbose > 1) {
            System.out.println("Win3ite start: " + this.reorder_nodenum() + " nodes");
        }
        do {
            lastsize = this.reorder_nodenum();
            dis = first;
            while (dis.next != null && dis.next.next != null) {
                BddTree[] f = new BddTree[]{first};
                dis = this.reorder_swapwin3(dis, f);
                first = f[0];
                if (this.verbose <= 1) continue;
                System.out.print(".");
                System.out.flush();
            }
            if (this.verbose <= 1) continue;
            System.out.println(" " + this.reorder_nodenum() + " nodes");
        } while (this.reorder_nodenum() != lastsize);
        if (this.verbose > 1) {
            System.out.println("Win3ite end: " + this.reorder_nodenum() + " nodes");
        }
        return first;
    }

    BddTree reorder_swapwin3(BddTree dis, BddTree[] first) {
        boolean setfirst = dis.prev == null;
        BddTree next = dis;
        int best = this.reorder_nodenum();
        if (dis.next.next == null) {
            this.blockdown(dis.prev);
            if (best < this.reorder_nodenum()) {
                this.blockdown(dis.prev);
                next = dis.next;
            } else {
                next = dis;
                if (setfirst) {
                    first[0] = dis.prev;
                }
            }
        } else {
            int pos = 0;
            this.blockdown(dis);
            ++pos;
            if (best > this.reorder_nodenum()) {
                pos = 0;
                best = this.reorder_nodenum();
            }
            this.blockdown(dis);
            ++pos;
            if (best > this.reorder_nodenum()) {
                pos = 0;
                best = this.reorder_nodenum();
            }
            dis = dis.prev.prev;
            this.blockdown(dis);
            ++pos;
            if (best > this.reorder_nodenum()) {
                pos = 0;
                best = this.reorder_nodenum();
            }
            this.blockdown(dis);
            ++pos;
            if (best > this.reorder_nodenum()) {
                pos = 0;
                best = this.reorder_nodenum();
            }
            dis = dis.prev.prev;
            this.blockdown(dis);
            ++pos;
            if (best > this.reorder_nodenum()) {
                pos = 0;
                best = this.reorder_nodenum();
            }
            if (pos >= 1) {
                dis = dis.prev;
                this.blockdown(dis);
                next = dis;
                if (setfirst) {
                    first[0] = dis.prev;
                }
            }
            if (pos >= 2) {
                this.blockdown(dis);
                next = dis.prev;
                if (setfirst) {
                    first[0] = dis.prev.prev;
                }
            }
            if (pos >= 3) {
                dis = dis.prev.prev;
                this.blockdown(dis);
                next = dis;
                if (setfirst) {
                    first[0] = dis.prev;
                }
            }
            if (pos >= 4) {
                this.blockdown(dis);
                next = dis.prev;
                if (setfirst) {
                    first[0] = dis.prev.prev;
                }
            }
            if (pos >= 5) {
                dis = dis.prev.prev;
                this.blockdown(dis);
                next = dis;
                if (setfirst) {
                    first[0] = dis.prev;
                }
            }
        }
        return next;
    }

    BddTree reorder_sift_seq(BddTree t, BddTree[] seq, int num) {
        if (t == null) {
            return t;
        }
        for (int n = 0; n < num; ++n) {
            long c1 = this.clock();
            if (this.verbose > 1) {
                System.out.print("Sift ");
                System.out.print(seq[n].id);
                System.out.print(": ");
            }
            this.reorder_sift_bestpos(seq[n], num / 2);
            if (this.verbose > 1) {
                System.out.println();
                System.out.print("> " + this.reorder_nodenum() + " nodes");
            }
            long c2 = this.clock();
            if (this.verbose <= 1) continue;
            System.out.println(" (" + (float)(c2 - c1) / 1000.0f + " sec)\n");
        }
        BddTree dis = t;
        while (dis.prev != null) {
            dis = dis.prev;
        }
        return dis;
    }

    void reorder_sift_bestpos(BddTree blk, int middlePos) {
        int best = this.reorder_nodenum();
        int bestpos = 0;
        boolean dirIsUp = true;
        int maxAllowed = this.bddmaxnodesize > 0 ? JFactory.MIN(best / 5 + best, this.bddmaxnodesize - this.bddmaxnodeincrease - 2) : best / 5 + best;
        if (blk.pos > middlePos) {
            dirIsUp = false;
        }
        for (int n = 0; n < 2; ++n) {
            boolean first = true;
            if (dirIsUp) {
                while (blk.prev != null && (this.reorder_nodenum() <= maxAllowed || first)) {
                    first = false;
                    this.blockdown(blk.prev);
                    --bestpos;
                    if (this.verbose > 1) {
                        System.out.print("-");
                        System.out.flush();
                    }
                    if (this.reorder_nodenum() >= best) continue;
                    best = this.reorder_nodenum();
                    bestpos = 0;
                    if (this.bddmaxnodesize > 0) {
                        maxAllowed = JFactory.MIN(best / 5 + best, this.bddmaxnodesize - this.bddmaxnodeincrease - 2);
                        continue;
                    }
                    maxAllowed = best / 5 + best;
                }
            } else {
                while (blk.next != null && (this.reorder_nodenum() <= maxAllowed || first)) {
                    first = false;
                    this.blockdown(blk);
                    ++bestpos;
                    if (this.verbose > 1) {
                        System.out.print("+");
                        System.out.flush();
                    }
                    if (this.reorder_nodenum() >= best) continue;
                    best = this.reorder_nodenum();
                    bestpos = 0;
                    if (this.bddmaxnodesize > 0) {
                        maxAllowed = JFactory.MIN(best / 5 + best, this.bddmaxnodesize - this.bddmaxnodeincrease - 2);
                        continue;
                    }
                    maxAllowed = best / 5 + best;
                }
            }
            if (this.reorder_nodenum() > maxAllowed && this.verbose > 1) {
                System.out.print("!");
                System.out.flush();
            }
            dirIsUp = !dirIsUp;
        }
        while (bestpos < 0) {
            this.blockdown(blk);
            ++bestpos;
        }
        while (bestpos > 0) {
            this.blockdown(blk.prev);
            --bestpos;
        }
    }

    BddTree reorder_random(BddTree t) {
        int num = 0;
        if (t == null) {
            return t;
        }
        BddTree dis = t;
        while (dis != null) {
            ++num;
            dis = dis.next;
        }
        BddTree[] seq = new BddTree[num];
        dis = t;
        num = 0;
        while (dis != null) {
            seq[num++] = dis;
            dis = dis.next;
        }
        for (int n = 0; n < 4 * num; ++n) {
            int blk = this.rng.nextInt(num);
            if (seq[blk].next == null) continue;
            this.blockdown(seq[blk]);
        }
        dis = t;
        while (dis.prev != null) {
            dis = dis.prev;
        }
        if (this.verbose != 0) {
            System.out.println("Random order: " + this.reorder_nodenum() + " nodes");
        }
        return dis;
    }

    static int siftTestCmp(sizePair a, sizePair b) {
        if (a.val < b.val) {
            return -1;
        }
        if (a.val > b.val) {
            return 1;
        }
        return 0;
    }

    BddTree reorder_sift(BddTree t) {
        BddTree dis = t;
        int num = 0;
        while (dis != null) {
            dis.pos = num++;
            dis = dis.next;
        }
        sizePair[] p = new sizePair[num];
        BddTree[] seq = new BddTree[num];
        dis = t;
        int n = 0;
        while (dis != null) {
            p[n] = new sizePair();
            p[n].val = 0;
            for (int v = dis.firstVar; v <= dis.lastVar; ++v) {
                p[n].val -= this.levels[v].nodenum;
            }
            p[n].block = dis;
            dis = dis.next;
            ++n;
        }
        Arrays.sort(p, 0, num, new Comparator<sizePair>(){

            @Override
            public int compare(sizePair o1, sizePair o2) {
                return JFactory.siftTestCmp(o1, o2);
            }
        });
        for (n = 0; n < num; ++n) {
            seq[n] = p[n].block;
        }
        t = this.reorder_sift_seq(t, seq, num);
        return t;
    }

    BddTree reorder_siftite(BddTree t) {
        int lastsize;
        BddTree first = t;
        int c = 1;
        if (t == null) {
            return t;
        }
        do {
            if (this.verbose > 1) {
                System.out.println("Reorder " + c++ + "\n");
            }
            lastsize = this.reorder_nodenum();
            first = this.reorder_sift(first);
        } while (this.reorder_nodenum() != lastsize);
        return first;
    }

    void blockinterleave(BddTree left) {
        int n;
        BddTree right = left.next;
        int leftsize = left.lastVar - left.firstVar;
        int rightsize = right.lastVar - right.firstVar;
        int[] lseq = left.seq;
        int[] rseq = right.seq;
        int minsize = Math.min(leftsize, rightsize);
        for (n = 0; n <= minsize; ++n) {
            while (this.bddvar2level[lseq[n]] + 1 < this.bddvar2level[rseq[n]]) {
                this.reorder_varup(rseq[n]);
            }
        }
        block2: while (n <= rightsize) {
            BddTree t;
            while ((t = left.prev) != null && t.interleaved) {
                int tsize = t.lastVar - t.firstVar;
                if (n > tsize) continue;
                int[] tseq = t.seq;
                while (this.bddvar2level[tseq[n]] + 1 < this.bddvar2level[rseq[n]]) {
                    this.reorder_varup(rseq[n]);
                }
                ++n;
                continue block2;
            }
            break block2;
        }
        right.next.prev = left;
        left.next = right.next;
        left.firstVar = Math.min(left.firstVar, right.firstVar);
        left.lastVar = Math.max(left.lastVar, right.lastVar);
        left.seq = new int[left.lastVar - left.firstVar + 1];
        this.update_seq(left);
    }

    void blockdown(BddTree left) {
        int n;
        BddTree right = left.next;
        int leftsize = left.lastVar - left.firstVar;
        int rightsize = right.lastVar - right.firstVar;
        int leftstart = this.bddvar2level[left.seq[0]];
        int[] lseq = left.seq;
        int[] rseq = right.seq;
        while (this.bddvar2level[lseq[0]] < this.bddvar2level[rseq[rightsize]]) {
            for (n = 0; n < leftsize; ++n) {
                if (this.bddvar2level[lseq[n]] + 1 == this.bddvar2level[lseq[n + 1]] || this.bddvar2level[lseq[n]] >= this.bddvar2level[rseq[rightsize]]) continue;
                this.reorder_vardown(lseq[n]);
            }
            if (this.bddvar2level[lseq[leftsize]] >= this.bddvar2level[rseq[rightsize]]) continue;
            this.reorder_vardown(lseq[leftsize]);
        }
        while (this.bddvar2level[rseq[0]] > leftstart) {
            for (n = rightsize; n > 0; --n) {
                if (this.bddvar2level[rseq[n]] - 1 == this.bddvar2level[rseq[n - 1]] || this.bddvar2level[rseq[n]] <= leftstart) continue;
                this.reorder_varup(rseq[n]);
            }
            if (this.bddvar2level[rseq[0]] <= leftstart) continue;
            this.reorder_varup(rseq[0]);
        }
        left.next = right.next;
        right.prev = left.prev;
        left.prev = right;
        right.next = left;
        if (right.prev != null) {
            right.prev.next = right;
        }
        if (left.next != null) {
            left.next.prev = left;
        }
        n = left.pos;
        left.pos = right.pos;
        right.pos = n;
        left.interleaved = false;
        right.interleaved = false;
        left.firstLevel = this.bddvar2level[lseq[0]];
        left.lastLevel = this.bddvar2level[lseq[leftsize]];
        right.firstLevel = this.bddvar2level[rseq[0]];
        right.lastLevel = this.bddvar2level[rseq[rightsize]];
    }

    BddTree reorder_win2ite(BddTree t) {
        int lastsize;
        BddTree first = t;
        if (t == null) {
            return t;
        }
        if (this.verbose > 1) {
            System.out.println("Win2ite start: " + this.reorder_nodenum() + " nodes");
        }
        do {
            lastsize = this.reorder_nodenum();
            BddTree dis = t;
            while (dis.next != null) {
                int best = this.reorder_nodenum();
                this.blockdown(dis);
                if (best < this.reorder_nodenum()) {
                    this.blockdown(dis.prev);
                    dis = dis.next;
                } else if (first == dis) {
                    first = dis.prev;
                }
                if (this.verbose <= 1) continue;
                System.out.print(".");
                System.out.flush();
            }
            if (this.verbose <= 1) continue;
            System.out.println(" " + this.reorder_nodenum() + " nodes");
        } while (this.reorder_nodenum() != lastsize);
        return first;
    }

    void bdd_reorder_auto() {
        if (!this.bdd_reorder_ready()) {
            return;
        }
        this.bdd_reorder(this.bddreordermethod);
        --this.bddreordertimes;
    }

    int bdd_reorder_gain() {
        if (this.usednum_before == 0) {
            return 0;
        }
        return 100 * (this.usednum_before - this.usednum_after) / this.usednum_before;
    }

    @Override
    public void done() {
        this.bdd_add_perf_stats();
        super.done();
        this.bdd_done();
    }

    void bdd_add_perf_stats() {
        if (this.cachestats.enabled || this.hasCacheStatsCallback()) {
            this.invokeCacheStatsCallbacks();
        }
        int usedBddNodes = -1;
        if (this.maxusedbddnodesstats.enabled || this.hasMaxUsedBddNodesStatsCallback()) {
            if (usedBddNodes == -1) {
                usedBddNodes = this.bdd_used_nodes_count();
            }
            this.maxusedbddnodesstats.newMeasurement(usedBddNodes);
            this.invokeMaxUsedBddNodesStatsCallbacks();
        }
        if (this.hasContinuousStatsCallback()) {
            if (usedBddNodes == -1) {
                usedBddNodes = this.bdd_used_nodes_count();
            }
            this.invokeContinuousStatsCallbacks(usedBddNodes, this.cachestats.opMiss);
        }
        if (this.maxmemorystats.enabled || this.hasMaxMemoryStatsCallback()) {
            this.maxmemorystats.newMeasurement();
            this.invokeMaxMemoryStatsCallbacks();
        }
    }

    void bdd_done() {
        this.bdd_pairs_done();
        this.bddnodes = null;
        this.bddrefstack = null;
        this.bddvarset = null;
        this.bddvar2level = null;
        this.bddlevel2var = null;
        this.bdd_operator_done();
        this.bddrunning = false;
        this.bddnodesize = 0;
        this.bddmaxnodesize = 0;
        this.bddvarnum = 0;
        this.bddproduced = 0;
        this.univ = 1;
    }

    int bdd_setmaxnodenum(int size) {
        if (size > this.bddnodesize || size == 0) {
            int old = this.bddmaxnodesize;
            this.bddmaxnodesize = size;
            return old;
        }
        return JFactory.bdd_error(-11);
    }

    int bdd_setminfreenodes(int mf) {
        int old = this.minfreenodes;
        if (mf < 0 || mf > 100) {
            return JFactory.bdd_error(-3);
        }
        this.minfreenodes = mf;
        return old;
    }

    int bdd_setmaxincrease(int size) {
        int old = this.bddmaxnodeincrease;
        if (size < 0) {
            return JFactory.bdd_error(-19);
        }
        this.bddmaxnodeincrease = size;
        return old;
    }

    double bdd_setincreasefactor(double x) {
        if (x < 0.0) {
            return JFactory.bdd_error(-3);
        }
        double old = this.increasefactor;
        this.increasefactor = x;
        return old;
    }

    double bdd_setcacheratio(double r) {
        double old = this.cacheratio;
        if (r <= 0.0) {
            return JFactory.bdd_error(-3);
        }
        if (this.bddnodesize == 0) {
            return old;
        }
        this.cacheratio = r;
        this.bdd_operator_noderesize();
        return old;
    }

    int bdd_setvarnum(int num) {
        int oldbddvarnum = this.bddvarnum;
        if (num < 1 || num > 0x1FFFFF) {
            JFactory.bdd_error(-3);
            return 0;
        }
        if (num < this.bddvarnum) {
            return JFactory.bdd_error(-15);
        }
        if (num == this.bddvarnum) {
            return 0;
        }
        this.bdd_disable_reorder();
        if (this.bddvarset == null) {
            this.bddvarset = new int[num * 2];
            this.bddlevel2var = new int[num + 1];
            this.bddvar2level = new int[num + 1];
        } else {
            int[] bddvarset2 = new int[num * 2];
            System.arraycopy(this.bddvarset, 0, bddvarset2, 0, this.bddvarset.length);
            this.bddvarset = bddvarset2;
            int[] bddlevel2var2 = new int[num + 1];
            System.arraycopy(this.bddlevel2var, 0, bddlevel2var2, 0, this.bddlevel2var.length);
            this.bddlevel2var = bddlevel2var2;
            int[] bddvar2level2 = new int[num + 1];
            System.arraycopy(this.bddvar2level, 0, bddvar2level2, 0, this.bddvar2level.length);
            this.bddvar2level = bddvar2level2;
        }
        this.bddrefstack = new int[num * 3 + 1];
        this.bddrefstacktop = 0;
        if (this.ZDD) {
            this.bddvarnum = 0;
        }
        this.univ = 1;
        int bdv = this.bddvarnum;
        while (this.bddvarnum < num) {
            if (this.ZDD) {
                int res = 1;
                int res_not = 1;
                for (int k = num - 1; k >= 0; --k) {
                    int res2 = this.zdd_makenode(k, k == this.bddvarnum ? 0 : res, res);
                    this.INCREF(res2);
                    this.DECREF(res);
                    res = res2;
                    int res_not2 = k == this.bddvarnum ? res_not : this.zdd_makenode(k, res_not, res_not);
                    this.INCREF(res_not2);
                    this.DECREF(res_not);
                    res_not = res_not2;
                    if (bdv != this.bddvarnum) continue;
                    int univ2 = this.zdd_makenode(k, this.univ, this.univ);
                    this.INCREF(univ2);
                    this.DECREF(this.univ);
                    this.univ = univ2;
                }
                this.bddvarset[this.bddvarnum * 2] = res;
                this.bddvarset[this.bddvarnum * 2 + 1] = res_not;
                this.SETMAXREF(this.univ);
            } else {
                this.bddvarset[this.bddvarnum * 2] = this.PUSHREF(this.bdd_makenode(this.bddvarnum, 0, 1));
                this.bddvarset[this.bddvarnum * 2 + 1] = this.bdd_makenode(this.bddvarnum, 1, 0);
                this.POPREF(1);
            }
            if (this.bdderrorcond != 0) {
                this.bddvarnum = bdv;
                return -this.bdderrorcond;
            }
            this.SETMAXREF(this.bddvarset[this.bddvarnum * 2]);
            this.SETMAXREF(this.bddvarset[this.bddvarnum * 2 + 1]);
            this.bddlevel2var[this.bddvarnum] = this.bddvarnum;
            this.bddvar2level[this.bddvarnum] = this.bddvarnum;
            ++this.bddvarnum;
        }
        this.SETLEVELANDMARK(0, num);
        this.SETLEVELANDMARK(1, num);
        this.bddvar2level[num] = num;
        this.bddlevel2var[num] = num;
        this.bdd_pairs_resize(oldbddvarnum, this.bddvarnum);
        this.bdd_operator_varresize();
        if (this.ZDD) {
            if (this.verbose != 0) {
                System.out.println("Changed number of ZDD variables to " + num + ", all existing ZDDs are now invalid.");
            }
            for (int n = 0; n < this.fdvarnum; ++n) {
                this.domain[n].var.free();
                this.domain[n].var = this.makeSet(this.domain[n].ivar);
            }
        }
        this.bdd_enable_reorder();
        return 0;
    }

    void bdd_reorder_init() {
        this.reorderdisabled = 0;
        this.vartree = null;
        this.bdd_clrvarblocks();
        this.bdd_reorder_verbose(0);
        this.bdd_autoreorder_times(0, 0);
        this.usednum_after = 0;
        this.usednum_before = 0;
        this.blockid = 0;
    }

    int reorder_nodenum() {
        return this.bdd_getnodenum();
    }

    int bdd_getnodenum() {
        return this.bddnodesize - this.bddfreenum;
    }

    int bdd_reorder_verbose(int v) {
        int tmp = this.verbose;
        this.verbose = v;
        return tmp;
    }

    int bdd_autoreorder(int method) {
        int tmp = this.bddreordermethod;
        this.bddreordermethod = method;
        this.bddreordertimes = -1;
        return tmp;
    }

    int bdd_autoreorder_times(int method, int num) {
        int tmp = this.bddreordermethod;
        this.bddreordermethod = method;
        this.bddreordertimes = num;
        return tmp;
    }

    void bdd_reorder_done() {
        this.bddtree_del(this.vartree);
        this.bdd_operator_reset();
        this.vartree = null;
    }

    void bddtree_del(BddTree t) {
        if (t == null) {
            return;
        }
        this.bddtree_del(t.nextlevel);
        this.bddtree_del(t.next);
        t.seq = null;
    }

    void bdd_clrvarblocks() {
        this.bddtree_del(this.vartree);
        this.vartree = null;
        this.blockid = 0;
    }

    int NODEHASHr(int var, int l, int h) {
        return Math.abs(JFactory.PAIR(l, h) % this.levels[var].size) + this.levels[var].start;
    }

    void bdd_setvarorder(int[] neworder) {
        if (this.vartree != null) {
            JFactory.bdd_error(-14);
            return;
        }
        this.reorder_init();
        for (int level = 0; level < this.bddvarnum; ++level) {
            int lowvar = neworder[level];
            while (this.bddvar2level[lowvar] > level) {
                this.reorder_varup(lowvar);
            }
        }
        this.reorder_done();
    }

    int reorder_varup(int var) {
        if (var < 0 || var >= this.bddvarnum) {
            return JFactory.bdd_error(-2);
        }
        if (this.bddvar2level[var] == 0) {
            return 0;
        }
        return this.reorder_vardown(this.bddlevel2var[this.bddvar2level[var] - 1]);
    }

    int reorder_vardown(int var) {
        if (var < 0 || var >= this.bddvarnum) {
            return JFactory.bdd_error(-2);
        }
        int level = this.bddvar2level[var];
        if (level >= this.bddvarnum - 1) {
            return 0;
        }
        this.resizedInMakenode = false;
        if (this.imatrixDepends(this.iactmtx, var, this.bddlevel2var[level + 1])) {
            int toBeProcessed = this.reorder_downSimple(var);
            levelData l = this.levels[var];
            if (l.nodenum < l.size / 3 || l.nodenum >= l.size * 3 / 2 && l.size < l.maxsize) {
                this.reorder_swapResize(toBeProcessed, var);
                this.reorder_localGbcResize(toBeProcessed, var);
            } else {
                this.reorder_swap(toBeProcessed, var);
                this.reorder_localGbc(var);
            }
        }
        int n = this.bddlevel2var[level];
        this.bddlevel2var[level] = this.bddlevel2var[level + 1];
        this.bddlevel2var[level + 1] = n;
        n = this.bddvar2level[var];
        this.bddvar2level[var] = this.bddvar2level[this.bddlevel2var[level]];
        this.bddvar2level[this.bddlevel2var[level]] = n;
        this.bdd_pairs_vardown(level);
        if (this.resizedInMakenode) {
            this.reorder_rehashAll();
        }
        return 0;
    }

    boolean imatrixDepends(imatrix mtx, int a, int b) {
        return (mtx.rows[a][b / 8] & 1 << b % 8) != 0;
    }

    void reorder_setLevellookup() {
        for (int n = 0; n < this.bddvarnum; ++n) {
            this.levels[n].maxsize = this.bddnodesize / this.bddvarnum;
            this.levels[n].start = n * this.levels[n].maxsize;
            this.levels[n].size = Math.min(this.levels[n].maxsize, this.levels[n].nodenum * 5 / 4);
            if (this.levels[n].size < 4) continue;
            this.levels[n].size = this.bdd_prime_lte(this.levels[n].size);
        }
    }

    void reorder_rehashAll() {
        int n;
        this.reorder_setLevellookup();
        this.bddfreepos = 0;
        for (n = this.bddnodesize - 1; n >= 0; --n) {
            this.SETHASH(n, 0);
        }
        for (n = this.bddnodesize - 1; n >= 2; --n) {
            if (this.HASREF(n)) {
                int hash2 = this.NODEHASH2(this.VARr(n), this.LOW(n), this.HIGH(n));
                this.SETNEXT(n, this.HASH(hash2));
                this.SETHASH(hash2, n);
                continue;
            }
            this.SETNEXT(n, this.bddfreepos);
            this.bddfreepos = n;
        }
    }

    void reorder_localGbc(int var0) {
        int var1 = this.bddlevel2var[this.bddvar2level[var0] + 1];
        int vl1 = this.levels[var1].start;
        int size1 = this.levels[var1].size;
        for (int n = 0; n < size1; ++n) {
            int hash = n + vl1;
            int r = this.HASH(hash);
            this.SETHASH(hash, 0);
            while (r != 0) {
                int next = this.NEXT(r);
                if (this.HASREF(r)) {
                    this.SETNEXT(r, this.HASH(hash));
                    this.SETHASH(hash, r);
                } else {
                    this.DECREF(this.LOW(r));
                    this.DECREF(this.HIGH(r));
                    this.SETLOW(r, -1);
                    this.SETNEXT(r, this.bddfreepos);
                    this.bddfreepos = r;
                    --this.levels[var1].nodenum;
                    ++this.bddfreenum;
                }
                r = next;
            }
        }
    }

    int reorder_downSimple(int var0) {
        int toBeProcessed = 0;
        int var1 = this.bddlevel2var[this.bddvar2level[var0] + 1];
        int vl0 = this.levels[var0].start;
        int size0 = this.levels[var0].size;
        this.levels[var0].nodenum = 0;
        for (int n = 0; n < size0; ++n) {
            int r = this.HASH(n + vl0);
            this.SETHASH(n + vl0, 0);
            while (r != 0) {
                int next = this.NEXT(r);
                if (this.VARr(this.LOW(r)) != var1 && this.VARr(this.HIGH(r)) != var1) {
                    this.SETNEXT(r, this.HASH(n + vl0));
                    this.SETHASH(n + vl0, r);
                    ++this.levels[var0].nodenum;
                } else {
                    this.SETNEXT(r, toBeProcessed);
                    toBeProcessed = r;
                }
                r = next;
            }
        }
        return toBeProcessed;
    }

    void reorder_swapResize(int toBeProcessed, int var0) {
        int var1 = this.bddlevel2var[this.bddvar2level[var0] + 1];
        while (toBeProcessed != 0) {
            int f11;
            int f10;
            int f01;
            int f00;
            int next = this.NEXT(toBeProcessed);
            int f0 = this.LOW(toBeProcessed);
            int f1 = this.HIGH(toBeProcessed);
            if (this.VARr(f0) == var1) {
                f00 = this.LOW(f0);
                f01 = this.HIGH(f0);
            } else {
                f00 = f01 = f0;
            }
            if (this.VARr(f1) == var1) {
                f10 = this.LOW(f1);
                f11 = this.HIGH(f1);
            } else {
                f10 = f11 = f1;
            }
            f0 = this.reorder_makenode(var0, f00, f10);
            f1 = this.reorder_makenode(var0, f01, f11);
            this.DECREF(this.LOW(toBeProcessed));
            this.DECREF(this.HIGH(toBeProcessed));
            this.SETVARr(toBeProcessed, var1);
            this.SETLOW(toBeProcessed, f0);
            this.SETHIGH(toBeProcessed, f1);
            ++this.levels[var1].nodenum;
            toBeProcessed = next;
        }
    }

    static final int MIN(int a, int b) {
        return Math.min(a, b);
    }

    void reorder_localGbcResize(int toBeProcessed, int var0) {
        int var1 = this.bddlevel2var[this.bddvar2level[var0] + 1];
        int vl1 = this.levels[var1].start;
        int size1 = this.levels[var1].size;
        for (int n = 0; n < size1; ++n) {
            int hash = n + vl1;
            int r = this.HASH(hash);
            this.SETHASH(hash, 0);
            while (r != 0) {
                int next = this.NEXT(r);
                if (this.HASREF(r)) {
                    this.SETNEXT(r, toBeProcessed);
                    toBeProcessed = r;
                } else {
                    this.DECREF(this.LOW(r));
                    this.DECREF(this.HIGH(r));
                    this.SETLOW(r, -1);
                    this.SETNEXT(r, this.bddfreepos);
                    this.bddfreepos = r;
                    --this.levels[var1].nodenum;
                    ++this.bddfreenum;
                }
                r = next;
            }
        }
        this.levels[var1].size = this.levels[var1].nodenum < this.levels[var1].size ? JFactory.MIN(this.levels[var1].maxsize, this.levels[var1].size / 2) : JFactory.MIN(this.levels[var1].maxsize, this.levels[var1].size * 2);
        if (this.levels[var1].size >= 4) {
            this.levels[var1].size = this.bdd_prime_lte(this.levels[var1].size);
        }
        while (toBeProcessed != 0) {
            int next = this.NEXT(toBeProcessed);
            int hash = this.NODEHASH2(this.VARr(toBeProcessed), this.LOW(toBeProcessed), this.HIGH(toBeProcessed));
            this.SETNEXT(toBeProcessed, this.HASH(hash));
            this.SETHASH(hash, toBeProcessed);
            toBeProcessed = next;
        }
    }

    void reorder_swap(int toBeProcessed, int var0) {
        int var1 = this.bddlevel2var[this.bddvar2level[var0] + 1];
        while (toBeProcessed != 0) {
            int f11;
            int f10;
            int f01;
            int f00;
            int next = this.NEXT(toBeProcessed);
            int f0 = this.LOW(toBeProcessed);
            int f1 = this.HIGH(toBeProcessed);
            if (this.VARr(f0) == var1) {
                f00 = this.LOW(f0);
                f01 = this.HIGH(f0);
            } else {
                f00 = f01 = f0;
            }
            if (this.VARr(f1) == var1) {
                f10 = this.LOW(f1);
                f11 = this.HIGH(f1);
            } else {
                f10 = f11 = f1;
            }
            f0 = this.reorder_makenode(var0, f00, f10);
            f1 = this.reorder_makenode(var0, f01, f11);
            this.DECREF(this.LOW(toBeProcessed));
            this.DECREF(this.HIGH(toBeProcessed));
            this.SETVARr(toBeProcessed, var1);
            this.SETLOW(toBeProcessed, f0);
            this.SETHIGH(toBeProcessed, f1);
            ++this.levels[var1].nodenum;
            int hash = this.NODEHASH2(this.VARr(toBeProcessed), this.LOW(toBeProcessed), this.HIGH(toBeProcessed));
            this.SETNEXT(toBeProcessed, this.HASH(hash));
            this.SETHASH(hash, toBeProcessed);
            toBeProcessed = next;
        }
    }

    int NODEHASH2(int var, int l, int h) {
        return Math.abs(JFactory.PAIR(l, h) % this.levels[var].size) + this.levels[var].start;
    }

    int reorder_makenode(int var, int low, int high) {
        if (this.cachestats.enabled) {
            ++this.cachestats.uniqueAccess;
        }
        if (this.ZDD) {
            if (high == 0) {
                this.INCREF(low);
                return low;
            }
        } else if (low == high) {
            this.INCREF(low);
            return low;
        }
        int hash = this.NODEHASH2(var, low, high);
        int res = this.HASH(hash);
        while (res != 0) {
            if (this.LOW(res) == low && this.HIGH(res) == high) {
                if (this.cachestats.enabled) {
                    ++this.cachestats.uniqueHit;
                }
                this.INCREF(res);
                return res;
            }
            res = this.NEXT(res);
            if (!this.cachestats.enabled) continue;
            ++this.cachestats.uniqueChain;
        }
        if (this.cachestats.enabled) {
            ++this.cachestats.uniqueMiss;
        }
        if (this.bddfreepos == 0) {
            if (this.bdderrorcond != 0) {
                return 0;
            }
            this.bdd_noderesize(false);
            this.resizedInMakenode = true;
            if (this.bddfreepos == 0) {
                JFactory.bdd_error(-17);
                this.bdderrorcond = Math.abs(-17);
                return 0;
            }
        }
        res = this.bddfreepos;
        this.bddfreepos = this.NEXT(this.bddfreepos);
        ++this.levels[var].nodenum;
        ++this.bddproduced;
        --this.bddfreenum;
        this.SETVARr(res, var);
        this.SETLOW(res, low);
        this.SETHIGH(res, high);
        this.SETNEXT(res, this.HASH(hash));
        this.SETHASH(hash, res);
        this.CLEARREF(res);
        this.INCREF(res);
        this.INCREF(this.LOW(res));
        this.INCREF(this.HIGH(res));
        return res;
    }

    int reorder_init() {
        this.reorderstats.usednum_before = this.getNodeNum();
        this.reorderstats.time = System.currentTimeMillis();
        this.invokeReorderStatsCallbacks(true);
        this.levels = new levelData[this.bddvarnum];
        for (int n = 0; n < this.bddvarnum; ++n) {
            this.levels[n] = new levelData();
            this.levels[n].start = -1;
            this.levels[n].size = 0;
            this.levels[n].nodenum = 0;
        }
        if (this.mark_roots() < 0) {
            return -1;
        }
        this.reorder_setLevellookup();
        this.reorder_gbc();
        return 0;
    }

    int mark_roots() {
        int n;
        boolean[] dep = new boolean[this.bddvarnum];
        this.extrootsize = 0;
        for (n = 2; n < this.bddnodesize; ++n) {
            this.SETLEVELANDMARK(n, this.bddlevel2var[this.LEVELANDMARK(n)]);
            if (!this.HASREF(n)) continue;
            this.SETMARK(n);
            ++this.extrootsize;
        }
        this.extroots = new int[this.extrootsize];
        this.iactmtx = this.imatrixNew(this.bddvarnum);
        this.extrootsize = 0;
        for (n = 2; n < this.bddnodesize; ++n) {
            if (this.MARKED(n)) {
                this.UNMARK(n);
                this.extroots[this.extrootsize++] = n;
                for (int i = 0; i < this.bddvarnum; ++i) {
                    dep[i] = false;
                }
                dep[this.VARr((int)n)] = true;
                ++this.levels[this.VARr((int)n)].nodenum;
                this.addref_rec(this.LOW(n), dep);
                this.addref_rec(this.HIGH(n), dep);
                this.addDependencies(dep);
            }
            this.SETHASH(n, 0);
        }
        this.SETHASH(0, 0);
        this.SETHASH(1, 0);
        return 0;
    }

    imatrix imatrixNew(int size) {
        imatrix mtx = new imatrix();
        mtx.rows = new byte[size][];
        for (int n = 0; n < size; ++n) {
            mtx.rows[n] = new byte[size / 8 + 1];
        }
        mtx.size = size;
        return mtx;
    }

    void addref_rec(int r, boolean[] dep) {
        if (r < 2) {
            return;
        }
        if (!this.HASREF(r) || this.MARKED(r)) {
            --this.bddfreenum;
            dep[this.VARr((int)r) & 0xFFDFFFFF] = true;
            ++this.levels[this.VARr((int)r) & 0xFFDFFFFF].nodenum;
            this.addref_rec(this.LOW(r), dep);
            this.addref_rec(this.HIGH(r), dep);
        } else {
            for (int n = 0; n < this.bddvarnum; ++n) {
                int n2 = n;
                dep[n2] = dep[n2] | this.imatrixDepends(this.iactmtx, this.VARr(r) & 0xFFDFFFFF, n);
            }
        }
        this.INCREF(r);
    }

    void addDependencies(boolean[] dep) {
        for (int n = 0; n < this.bddvarnum; ++n) {
            for (int m = n; m < this.bddvarnum; ++m) {
                if (!dep[n] || !dep[m]) continue;
                this.imatrixSet(this.iactmtx, n, m);
                this.imatrixSet(this.iactmtx, m, n);
            }
        }
    }

    void imatrixSet(imatrix mtx, int a, int b) {
        byte[] byArray = mtx.rows[a];
        int n = b / 8;
        byArray[n] = (byte)(byArray[n] | 1 << b % 8);
    }

    void reorder_gbc() {
        this.bddfreepos = 0;
        this.bddfreenum = 0;
        for (int n = this.bddnodesize - 1; n >= 2; --n) {
            if (this.HASREF(n)) {
                int hash = this.NODEHASH2(this.VARr(n), this.LOW(n), this.HIGH(n));
                this.SETNEXT(n, this.HASH(hash));
                this.SETHASH(hash, n);
                continue;
            }
            this.SETLOW(n, -1);
            this.SETNEXT(n, this.bddfreepos);
            this.bddfreepos = n;
            ++this.bddfreenum;
        }
    }

    void reorder_done() {
        int n;
        for (n = 0; n < this.extrootsize; ++n) {
            this.SETMARK(this.extroots[n]);
        }
        for (n = 2; n < this.bddnodesize; ++n) {
            if (this.MARKED(n)) {
                this.UNMARK(n);
            } else {
                this.CLEARREF(n);
            }
            this.SETLEVELANDMARK(n, this.bddvar2level[this.LEVELANDMARK(n)]);
        }
        this.imatrixDelete(this.iactmtx);
        this.bdd_gbc();
        this.reorderstats.usednum_after = this.getNodeNum();
        this.reorderstats.time = System.currentTimeMillis() - this.reorderstats.time;
        this.invokeReorderStatsCallbacks(false);
    }

    void imatrixDelete(imatrix mtx) {
        for (int n = 0; n < mtx.size; ++n) {
            mtx.rows[n] = null;
        }
        mtx.rows = null;
    }

    int bdd_getallocnum() {
        return this.bddnodesize;
    }

    int bdd_setallocnum(int size) {
        int old = this.bddnodesize;
        this.doResize(true, old, size);
        return old;
    }

    int bdd_swapvar(int v1, int v2) {
        if (this.vartree != null) {
            return JFactory.bdd_error(-14);
        }
        if (v1 == v2) {
            return 0;
        }
        if (v1 < 0 || v1 >= this.bddvarnum || v2 < 0 || v2 >= this.bddvarnum) {
            return JFactory.bdd_error(-2);
        }
        int l1 = this.bddvar2level[v1];
        int l2 = this.bddvar2level[v2];
        if (l1 > l2) {
            int tmp = v1;
            v1 = v2;
            v2 = tmp;
            l1 = this.bddvar2level[v1];
            l2 = this.bddvar2level[v2];
        }
        this.reorder_init();
        while (this.bddvar2level[v1] < l2) {
            this.reorder_vardown(v1);
        }
        while (this.bddvar2level[v2] > l1) {
            this.reorder_varup(v2);
        }
        this.reorder_done();
        return 0;
    }

    void bdd_fprintall(PrintStream out) {
        for (int n = 0; n < this.bddnodesize; ++n) {
            if (this.LOW(n) == -1) continue;
            out.print("[" + JFactory.right(n, 5) + " - " + JFactory.right(this.GETREF(n), 2) + "] ");
            out.print(JFactory.right(this.bddlevel2var[this.LEVEL(n)], 3));
            out.print(": " + JFactory.right(this.LOW(n), 3));
            out.println(" " + JFactory.right(this.HIGH(n), 3));
        }
    }

    void bdd_fprinttable(PrintStream out, int r) {
        out.println("ROOT: " + r);
        if (r < 2) {
            return;
        }
        this.bdd_mark(r);
        for (int n = 0; n < this.bddnodesize; ++n) {
            if (!this.MARKED(n)) continue;
            this.UNMARK(n);
            out.print("[" + JFactory.right(n, 5) + "] ");
            out.print(JFactory.right(this.bddlevel2var[this.LEVEL(n)], 3));
            out.print(": " + JFactory.right(this.LOW(n), 3));
            out.println(" " + JFactory.right(this.HIGH(n), 3));
        }
    }

    int bdd_load(BufferedReader ifile, int[] translate) throws IOException {
        int n;
        this.lh_nodenum = Integer.parseInt(this.readNext(ifile));
        int vnum = Integer.parseInt(this.readNext(ifile));
        if (this.lh_nodenum == 0 && vnum == 0) {
            int root = Integer.parseInt(this.readNext(ifile));
            return root;
        }
        this.loadvar2level = new int[vnum];
        for (n = 0; n < vnum; ++n) {
            this.loadvar2level[n] = Integer.parseInt(this.readNext(ifile));
        }
        if (vnum > this.bddvarnum) {
            this.bdd_setvarnum(vnum);
        }
        this.lh_table = new LoadHash[this.lh_nodenum];
        for (n = 0; n < this.lh_nodenum; ++n) {
            this.lh_table[n] = new LoadHash();
            this.lh_table[n].first = -1;
            this.lh_table[n].next = n + 1;
        }
        this.lh_table[this.lh_nodenum - 1].next = -1;
        this.lh_freepos = 0;
        int tmproot = this.bdd_loaddata(ifile, translate);
        for (n = 0; n < this.lh_nodenum; ++n) {
            this.bdd_delref(this.lh_table[n].data);
        }
        this.lh_table = null;
        this.loadvar2level = null;
        int root = tmproot;
        return root;
    }

    int bdd_loaddata(BufferedReader ifile, int[] translate) throws IOException {
        int root = 0;
        for (int n = 0; n < this.lh_nodenum; ++n) {
            int key = Integer.parseInt(this.readNext(ifile));
            int var = Integer.parseInt(this.readNext(ifile));
            if (translate != null) {
                var = translate[var];
            }
            int low = Integer.parseInt(this.readNext(ifile));
            int high = Integer.parseInt(this.readNext(ifile));
            if (low >= 2) {
                low = this.loadhash_get(low);
            }
            if (high >= 2) {
                high = this.loadhash_get(high);
            }
            if (low < 0 || high < 0 || var < 0) {
                return JFactory.bdd_error(-7);
            }
            if (this.ZDD) {
                if (low == 1) {
                    low = this.univ;
                }
                if (high == 1) {
                    high = this.univ;
                }
            }
            root = this.bdd_addref(this.bdd_ite(this.bdd_ithvar(var), high, low));
            this.loadhash_add(key, root);
        }
        return root;
    }

    void loadhash_add(int key, int data) {
        int hash = key % this.lh_nodenum;
        int pos = this.lh_freepos;
        this.lh_freepos = this.lh_table[pos].next;
        this.lh_table[pos].next = this.lh_table[hash].first;
        this.lh_table[hash].first = pos;
        this.lh_table[pos].key = key;
        this.lh_table[pos].data = data;
    }

    int loadhash_get(int key) {
        int hash = this.lh_table[key % this.lh_nodenum].first;
        while (hash != -1 && this.lh_table[hash].key != key) {
            hash = this.lh_table[hash].next;
        }
        if (hash == -1) {
            return -1;
        }
        return this.lh_table[hash].data;
    }

    void bdd_save(BufferedWriter out, int r) throws IOException {
        int[] n = new int[1];
        if (r < 2) {
            out.write("0 0 " + r + "\n");
            return;
        }
        this.bdd_markcount(r, n);
        this.bdd_unmark(r);
        out.write(n[0] + " " + this.bddvarnum + "\n");
        for (int x = 0; x < this.bddvarnum; ++x) {
            out.write(this.bddvar2level[x] + " ");
        }
        out.write("\n");
        this.bdd_save_rec(out, r);
        this.bdd_unmark(r);
        out.flush();
    }

    void bdd_save_rec(BufferedWriter out, int root) throws IOException {
        if (root < 2) {
            return;
        }
        if (this.MARKED(root)) {
            return;
        }
        this.SETMARK(root);
        this.bdd_save_rec(out, this.LOW(root));
        this.bdd_save_rec(out, this.HIGH(root));
        out.write(root + " ");
        out.write(this.bddlevel2var[this.LEVEL(root)] + " ");
        out.write(this.LOW(root) + " ");
        out.write(this.HIGH(root) + "\n");
    }

    static String right(int x, int w) {
        return JFactory.right(Integer.toString(x), w);
    }

    static String right(String s, int w) {
        int n = s.length();
        StringBuffer b = new StringBuffer(w);
        for (int i = n; i < w; ++i) {
            b.append(' ');
        }
        b.append(s);
        return b.toString();
    }

    int bdd_intaddvarblock(int first, int last, boolean fixed) {
        if (first < 0 || first >= this.bddvarnum || last < 0 || last >= this.bddvarnum) {
            return JFactory.bdd_error(-2);
        }
        BddTree t = this.bddtree_addrange(this.vartree, first, last, fixed, this.blockid);
        if (t == null) {
            return JFactory.bdd_error(-14);
        }
        this.vartree = t;
        return this.blockid++;
    }

    BddTree bddtree_addrange_rec(BddTree t, BddTree prev, int first, int last, boolean fixed, int id) {
        if (first < 0 || last < 0 || last < first) {
            return null;
        }
        if (t == null) {
            t = this.bddtree_new(id);
            t.firstVar = first;
            t.firstLevel = this.bddvar2level[first];
            t.fixed = fixed;
            t.seq = new int[last - first + 1];
            t.lastVar = last;
            t.lastLevel = this.bddvar2level[last];
            this.update_seq(t);
            t.prev = prev;
            return t;
        }
        if (first == t.firstVar && last == t.lastVar) {
            return t;
        }
        int firstLev = Math.min(this.bddvar2level[first], this.bddvar2level[last]);
        int lastLev = Math.max(this.bddvar2level[first], this.bddvar2level[last]);
        if (firstLev >= t.firstLevel && lastLev <= t.lastLevel) {
            t.nextlevel = this.bddtree_addrange_rec(t.nextlevel, null, first, last, fixed, id);
            return t;
        }
        if (lastLev < t.firstLevel) {
            BddTree tnew = this.bddtree_new(id);
            tnew.firstVar = first;
            tnew.firstLevel = firstLev;
            tnew.lastVar = last;
            tnew.lastLevel = lastLev;
            tnew.fixed = fixed;
            tnew.seq = new int[last - first + 1];
            this.update_seq(tnew);
            tnew.next = t;
            tnew.prev = t.prev;
            t.prev = tnew;
            return tnew;
        }
        if (firstLev > t.lastLevel) {
            t.next = this.bddtree_addrange_rec(t.next, t, first, last, fixed, id);
            return t;
        }
        if (firstLev <= t.firstLevel) {
            BddTree dis = t;
            while (true) {
                if (lastLev >= dis.firstLevel && lastLev < dis.lastLevel) {
                    return null;
                }
                if (dis.next == null || last < dis.next.firstLevel) {
                    BddTree tnew = this.bddtree_new(id);
                    tnew.firstVar = first;
                    tnew.firstLevel = firstLev;
                    tnew.lastVar = last;
                    tnew.lastLevel = lastLev;
                    tnew.fixed = fixed;
                    tnew.seq = new int[last - first + 1];
                    this.update_seq(tnew);
                    tnew.nextlevel = t;
                    tnew.next = dis.next;
                    tnew.prev = t.prev;
                    if (dis.next != null) {
                        dis.next.prev = tnew;
                    }
                    dis.next = null;
                    t.prev = null;
                    return tnew;
                }
                dis = dis.next;
            }
        }
        return null;
    }

    void update_seq(BddTree t) {
        int n;
        int low = t.firstVar;
        int high = t.lastVar;
        for (n = t.firstVar; n <= t.lastVar; ++n) {
            if (this.bddvar2level[n] < this.bddvar2level[low]) {
                low = n;
            }
            if (this.bddvar2level[n] <= this.bddvar2level[high]) continue;
            high = n;
        }
        for (n = t.firstVar; n <= t.lastVar; ++n) {
            t.seq[this.bddvar2level[n] - this.bddvar2level[low]] = n;
        }
        t.firstLevel = this.bddvar2level[low];
        t.lastLevel = this.bddvar2level[high];
    }

    BddTree bddtree_addrange(BddTree t, int first, int last, boolean fixed, int id) {
        return this.bddtree_addrange_rec(t, null, first, last, fixed, id);
    }

    void bdd_varblockall() {
        for (int n = 0; n < this.bddvarnum; ++n) {
            this.bdd_intaddvarblock(n, n, true);
        }
    }

    void print_order_rec(PrintStream o, BddTree t, int level) {
        if (t == null) {
            return;
        }
        if (t.nextlevel != null) {
            int i;
            for (i = 0; i < level; ++i) {
                o.print("   ");
            }
            o.print(JFactory.right(t.id, 3));
            if (t.interleaved) {
                o.print('x');
            }
            o.println("{\n");
            this.print_order_rec(o, t.nextlevel, level + 1);
            for (i = 0; i < level; ++i) {
                o.print("   ");
            }
            o.print(JFactory.right(t.id, 3));
            o.println("}\n");
            this.print_order_rec(o, t.next, level);
        } else {
            for (int i = 0; i < level; ++i) {
                o.print("   ");
            }
            o.print(JFactory.right(t.id, 3));
            if (t.interleaved) {
                o.print('x');
            }
            o.println();
            this.print_order_rec(o, t.next, level);
        }
    }

    void bdd_fprintorder(PrintStream ofile) {
        this.print_order_rec(ofile, this.vartree, 0);
    }

    void bdd_fprintstat(PrintStream out) {
        BDDFactory.CacheStats s = this.cachestats;
        out.print(s.toString());
    }

    void bdd_validate_all() {
        for (int n = this.bddnodesize - 1; n >= 2; --n) {
            if (!this.HASREF(n)) continue;
            this.bdd_validate(n);
        }
    }

    void bdd_validate(int k) {
        try {
            this.validate(k, -1);
        }
        finally {
            this.bdd_unmark(k);
        }
    }

    void validate(int k, int lastLevel) {
        if (k < 2) {
            return;
        }
        int lev = this.LEVEL(k);
        if (lev <= lastLevel) {
            throw new BDDException(lev + " <= " + lastLevel);
        }
        if (this.ZDD) {
            if (this.HIGH(k) == 0) {
                throw new BDDException("HIGH(" + k + ")==0");
            }
        } else if (this.LOW(k) == this.HIGH(k)) {
            throw new BDDException("LOW(" + k + ") == HIGH(" + k + ")");
        }
        if (this.MARKED(k)) {
            return;
        }
        this.SETMARK(k);
        this.validate(this.LOW(k), lev);
        this.validate(this.HIGH(k), lev);
    }

    final int Random(int i) {
        return this.rng.nextInt(i) + 1;
    }

    static boolean isEven(int src) {
        return (src & 1) == 0;
    }

    static boolean hasFactor(int src, int n) {
        return src != n && src % n == 0;
    }

    static boolean BitIsSet(int src, int b) {
        return (src & 1 << b) != 0;
    }

    static final int u64_mulmod(int a, int b, int c) {
        return (int)((long)a * (long)b % (long)c);
    }

    static int numberOfBits(int src) {
        if (src == 0) {
            return 0;
        }
        for (int b = 31; b > 0; --b) {
            if (!JFactory.BitIsSet(src, b)) continue;
            return b + 1;
        }
        return 1;
    }

    static boolean isWitness(int witness, int src) {
        int bitNum = JFactory.numberOfBits(src - 1) - 1;
        int d = 1;
        for (int i = bitNum; i >= 0; --i) {
            int x = d;
            if ((d = JFactory.u64_mulmod(d, d, src)) == 1 && x != 1 && x != src - 1) {
                return true;
            }
            if (!JFactory.BitIsSet(src - 1, i)) continue;
            d = JFactory.u64_mulmod(d, witness, src);
        }
        return d != 1;
    }

    boolean isMillerRabinPrime(int src) {
        for (int n = 0; n < 20; ++n) {
            int witness = this.Random(src - 1);
            if (!JFactory.isWitness(witness, src)) continue;
            return false;
        }
        return true;
    }

    static boolean hasEasyFactors(int src) {
        return JFactory.hasFactor(src, 3) || JFactory.hasFactor(src, 5) || JFactory.hasFactor(src, 7) || JFactory.hasFactor(src, 11) || JFactory.hasFactor(src, 13);
    }

    boolean isPrime(int src) {
        if (JFactory.hasEasyFactors(src)) {
            return false;
        }
        return this.isMillerRabinPrime(src);
    }

    int bdd_prime_gte(int src) {
        if (JFactory.isEven(src)) {
            ++src;
        }
        while (!this.isPrime(src)) {
            src += 2;
        }
        return src;
    }

    int bdd_prime_lte(int src) {
        if (JFactory.isEven(src)) {
            --src;
        }
        while (!this.isPrime(src)) {
            src -= 2;
        }
        return src;
    }

    class bddPair
    extends BDDPairing {
        int[] result;
        int last;
        int id;
        bddPair next;

        bddPair() {
        }

        @Override
        public void set(int oldvar, int newvar) {
            JFactory.this.bdd_setpair(this, oldvar, newvar);
        }

        @Override
        public void set(int oldvar, BDD newvar) {
            JFactory.this.bdd_setbddpair(this, oldvar, BDDFactoryIntImpl.unwrap(newvar));
        }

        @Override
        public void reset() {
            JFactory.this.bdd_resetpair(this);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append('{');
            boolean any = false;
            for (int i = 0; i < this.result.length; ++i) {
                if (this.result[i] == (JFactory.this.ZDD ? JFactory.this.zdd_makenode(i, 0, 1) : JFactory.this.bdd_ithvar(JFactory.this.bddlevel2var[i]))) continue;
                if (any) {
                    sb.append(", ");
                }
                any = true;
                sb.append(JFactory.this.bddlevel2var[i]);
                sb.append('=');
                BDDFactoryIntImpl.IntBDD b = JFactory.this.makeBDD(this.result[i]);
                sb.append(b);
                ((BDD)b).free();
            }
            sb.append('}');
            return sb.toString();
        }
    }

    private static class BddCache {
        BddCacheData[] table;
        int tablesize;

        private BddCache() {
        }

        BddCache copy() {
            BddCache that = new BddCache();
            boolean is_d = this.table instanceof BddCacheDataD[];
            that.table = is_d ? new BddCacheDataD[this.table.length] : new BddCacheDataI[this.table.length];
            that.tablesize = this.tablesize;
            for (int i = 0; i < this.table.length; ++i) {
                that.table[i] = this.table[i].copy();
            }
            return that;
        }
    }

    static class BddTree {
        int firstVar;
        int lastVar;
        int firstLevel;
        int lastLevel;
        int pos;
        int[] seq;
        boolean fixed;
        boolean interleaved;
        int id;
        BddTree next;
        BddTree prev;
        BddTree nextlevel;

        BddTree() {
        }
    }

    private static class JavaBDDException
    extends BDDException {
        private static final long serialVersionUID = 3257289144995952950L;

        public JavaBDDException(int x) {
            super(errorstrings[-x]);
        }
    }

    private static class ReorderException
    extends RuntimeException {
        private static final long serialVersionUID = 3256727264505772345L;

        private ReorderException() {
        }
    }

    private static class BddCacheDataI
    extends BddCacheData {
        int d;
        int e;
        int res;

        private BddCacheDataI() {
        }

        @Override
        BddCacheData copy() {
            BddCacheDataI that = new BddCacheDataI();
            that.a = this.a;
            that.b = this.b;
            that.c = this.c;
            that.d = this.d;
            that.e = this.e;
            that.res = this.res;
            return that;
        }
    }

    private static class BddCacheDataD
    extends BddCacheData {
        double dres;

        private BddCacheDataD() {
        }

        @Override
        BddCacheData copy() {
            BddCacheDataD that = new BddCacheDataD();
            that.a = this.a;
            that.b = this.b;
            that.c = this.c;
            that.dres = this.dres;
            return that;
        }
    }

    private static abstract class BddCacheData {
        int a;
        int b;
        int c;

        private BddCacheData() {
        }

        abstract BddCacheData copy();
    }

    static class sizePair {
        int val;
        BddTree block;

        sizePair() {
        }
    }

    static class levelData {
        int start;
        int size;
        int maxsize;
        int nodenum;

        levelData() {
        }
    }

    static class imatrix {
        byte[][] rows;
        int size;

        imatrix() {
        }
    }

    static class LoadHash {
        int key;
        int data;
        int first;
        int next;

        LoadHash() {
        }
    }
}

