/*
 * Decompiled with CFR 0.152.
 */
package com.github.javabdd;

import com.github.javabdd.BDD;
import com.github.javabdd.BDDBitVector;
import com.github.javabdd.BDDException;
import com.github.javabdd.BDDFactory;
import com.github.javabdd.BDDPairing;
import com.github.javabdd.BDDVarSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class BDDFactoryIntImpl
extends BDDFactory {
    static final boolean USE_FINALIZER = false;
    static final boolean FINALIZER_CHECK_BDD_NOT_FREED = false;
    protected int[] to_free = new int[8];
    protected int to_free_length = 0;

    protected abstract void addref_impl(int var1);

    protected abstract void delref_impl(int var1);

    protected abstract int zero_impl();

    protected abstract int one_impl();

    protected int universe_impl() {
        return this.one_impl();
    }

    protected abstract int invalid_bdd_impl();

    protected abstract int var_impl(int var1);

    protected abstract int level_impl(int var1);

    protected abstract int low_impl(int var1);

    protected abstract int high_impl(int var1);

    protected abstract int ithVar_impl(int var1);

    protected abstract int nithVar_impl(int var1);

    protected abstract int makenode_impl(int var1, int var2, int var3);

    protected abstract int ite_impl(int var1, int var2, int var3);

    protected abstract int apply_impl(int var1, int var2, BDDFactory.BDDOp var3);

    protected abstract int not_impl(int var1);

    protected abstract int applyAll_impl(int var1, int var2, BDDFactory.BDDOp var3, int var4);

    protected abstract int applyEx_impl(int var1, int var2, BDDFactory.BDDOp var3, int var4);

    protected abstract int applyUni_impl(int var1, int var2, BDDFactory.BDDOp var3, int var4);

    protected abstract int compose_impl(int var1, int var2, int var3);

    protected abstract int constrain_impl(int var1, int var2);

    protected abstract int restrict_impl(int var1, int var2);

    protected abstract int simplify_impl(int var1, int var2);

    protected abstract int support_impl(int var1);

    protected abstract int exist_impl(int var1, int var2);

    protected abstract int forAll_impl(int var1, int var2);

    protected abstract int unique_impl(int var1, int var2);

    protected abstract int fullSatOne_impl(int var1);

    protected abstract int replace_impl(int var1, BDDPairing var2);

    protected abstract int veccompose_impl(int var1, BDDPairing var2);

    protected abstract int relnext_impl(int var1, int var2, int var3);

    protected abstract int relnextUnion_impl(int var1, int var2, int var3, int var4);

    protected abstract int relnextIntersection_impl(int var1, int var2, int var3, int var4);

    protected abstract int relprev_impl(int var1, int var2, int var3);

    protected abstract int relprevUnion_impl(int var1, int var2, int var3, int var4);

    protected abstract int relprevIntersection_impl(int var1, int var2, int var3, int var4);

    protected abstract int saturationForward_impl(int var1, int[] var2, int[] var3, int var4);

    protected abstract int boundedSaturationForward_impl(int var1, int var2, int[] var3, int[] var4, int var5);

    protected abstract int saturationBackward_impl(int var1, int[] var2, int[] var3, int var4);

    protected abstract int boundedSaturationBackward_impl(int var1, int var2, int[] var3, int[] var4, int var5);

    protected abstract int nodeCount_impl(int var1);

    protected abstract double pathCount_impl(int var1);

    protected abstract double satCount_impl(int var1);

    protected abstract int satOne_impl(int var1);

    protected abstract int satOne_impl2(int var1, int var2, boolean var3);

    protected abstract int nodeCount_impl2(int[] var1);

    protected abstract int[] varProfile_impl(int var1);

    protected abstract void printTable_impl(int var1);

    protected IntBDD makeBDD(int v) {
        return new IntBDD(v);
    }

    protected static final int unwrap(BDD b) {
        return ((IntBDD)b).v;
    }

    protected static final int[] unwrap(Collection<BDD> c) {
        int[] result = new int[c.size()];
        int k = -1;
        Iterator<BDD> i = c.iterator();
        while (i.hasNext()) {
            result[++k] = ((IntBDD)i.next()).v;
        }
        return result;
    }

    protected IntBDDVarSet makeBDDVarSet(int v) {
        if (this.isZDD()) {
            return new IntZDDVarSet(v);
        }
        return new IntBDDVarSet(v);
    }

    protected static final int unwrap(BDDVarSet b) {
        return ((IntBDDVarSet)b).v;
    }

    @Override
    public BDD ithVar(int var) {
        return this.makeBDD(this.ithVar_impl(var));
    }

    @Override
    public BDD nithVar(int var) {
        return this.makeBDD(this.nithVar_impl(var));
    }

    @Override
    public int nodeCount(Collection<BDD> r) {
        return this.nodeCount_impl2(BDDFactoryIntImpl.unwrap(r));
    }

    @Override
    public BDD one() {
        return this.makeBDD(this.one_impl());
    }

    @Override
    public BDD universe() {
        return this.makeBDD(this.universe_impl());
    }

    @Override
    public BDDVarSet emptySet() {
        return this.makeBDDVarSet(this.one_impl());
    }

    @Override
    public void printTable(BDD b) {
        this.printTable_impl(BDDFactoryIntImpl.unwrap(b));
    }

    @Override
    public BDD zero() {
        return this.makeBDD(this.zero_impl());
    }

    @Override
    public void done() {
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deferredFree(int v) {
        if (v == this.invalid_bdd_impl()) {
            return;
        }
        int[] nArray = this.to_free;
        synchronized (this.to_free) {
            if (this.to_free_length == this.to_free.length) {
                int[] t = new int[this.to_free.length * 2];
                System.arraycopy(this.to_free, 0, t, 0, this.to_free.length);
                this.to_free = t;
            }
            this.to_free[this.to_free_length++] = v;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDeferredFree() {
        int[] nArray = this.to_free;
        synchronized (this.to_free) {
            while (this.to_free_length > 0) {
                this.delref_impl(this.to_free[--this.to_free_length]);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public class IntBDD
    extends BDD {
        protected int v;

        protected IntBDD(int v) {
            this.v = v;
            BDDFactoryIntImpl.this.addref_impl(v);
        }

        @Override
        public BDD apply(BDD that, BDDFactory.BDDOp opr) {
            return BDDFactoryIntImpl.this.makeBDD(BDDFactoryIntImpl.this.apply_impl(this.v, BDDFactoryIntImpl.unwrap(that), opr));
        }

        @Override
        public BDD applyAll(BDD that, BDDFactory.BDDOp opr, BDDVarSet var) {
            return BDDFactoryIntImpl.this.makeBDD(BDDFactoryIntImpl.this.applyAll_impl(this.v, BDDFactoryIntImpl.unwrap(that), opr, BDDFactoryIntImpl.unwrap(var)));
        }

        @Override
        public BDD applyEx(BDD that, BDDFactory.BDDOp opr, BDDVarSet var) {
            return BDDFactoryIntImpl.this.makeBDD(BDDFactoryIntImpl.this.applyEx_impl(this.v, BDDFactoryIntImpl.unwrap(that), opr, BDDFactoryIntImpl.unwrap(var)));
        }

        @Override
        public BDD applyUni(BDD that, BDDFactory.BDDOp opr, BDDVarSet var) {
            return BDDFactoryIntImpl.this.makeBDD(BDDFactoryIntImpl.this.applyUni_impl(this.v, BDDFactoryIntImpl.unwrap(that), opr, BDDFactoryIntImpl.unwrap(var)));
        }

        @Override
        public BDD applyWith(BDD that, BDDFactory.BDDOp opr) {
            int v2 = BDDFactoryIntImpl.unwrap(that);
            int v3 = BDDFactoryIntImpl.this.apply_impl(this.v, v2, opr);
            BDDFactoryIntImpl.this.addref_impl(v3);
            BDDFactoryIntImpl.this.delref_impl(this.v);
            if (this != that) {
                that.free();
            }
            this.v = v3;
            return this;
        }

        @Override
        public BDD compose(BDD g, int var) {
            return BDDFactoryIntImpl.this.makeBDD(BDDFactoryIntImpl.this.compose_impl(this.v, BDDFactoryIntImpl.unwrap(g), var));
        }

        @Override
        public BDD constrain(BDD that) {
            return BDDFactoryIntImpl.this.makeBDD(BDDFactoryIntImpl.this.constrain_impl(this.v, BDDFactoryIntImpl.unwrap(that)));
        }

        @Override
        public boolean equalsBDD(BDD that) {
            return this.v == BDDFactoryIntImpl.unwrap(that);
        }

        @Override
        public BDD exist(BDDVarSet var) {
            return BDDFactoryIntImpl.this.makeBDD(BDDFactoryIntImpl.this.exist_impl(this.v, BDDFactoryIntImpl.unwrap(var)));
        }

        @Override
        public BDD forAll(BDDVarSet var) {
            return BDDFactoryIntImpl.this.makeBDD(BDDFactoryIntImpl.this.forAll_impl(this.v, BDDFactoryIntImpl.unwrap(var)));
        }

        @Override
        public void free() {
            BDDFactoryIntImpl.this.delref_impl(this.v);
            this.v = BDDFactoryIntImpl.this.invalid_bdd_impl();
        }

        @Override
        public BDD fullSatOne() {
            return BDDFactoryIntImpl.this.makeBDD(BDDFactoryIntImpl.this.fullSatOne_impl(this.v));
        }

        @Override
        public BDDFactory getFactory() {
            return BDDFactoryIntImpl.this;
        }

        @Override
        public int hashCode() {
            return this.v;
        }

        @Override
        public BDD high() {
            return BDDFactoryIntImpl.this.makeBDD(BDDFactoryIntImpl.this.high_impl(this.v));
        }

        @Override
        public BDD id() {
            return BDDFactoryIntImpl.this.makeBDD(this.v);
        }

        @Override
        public boolean isOne() {
            return this.v == BDDFactoryIntImpl.this.one_impl();
        }

        @Override
        public boolean isUniverse() {
            return this.v == BDDFactoryIntImpl.this.universe_impl();
        }

        @Override
        public boolean isZero() {
            return this.v == BDDFactoryIntImpl.this.zero_impl();
        }

        @Override
        public BDD ite(BDD thenBDD, BDD elseBDD) {
            return BDDFactoryIntImpl.this.makeBDD(BDDFactoryIntImpl.this.ite_impl(this.v, BDDFactoryIntImpl.unwrap(thenBDD), BDDFactoryIntImpl.unwrap(elseBDD)));
        }

        @Override
        public BDD low() {
            return BDDFactoryIntImpl.this.makeBDD(BDDFactoryIntImpl.this.low_impl(this.v));
        }

        @Override
        public int level() {
            return BDDFactoryIntImpl.this.level_impl(this.v);
        }

        @Override
        public int nodeCount() {
            return BDDFactoryIntImpl.this.nodeCount_impl(this.v);
        }

        @Override
        public BDD not() {
            return BDDFactoryIntImpl.this.makeBDD(BDDFactoryIntImpl.this.not_impl(this.v));
        }

        @Override
        public double pathCount() {
            return BDDFactoryIntImpl.this.pathCount_impl(this.v);
        }

        @Override
        public BDD replace(BDDPairing pair) {
            return BDDFactoryIntImpl.this.makeBDD(BDDFactoryIntImpl.this.replace_impl(this.v, pair));
        }

        @Override
        public BDD replaceWith(BDDPairing pair) {
            int v3 = BDDFactoryIntImpl.this.replace_impl(this.v, pair);
            BDDFactoryIntImpl.this.addref_impl(v3);
            BDDFactoryIntImpl.this.delref_impl(this.v);
            this.v = v3;
            return this;
        }

        @Override
        public BDD restrict(BDD var) {
            return BDDFactoryIntImpl.this.makeBDD(BDDFactoryIntImpl.this.restrict_impl(this.v, BDDFactoryIntImpl.unwrap(var)));
        }

        @Override
        public BDD restrictWith(BDD that) {
            int v2 = BDDFactoryIntImpl.unwrap(that);
            int v3 = BDDFactoryIntImpl.this.restrict_impl(this.v, v2);
            BDDFactoryIntImpl.this.addref_impl(v3);
            BDDFactoryIntImpl.this.delref_impl(this.v);
            if (this != that) {
                that.free();
            }
            this.v = v3;
            return this;
        }

        @Override
        public double satCount() {
            return BDDFactoryIntImpl.this.satCount_impl(this.v);
        }

        @Override
        public BDD satOne() {
            return BDDFactoryIntImpl.this.makeBDD(BDDFactoryIntImpl.this.satOne_impl(this.v));
        }

        @Override
        public BDD satOne(BDDVarSet var, boolean pol) {
            return BDDFactoryIntImpl.this.makeBDD(BDDFactoryIntImpl.this.satOne_impl2(this.v, BDDFactoryIntImpl.unwrap(var), pol));
        }

        @Override
        public BDD simplify(BDD d) {
            return BDDFactoryIntImpl.this.makeBDD(BDDFactoryIntImpl.this.simplify_impl(this.v, BDDFactoryIntImpl.unwrap(d)));
        }

        @Override
        public BDDVarSet support() {
            return BDDFactoryIntImpl.this.makeBDDVarSet(BDDFactoryIntImpl.this.support_impl(this.v));
        }

        @Override
        public BDD unique(BDDVarSet var) {
            return BDDFactoryIntImpl.this.makeBDD(BDDFactoryIntImpl.this.unique_impl(this.v, BDDFactoryIntImpl.unwrap(var)));
        }

        @Override
        public int var() {
            return BDDFactoryIntImpl.this.var_impl(this.v);
        }

        @Override
        public int[] varProfile() {
            return BDDFactoryIntImpl.this.varProfile_impl(this.v);
        }

        @Override
        public BDD veccompose(BDDPairing pair) {
            return BDDFactoryIntImpl.this.makeBDD(BDDFactoryIntImpl.this.veccompose_impl(this.v, pair));
        }

        @Override
        public BDDVarSet toVarSet() {
            return BDDFactoryIntImpl.this.makeBDDVarSet(this.v);
        }

        @Override
        public BDD relnext(BDD states, BDDVarSet vars) {
            return BDDFactoryIntImpl.this.makeBDD(BDDFactoryIntImpl.this.relnext_impl(BDDFactoryIntImpl.unwrap(states), this.v, BDDFactoryIntImpl.unwrap(vars)));
        }

        @Override
        public BDD relnextUnion(BDD states, BDD union, BDDVarSet vars) {
            return BDDFactoryIntImpl.this.makeBDD(BDDFactoryIntImpl.this.relnextUnion_impl(BDDFactoryIntImpl.unwrap(states), this.v, BDDFactoryIntImpl.unwrap(union), BDDFactoryIntImpl.unwrap(vars)));
        }

        @Override
        public BDD relnextIntersection(BDD states, BDD restriction, BDDVarSet vars) {
            return BDDFactoryIntImpl.this.makeBDD(BDDFactoryIntImpl.this.relnextIntersection_impl(BDDFactoryIntImpl.unwrap(states), this.v, BDDFactoryIntImpl.unwrap(restriction), BDDFactoryIntImpl.unwrap(vars)));
        }

        @Override
        public BDD relprev(BDD states, BDDVarSet vars) {
            return BDDFactoryIntImpl.this.makeBDD(BDDFactoryIntImpl.this.relprev_impl(this.v, BDDFactoryIntImpl.unwrap(states), BDDFactoryIntImpl.unwrap(vars)));
        }

        @Override
        public BDD relprevUnion(BDD states, BDD union, BDDVarSet vars) {
            return BDDFactoryIntImpl.this.makeBDD(BDDFactoryIntImpl.this.relprevUnion_impl(this.v, BDDFactoryIntImpl.unwrap(states), BDDFactoryIntImpl.unwrap(union), BDDFactoryIntImpl.unwrap(vars)));
        }

        @Override
        public BDD relprevIntersection(BDD states, BDD restriction, BDDVarSet vars) {
            return BDDFactoryIntImpl.this.makeBDD(BDDFactoryIntImpl.this.relprevIntersection_impl(this.v, BDDFactoryIntImpl.unwrap(states), BDDFactoryIntImpl.unwrap(restriction), BDDFactoryIntImpl.unwrap(vars)));
        }

        @Override
        public BDD saturationForward(List<BDD> relations, List<BDDVarSet> vars, int instance) {
            if (relations.size() != vars.size()) {
                throw new RuntimeException("Expected the number of relations and variable sets to be equal.");
            }
            int nrOfRelations = relations.size();
            int[] unwrappedRelations = new int[nrOfRelations];
            int[] unwrappedVars = new int[nrOfRelations];
            for (int i = 0; i < nrOfRelations; ++i) {
                unwrappedRelations[i] = BDDFactoryIntImpl.unwrap(relations.get(i));
                unwrappedVars[i] = BDDFactoryIntImpl.unwrap(vars.get(i));
            }
            return BDDFactoryIntImpl.this.makeBDD(BDDFactoryIntImpl.this.saturationForward_impl(this.v, unwrappedRelations, unwrappedVars, instance));
        }

        @Override
        public BDD boundedSaturationForward(BDD bound, List<BDD> relations, List<BDDVarSet> vars, int instance) {
            if (relations.size() != vars.size()) {
                throw new RuntimeException("Expected the number of relations and variable sets to be equal.");
            }
            int nrOfRelations = relations.size();
            int[] unwrappedRelations = new int[nrOfRelations];
            int[] unwrappedVars = new int[nrOfRelations];
            for (int i = 0; i < nrOfRelations; ++i) {
                unwrappedRelations[i] = BDDFactoryIntImpl.unwrap(relations.get(i));
                unwrappedVars[i] = BDDFactoryIntImpl.unwrap(vars.get(i));
            }
            return BDDFactoryIntImpl.this.makeBDD(BDDFactoryIntImpl.this.boundedSaturationForward_impl(this.v, BDDFactoryIntImpl.unwrap(bound), unwrappedRelations, unwrappedVars, instance));
        }

        @Override
        public BDD saturationBackward(List<BDD> relations, List<BDDVarSet> vars, int instance) {
            if (relations.size() != vars.size()) {
                throw new RuntimeException("Expected the number of relations and variable sets to be equal.");
            }
            int nrOfRelations = relations.size();
            int[] unwrappedRelations = new int[nrOfRelations];
            int[] unwrappedVars = new int[nrOfRelations];
            for (int i = 0; i < nrOfRelations; ++i) {
                unwrappedRelations[i] = BDDFactoryIntImpl.unwrap(relations.get(i));
                unwrappedVars[i] = BDDFactoryIntImpl.unwrap(vars.get(i));
            }
            return BDDFactoryIntImpl.this.makeBDD(BDDFactoryIntImpl.this.saturationBackward_impl(this.v, unwrappedRelations, unwrappedVars, instance));
        }

        @Override
        public BDD boundedSaturationBackward(BDD bound, List<BDD> relations, List<BDDVarSet> vars, int instance) {
            if (relations.size() != vars.size()) {
                throw new RuntimeException("Expected the number of relations and variable sets to be equal.");
            }
            int nrOfRelations = relations.size();
            int[] unwrappedRelations = new int[nrOfRelations];
            int[] unwrappedVars = new int[nrOfRelations];
            for (int i = 0; i < nrOfRelations; ++i) {
                unwrappedRelations[i] = BDDFactoryIntImpl.unwrap(relations.get(i));
                unwrappedVars[i] = BDDFactoryIntImpl.unwrap(vars.get(i));
            }
            return BDDFactoryIntImpl.this.makeBDD(BDDFactoryIntImpl.this.boundedSaturationBackward_impl(this.v, BDDFactoryIntImpl.unwrap(bound), unwrappedRelations, unwrappedVars, instance));
        }
    }

    public class IntZDDVarSet
    extends IntBDDVarSet {
        protected IntZDDVarSet(int v) {
            super(v);
        }

        @Override
        protected int do_intersect(int v1, int v2) {
            if (v1 == BDDFactoryIntImpl.this.one_impl()) {
                return v2;
            }
            if (v2 == BDDFactoryIntImpl.this.one_impl()) {
                return v1;
            }
            int l1 = BDDFactoryIntImpl.this.level_impl(v1);
            int l2 = BDDFactoryIntImpl.this.level_impl(v2);
            while (true) {
                if (v1 == v2) {
                    return v1;
                }
                if (l1 < l2) {
                    if ((v1 = BDDFactoryIntImpl.this.high_impl(v1)) == BDDFactoryIntImpl.this.one_impl()) {
                        return v2;
                    }
                    l1 = BDDFactoryIntImpl.this.level_impl(v1);
                    continue;
                }
                if (l1 <= l2) break;
                if ((v2 = BDDFactoryIntImpl.this.high_impl(v2)) == BDDFactoryIntImpl.this.one_impl()) {
                    return v1;
                }
                l2 = BDDFactoryIntImpl.this.level_impl(v2);
            }
            int k = this.do_intersect(BDDFactoryIntImpl.this.high_impl(v1), BDDFactoryIntImpl.this.high_impl(v2));
            BDDFactoryIntImpl.this.addref_impl(k);
            int result = BDDFactoryIntImpl.this.makenode_impl(l1, BDDFactoryIntImpl.this.zero_impl(), k);
            BDDFactoryIntImpl.this.delref_impl(k);
            return result;
        }

        @Override
        protected int do_union(int v1, int v2) {
            if (v1 == v2) {
                return v1;
            }
            if (v1 == BDDFactoryIntImpl.this.one_impl()) {
                return v2;
            }
            if (v2 == BDDFactoryIntImpl.this.one_impl()) {
                return v1;
            }
            int l1 = BDDFactoryIntImpl.this.level_impl(v1);
            int l2 = BDDFactoryIntImpl.this.level_impl(v2);
            int vv1 = v1;
            int vv2 = v2;
            int lev = l1;
            if (l1 <= l2) {
                vv1 = BDDFactoryIntImpl.this.high_impl(v1);
            }
            if (l1 >= l2) {
                vv2 = BDDFactoryIntImpl.this.high_impl(v2);
                lev = l2;
            }
            int k = this.do_union(vv1, vv2);
            BDDFactoryIntImpl.this.addref_impl(k);
            int result = BDDFactoryIntImpl.this.makenode_impl(lev, BDDFactoryIntImpl.this.zero_impl(), k);
            BDDFactoryIntImpl.this.delref_impl(k);
            return result;
        }

        @Override
        protected int do_unionvar(int v, int var) {
            return this.do_unionlevel(v, BDDFactoryIntImpl.this.var2Level(var));
        }

        private int do_unionlevel(int v, int lev) {
            if (v == BDDFactoryIntImpl.this.one_impl()) {
                return BDDFactoryIntImpl.this.makenode_impl(lev, BDDFactoryIntImpl.this.zero_impl(), BDDFactoryIntImpl.this.one_impl());
            }
            int l = BDDFactoryIntImpl.this.level_impl(v);
            if (l == lev) {
                return v;
            }
            if (l > lev) {
                return BDDFactoryIntImpl.this.makenode_impl(lev, BDDFactoryIntImpl.this.zero_impl(), v);
            }
            int k = this.do_unionlevel(BDDFactoryIntImpl.this.high_impl(v), lev);
            BDDFactoryIntImpl.this.addref_impl(k);
            int result = BDDFactoryIntImpl.this.makenode_impl(l, BDDFactoryIntImpl.this.zero_impl(), k);
            BDDFactoryIntImpl.this.delref_impl(k);
            return result;
        }
    }

    public class IntBDDVarSet
    extends BDDVarSet {
        int v;

        protected IntBDDVarSet(int v) {
            this.v = v;
            BDDFactoryIntImpl.this.addref_impl(v);
        }

        @Override
        public boolean equalsBDDVarSet(BDDVarSet that) {
            return this.v == BDDFactoryIntImpl.unwrap(that);
        }

        @Override
        public void free() {
            BDDFactoryIntImpl.this.delref_impl(this.v);
            this.v = BDDFactoryIntImpl.this.invalid_bdd_impl();
        }

        @Override
        public BDDFactory getFactory() {
            return BDDFactoryIntImpl.this;
        }

        @Override
        public int hashCode() {
            return this.v;
        }

        @Override
        public BDDVarSet id() {
            return BDDFactoryIntImpl.this.makeBDDVarSet(this.v);
        }

        protected int do_intersect(int v1, int v2) {
            return BDDFactoryIntImpl.this.apply_impl(v1, v2, BDDFactory.or);
        }

        @Override
        public BDDVarSet intersect(BDDVarSet b) {
            return BDDFactoryIntImpl.this.makeBDDVarSet(this.do_intersect(this.v, BDDFactoryIntImpl.unwrap(b)));
        }

        @Override
        public BDDVarSet intersectWith(BDDVarSet b) {
            int v2 = BDDFactoryIntImpl.unwrap(b);
            int v3 = this.do_intersect(this.v, v2);
            BDDFactoryIntImpl.this.addref_impl(v3);
            BDDFactoryIntImpl.this.delref_impl(this.v);
            if (this != b) {
                b.free();
            }
            this.v = v3;
            return this;
        }

        @Override
        public boolean isEmpty() {
            return this.v == BDDFactoryIntImpl.this.one_impl();
        }

        @Override
        public int size() {
            int result = 0;
            int p = this.v;
            while (p != BDDFactoryIntImpl.this.one_impl()) {
                if (p == BDDFactoryIntImpl.this.zero_impl()) {
                    throw new BDDException("varset contains zero");
                }
                ++result;
                p = BDDFactoryIntImpl.this.high_impl(p);
            }
            return result;
        }

        @Override
        public int[] toArray() {
            int[] result = new int[this.size()];
            int k = -1;
            int p = this.v;
            while (p != BDDFactoryIntImpl.this.one_impl()) {
                result[++k] = BDDFactoryIntImpl.this.var_impl(p);
                p = BDDFactoryIntImpl.this.high_impl(p);
            }
            return result;
        }

        @Override
        public BDD toBDD() {
            return BDDFactoryIntImpl.this.makeBDD(this.v);
        }

        @Override
        public int[] toLevelArray() {
            int[] result = new int[this.size()];
            int k = -1;
            int p = this.v;
            while (p != BDDFactoryIntImpl.this.one_impl()) {
                result[++k] = BDDFactoryIntImpl.this.level_impl(p);
                p = BDDFactoryIntImpl.this.high_impl(p);
            }
            return result;
        }

        protected int do_unionvar(int v, int var) {
            return BDDFactoryIntImpl.this.apply_impl(v, BDDFactoryIntImpl.this.ithVar_impl(var), BDDFactory.and);
        }

        protected int do_union(int v1, int v2) {
            return BDDFactoryIntImpl.this.apply_impl(v1, v2, BDDFactory.and);
        }

        @Override
        public BDDVarSet union(BDDVarSet b) {
            return BDDFactoryIntImpl.this.makeBDDVarSet(this.do_union(this.v, BDDFactoryIntImpl.unwrap(b)));
        }

        @Override
        public BDDVarSet union(int var) {
            return BDDFactoryIntImpl.this.makeBDDVarSet(this.do_unionvar(this.v, var));
        }

        @Override
        public BDDVarSet unionWith(BDDVarSet b) {
            int v2 = BDDFactoryIntImpl.unwrap(b);
            int v3 = this.do_union(this.v, v2);
            BDDFactoryIntImpl.this.addref_impl(v3);
            BDDFactoryIntImpl.this.delref_impl(this.v);
            if (this != b) {
                b.free();
            }
            this.v = v3;
            return this;
        }

        @Override
        public BDDVarSet unionWith(int var) {
            int v3 = this.do_unionvar(this.v, var);
            BDDFactoryIntImpl.this.addref_impl(v3);
            BDDFactoryIntImpl.this.delref_impl(this.v);
            this.v = v3;
            return this;
        }
    }

    public class IntBDDBitVector
    extends BDDBitVector {
        protected IntBDDBitVector(int bitnum) {
            super(bitnum);
        }

        @Override
        public BDDFactory getFactory() {
            return BDDFactoryIntImpl.this;
        }
    }

    public class IntZDDVarSetWithFinalizer
    extends IntZDDVarSet {
        protected IntZDDVarSetWithFinalizer(int v) {
            super(v);
        }

        protected void finalize() throws Throwable {
            super.finalize();
        }
    }

    public class IntBDDVarSetWithFinalizer
    extends IntBDDVarSet {
        protected IntBDDVarSetWithFinalizer(int v) {
            super(v);
        }

        protected void finalize() throws Throwable {
            super.finalize();
            BDDFactoryIntImpl.this.deferredFree(this.v);
        }
    }

    public class IntBDDWithFinalizer
    extends IntBDD {
        protected IntBDDWithFinalizer(int v) {
            super(v);
        }

        protected void finalize() throws Throwable {
            super.finalize();
            BDDFactoryIntImpl.this.deferredFree(this.v);
        }
    }
}

