//////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2010, 2024 Contributors to the Eclipse Foundation
//
// See the NOTICE file(s) distributed with this work for additional
// information regarding copyright ownership.
//
// This program and the accompanying materials are made available
// under the terms of the MIT License which is available at
// https://opensource.org/licenses/MIT
//
// SPDX-License-Identifier: MIT
//////////////////////////////////////////////////////////////////////////////

// Disable Eclipse Java formatter for generated code file:
// @formatter:off

package org.eclipse.escet.cif.bdd.varorder.parser;

import static org.eclipse.escet.common.java.Strings.fmt;

import java.io.IOException;
import java.util.List;

import org.eclipse.escet.cif.bdd.varorder.parser.ast.VarOrdererArg;
import org.eclipse.escet.cif.bdd.varorder.parser.ast.VarOrdererInstance;
import org.eclipse.escet.setext.runtime.Parser;
import org.eclipse.escet.setext.runtime.ParserHooksBase;
import org.eclipse.escet.setext.runtime.Token;

/**
 * VarOrdererParser.
 *
 * <p>This parser is generated by SeText for main symbol
 * "VarOrdererSeq".</p>
 */
@SuppressWarnings("unchecked")
public final class VarOrdererParser extends Parser<List<VarOrdererInstance>> {
    /** The names of the non-terminals, ordered by their unique ids. */
    private static final String[] NON_TERMINAL_NAMES = {
        "VarOrdererSeq",
        "VarOrdererList",
        "VarOrderer",
        "VarOrdererArgs",
        "VarOrdererArg",
        "OptComma",
    };

    /**
     * The entry symbol names for each of the parser states, and {@code null}
     * for the initial state.
     */
    private static final String[] ENTRY_SYMBOL_NAMES = new String[] {
        null,
        "PAROPENTK",
        "IDENTIFIERTK",
        "VarOrderer",
        "VarOrdererSeq",
        "ARROWTK",
        "VarOrderer",
        "PAROPENTK",
        "PARCLOSETK",
        "IDENTIFIERTK",
        "VarOrdererArg",
        "VarOrdererArgs",
        "COMMATK",
        "OptComma",
        "PARCLOSETK",
        "VarOrdererArg",
        "EQUALTK",
        "SQOPENTK",
        "NUMBERTK",
        "STRINGTK",
        "VarOrderer",
        "VarOrderer",
        "VarOrdererList",
        "COMMATK",
        "SQCLOSETK",
        "VarOrderer",
        "VarOrdererSeq",
        "PARCLOSETK",
    };

    /** Parser call back hook methods. */
    private final VarOrdererParserHooks hooks;

    /** Whether parsing has completed (final result has been accepted). */
    private boolean accept;

    /** The parse result, but only if {@code #accept} is {@code true}. */
    private List<VarOrdererInstance> acceptObject;

    /** The current scanner token to process, if any. */
    private Token token;

    /** Whether parsing has resulted in a reduce action. */
    private boolean reduce;

    /** The state from which to reduce, if {@code #reduce} is {@code true}. */
    private int reduceState;

    /** The non-terminal to reduce, if {@code #reduce} is {@code true}. */
    private int reduceNonTerminal;

    /** Constructor for the {@link VarOrdererParser} class. */
    public VarOrdererParser() {
        super(new VarOrdererScanner());
        entrySymbolNames = ENTRY_SYMBOL_NAMES;
        firstTerminals = FirstTerminals.FIRST_TERMINALS;
        firstTerminalsReduced = FirstTerminalsReduced.FIRST_TERMINALS_REDUCED;
        reducibleNonTerminals = ReducibleNonTerminals.REDUCIBLE_NON_TERMINALS;
        reducibleNonTerminalsReduced = ReducibleNonTerminalsReduced.REDUCIBLE_NON_TERMINALS_REDUCED;
        hooks = new VarOrdererParserHooks();
    }

    @Override
    public ParserHooksBase getHooks() {
        return hooks;
    }

    @Override
    protected final List<VarOrdererInstance> parse() throws IOException {
        token = nextToken();
        int state;

        accept = false;

        while (true) {
            // Perform action.
            state = getCurrentState();
            reduce = false;

            switch (state) {
                case 0:
                    action0();
                    break;
                case 1:
                    action1();
                    break;
                case 2:
                    action2();
                    break;
                case 3:
                    action3();
                    break;
                case 4:
                    action4();
                    break;
                case 5:
                    action5();
                    break;
                case 6:
                    action6();
                    break;
                case 7:
                    action7();
                    break;
                case 8:
                    action8();
                    break;
                case 9:
                    action9();
                    break;
                case 10:
                    action10();
                    break;
                case 11:
                    action11();
                    break;
                case 12:
                    action12();
                    break;
                case 13:
                    action13();
                    break;
                case 14:
                    action14();
                    break;
                case 15:
                    action15();
                    break;
                case 16:
                    action16();
                    break;
                case 17:
                    action17();
                    break;
                case 18:
                    action18();
                    break;
                case 19:
                    action19();
                    break;
                case 20:
                    action20();
                    break;
                case 21:
                    action21();
                    break;
                case 22:
                    action22();
                    break;
                case 23:
                    action23();
                    break;
                case 24:
                    action24();
                    break;
                case 25:
                    action25();
                    break;
                case 26:
                    action26();
                    break;
                case 27:
                    action27();
                    break;
                default:
                    String msg = "Unknown parser state: " + state;
                    throw new RuntimeException(msg);
            }

            // Accept action.
            if (accept) {
                return acceptObject;
            }

            // Shift action.
            if (!reduce) {
                continue;
            }

            // Perform goto (as part of a reduce action).
            switch (reduceState) {
                case 0:
                    goto0();
                    break;
                case 1:
                    goto1();
                    break;
                case 2:
                    goto2();
                    break;
                case 3:
                    goto3();
                    break;
                case 4:
                    goto4();
                    break;
                case 5:
                    goto5();
                    break;
                case 6:
                    goto6();
                    break;
                case 7:
                    goto7();
                    break;
                case 8:
                    goto8();
                    break;
                case 9:
                    goto9();
                    break;
                case 10:
                    goto10();
                    break;
                case 11:
                    goto11();
                    break;
                case 12:
                    goto12();
                    break;
                case 13:
                    goto13();
                    break;
                case 14:
                    goto14();
                    break;
                case 15:
                    goto15();
                    break;
                case 16:
                    goto16();
                    break;
                case 17:
                    goto17();
                    break;
                case 18:
                    goto18();
                    break;
                case 19:
                    goto19();
                    break;
                case 20:
                    goto20();
                    break;
                case 21:
                    goto21();
                    break;
                case 22:
                    goto22();
                    break;
                case 23:
                    goto23();
                    break;
                case 24:
                    goto24();
                    break;
                case 25:
                    goto25();
                    break;
                case 26:
                    goto26();
                    break;
                case 27:
                    goto27();
                    break;
                default:
                    String msg = fmt("Unknown reduce state %d.", reduceState);
                    throw new RuntimeException(msg);
            }
        }
    }

    /**
     * Parser action code for parser state 0.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action0() throws IOException {
        switch (token.id) {
            case 4: {
                // Shift 1.
                token = doShift(token, 1);
                return;
            }

            case 7: {
                // Shift 2.
                token = doShift(token, 2);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 1.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action1() throws IOException {
        switch (token.id) {
            case 4: {
                // Shift 1.
                token = doShift(token, 1);
                return;
            }

            case 7: {
                // Shift 2.
                token = doShift(token, 2);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 2.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action2() throws IOException {
        switch (token.id) {
            case 4: {
                // Shift 7.
                token = doShift(token, 7);
                return;
            }

            case 0:
            case 1:
            case 3:
            case 6:
            case 11: {
                // Reduce VarOrderer : IDENTIFIERTK;
                doReduce1(token, 2);
                Object o1 = doReduce2();

                VarOrdererInstance o = hooks.parseVarOrderer1((Token)o1);

                reduce = true;
                reduceNonTerminal = 2;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 3.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action3() throws IOException {
        switch (token.id) {
            case 0:
            case 3:
            case 11: {
                // Reduce VarOrdererSeq : VarOrderer;
                doReduce1(token, 0);
                Object o1 = doReduce2();

                List<VarOrdererInstance> o = hooks.parseVarOrdererSeq1((VarOrdererInstance)o1);

                reduce = true;
                reduceNonTerminal = 0;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 4.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action4() throws IOException {
        switch (token.id) {
            case 0: {
                // Shift 5.
                token = doShift(token, 5);
                return;
            }

            case 11: {
                // Accept.
                Object rslt = doAccept(token);
                accept = true;
                acceptObject = (List<VarOrdererInstance>)rslt;
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 5.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action5() throws IOException {
        switch (token.id) {
            case 4: {
                // Shift 1.
                token = doShift(token, 1);
                return;
            }

            case 7: {
                // Shift 2.
                token = doShift(token, 2);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 6.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action6() throws IOException {
        switch (token.id) {
            case 0:
            case 3:
            case 11: {
                // Reduce VarOrdererSeq : VarOrdererSeq ARROWTK VarOrderer;
                doReduce1(token, 0);
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                List<VarOrdererInstance> o = hooks.parseVarOrdererSeq2((List<VarOrdererInstance>)o1, (VarOrdererInstance)o3);

                reduce = true;
                reduceNonTerminal = 0;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 7.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action7() throws IOException {
        switch (token.id) {
            case 3: {
                // Shift 8.
                token = doShift(token, 8);
                return;
            }

            case 7: {
                // Shift 9.
                token = doShift(token, 9);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 8.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action8() throws IOException {
        switch (token.id) {
            case 0:
            case 1:
            case 3:
            case 6:
            case 11: {
                // Reduce VarOrderer : IDENTIFIERTK PAROPENTK PARCLOSETK;
                doReduce1(token, 2);
                doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                VarOrdererInstance o = hooks.parseVarOrderer2((Token)o1);

                reduce = true;
                reduceNonTerminal = 2;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 9.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action9() throws IOException {
        switch (token.id) {
            case 2: {
                // Shift 16.
                token = doShift(token, 16);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 10.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action10() throws IOException {
        switch (token.id) {
            case 1:
            case 3: {
                // Reduce VarOrdererArgs : VarOrdererArg;
                doReduce1(token, 3);
                Object o1 = doReduce2();

                List<VarOrdererArg> o = hooks.parseVarOrdererArgs1((VarOrdererArg)o1);

                reduce = true;
                reduceNonTerminal = 3;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 11.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action11() throws IOException {
        switch (token.id) {
            case 1: {
                // Shift 12.
                token = doShift(token, 12);
                return;
            }

            case 3: {
                // Reduce OptComma : ;
                doReduce1(token, 5);
                Token o = hooks.parseOptComma1();

                reduce = true;
                reduceNonTerminal = 5;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 12.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action12() throws IOException {
        switch (token.id) {
            case 7: {
                // Shift 9.
                token = doShift(token, 9);
                return;
            }

            case 3: {
                // Reduce OptComma : COMMATK;
                doReduce1(token, 5);
                Object o1 = doReduce2();

                Token o = hooks.parseOptComma2((Token)o1);

                reduce = true;
                reduceNonTerminal = 5;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 13.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action13() throws IOException {
        switch (token.id) {
            case 3: {
                // Shift 14.
                token = doShift(token, 14);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 14.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action14() throws IOException {
        switch (token.id) {
            case 0:
            case 1:
            case 3:
            case 6:
            case 11: {
                // Reduce VarOrderer : IDENTIFIERTK PAROPENTK VarOrdererArgs OptComma PARCLOSETK;
                doReduce1(token, 2);
                doReduce2();
                Object o4 = doReduce2();
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                VarOrdererInstance o = hooks.parseVarOrderer3((Token)o1, (List<VarOrdererArg>)o3, (Token)o4);

                reduce = true;
                reduceNonTerminal = 2;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 15.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action15() throws IOException {
        switch (token.id) {
            case 1:
            case 3: {
                // Reduce VarOrdererArgs : VarOrdererArgs COMMATK VarOrdererArg;
                doReduce1(token, 3);
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                List<VarOrdererArg> o = hooks.parseVarOrdererArgs2((List<VarOrdererArg>)o1, (VarOrdererArg)o3);

                reduce = true;
                reduceNonTerminal = 3;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 16.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action16() throws IOException {
        switch (token.id) {
            case 4: {
                // Shift 1.
                token = doShift(token, 1);
                return;
            }

            case 7: {
                // Shift 2.
                token = doShift(token, 2);
                return;
            }

            case 5: {
                // Shift 17.
                token = doShift(token, 17);
                return;
            }

            case 8: {
                // Shift 18.
                token = doShift(token, 18);
                return;
            }

            case 9: {
                // Shift 19.
                token = doShift(token, 19);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 17.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action17() throws IOException {
        switch (token.id) {
            case 4: {
                // Shift 1.
                token = doShift(token, 1);
                return;
            }

            case 7: {
                // Shift 2.
                token = doShift(token, 2);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 18.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action18() throws IOException {
        switch (token.id) {
            case 1:
            case 3: {
                // Reduce VarOrdererArg : IDENTIFIERTK EQUALTK NUMBERTK;
                doReduce1(token, 4);
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                VarOrdererArg o = hooks.parseVarOrdererArg1((Token)o1, (Token)o3);

                reduce = true;
                reduceNonTerminal = 4;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 19.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action19() throws IOException {
        switch (token.id) {
            case 1:
            case 3: {
                // Reduce VarOrdererArg : IDENTIFIERTK EQUALTK STRINGTK;
                doReduce1(token, 4);
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                VarOrdererArg o = hooks.parseVarOrdererArg2((Token)o1, (Token)o3);

                reduce = true;
                reduceNonTerminal = 4;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 20.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action20() throws IOException {
        switch (token.id) {
            case 1:
            case 3: {
                // Reduce VarOrdererArg : IDENTIFIERTK EQUALTK VarOrderer;
                doReduce1(token, 4);
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                VarOrdererArg o = hooks.parseVarOrdererArg3((Token)o1, (VarOrdererInstance)o3);

                reduce = true;
                reduceNonTerminal = 4;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 21.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action21() throws IOException {
        switch (token.id) {
            case 1:
            case 6: {
                // Reduce VarOrdererList : VarOrderer;
                doReduce1(token, 1);
                Object o1 = doReduce2();

                List<VarOrdererInstance> o = hooks.parseVarOrdererList1((VarOrdererInstance)o1);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 22.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action22() throws IOException {
        switch (token.id) {
            case 1: {
                // Shift 23.
                token = doShift(token, 23);
                return;
            }

            case 6: {
                // Shift 24.
                token = doShift(token, 24);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 23.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action23() throws IOException {
        switch (token.id) {
            case 4: {
                // Shift 1.
                token = doShift(token, 1);
                return;
            }

            case 7: {
                // Shift 2.
                token = doShift(token, 2);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 24.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action24() throws IOException {
        switch (token.id) {
            case 1:
            case 3: {
                // Reduce VarOrdererArg : IDENTIFIERTK EQUALTK SQOPENTK VarOrdererList SQCLOSETK;
                doReduce1(token, 4);
                doReduce2();
                Object o4 = doReduce2();
                doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                VarOrdererArg o = hooks.parseVarOrdererArg4((Token)o1, (List<VarOrdererInstance>)o4);

                reduce = true;
                reduceNonTerminal = 4;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 25.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action25() throws IOException {
        switch (token.id) {
            case 1:
            case 6: {
                // Reduce VarOrdererList : VarOrdererList COMMATK VarOrderer;
                doReduce1(token, 1);
                Object o3 = doReduce2();
                doReduce2();
                Object o1 = doReduce2();

                List<VarOrdererInstance> o = hooks.parseVarOrdererList2((List<VarOrdererInstance>)o1, (VarOrdererInstance)o3);

                reduce = true;
                reduceNonTerminal = 1;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 26.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action26() throws IOException {
        switch (token.id) {
            case 0: {
                // Shift 5.
                token = doShift(token, 5);
                return;
            }

            case 3: {
                // Shift 27.
                token = doShift(token, 27);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /**
     * Parser action code for parser state 27.
     *
     * @throws IOException If reading the input failed due to an I/O error.
     */
    private final void action27() throws IOException {
        switch (token.id) {
            case 0:
            case 1:
            case 3:
            case 6:
            case 11: {
                // Reduce VarOrderer : PAROPENTK VarOrdererSeq PARCLOSETK;
                doReduce1(token, 2);
                doReduce2();
                Object o2 = doReduce2();
                Object o1 = doReduce2();

                VarOrdererInstance o = hooks.parseVarOrderer4((Token)o1, (List<VarOrdererInstance>)o2);

                reduce = true;
                reduceNonTerminal = 2;
                reduceState = doReduce3(o);
                return;
            }

            default:
                parsingFailed(token);
        }
    }

    /** Parser goto code for parser state 0. */
    private final void goto0() {
        switch (reduceNonTerminal) {
            case 0:
                // VarOrdererSeq
                doGoto(4);
                return;

            case 2:
                // VarOrderer
                doGoto(3);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 1. */
    private final void goto1() {
        switch (reduceNonTerminal) {
            case 0:
                // VarOrdererSeq
                doGoto(26);
                return;

            case 2:
                // VarOrderer
                doGoto(3);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 2. */
    private final void goto2() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 3. */
    private final void goto3() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 4. */
    private final void goto4() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 5. */
    private final void goto5() {
        switch (reduceNonTerminal) {
            case 2:
                // VarOrderer
                doGoto(6);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 6. */
    private final void goto6() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 7. */
    private final void goto7() {
        switch (reduceNonTerminal) {
            case 3:
                // VarOrdererArgs
                doGoto(11);
                return;

            case 4:
                // VarOrdererArg
                doGoto(10);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 8. */
    private final void goto8() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 9. */
    private final void goto9() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 10. */
    private final void goto10() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 11. */
    private final void goto11() {
        switch (reduceNonTerminal) {
            case 5:
                // OptComma
                doGoto(13);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 12. */
    private final void goto12() {
        switch (reduceNonTerminal) {
            case 4:
                // VarOrdererArg
                doGoto(15);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 13. */
    private final void goto13() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 14. */
    private final void goto14() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 15. */
    private final void goto15() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 16. */
    private final void goto16() {
        switch (reduceNonTerminal) {
            case 2:
                // VarOrderer
                doGoto(20);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 17. */
    private final void goto17() {
        switch (reduceNonTerminal) {
            case 1:
                // VarOrdererList
                doGoto(22);
                return;

            case 2:
                // VarOrderer
                doGoto(21);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 18. */
    private final void goto18() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 19. */
    private final void goto19() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 20. */
    private final void goto20() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 21. */
    private final void goto21() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 22. */
    private final void goto22() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 23. */
    private final void goto23() {
        switch (reduceNonTerminal) {
            case 2:
                // VarOrderer
                doGoto(25);
                return;

            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 24. */
    private final void goto24() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 25. */
    private final void goto25() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 26. */
    private final void goto26() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    /** Parser goto code for parser state 27. */
    private final void goto27() {
        switch (reduceNonTerminal) {
            default:
                String msg = fmt("Unknown non-terminal %d (%s) for reduce " +
                                 "state %d.", reduceNonTerminal,
                                 NON_TERMINAL_NAMES[reduceNonTerminal],
                                 reduceState);
                throw new RuntimeException(msg);
        }
    }

    @Override
    protected final String getNonTerminalName(int nonTerminalId) {
        return NON_TERMINAL_NAMES[nonTerminalId];
    }

    /** See {@code Parser.firstTerminals}. */
    private static final class FirstTerminals {
        /** See {@code Parser.firstTerminals}. */
        private static final int[][] FIRST_TERMINALS = new int[28][];

        static {
            init0();
            init1();
            init2();
            init3();
            init4();
            init5();
            init6();
            init7();
            init8();
            init9();
            init10();
            init11();
            init12();
            init13();
            init14();
            init15();
            init16();
            init17();
            init18();
            init19();
            init20();
            init21();
            init22();
            init23();
            init24();
            init25();
            init26();
            init27();
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [0]}. */
        private static void init0() {
            FIRST_TERMINALS[0] = new int[] {4, 7};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [1]}. */
        private static void init1() {
            FIRST_TERMINALS[1] = new int[] {4, 7};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [2]}. */
        private static void init2() {
            FIRST_TERMINALS[2] = new int[] {4};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [3]}. */
        private static void init3() {
            FIRST_TERMINALS[3] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [4]}. */
        private static void init4() {
            FIRST_TERMINALS[4] = new int[] {0, 11};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [5]}. */
        private static void init5() {
            FIRST_TERMINALS[5] = new int[] {4, 7};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [6]}. */
        private static void init6() {
            FIRST_TERMINALS[6] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [7]}. */
        private static void init7() {
            FIRST_TERMINALS[7] = new int[] {3, 7};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [8]}. */
        private static void init8() {
            FIRST_TERMINALS[8] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [9]}. */
        private static void init9() {
            FIRST_TERMINALS[9] = new int[] {2};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [10]}. */
        private static void init10() {
            FIRST_TERMINALS[10] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [11]}. */
        private static void init11() {
            FIRST_TERMINALS[11] = new int[] {1, 3};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [12]}. */
        private static void init12() {
            FIRST_TERMINALS[12] = new int[] {7};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [13]}. */
        private static void init13() {
            FIRST_TERMINALS[13] = new int[] {3};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [14]}. */
        private static void init14() {
            FIRST_TERMINALS[14] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [15]}. */
        private static void init15() {
            FIRST_TERMINALS[15] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [16]}. */
        private static void init16() {
            FIRST_TERMINALS[16] = new int[] {4, 5, 7, 8, 9};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [17]}. */
        private static void init17() {
            FIRST_TERMINALS[17] = new int[] {4, 7};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [18]}. */
        private static void init18() {
            FIRST_TERMINALS[18] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [19]}. */
        private static void init19() {
            FIRST_TERMINALS[19] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [20]}. */
        private static void init20() {
            FIRST_TERMINALS[20] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [21]}. */
        private static void init21() {
            FIRST_TERMINALS[21] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [22]}. */
        private static void init22() {
            FIRST_TERMINALS[22] = new int[] {1, 6};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [23]}. */
        private static void init23() {
            FIRST_TERMINALS[23] = new int[] {4, 7};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [24]}. */
        private static void init24() {
            FIRST_TERMINALS[24] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [25]}. */
        private static void init25() {
            FIRST_TERMINALS[25] = new int[] {};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [26]}. */
        private static void init26() {
            FIRST_TERMINALS[26] = new int[] {0, 3};
        }

        /** Initialize {@link #FIRST_TERMINALS}{@code [27]}. */
        private static void init27() {
            FIRST_TERMINALS[27] = new int[] {};
        }
    }

    /** See {@code Parser.firstTerminalsReduced}. */
    private static final class FirstTerminalsReduced {
        /** See {@code Parser.firstTerminalsReduced}. */
        private static final int[][][] FIRST_TERMINALS_REDUCED = new int[28][][];

        static {
            init0();
            init1();
            init2();
            init3();
            init4();
            init5();
            init6();
            init7();
            init8();
            init9();
            init10();
            init11();
            init12();
            init13();
            init14();
            init15();
            init16();
            init17();
            init18();
            init19();
            init20();
            init21();
            init22();
            init23();
            init24();
            init25();
            init26();
            init27();
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [0]}. */
        private static void init0() {
            FIRST_TERMINALS_REDUCED[0] = new int[][] {
                {0, 0, 11},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [1]}. */
        private static void init1() {
            FIRST_TERMINALS_REDUCED[1] = new int[][] {
                {0, 0, 3},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [2]}. */
        private static void init2() {
            FIRST_TERMINALS_REDUCED[2] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [3]}. */
        private static void init3() {
            FIRST_TERMINALS_REDUCED[3] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [4]}. */
        private static void init4() {
            FIRST_TERMINALS_REDUCED[4] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [5]}. */
        private static void init5() {
            FIRST_TERMINALS_REDUCED[5] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [6]}. */
        private static void init6() {
            FIRST_TERMINALS_REDUCED[6] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [7]}. */
        private static void init7() {
            FIRST_TERMINALS_REDUCED[7] = new int[][] {
                {3, 1, 3},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [8]}. */
        private static void init8() {
            FIRST_TERMINALS_REDUCED[8] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [9]}. */
        private static void init9() {
            FIRST_TERMINALS_REDUCED[9] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [10]}. */
        private static void init10() {
            FIRST_TERMINALS_REDUCED[10] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [11]}. */
        private static void init11() {
            FIRST_TERMINALS_REDUCED[11] = new int[][] {
                {5, 3},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [12]}. */
        private static void init12() {
            FIRST_TERMINALS_REDUCED[12] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [13]}. */
        private static void init13() {
            FIRST_TERMINALS_REDUCED[13] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [14]}. */
        private static void init14() {
            FIRST_TERMINALS_REDUCED[14] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [15]}. */
        private static void init15() {
            FIRST_TERMINALS_REDUCED[15] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [16]}. */
        private static void init16() {
            FIRST_TERMINALS_REDUCED[16] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [17]}. */
        private static void init17() {
            FIRST_TERMINALS_REDUCED[17] = new int[][] {
                {1, 1, 6},
            };
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [18]}. */
        private static void init18() {
            FIRST_TERMINALS_REDUCED[18] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [19]}. */
        private static void init19() {
            FIRST_TERMINALS_REDUCED[19] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [20]}. */
        private static void init20() {
            FIRST_TERMINALS_REDUCED[20] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [21]}. */
        private static void init21() {
            FIRST_TERMINALS_REDUCED[21] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [22]}. */
        private static void init22() {
            FIRST_TERMINALS_REDUCED[22] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [23]}. */
        private static void init23() {
            FIRST_TERMINALS_REDUCED[23] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [24]}. */
        private static void init24() {
            FIRST_TERMINALS_REDUCED[24] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [25]}. */
        private static void init25() {
            FIRST_TERMINALS_REDUCED[25] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [26]}. */
        private static void init26() {
            FIRST_TERMINALS_REDUCED[26] = new int[][] {};
        }

        /** Initialize {@link #FIRST_TERMINALS_REDUCED}{@code [27]}. */
        private static void init27() {
            FIRST_TERMINALS_REDUCED[27] = new int[][] {};
        }
    }

    /** See {@code Parser.reducibleNonTerminals}. */
    private static final class ReducibleNonTerminals {
        /** See {@code Parser.reducibleNonTerminals}. */
        private static final int[][][] REDUCIBLE_NON_TERMINALS = new int[28][][];

        static {
            init0();
            init1();
            init2();
            init3();
            init4();
            init5();
            init6();
            init7();
            init8();
            init9();
            init10();
            init11();
            init12();
            init13();
            init14();
            init15();
            init16();
            init17();
            init18();
            init19();
            init20();
            init21();
            init22();
            init23();
            init24();
            init25();
            init26();
            init27();
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [0]}. */
        private static void init0() {
            REDUCIBLE_NON_TERMINALS[0] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [1]}. */
        private static void init1() {
            REDUCIBLE_NON_TERMINALS[1] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [2]}. */
        private static void init2() {
            REDUCIBLE_NON_TERMINALS[2] = new int[][] {
                {2, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [3]}. */
        private static void init3() {
            REDUCIBLE_NON_TERMINALS[3] = new int[][] {
                {0, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [4]}. */
        private static void init4() {
            REDUCIBLE_NON_TERMINALS[4] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [5]}. */
        private static void init5() {
            REDUCIBLE_NON_TERMINALS[5] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [6]}. */
        private static void init6() {
            REDUCIBLE_NON_TERMINALS[6] = new int[][] {
                {0, 3},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [7]}. */
        private static void init7() {
            REDUCIBLE_NON_TERMINALS[7] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [8]}. */
        private static void init8() {
            REDUCIBLE_NON_TERMINALS[8] = new int[][] {
                {2, 3},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [9]}. */
        private static void init9() {
            REDUCIBLE_NON_TERMINALS[9] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [10]}. */
        private static void init10() {
            REDUCIBLE_NON_TERMINALS[10] = new int[][] {
                {3, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [11]}. */
        private static void init11() {
            REDUCIBLE_NON_TERMINALS[11] = new int[][] {
                {5, 0},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [12]}. */
        private static void init12() {
            REDUCIBLE_NON_TERMINALS[12] = new int[][] {
                {5, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [13]}. */
        private static void init13() {
            REDUCIBLE_NON_TERMINALS[13] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [14]}. */
        private static void init14() {
            REDUCIBLE_NON_TERMINALS[14] = new int[][] {
                {2, 5},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [15]}. */
        private static void init15() {
            REDUCIBLE_NON_TERMINALS[15] = new int[][] {
                {3, 3},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [16]}. */
        private static void init16() {
            REDUCIBLE_NON_TERMINALS[16] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [17]}. */
        private static void init17() {
            REDUCIBLE_NON_TERMINALS[17] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [18]}. */
        private static void init18() {
            REDUCIBLE_NON_TERMINALS[18] = new int[][] {
                {4, 3},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [19]}. */
        private static void init19() {
            REDUCIBLE_NON_TERMINALS[19] = new int[][] {
                {4, 3},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [20]}. */
        private static void init20() {
            REDUCIBLE_NON_TERMINALS[20] = new int[][] {
                {4, 3},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [21]}. */
        private static void init21() {
            REDUCIBLE_NON_TERMINALS[21] = new int[][] {
                {1, 1},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [22]}. */
        private static void init22() {
            REDUCIBLE_NON_TERMINALS[22] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [23]}. */
        private static void init23() {
            REDUCIBLE_NON_TERMINALS[23] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [24]}. */
        private static void init24() {
            REDUCIBLE_NON_TERMINALS[24] = new int[][] {
                {4, 5},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [25]}. */
        private static void init25() {
            REDUCIBLE_NON_TERMINALS[25] = new int[][] {
                {1, 3},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [26]}. */
        private static void init26() {
            REDUCIBLE_NON_TERMINALS[26] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS}{@code [27]}. */
        private static void init27() {
            REDUCIBLE_NON_TERMINALS[27] = new int[][] {
                {2, 3},
            };
        }
    }

    /** See {@code Parser.reducibleNonTerminalsReduced}. */
    private static final class ReducibleNonTerminalsReduced {
        /** See {@code Parser.reducibleNonTerminalsReduced}. */
        private static final int[][][] REDUCIBLE_NON_TERMINALS_REDUCED = new int[28][][];

        static {
            init0();
            init1();
            init2();
            init3();
            init4();
            init5();
            init6();
            init7();
            init8();
            init9();
            init10();
            init11();
            init12();
            init13();
            init14();
            init15();
            init16();
            init17();
            init18();
            init19();
            init20();
            init21();
            init22();
            init23();
            init24();
            init25();
            init26();
            init27();
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [0]}. */
        private static void init0() {
            REDUCIBLE_NON_TERMINALS_REDUCED[0] = new int[][] {
                {2, 0, 0},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [1]}. */
        private static void init1() {
            REDUCIBLE_NON_TERMINALS_REDUCED[1] = new int[][] {
                {2, 0, 0},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [2]}. */
        private static void init2() {
            REDUCIBLE_NON_TERMINALS_REDUCED[2] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [3]}. */
        private static void init3() {
            REDUCIBLE_NON_TERMINALS_REDUCED[3] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [4]}. */
        private static void init4() {
            REDUCIBLE_NON_TERMINALS_REDUCED[4] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [5]}. */
        private static void init5() {
            REDUCIBLE_NON_TERMINALS_REDUCED[5] = new int[][] {
                {2, 0, 2},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [6]}. */
        private static void init6() {
            REDUCIBLE_NON_TERMINALS_REDUCED[6] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [7]}. */
        private static void init7() {
            REDUCIBLE_NON_TERMINALS_REDUCED[7] = new int[][] {
                {4, 3, 0},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [8]}. */
        private static void init8() {
            REDUCIBLE_NON_TERMINALS_REDUCED[8] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [9]}. */
        private static void init9() {
            REDUCIBLE_NON_TERMINALS_REDUCED[9] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [10]}. */
        private static void init10() {
            REDUCIBLE_NON_TERMINALS_REDUCED[10] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [11]}. */
        private static void init11() {
            REDUCIBLE_NON_TERMINALS_REDUCED[11] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [12]}. */
        private static void init12() {
            REDUCIBLE_NON_TERMINALS_REDUCED[12] = new int[][] {
                {4, 3, 2},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [13]}. */
        private static void init13() {
            REDUCIBLE_NON_TERMINALS_REDUCED[13] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [14]}. */
        private static void init14() {
            REDUCIBLE_NON_TERMINALS_REDUCED[14] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [15]}. */
        private static void init15() {
            REDUCIBLE_NON_TERMINALS_REDUCED[15] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [16]}. */
        private static void init16() {
            REDUCIBLE_NON_TERMINALS_REDUCED[16] = new int[][] {
                {2, 4, 2},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [17]}. */
        private static void init17() {
            REDUCIBLE_NON_TERMINALS_REDUCED[17] = new int[][] {
                {2, 1, 0},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [18]}. */
        private static void init18() {
            REDUCIBLE_NON_TERMINALS_REDUCED[18] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [19]}. */
        private static void init19() {
            REDUCIBLE_NON_TERMINALS_REDUCED[19] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [20]}. */
        private static void init20() {
            REDUCIBLE_NON_TERMINALS_REDUCED[20] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [21]}. */
        private static void init21() {
            REDUCIBLE_NON_TERMINALS_REDUCED[21] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [22]}. */
        private static void init22() {
            REDUCIBLE_NON_TERMINALS_REDUCED[22] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [23]}. */
        private static void init23() {
            REDUCIBLE_NON_TERMINALS_REDUCED[23] = new int[][] {
                {2, 1, 2},
            };
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [24]}. */
        private static void init24() {
            REDUCIBLE_NON_TERMINALS_REDUCED[24] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [25]}. */
        private static void init25() {
            REDUCIBLE_NON_TERMINALS_REDUCED[25] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [26]}. */
        private static void init26() {
            REDUCIBLE_NON_TERMINALS_REDUCED[26] = new int[][] {};
        }

        /** Initialize {@link #REDUCIBLE_NON_TERMINALS_REDUCED}{@code [27]}. */
        private static void init27() {
            REDUCIBLE_NON_TERMINALS_REDUCED[27] = new int[][] {};
        }
    }

    /** Parser call back hooks for {@link VarOrdererParser}. */
    public interface Hooks extends ParserHooksBase {
        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code VarOrdererSeq : VarOrderer;}</p>
         *
         * @param v1 {@code VarOrderer}.
         * @return The parser call back hook result.
         */
        public List<VarOrdererInstance> parseVarOrdererSeq1(VarOrdererInstance v1);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code VarOrdererSeq : VarOrdererSeq ARROWTK VarOrderer;}</p>
         *
         * @param l1 {@code VarOrdererSeq}.
         * @param v3 {@code VarOrderer}.
         * @return The parser call back hook result.
         */
        public List<VarOrdererInstance> parseVarOrdererSeq2(List<VarOrdererInstance> l1, VarOrdererInstance v3);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code VarOrdererList : VarOrderer;}</p>
         *
         * @param v1 {@code VarOrderer}.
         * @return The parser call back hook result.
         */
        public List<VarOrdererInstance> parseVarOrdererList1(VarOrdererInstance v1);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code VarOrdererList : VarOrdererList COMMATK VarOrderer;}</p>
         *
         * @param l1 {@code VarOrdererList}.
         * @param v3 {@code VarOrderer}.
         * @return The parser call back hook result.
         */
        public List<VarOrdererInstance> parseVarOrdererList2(List<VarOrdererInstance> l1, VarOrdererInstance v3);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code VarOrderer : @IDENTIFIERTK;}</p>
         *
         * @param t1 {@code IDENTIFIERTK}.
         * @return The parser call back hook result.
         */
        public VarOrdererInstance parseVarOrderer1(Token t1);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code VarOrderer : @IDENTIFIERTK PAROPENTK PARCLOSETK;}</p>
         *
         * @param t1 {@code IDENTIFIERTK}.
         * @return The parser call back hook result.
         */
        public VarOrdererInstance parseVarOrderer2(Token t1);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code VarOrderer : @IDENTIFIERTK PAROPENTK VarOrdererArgs OptComma PARCLOSETK;}</p>
         *
         * @param t1 {@code IDENTIFIERTK}.
         * @param l3 {@code VarOrdererArgs}.
         * @param t4 {@code OptComma}.
         * @return The parser call back hook result.
         */
        public VarOrdererInstance parseVarOrderer3(Token t1, List<VarOrdererArg> l3, Token t4);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code VarOrderer : @PAROPENTK VarOrdererSeq PARCLOSETK;}</p>
         *
         * @param t1 {@code PAROPENTK}.
         * @param l2 {@code VarOrdererSeq}.
         * @return The parser call back hook result.
         */
        public VarOrdererInstance parseVarOrderer4(Token t1, List<VarOrdererInstance> l2);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code VarOrdererArgs : VarOrdererArg;}</p>
         *
         * @param v1 {@code VarOrdererArg}.
         * @return The parser call back hook result.
         */
        public List<VarOrdererArg> parseVarOrdererArgs1(VarOrdererArg v1);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code VarOrdererArgs : VarOrdererArgs COMMATK VarOrdererArg;}</p>
         *
         * @param l1 {@code VarOrdererArgs}.
         * @param v3 {@code VarOrdererArg}.
         * @return The parser call back hook result.
         */
        public List<VarOrdererArg> parseVarOrdererArgs2(List<VarOrdererArg> l1, VarOrdererArg v3);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code VarOrdererArg : @IDENTIFIERTK EQUALTK @NUMBERTK;}</p>
         *
         * @param t1 {@code IDENTIFIERTK}.
         * @param t3 {@code NUMBERTK}.
         * @return The parser call back hook result.
         */
        public VarOrdererArg parseVarOrdererArg1(Token t1, Token t3);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code VarOrdererArg : @IDENTIFIERTK EQUALTK @STRINGTK;}</p>
         *
         * @param t1 {@code IDENTIFIERTK}.
         * @param t3 {@code STRINGTK}.
         * @return The parser call back hook result.
         */
        public VarOrdererArg parseVarOrdererArg2(Token t1, Token t3);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code VarOrdererArg : @IDENTIFIERTK EQUALTK VarOrderer;}</p>
         *
         * @param t1 {@code IDENTIFIERTK}.
         * @param v3 {@code VarOrderer}.
         * @return The parser call back hook result.
         */
        public VarOrdererArg parseVarOrdererArg3(Token t1, VarOrdererInstance v3);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code VarOrdererArg : @IDENTIFIERTK EQUALTK SQOPENTK VarOrdererList SQCLOSETK;}</p>
         *
         * @param t1 {@code IDENTIFIERTK}.
         * @param l4 {@code VarOrdererList}.
         * @return The parser call back hook result.
         */
        public VarOrdererArg parseVarOrdererArg4(Token t1, List<VarOrdererInstance> l4);

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code OptComma : ;}</p>
         *
         * @return The parser call back hook result.
         */
        public Token parseOptComma1();

        /**
         * Parser call back hook for rule/production:
         *
         * <p>{@code OptComma : @COMMATK;}</p>
         *
         * @param t1 {@code COMMATK}.
         * @return The parser call back hook result.
         */
        public Token parseOptComma2(Token t1);
    }
}
